package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Entityanalyticsconfig;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class EntityanalyticsconfigRequest extends EntityRequest<Entityanalyticsconfig> {

    public EntityanalyticsconfigRequest(ContextPath contextPath, Optional<Object> value) {
        super(Entityanalyticsconfig.class, contextPath, value, false);
    }

    public SyncerrorRequest entityanalyticsconfig_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("entityanalyticsconfig_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest entityanalyticsconfig_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("entityanalyticsconfig_SyncErrors"), Optional.empty());
    }

    public AsyncoperationRequest entityanalyticsconfig_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("entityanalyticsconfig_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest entityanalyticsconfig_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("entityanalyticsconfig_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest entityanalyticsconfig_MailboxTrackingFolders(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("entityanalyticsconfig_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest entityanalyticsconfig_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("entityanalyticsconfig_MailboxTrackingFolders"), Optional.empty());
    }

    public BulkdeletefailureRequest entityanalyticsconfig_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("entityanalyticsconfig_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest entityanalyticsconfig_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("entityanalyticsconfig_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest entityanalyticsconfig_PrincipalObjectAttributeAccesses(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("entityanalyticsconfig_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest entityanalyticsconfig_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("entityanalyticsconfig_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public microsoft.dynamics.crm.entity.request.EntityRequest parententityid() {
        return new microsoft.dynamics.crm.entity.request.EntityRequest(contextPath.addSegment("parententityid"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

}
