package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Connector;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionreferenceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class ConnectorRequest extends EntityRequest<Connector> {

    public ConnectorRequest(ContextPath contextPath, Optional<Object> value) {
        super(Connector.class, contextPath, value, false);
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest owninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), Optional.empty());
    }

    public TeamRequest owningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public SyncerrorRequest connector_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("connector_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest connector_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("connector_SyncErrors"), Optional.empty());
    }

    public DuplicaterecordRequest connector_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("connector_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest connector_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("connector_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest connector_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("connector_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest connector_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("connector_DuplicateBaseRecord"), Optional.empty());
    }

    public AsyncoperationRequest connector_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("connector_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest connector_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("connector_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest connector_MailboxTrackingFolders(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("connector_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest connector_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("connector_MailboxTrackingFolders"), Optional.empty());
    }

    public ProcesssessionRequest connector_ProcessSession(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("connector_ProcessSession").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest connector_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("connector_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest connector_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("connector_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest connector_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("connector_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest connector_PrincipalObjectAttributeAccesses(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("connector_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest connector_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("connector_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public ConnectionreferenceRequest connector_connectionreference(String connectionreferenceid) {
        return new ConnectionreferenceRequest(contextPath.addSegment("connector_connectionreference").addKeys(new NameValue(connectionreferenceid.toString())), Optional.empty());
    }

    public ConnectionreferenceCollectionRequest connector_connectionreference() {
        return new ConnectionreferenceCollectionRequest(
                        contextPath.addSegment("connector_connectionreference"), Optional.empty());
    }

}
