package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Attribute;
import microsoft.dynamics.crm.entity.collection.request.RelationshipattributeCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SolutioncomponentattributeconfigurationCollectionRequest;

@JsonIgnoreType
public class AttributeRequest extends EntityRequest<Attribute> {

    public AttributeRequest(ContextPath contextPath, Optional<Object> value) {
        super(Attribute.class, contextPath, value, false);
    }

    public SolutioncomponentattributeconfigurationRequest attribute_solutioncomponentattrconfig(String solutioncomponentattributeconfigurationid) {
        return new SolutioncomponentattributeconfigurationRequest(contextPath.addSegment("attribute_solutioncomponentattrconfig").addKeys(new NameValue(solutioncomponentattributeconfigurationid.toString())), Optional.empty());
    }

    public SolutioncomponentattributeconfigurationCollectionRequest attribute_solutioncomponentattrconfig() {
        return new SolutioncomponentattributeconfigurationCollectionRequest(
                        contextPath.addSegment("attribute_solutioncomponentattrconfig"), Optional.empty());
    }

    public RelationshipattributeRequest referencingdattribute_relationshipattribute(String relationshipattributeid) {
        return new RelationshipattributeRequest(contextPath.addSegment("referencingdattribute_relationshipattribute").addKeys(new NameValue(relationshipattributeid.toString())), Optional.empty());
    }

    public RelationshipattributeCollectionRequest referencingdattribute_relationshipattribute() {
        return new RelationshipattributeCollectionRequest(
                        contextPath.addSegment("referencingdattribute_relationshipattribute"), Optional.empty());
    }

    public RelationshipattributeRequest referencedattribute_relationshipattribute(String relationshipattributeid) {
        return new RelationshipattributeRequest(contextPath.addSegment("referencedattribute_relationshipattribute").addKeys(new NameValue(relationshipattributeid.toString())), Optional.empty());
    }

    public RelationshipattributeCollectionRequest referencedattribute_relationshipattribute() {
        return new RelationshipattributeCollectionRequest(
                        contextPath.addSegment("referencedattribute_relationshipattribute"), Optional.empty());
    }

}
