package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Activityparty;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class ActivitypartyRequest extends EntityRequest<Activityparty> {

    public ActivitypartyRequest(ContextPath contextPath, Optional<Object> value) {
        super(Activityparty.class, contextPath, value, false);
    }

    public SyncerrorRequest activityParty_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("ActivityParty_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest activityParty_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("ActivityParty_SyncErrors"), Optional.empty());
    }

    public RecurringappointmentmasterRequest activityid_recurringappointmentmaster() {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("activityid_recurringappointmentmaster"), Optional.empty());
    }

    public SocialactivityRequest activityid_socialactivity() {
        return new SocialactivityRequest(contextPath.addSegment("activityid_socialactivity"), Optional.empty());
    }

    public AppointmentRequest activityid_appointment() {
        return new AppointmentRequest(contextPath.addSegment("activityid_appointment"), Optional.empty());
    }

    public QueueRequest partyid_queue() {
        return new QueueRequest(contextPath.addSegment("partyid_queue"), Optional.empty());
    }

    public SystemuserRequest partyid_systemuser() {
        return new SystemuserRequest(contextPath.addSegment("partyid_systemuser"), Optional.empty());
    }

    public FaxRequest activityid_fax() {
        return new FaxRequest(contextPath.addSegment("activityid_fax"), Optional.empty());
    }

    public PhonecallRequest activityid_phonecall() {
        return new PhonecallRequest(contextPath.addSegment("activityid_phonecall"), Optional.empty());
    }

    public TaskRequest activityid_task() {
        return new TaskRequest(contextPath.addSegment("activityid_task"), Optional.empty());
    }

    public LetterRequest activityid_letter() {
        return new LetterRequest(contextPath.addSegment("activityid_letter"), Optional.empty());
    }

    public EmailRequest activityid_email() {
        return new EmailRequest(contextPath.addSegment("activityid_email"), Optional.empty());
    }

    public KnowledgearticleRequest partyid_knowledgearticle() {
        return new KnowledgearticleRequest(contextPath.addSegment("partyid_knowledgearticle"), Optional.empty());
    }

    public AccountRequest partyid_account() {
        return new AccountRequest(contextPath.addSegment("partyid_account"), Optional.empty());
    }

    public ActivitypointerRequest activityid_activitypointer() {
        return new ActivitypointerRequest(contextPath.addSegment("activityid_activitypointer"), Optional.empty());
    }

    public ContactRequest partyid_contact() {
        return new ContactRequest(contextPath.addSegment("partyid_contact"), Optional.empty());
    }

}
