package microsoft.dynamics.crm.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Crmbaseentity;
import microsoft.dynamics.crm.entity.Timezonedefinition;
import microsoft.dynamics.crm.entity.request.TimezonedefinitionRequest;
import microsoft.dynamics.crm.entity.request.TimezonelocalizednameRequest;
import microsoft.dynamics.crm.entity.request.TimezoneruleRequest;

public class TimezonedefinitionCollectionRequest extends CollectionPageEntityRequest<Timezonedefinition, TimezonedefinitionRequest>{

    protected ContextPath contextPath;

    public TimezonedefinitionCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Timezonedefinition.class, cp -> new TimezonedefinitionRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public TimezonelocalizednameRequest lk_timezonelocalizedname_timezonedefinitionid(String timezonelocalizednameid) {
        return new TimezonelocalizednameRequest(contextPath.addSegment("lk_timezonelocalizedname_timezonedefinitionid").addKeys(new NameValue(timezonelocalizednameid.toString())), Optional.empty());
    }

    public TimezonelocalizednameCollectionRequest lk_timezonelocalizedname_timezonedefinitionid() {
        return new TimezonelocalizednameCollectionRequest(contextPath.addSegment("lk_timezonelocalizedname_timezonedefinitionid"), Optional.empty());
    }

    public TimezoneruleRequest lk_timezonerule_timezonedefinitionid(String timezoneruleid) {
        return new TimezoneruleRequest(contextPath.addSegment("lk_timezonerule_timezonedefinitionid").addKeys(new NameValue(timezoneruleid.toString())), Optional.empty());
    }

    public TimezoneruleCollectionRequest lk_timezonerule_timezonedefinitionid() {
        return new TimezoneruleCollectionRequest(contextPath.addSegment("lk_timezonerule_timezonedefinitionid"), Optional.empty());
    }

    @Function(name = "GetAllTimeZonesWithDisplayName")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Crmbaseentity> getAllTimeZonesWithDisplayName(Integer localeId) {
        Preconditions.checkNotNull(localeId, "localeId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("LocaleId", "Edm.Int32", localeId)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.GetAllTimeZonesWithDisplayName"), Crmbaseentity.class, _parameters);
    }

}
