package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Task;
import microsoft.dynamics.crm.entity.request.ActioncardRequest;
import microsoft.dynamics.crm.entity.request.ActivitypartyRequest;
import microsoft.dynamics.crm.entity.request.AnnotationRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.ConnectionRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.PostfollowRequest;
import microsoft.dynamics.crm.entity.request.PostregardingRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.QueueitemRequest;
import microsoft.dynamics.crm.entity.request.SlakpiinstanceRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.entity.request.TaskRequest;

public class TaskCollectionRequest extends CollectionPageEntityRequest<Task, TaskRequest>{

    protected ContextPath contextPath;

    public TaskCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Task.class, cp -> new TaskRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public PostregardingRequest task_PostRegardings(String postregardingid) {
        return new PostregardingRequest(contextPath.addSegment("task_PostRegardings").addKeys(new NameValue(postregardingid.toString())), Optional.empty());
    }

    public PostregardingCollectionRequest task_PostRegardings() {
        return new PostregardingCollectionRequest(contextPath.addSegment("task_PostRegardings"), Optional.empty());
    }

    public PostfollowRequest task_PostFollows(String postfollowid) {
        return new PostfollowRequest(contextPath.addSegment("task_PostFollows").addKeys(new NameValue(postfollowid.toString())), Optional.empty());
    }

    public PostfollowCollectionRequest task_PostFollows() {
        return new PostfollowCollectionRequest(contextPath.addSegment("task_PostFollows"), Optional.empty());
    }

    public ConnectionRequest task_connections2(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("task_connections2").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public ConnectionCollectionRequest task_connections2() {
        return new ConnectionCollectionRequest(contextPath.addSegment("task_connections2"), Optional.empty());
    }

    public DuplicaterecordRequest task_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("Task_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest task_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("Task_DuplicateBaseRecord"), Optional.empty());
    }

    public SlakpiinstanceRequest slakpiinstance_task(String slakpiinstanceid) {
        return new SlakpiinstanceRequest(contextPath.addSegment("slakpiinstance_task").addKeys(new NameValue(slakpiinstanceid.toString())), Optional.empty());
    }

    public SlakpiinstanceCollectionRequest slakpiinstance_task() {
        return new SlakpiinstanceCollectionRequest(contextPath.addSegment("slakpiinstance_task"), Optional.empty());
    }

    public DuplicaterecordRequest task_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("Task_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest task_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("Task_DuplicateMatchingRecord"), Optional.empty());
    }

    public ConnectionRequest task_connections1(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("task_connections1").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public ConnectionCollectionRequest task_connections1() {
        return new ConnectionCollectionRequest(contextPath.addSegment("task_connections1"), Optional.empty());
    }

    public ActivitypartyRequest task_activity_parties(String activitypartyid) {
        return new ActivitypartyRequest(contextPath.addSegment("task_activity_parties").addKeys(new NameValue(activitypartyid.toString())), Optional.empty());
    }

    public ActivitypartyCollectionRequest task_activity_parties() {
        return new ActivitypartyCollectionRequest(contextPath.addSegment("task_activity_parties"), Optional.empty());
    }

    public AnnotationRequest task_Annotation(String annotationid) {
        return new AnnotationRequest(contextPath.addSegment("Task_Annotation").addKeys(new NameValue(annotationid.toString())), Optional.empty());
    }

    public AnnotationCollectionRequest task_Annotation() {
        return new AnnotationCollectionRequest(contextPath.addSegment("Task_Annotation"), Optional.empty());
    }

    public ProcesssessionRequest task_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("Task_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest task_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("Task_ProcessSessions"), Optional.empty());
    }

    public AsyncoperationRequest task_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Task_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest task_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("Task_AsyncOperations"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest task_principalobjectattributeaccess(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("task_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest task_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("task_principalobjectattributeaccess"), Optional.empty());
    }

    public SyncerrorRequest task_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Task_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest task_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("Task_SyncErrors"), Optional.empty());
    }

    public QueueitemRequest task_QueueItem(String queueitemid) {
        return new QueueitemRequest(contextPath.addSegment("Task_QueueItem").addKeys(new NameValue(queueitemid.toString())), Optional.empty());
    }

    public QueueitemCollectionRequest task_QueueItem() {
        return new QueueitemCollectionRequest(contextPath.addSegment("Task_QueueItem"), Optional.empty());
    }

    public ActioncardRequest task_actioncard(String actioncardid) {
        return new ActioncardRequest(contextPath.addSegment("task_actioncard").addKeys(new NameValue(actioncardid.toString())), Optional.empty());
    }

    public ActioncardCollectionRequest task_actioncard() {
        return new ActioncardCollectionRequest(contextPath.addSegment("task_actioncard"), Optional.empty());
    }

    public BulkdeletefailureRequest task_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("Task_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest task_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("Task_BulkDeleteFailures"), Optional.empty());
    }

}
