package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Sla;
import microsoft.dynamics.crm.entity.request.AccountRequest;
import microsoft.dynamics.crm.entity.request.ActivitypointerRequest;
import microsoft.dynamics.crm.entity.request.AnnotationRequest;
import microsoft.dynamics.crm.entity.request.AppointmentRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.ContactRequest;
import microsoft.dynamics.crm.entity.request.EmailRequest;
import microsoft.dynamics.crm.entity.request.FaxRequest;
import microsoft.dynamics.crm.entity.request.LetterRequest;
import microsoft.dynamics.crm.entity.request.PhonecallRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SlaRequest;
import microsoft.dynamics.crm.entity.request.SlaitemRequest;
import microsoft.dynamics.crm.entity.request.SocialactivityRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.entity.request.TaskRequest;

public class SlaCollectionRequest extends CollectionPageEntityRequest<Sla, SlaRequest>{

    protected ContextPath contextPath;

    public SlaCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Sla.class, cp -> new SlaRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AccountRequest manualsla_account(String accountid) {
        return new AccountRequest(contextPath.addSegment("manualsla_account").addKeys(new NameValue(accountid.toString())), Optional.empty());
    }

    public AccountCollectionRequest manualsla_account() {
        return new AccountCollectionRequest(contextPath.addSegment("manualsla_account"), Optional.empty());
    }

    public TaskRequest manualsla_task(String activityid) {
        return new TaskRequest(contextPath.addSegment("manualsla_task").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public TaskCollectionRequest manualsla_task() {
        return new TaskCollectionRequest(contextPath.addSegment("manualsla_task"), Optional.empty());
    }

    public EmailRequest manualsla_email(String activityid) {
        return new EmailRequest(contextPath.addSegment("manualsla_email").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public EmailCollectionRequest manualsla_email() {
        return new EmailCollectionRequest(contextPath.addSegment("manualsla_email"), Optional.empty());
    }

    public AnnotationRequest sla_Annotation(String annotationid) {
        return new AnnotationRequest(contextPath.addSegment("sla_Annotation").addKeys(new NameValue(annotationid.toString())), Optional.empty());
    }

    public AnnotationCollectionRequest sla_Annotation() {
        return new AnnotationCollectionRequest(contextPath.addSegment("sla_Annotation"), Optional.empty());
    }

    public SyncerrorRequest sLA_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("SLA_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest sLA_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("SLA_SyncErrors"), Optional.empty());
    }

    public PhonecallRequest manualsla_phonecall(String activityid) {
        return new PhonecallRequest(contextPath.addSegment("manualsla_phonecall").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public PhonecallCollectionRequest manualsla_phonecall() {
        return new PhonecallCollectionRequest(contextPath.addSegment("manualsla_phonecall"), Optional.empty());
    }

    public ContactRequest sla_contact(String contactid) {
        return new ContactRequest(contextPath.addSegment("sla_contact").addKeys(new NameValue(contactid.toString())), Optional.empty());
    }

    public ContactCollectionRequest sla_contact() {
        return new ContactCollectionRequest(contextPath.addSegment("sla_contact"), Optional.empty());
    }

    public ContactRequest manualsla_contact(String contactid) {
        return new ContactRequest(contextPath.addSegment("manualsla_contact").addKeys(new NameValue(contactid.toString())), Optional.empty());
    }

    public ContactCollectionRequest manualsla_contact() {
        return new ContactCollectionRequest(contextPath.addSegment("manualsla_contact"), Optional.empty());
    }

    public ActivitypointerRequest manualsla_activitypointer(String activityid) {
        return new ActivitypointerRequest(contextPath.addSegment("manualsla_activitypointer").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public ActivitypointerCollectionRequest manualsla_activitypointer() {
        return new ActivitypointerCollectionRequest(contextPath.addSegment("manualsla_activitypointer"), Optional.empty());
    }

    public TaskRequest sla_task(String activityid) {
        return new TaskRequest(contextPath.addSegment("sla_task").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public TaskCollectionRequest sla_task() {
        return new TaskCollectionRequest(contextPath.addSegment("sla_task"), Optional.empty());
    }

    public ProcesssessionRequest slabase_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("slabase_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest slabase_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("slabase_ProcessSessions"), Optional.empty());
    }

    public FaxRequest manualsla_fax(String activityid) {
        return new FaxRequest(contextPath.addSegment("manualsla_fax").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public FaxCollectionRequest manualsla_fax() {
        return new FaxCollectionRequest(contextPath.addSegment("manualsla_fax"), Optional.empty());
    }

    public LetterRequest sla_letter(String activityid) {
        return new LetterRequest(contextPath.addSegment("sla_letter").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public LetterCollectionRequest sla_letter() {
        return new LetterCollectionRequest(contextPath.addSegment("sla_letter"), Optional.empty());
    }

    public EmailRequest sla_email(String activityid) {
        return new EmailRequest(contextPath.addSegment("sla_email").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public EmailCollectionRequest sla_email() {
        return new EmailCollectionRequest(contextPath.addSegment("sla_email"), Optional.empty());
    }

    public SocialactivityRequest manualsla_socialactivity(String activityid) {
        return new SocialactivityRequest(contextPath.addSegment("manualsla_socialactivity").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public SocialactivityCollectionRequest manualsla_socialactivity() {
        return new SocialactivityCollectionRequest(contextPath.addSegment("manualsla_socialactivity"), Optional.empty());
    }

    public FaxRequest sla_fax(String activityid) {
        return new FaxRequest(contextPath.addSegment("sla_fax").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public FaxCollectionRequest sla_fax() {
        return new FaxCollectionRequest(contextPath.addSegment("sla_fax"), Optional.empty());
    }

    public AccountRequest sla_account(String accountid) {
        return new AccountRequest(contextPath.addSegment("sla_account").addKeys(new NameValue(accountid.toString())), Optional.empty());
    }

    public AccountCollectionRequest sla_account() {
        return new AccountCollectionRequest(contextPath.addSegment("sla_account"), Optional.empty());
    }

    public AsyncoperationRequest slabase_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("slabase_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest slabase_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("slabase_AsyncOperations"), Optional.empty());
    }

    public AppointmentRequest manualsla_appointment(String activityid) {
        return new AppointmentRequest(contextPath.addSegment("manualsla_appointment").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public AppointmentCollectionRequest manualsla_appointment() {
        return new AppointmentCollectionRequest(contextPath.addSegment("manualsla_appointment"), Optional.empty());
    }

    public PhonecallRequest sla_phonecall(String activityid) {
        return new PhonecallRequest(contextPath.addSegment("sla_phonecall").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public PhonecallCollectionRequest sla_phonecall() {
        return new PhonecallCollectionRequest(contextPath.addSegment("sla_phonecall"), Optional.empty());
    }

    public SocialactivityRequest sla_socialactivity(String activityid) {
        return new SocialactivityRequest(contextPath.addSegment("sla_socialactivity").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public SocialactivityCollectionRequest sla_socialactivity() {
        return new SocialactivityCollectionRequest(contextPath.addSegment("sla_socialactivity"), Optional.empty());
    }

    public BulkdeletefailureRequest slabase_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("slabase_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest slabase_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("slabase_BulkDeleteFailures"), Optional.empty());
    }

    public AppointmentRequest sla_appointment(String activityid) {
        return new AppointmentRequest(contextPath.addSegment("sla_appointment").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public AppointmentCollectionRequest sla_appointment() {
        return new AppointmentCollectionRequest(contextPath.addSegment("sla_appointment"), Optional.empty());
    }

    public SlaitemRequest sla_slaitem_slaId(String slaitemid) {
        return new SlaitemRequest(contextPath.addSegment("sla_slaitem_slaId").addKeys(new NameValue(slaitemid.toString())), Optional.empty());
    }

    public SlaitemCollectionRequest sla_slaitem_slaId() {
        return new SlaitemCollectionRequest(contextPath.addSegment("sla_slaitem_slaId"), Optional.empty());
    }

    public ActivitypointerRequest sla_activitypointer(String activityid) {
        return new ActivitypointerRequest(contextPath.addSegment("sla_activitypointer").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public ActivitypointerCollectionRequest sla_activitypointer() {
        return new ActivitypointerCollectionRequest(contextPath.addSegment("sla_activitypointer"), Optional.empty());
    }

    public LetterRequest manualsla_letter(String activityid) {
        return new LetterRequest(contextPath.addSegment("manualsla_letter").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public LetterCollectionRequest manualsla_letter() {
        return new LetterCollectionRequest(contextPath.addSegment("manualsla_letter"), Optional.empty());
    }

}
