package microsoft.dynamics.crm.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Crmbaseentity;
import microsoft.dynamics.crm.entity.Post;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.PostRequest;
import microsoft.dynamics.crm.entity.request.PostcommentRequest;
import microsoft.dynamics.crm.entity.request.PostlikeRequest;

public class PostCollectionRequest extends CollectionPageEntityRequest<Post, PostRequest>{

    protected ContextPath contextPath;

    public PostCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Post.class, cp -> new PostRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AsyncoperationRequest post_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("post_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest post_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("post_AsyncOperations"), Optional.empty());
    }

    public BulkdeletefailureRequest post_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("post_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest post_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("post_BulkDeleteFailures"), Optional.empty());
    }

    public PostcommentRequest post_Comments(String postcommentid) {
        return new PostcommentRequest(contextPath.addSegment("Post_Comments").addKeys(new NameValue(postcommentid.toString())), Optional.empty());
    }

    public PostcommentCollectionRequest post_Comments() {
        return new PostcommentCollectionRequest(contextPath.addSegment("Post_Comments"), Optional.empty());
    }

    public PostlikeRequest post_Likes(String postlikeid) {
        return new PostlikeRequest(contextPath.addSegment("Post_Likes").addKeys(new NameValue(postlikeid.toString())), Optional.empty());
    }

    public PostlikeCollectionRequest post_Likes() {
        return new PostlikeCollectionRequest(contextPath.addSegment("Post_Likes"), Optional.empty());
    }

    @Function(name = "RetrievePersonalWall")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Post> retrievePersonalWall(Integer pageNumber, Integer pageSize, Integer commentsPerPost, OffsetDateTime startDate, OffsetDateTime endDate, Integer type, Integer source, Boolean sortDirection, String keyword) {
        Preconditions.checkNotNull(pageNumber, "pageNumber cannot be null");
        Preconditions.checkNotNull(pageSize, "pageSize cannot be null");
        Preconditions.checkNotNull(commentsPerPost, "commentsPerPost cannot be null");
        Preconditions.checkNotNull(startDate, "startDate cannot be null");
        Preconditions.checkNotNull(endDate, "endDate cannot be null");
        Preconditions.checkNotNull(type, "type cannot be null");
        Preconditions.checkNotNull(source, "source cannot be null");
        Preconditions.checkNotNull(sortDirection, "sortDirection cannot be null");
        Preconditions.checkNotNull(keyword, "keyword cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PageNumber", "Edm.Int32", pageNumber)
            .put("PageSize", "Edm.Int32", pageSize)
            .put("CommentsPerPost", "Edm.Int32", commentsPerPost)
            .put("StartDate", "Edm.DateTimeOffset", startDate)
            .put("EndDate", "Edm.DateTimeOffset", endDate)
            .put("Type", "Edm.Int32", type)
            .put("Source", "Edm.Int32", source)
            .put("SortDirection", "Edm.Boolean", sortDirection)
            .put("Keyword", "Edm.String", Checks.checkIsAscii(keyword))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrievePersonalWall"), Post.class, _parameters);
    }

    @Function(name = "RetrieveRecordWall")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Post> retrieveRecordWall(Crmbaseentity entity, Integer pageNumber, Integer pageSize, Integer commentsPerPost, OffsetDateTime startDate, OffsetDateTime endDate, Integer type, Integer source, Boolean sortDirection, String keyword) {
        Preconditions.checkNotNull(entity, "entity cannot be null");
        Preconditions.checkNotNull(pageNumber, "pageNumber cannot be null");
        Preconditions.checkNotNull(pageSize, "pageSize cannot be null");
        Preconditions.checkNotNull(commentsPerPost, "commentsPerPost cannot be null");
        Preconditions.checkNotNull(startDate, "startDate cannot be null");
        Preconditions.checkNotNull(endDate, "endDate cannot be null");
        Preconditions.checkNotNull(type, "type cannot be null");
        Preconditions.checkNotNull(source, "source cannot be null");
        Preconditions.checkNotNull(sortDirection, "sortDirection cannot be null");
        Preconditions.checkNotNull(keyword, "keyword cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Entity", "Microsoft.Dynamics.CRM.crmbaseentity", entity)
            .put("PageNumber", "Edm.Int32", pageNumber)
            .put("PageSize", "Edm.Int32", pageSize)
            .put("CommentsPerPost", "Edm.Int32", commentsPerPost)
            .put("StartDate", "Edm.DateTimeOffset", startDate)
            .put("EndDate", "Edm.DateTimeOffset", endDate)
            .put("Type", "Edm.Int32", type)
            .put("Source", "Edm.Int32", source)
            .put("SortDirection", "Edm.Boolean", sortDirection)
            .put("Keyword", "Edm.String", Checks.checkIsAscii(keyword))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveRecordWall"), Post.class, _parameters);
    }

}
