package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Activitymimeattachment;
import microsoft.dynamics.crm.entity.request.ActivitymimeattachmentRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class ActivitymimeattachmentCollectionRequest extends CollectionPageEntityRequest<Activitymimeattachment, ActivitymimeattachmentRequest>{

    protected ContextPath contextPath;

    public ActivitymimeattachmentCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Activitymimeattachment.class, cp -> new ActivitymimeattachmentRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest activityMimeAttachment_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("ActivityMimeAttachment_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest activityMimeAttachment_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("ActivityMimeAttachment_SyncErrors"), Optional.empty());
    }

    public AsyncoperationRequest activityMimeAttachment_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("ActivityMimeAttachment_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest activityMimeAttachment_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("ActivityMimeAttachment_AsyncOperations"), Optional.empty());
    }

    public BulkdeletefailureRequest activityMimeAttachment_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("ActivityMimeAttachment_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest activityMimeAttachment_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("ActivityMimeAttachment_BulkDeleteFailures"), Optional.empty());
    }

}
