package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.TracelogCollectionRequest;
import microsoft.dynamics.crm.entity.request.EmailserverprofileRequest;
import microsoft.dynamics.crm.entity.request.MailboxRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TracelogRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "canbedeleted", 
    "collationlevel", 
    "traceparameterxml", 
    "timezoneruleversionnumber", 
    "traceparameterhash", 
    "errortypedisplay", 
    "createdon", 
    "text", 
    "_regardingobjectowningbusinessunit_value", 
    "level", 
    "utcconversiontimezonecode", 
    "machinename", 
    "_createdonbehalfby_value", 
    "_organizationid_value", 
    "tracecode", 
    "_createdby_value", 
    "modifiedon", 
    "tracedetailxml", 
    "_modifiedby_value", 
    "errordetails", 
    "tracelogid", 
    "traceactionxml", 
    "isunique", 
    "_modifiedonbehalfby_value", 
    "_regardingobjectid_value", 
    "_regardingobjectownerid_value", 
    "tracestatus", 
    "_parenttracelogid_value"})
@JsonInclude(Include.NON_NULL)
public class Tracelog extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.tracelog";
    }

    @JsonProperty("canbedeleted")
    protected Boolean canbedeleted;

    @JsonProperty("collationlevel")
    protected Integer collationlevel;

    @JsonProperty("traceparameterxml")
    protected String traceparameterxml;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("traceparameterhash")
    protected Integer traceparameterhash;

    @JsonProperty("errortypedisplay")
    protected String errortypedisplay;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("text")
    protected String text;

    @JsonProperty("_regardingobjectowningbusinessunit_value")
    protected String _regardingobjectowningbusinessunit_value;

    @JsonProperty("level")
    protected Integer level;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("machinename")
    protected String machinename;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("tracecode")
    protected Integer tracecode;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("tracedetailxml")
    protected String tracedetailxml;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("errordetails")
    protected String errordetails;

    @JsonProperty("tracelogid")
    protected String tracelogid;

    @JsonProperty("traceactionxml")
    protected String traceactionxml;

    @JsonProperty("isunique")
    protected Boolean isunique;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("_regardingobjectid_value")
    protected String _regardingobjectid_value;

    @JsonProperty("_regardingobjectownerid_value")
    protected String _regardingobjectownerid_value;

    @JsonProperty("tracestatus")
    protected Boolean tracestatus;

    @JsonProperty("_parenttracelogid_value")
    protected String _parenttracelogid_value;

    protected Tracelog() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTracelog() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean canbedeleted;
        private Integer collationlevel;
        private String traceparameterxml;
        private Integer timezoneruleversionnumber;
        private Integer traceparameterhash;
        private String errortypedisplay;
        private OffsetDateTime createdon;
        private String text;
        private String _regardingobjectowningbusinessunit_value;
        private Integer level;
        private Integer utcconversiontimezonecode;
        private String machinename;
        private String _createdonbehalfby_value;
        private String _organizationid_value;
        private Integer tracecode;
        private String _createdby_value;
        private OffsetDateTime modifiedon;
        private String tracedetailxml;
        private String _modifiedby_value;
        private String errordetails;
        private String tracelogid;
        private String traceactionxml;
        private Boolean isunique;
        private String _modifiedonbehalfby_value;
        private String _regardingobjectid_value;
        private String _regardingobjectownerid_value;
        private Boolean tracestatus;
        private String _parenttracelogid_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder canbedeleted(Boolean canbedeleted) {
            this.canbedeleted = canbedeleted;
            this.changedFields = changedFields.add("canbedeleted");
            return this;
        }

        public Builder collationlevel(Integer collationlevel) {
            this.collationlevel = collationlevel;
            this.changedFields = changedFields.add("collationlevel");
            return this;
        }

        public Builder traceparameterxml(String traceparameterxml) {
            this.traceparameterxml = traceparameterxml;
            this.changedFields = changedFields.add("traceparameterxml");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder traceparameterhash(Integer traceparameterhash) {
            this.traceparameterhash = traceparameterhash;
            this.changedFields = changedFields.add("traceparameterhash");
            return this;
        }

        public Builder errortypedisplay(String errortypedisplay) {
            this.errortypedisplay = errortypedisplay;
            this.changedFields = changedFields.add("errortypedisplay");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            this.changedFields = changedFields.add("text");
            return this;
        }

        public Builder _regardingobjectowningbusinessunit_value(String _regardingobjectowningbusinessunit_value) {
            this._regardingobjectowningbusinessunit_value = _regardingobjectowningbusinessunit_value;
            this.changedFields = changedFields.add("_regardingobjectowningbusinessunit_value");
            return this;
        }

        public Builder level(Integer level) {
            this.level = level;
            this.changedFields = changedFields.add("level");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder machinename(String machinename) {
            this.machinename = machinename;
            this.changedFields = changedFields.add("machinename");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder tracecode(Integer tracecode) {
            this.tracecode = tracecode;
            this.changedFields = changedFields.add("tracecode");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder tracedetailxml(String tracedetailxml) {
            this.tracedetailxml = tracedetailxml;
            this.changedFields = changedFields.add("tracedetailxml");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder errordetails(String errordetails) {
            this.errordetails = errordetails;
            this.changedFields = changedFields.add("errordetails");
            return this;
        }

        public Builder tracelogid(String tracelogid) {
            this.tracelogid = tracelogid;
            this.changedFields = changedFields.add("tracelogid");
            return this;
        }

        public Builder traceactionxml(String traceactionxml) {
            this.traceactionxml = traceactionxml;
            this.changedFields = changedFields.add("traceactionxml");
            return this;
        }

        public Builder isunique(Boolean isunique) {
            this.isunique = isunique;
            this.changedFields = changedFields.add("isunique");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _regardingobjectid_value(String _regardingobjectid_value) {
            this._regardingobjectid_value = _regardingobjectid_value;
            this.changedFields = changedFields.add("_regardingobjectid_value");
            return this;
        }

        public Builder _regardingobjectownerid_value(String _regardingobjectownerid_value) {
            this._regardingobjectownerid_value = _regardingobjectownerid_value;
            this.changedFields = changedFields.add("_regardingobjectownerid_value");
            return this;
        }

        public Builder tracestatus(Boolean tracestatus) {
            this.tracestatus = tracestatus;
            this.changedFields = changedFields.add("tracestatus");
            return this;
        }

        public Builder _parenttracelogid_value(String _parenttracelogid_value) {
            this._parenttracelogid_value = _parenttracelogid_value;
            this.changedFields = changedFields.add("_parenttracelogid_value");
            return this;
        }

        public Tracelog build() {
            Tracelog _x = new Tracelog();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.tracelog";
            _x.canbedeleted = canbedeleted;
            _x.collationlevel = collationlevel;
            _x.traceparameterxml = traceparameterxml;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.traceparameterhash = traceparameterhash;
            _x.errortypedisplay = errortypedisplay;
            _x.createdon = createdon;
            _x.text = text;
            _x._regardingobjectowningbusinessunit_value = _regardingobjectowningbusinessunit_value;
            _x.level = level;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.machinename = machinename;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._organizationid_value = _organizationid_value;
            _x.tracecode = tracecode;
            _x._createdby_value = _createdby_value;
            _x.modifiedon = modifiedon;
            _x.tracedetailxml = tracedetailxml;
            _x._modifiedby_value = _modifiedby_value;
            _x.errordetails = errordetails;
            _x.tracelogid = tracelogid;
            _x.traceactionxml = traceactionxml;
            _x.isunique = isunique;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._regardingobjectid_value = _regardingobjectid_value;
            _x._regardingobjectownerid_value = _regardingobjectownerid_value;
            _x.tracestatus = tracestatus;
            _x._parenttracelogid_value = _parenttracelogid_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && tracelogid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(tracelogid.toString()));
        }
    }

    @Property(name="canbedeleted")
    @JsonIgnore
    public Optional<Boolean> getCanbedeleted() {
        return Optional.ofNullable(canbedeleted);
    }

    public Tracelog withCanbedeleted(Boolean canbedeleted) {
        Tracelog _x = _copy();
        _x.changedFields = changedFields.add("canbedeleted");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.tracelog");
        _x.canbedeleted = canbedeleted;
        return _x;
    }

    @Property(name="collationlevel")
    @JsonIgnore
    public Optional<Integer> getCollationlevel() {
        return Optional.ofNullable(collationlevel);
    }

    public Tracelog withCollationlevel(Integer collationlevel) {
        Tracelog _x = _copy();
        _x.changedFields = changedFields.add("collationlevel");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.tracelog");
        _x.collationlevel = collationlevel;
        return _x;
    }

    @Property(name="traceparameterxml")
    @JsonIgnore
    public Optional<String> getTraceparameterxml() {
        return Optional.ofNullable(traceparameterxml);
    }

    public Tracelog withTraceparameterxml(String traceparameterxml) {
        Checks.checkIsAscii(traceparameterxml);
        Tracelog _x = _copy();
        _x.changedFields = changedFields.add("traceparameterxml");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.tracelog");
        _x.traceparameterxml = traceparameterxml;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Tracelog withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Tracelog _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.tracelog");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="traceparameterhash")
    @JsonIgnore
    public Optional<Integer> getTraceparameterhash() {
        return Optional.ofNullable(traceparameterhash);
    }

    public Tracelog withTraceparameterhash(Integer traceparameterhash) {
        Tracelog _x = _copy();
        _x.changedFields = changedFields.add("traceparameterhash");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.tracelog");
        _x.traceparameterhash = traceparameterhash;
        return _x;
    }

    @Property(name="errortypedisplay")
    @JsonIgnore
    public Optional<String> getErrortypedisplay() {
        return Optional.ofNullable(errortypedisplay);
    }

    public Tracelog withErrortypedisplay(String errortypedisplay) {
        Checks.checkIsAscii(errortypedisplay);
        Tracelog _x = _copy();
        _x.changedFields = changedFields.add("errortypedisplay");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.tracelog");
        _x.errortypedisplay = errortypedisplay;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Tracelog withCreatedon(OffsetDateTime createdon) {
        Tracelog _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.tracelog");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="text")
    @JsonIgnore
    public Optional<String> getText() {
        return Optional.ofNullable(text);
    }

    public Tracelog withText(String text) {
        Checks.checkIsAscii(text);
        Tracelog _x = _copy();
        _x.changedFields = changedFields.add("text");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.tracelog");
        _x.text = text;
        return _x;
    }

    @Property(name="_regardingobjectowningbusinessunit_value")
    @JsonIgnore
    public Optional<String> get_regardingobjectowningbusinessunit_value() {
        return Optional.ofNullable(_regardingobjectowningbusinessunit_value);
    }

    public Tracelog with_regardingobjectowningbusinessunit_value(String _regardingobjectowningbusinessunit_value) {
        Tracelog _x = _copy();
        _x.changedFields = changedFields.add("_regardingobjectowningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.tracelog");
        _x._regardingobjectowningbusinessunit_value = _regardingobjectowningbusinessunit_value;
        return _x;
    }

    @Property(name="level")
    @JsonIgnore
    public Optional<Integer> getLevel() {
        return Optional.ofNullable(level);
    }

    public Tracelog withLevel(Integer level) {
        Tracelog _x = _copy();
        _x.changedFields = changedFields.add("level");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.tracelog");
        _x.level = level;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Tracelog withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Tracelog _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.tracelog");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="machinename")
    @JsonIgnore
    public Optional<String> getMachinename() {
        return Optional.ofNullable(machinename);
    }

    public Tracelog withMachinename(String machinename) {
        Checks.checkIsAscii(machinename);
        Tracelog _x = _copy();
        _x.changedFields = changedFields.add("machinename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.tracelog");
        _x.machinename = machinename;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Tracelog with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Tracelog _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.tracelog");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Tracelog with_organizationid_value(String _organizationid_value) {
        Tracelog _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.tracelog");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="tracecode")
    @JsonIgnore
    public Optional<Integer> getTracecode() {
        return Optional.ofNullable(tracecode);
    }

    public Tracelog withTracecode(Integer tracecode) {
        Tracelog _x = _copy();
        _x.changedFields = changedFields.add("tracecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.tracelog");
        _x.tracecode = tracecode;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Tracelog with_createdby_value(String _createdby_value) {
        Tracelog _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.tracelog");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Tracelog withModifiedon(OffsetDateTime modifiedon) {
        Tracelog _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.tracelog");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="tracedetailxml")
    @JsonIgnore
    public Optional<String> getTracedetailxml() {
        return Optional.ofNullable(tracedetailxml);
    }

    public Tracelog withTracedetailxml(String tracedetailxml) {
        Checks.checkIsAscii(tracedetailxml);
        Tracelog _x = _copy();
        _x.changedFields = changedFields.add("tracedetailxml");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.tracelog");
        _x.tracedetailxml = tracedetailxml;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Tracelog with_modifiedby_value(String _modifiedby_value) {
        Tracelog _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.tracelog");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="errordetails")
    @JsonIgnore
    public Optional<String> getErrordetails() {
        return Optional.ofNullable(errordetails);
    }

    public Tracelog withErrordetails(String errordetails) {
        Checks.checkIsAscii(errordetails);
        Tracelog _x = _copy();
        _x.changedFields = changedFields.add("errordetails");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.tracelog");
        _x.errordetails = errordetails;
        return _x;
    }

    @Property(name="tracelogid")
    @JsonIgnore
    public Optional<String> getTracelogid() {
        return Optional.ofNullable(tracelogid);
    }

    public Tracelog withTracelogid(String tracelogid) {
        Tracelog _x = _copy();
        _x.changedFields = changedFields.add("tracelogid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.tracelog");
        _x.tracelogid = tracelogid;
        return _x;
    }

    @Property(name="traceactionxml")
    @JsonIgnore
    public Optional<String> getTraceactionxml() {
        return Optional.ofNullable(traceactionxml);
    }

    public Tracelog withTraceactionxml(String traceactionxml) {
        Checks.checkIsAscii(traceactionxml);
        Tracelog _x = _copy();
        _x.changedFields = changedFields.add("traceactionxml");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.tracelog");
        _x.traceactionxml = traceactionxml;
        return _x;
    }

    @Property(name="isunique")
    @JsonIgnore
    public Optional<Boolean> getIsunique() {
        return Optional.ofNullable(isunique);
    }

    public Tracelog withIsunique(Boolean isunique) {
        Tracelog _x = _copy();
        _x.changedFields = changedFields.add("isunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.tracelog");
        _x.isunique = isunique;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Tracelog with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Tracelog _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.tracelog");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_regardingobjectid_value")
    @JsonIgnore
    public Optional<String> get_regardingobjectid_value() {
        return Optional.ofNullable(_regardingobjectid_value);
    }

    public Tracelog with_regardingobjectid_value(String _regardingobjectid_value) {
        Tracelog _x = _copy();
        _x.changedFields = changedFields.add("_regardingobjectid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.tracelog");
        _x._regardingobjectid_value = _regardingobjectid_value;
        return _x;
    }

    @Property(name="_regardingobjectownerid_value")
    @JsonIgnore
    public Optional<String> get_regardingobjectownerid_value() {
        return Optional.ofNullable(_regardingobjectownerid_value);
    }

    public Tracelog with_regardingobjectownerid_value(String _regardingobjectownerid_value) {
        Tracelog _x = _copy();
        _x.changedFields = changedFields.add("_regardingobjectownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.tracelog");
        _x._regardingobjectownerid_value = _regardingobjectownerid_value;
        return _x;
    }

    @Property(name="tracestatus")
    @JsonIgnore
    public Optional<Boolean> getTracestatus() {
        return Optional.ofNullable(tracestatus);
    }

    public Tracelog withTracestatus(Boolean tracestatus) {
        Tracelog _x = _copy();
        _x.changedFields = changedFields.add("tracestatus");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.tracelog");
        _x.tracestatus = tracestatus;
        return _x;
    }

    @Property(name="_parenttracelogid_value")
    @JsonIgnore
    public Optional<String> get_parenttracelogid_value() {
        return Optional.ofNullable(_parenttracelogid_value);
    }

    public Tracelog with_parenttracelogid_value(String _parenttracelogid_value) {
        Tracelog _x = _copy();
        _x.changedFields = changedFields.add("_parenttracelogid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.tracelog");
        _x._parenttracelogid_value = _parenttracelogid_value;
        return _x;
    }

    public Tracelog withUnmappedField(String name, String value) {
        Tracelog _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="regardingobjectid_mailbox")
    @JsonIgnore
    public MailboxRequest getRegardingobjectid_mailbox() {
        return new MailboxRequest(contextPath.addSegment("regardingobjectid_mailbox"), RequestHelper.getValue(unmappedFields, "regardingobjectid_mailbox"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="parenttracelogid")
    @JsonIgnore
    public TracelogRequest getParenttracelogid() {
        return new TracelogRequest(contextPath.addSegment("parenttracelogid"), RequestHelper.getValue(unmappedFields, "parenttracelogid"));
    }

    @NavigationProperty(name="tracelog_parent_tracelog")
    @JsonIgnore
    public TracelogCollectionRequest getTracelog_parent_tracelog() {
        return new TracelogCollectionRequest(
                        contextPath.addSegment("tracelog_parent_tracelog"), RequestHelper.getValue(unmappedFields, "tracelog_parent_tracelog"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="regardingobjectid_emailserverprofile")
    @JsonIgnore
    public EmailserverprofileRequest getRegardingobjectid_emailserverprofile() {
        return new EmailserverprofileRequest(contextPath.addSegment("regardingobjectid_emailserverprofile"), RequestHelper.getValue(unmappedFields, "regardingobjectid_emailserverprofile"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Tracelog patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Tracelog _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Tracelog put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Tracelog _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Tracelog _copy() {
        Tracelog _x = new Tracelog();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.canbedeleted = canbedeleted;
        _x.collationlevel = collationlevel;
        _x.traceparameterxml = traceparameterxml;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.traceparameterhash = traceparameterhash;
        _x.errortypedisplay = errortypedisplay;
        _x.createdon = createdon;
        _x.text = text;
        _x._regardingobjectowningbusinessunit_value = _regardingobjectowningbusinessunit_value;
        _x.level = level;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.machinename = machinename;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._organizationid_value = _organizationid_value;
        _x.tracecode = tracecode;
        _x._createdby_value = _createdby_value;
        _x.modifiedon = modifiedon;
        _x.tracedetailxml = tracedetailxml;
        _x._modifiedby_value = _modifiedby_value;
        _x.errordetails = errordetails;
        _x.tracelogid = tracelogid;
        _x.traceactionxml = traceactionxml;
        _x.isunique = isunique;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._regardingobjectid_value = _regardingobjectid_value;
        _x._regardingobjectownerid_value = _regardingobjectownerid_value;
        _x.tracestatus = tracestatus;
        _x._parenttracelogid_value = _parenttracelogid_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Tracelog[");
        b.append("canbedeleted=");
        b.append(this.canbedeleted);
        b.append(", ");
        b.append("collationlevel=");
        b.append(this.collationlevel);
        b.append(", ");
        b.append("traceparameterxml=");
        b.append(this.traceparameterxml);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("traceparameterhash=");
        b.append(this.traceparameterhash);
        b.append(", ");
        b.append("errortypedisplay=");
        b.append(this.errortypedisplay);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("text=");
        b.append(this.text);
        b.append(", ");
        b.append("_regardingobjectowningbusinessunit_value=");
        b.append(this._regardingobjectowningbusinessunit_value);
        b.append(", ");
        b.append("level=");
        b.append(this.level);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("machinename=");
        b.append(this.machinename);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("tracecode=");
        b.append(this.tracecode);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("tracedetailxml=");
        b.append(this.tracedetailxml);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("errordetails=");
        b.append(this.errordetails);
        b.append(", ");
        b.append("tracelogid=");
        b.append(this.tracelogid);
        b.append(", ");
        b.append("traceactionxml=");
        b.append(this.traceactionxml);
        b.append(", ");
        b.append("isunique=");
        b.append(this.isunique);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_regardingobjectid_value=");
        b.append(this._regardingobjectid_value);
        b.append(", ");
        b.append("_regardingobjectownerid_value=");
        b.append(this._regardingobjectownerid_value);
        b.append(", ");
        b.append("tracestatus=");
        b.append(this.tracestatus);
        b.append(", ");
        b.append("_parenttracelogid_value=");
        b.append(this._parenttracelogid_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
