package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Double;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "importjobid", 
    "_createdby_value", 
    "_modifiedonbehalfby_value", 
    "name", 
    "modifiedon", 
    "importcontext", 
    "completedon", 
    "_createdonbehalfby_value", 
    "_modifiedby_value", 
    "progress", 
    "operationcontext", 
    "utcconversiontimezonecode", 
    "_organizationid_value", 
    "timezoneruleversionnumber", 
    "data", 
    "solutionid", 
    "solutionname", 
    "createdon", 
    "startedon"})
@JsonInclude(Include.NON_NULL)
public class Importjob extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.importjob";
    }

    @JsonProperty("importjobid")
    protected String importjobid;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("importcontext")
    protected String importcontext;

    @JsonProperty("completedon")
    protected OffsetDateTime completedon;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("progress")
    protected Double progress;

    @JsonProperty("operationcontext")
    protected String operationcontext;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("data")
    protected String data;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("solutionname")
    protected String solutionname;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("startedon")
    protected OffsetDateTime startedon;

    protected Importjob() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderImportjob() {
        return new Builder();
    }

    public static final class Builder {
        private String importjobid;
        private String _createdby_value;
        private String _modifiedonbehalfby_value;
        private String name;
        private OffsetDateTime modifiedon;
        private String importcontext;
        private OffsetDateTime completedon;
        private String _createdonbehalfby_value;
        private String _modifiedby_value;
        private Double progress;
        private String operationcontext;
        private Integer utcconversiontimezonecode;
        private String _organizationid_value;
        private Integer timezoneruleversionnumber;
        private String data;
        private String solutionid;
        private String solutionname;
        private OffsetDateTime createdon;
        private OffsetDateTime startedon;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder importjobid(String importjobid) {
            this.importjobid = importjobid;
            this.changedFields = changedFields.add("importjobid");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder importcontext(String importcontext) {
            this.importcontext = importcontext;
            this.changedFields = changedFields.add("importcontext");
            return this;
        }

        public Builder completedon(OffsetDateTime completedon) {
            this.completedon = completedon;
            this.changedFields = changedFields.add("completedon");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder progress(Double progress) {
            this.progress = progress;
            this.changedFields = changedFields.add("progress");
            return this;
        }

        public Builder operationcontext(String operationcontext) {
            this.operationcontext = operationcontext;
            this.changedFields = changedFields.add("operationcontext");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder data(String data) {
            this.data = data;
            this.changedFields = changedFields.add("data");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder solutionname(String solutionname) {
            this.solutionname = solutionname;
            this.changedFields = changedFields.add("solutionname");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder startedon(OffsetDateTime startedon) {
            this.startedon = startedon;
            this.changedFields = changedFields.add("startedon");
            return this;
        }

        public Importjob build() {
            Importjob _x = new Importjob();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.importjob";
            _x.importjobid = importjobid;
            _x._createdby_value = _createdby_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.name = name;
            _x.modifiedon = modifiedon;
            _x.importcontext = importcontext;
            _x.completedon = completedon;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._modifiedby_value = _modifiedby_value;
            _x.progress = progress;
            _x.operationcontext = operationcontext;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x._organizationid_value = _organizationid_value;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.data = data;
            _x.solutionid = solutionid;
            _x.solutionname = solutionname;
            _x.createdon = createdon;
            _x.startedon = startedon;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && importjobid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(importjobid.toString()));
        }
    }

    @Property(name="importjobid")
    @JsonIgnore
    public Optional<String> getImportjobid() {
        return Optional.ofNullable(importjobid);
    }

    public Importjob withImportjobid(String importjobid) {
        Importjob _x = _copy();
        _x.changedFields = changedFields.add("importjobid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importjob");
        _x.importjobid = importjobid;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Importjob with_createdby_value(String _createdby_value) {
        Importjob _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importjob");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Importjob with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Importjob _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importjob");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Importjob withName(String name) {
        Checks.checkIsAscii(name);
        Importjob _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importjob");
        _x.name = name;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Importjob withModifiedon(OffsetDateTime modifiedon) {
        Importjob _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importjob");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="importcontext")
    @JsonIgnore
    public Optional<String> getImportcontext() {
        return Optional.ofNullable(importcontext);
    }

    public Importjob withImportcontext(String importcontext) {
        Checks.checkIsAscii(importcontext);
        Importjob _x = _copy();
        _x.changedFields = changedFields.add("importcontext");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importjob");
        _x.importcontext = importcontext;
        return _x;
    }

    @Property(name="completedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCompletedon() {
        return Optional.ofNullable(completedon);
    }

    public Importjob withCompletedon(OffsetDateTime completedon) {
        Importjob _x = _copy();
        _x.changedFields = changedFields.add("completedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importjob");
        _x.completedon = completedon;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Importjob with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Importjob _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importjob");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Importjob with_modifiedby_value(String _modifiedby_value) {
        Importjob _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importjob");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="progress")
    @JsonIgnore
    public Optional<Double> getProgress() {
        return Optional.ofNullable(progress);
    }

    public Importjob withProgress(Double progress) {
        Importjob _x = _copy();
        _x.changedFields = changedFields.add("progress");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importjob");
        _x.progress = progress;
        return _x;
    }

    @Property(name="operationcontext")
    @JsonIgnore
    public Optional<String> getOperationcontext() {
        return Optional.ofNullable(operationcontext);
    }

    public Importjob withOperationcontext(String operationcontext) {
        Checks.checkIsAscii(operationcontext);
        Importjob _x = _copy();
        _x.changedFields = changedFields.add("operationcontext");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importjob");
        _x.operationcontext = operationcontext;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Importjob withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Importjob _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importjob");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Importjob with_organizationid_value(String _organizationid_value) {
        Importjob _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importjob");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Importjob withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Importjob _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importjob");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="data")
    @JsonIgnore
    public Optional<String> getData() {
        return Optional.ofNullable(data);
    }

    public Importjob withData(String data) {
        Checks.checkIsAscii(data);
        Importjob _x = _copy();
        _x.changedFields = changedFields.add("data");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importjob");
        _x.data = data;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Importjob withSolutionid(String solutionid) {
        Importjob _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importjob");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="solutionname")
    @JsonIgnore
    public Optional<String> getSolutionname() {
        return Optional.ofNullable(solutionname);
    }

    public Importjob withSolutionname(String solutionname) {
        Checks.checkIsAscii(solutionname);
        Importjob _x = _copy();
        _x.changedFields = changedFields.add("solutionname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importjob");
        _x.solutionname = solutionname;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Importjob withCreatedon(OffsetDateTime createdon) {
        Importjob _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importjob");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="startedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartedon() {
        return Optional.ofNullable(startedon);
    }

    public Importjob withStartedon(OffsetDateTime startedon) {
        Importjob _x = _copy();
        _x.changedFields = changedFields.add("startedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importjob");
        _x.startedon = startedon;
        return _x;
    }

    public Importjob withUnmappedField(String name, String value) {
        Importjob _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Importjob patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Importjob _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Importjob put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Importjob _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Importjob _copy() {
        Importjob _x = new Importjob();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.importjobid = importjobid;
        _x._createdby_value = _createdby_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.name = name;
        _x.modifiedon = modifiedon;
        _x.importcontext = importcontext;
        _x.completedon = completedon;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._modifiedby_value = _modifiedby_value;
        _x.progress = progress;
        _x.operationcontext = operationcontext;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x._organizationid_value = _organizationid_value;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.data = data;
        _x.solutionid = solutionid;
        _x.solutionname = solutionname;
        _x.createdon = createdon;
        _x.startedon = startedon;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Importjob[");
        b.append("importjobid=");
        b.append(this.importjobid);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("importcontext=");
        b.append(this.importcontext);
        b.append(", ");
        b.append("completedon=");
        b.append(this.completedon);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("progress=");
        b.append(this.progress);
        b.append(", ");
        b.append("operationcontext=");
        b.append(this.operationcontext);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("data=");
        b.append(this.data);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("solutionname=");
        b.append(this.solutionname);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("startedon=");
        b.append(this.startedon);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
