package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;

@JsonPropertyOrder({
    "@odata.type", 
    "retrieveplugin", 
    "updatemultipleplugin", 
    "createmultipleplugin", 
    "overwritetime", 
    "componentstate", 
    "deleteplugin", 
    "retrievemultipleplugin", 
    "updateplugin", 
    "entitydataproviderid", 
    "solutionid", 
    "description", 
    "upsertplugin", 
    "organizationid", 
    "upsertmultipleplugin", 
    "createplugin", 
    "iscustomizable", 
    "name", 
    "entitydataprovideridunique", 
    "introducedversion", 
    "ismanaged", 
    "datasourcelogicalname"})
@JsonInclude(Include.NON_NULL)
public class Entitydataprovider extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.entitydataprovider";
    }

    @JsonProperty("retrieveplugin")
    protected String retrieveplugin;

    @JsonProperty("updatemultipleplugin")
    protected String updatemultipleplugin;

    @JsonProperty("createmultipleplugin")
    protected String createmultipleplugin;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("deleteplugin")
    protected String deleteplugin;

    @JsonProperty("retrievemultipleplugin")
    protected String retrievemultipleplugin;

    @JsonProperty("updateplugin")
    protected String updateplugin;

    @JsonProperty("entitydataproviderid")
    protected String entitydataproviderid;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("upsertplugin")
    protected String upsertplugin;

    @JsonProperty("organizationid")
    protected String organizationid;

    @JsonProperty("upsertmultipleplugin")
    protected String upsertmultipleplugin;

    @JsonProperty("createplugin")
    protected String createplugin;

    @JsonProperty("iscustomizable")
    protected BooleanManagedProperty iscustomizable;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("entitydataprovideridunique")
    protected String entitydataprovideridunique;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("datasourcelogicalname")
    protected String datasourcelogicalname;

    protected Entitydataprovider() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEntitydataprovider() {
        return new Builder();
    }

    public static final class Builder {
        private String retrieveplugin;
        private String updatemultipleplugin;
        private String createmultipleplugin;
        private OffsetDateTime overwritetime;
        private Integer componentstate;
        private String deleteplugin;
        private String retrievemultipleplugin;
        private String updateplugin;
        private String entitydataproviderid;
        private String solutionid;
        private String description;
        private String upsertplugin;
        private String organizationid;
        private String upsertmultipleplugin;
        private String createplugin;
        private BooleanManagedProperty iscustomizable;
        private String name;
        private String entitydataprovideridunique;
        private String introducedversion;
        private Boolean ismanaged;
        private String datasourcelogicalname;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder retrieveplugin(String retrieveplugin) {
            this.retrieveplugin = retrieveplugin;
            this.changedFields = changedFields.add("retrieveplugin");
            return this;
        }

        public Builder updatemultipleplugin(String updatemultipleplugin) {
            this.updatemultipleplugin = updatemultipleplugin;
            this.changedFields = changedFields.add("updatemultipleplugin");
            return this;
        }

        public Builder createmultipleplugin(String createmultipleplugin) {
            this.createmultipleplugin = createmultipleplugin;
            this.changedFields = changedFields.add("createmultipleplugin");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder deleteplugin(String deleteplugin) {
            this.deleteplugin = deleteplugin;
            this.changedFields = changedFields.add("deleteplugin");
            return this;
        }

        public Builder retrievemultipleplugin(String retrievemultipleplugin) {
            this.retrievemultipleplugin = retrievemultipleplugin;
            this.changedFields = changedFields.add("retrievemultipleplugin");
            return this;
        }

        public Builder updateplugin(String updateplugin) {
            this.updateplugin = updateplugin;
            this.changedFields = changedFields.add("updateplugin");
            return this;
        }

        public Builder entitydataproviderid(String entitydataproviderid) {
            this.entitydataproviderid = entitydataproviderid;
            this.changedFields = changedFields.add("entitydataproviderid");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder upsertplugin(String upsertplugin) {
            this.upsertplugin = upsertplugin;
            this.changedFields = changedFields.add("upsertplugin");
            return this;
        }

        public Builder organizationid(String organizationid) {
            this.organizationid = organizationid;
            this.changedFields = changedFields.add("organizationid");
            return this;
        }

        public Builder upsertmultipleplugin(String upsertmultipleplugin) {
            this.upsertmultipleplugin = upsertmultipleplugin;
            this.changedFields = changedFields.add("upsertmultipleplugin");
            return this;
        }

        public Builder createplugin(String createplugin) {
            this.createplugin = createplugin;
            this.changedFields = changedFields.add("createplugin");
            return this;
        }

        public Builder iscustomizable(BooleanManagedProperty iscustomizable) {
            this.iscustomizable = iscustomizable;
            this.changedFields = changedFields.add("iscustomizable");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder entitydataprovideridunique(String entitydataprovideridunique) {
            this.entitydataprovideridunique = entitydataprovideridunique;
            this.changedFields = changedFields.add("entitydataprovideridunique");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder datasourcelogicalname(String datasourcelogicalname) {
            this.datasourcelogicalname = datasourcelogicalname;
            this.changedFields = changedFields.add("datasourcelogicalname");
            return this;
        }

        public Entitydataprovider build() {
            Entitydataprovider _x = new Entitydataprovider();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.entitydataprovider";
            _x.retrieveplugin = retrieveplugin;
            _x.updatemultipleplugin = updatemultipleplugin;
            _x.createmultipleplugin = createmultipleplugin;
            _x.overwritetime = overwritetime;
            _x.componentstate = componentstate;
            _x.deleteplugin = deleteplugin;
            _x.retrievemultipleplugin = retrievemultipleplugin;
            _x.updateplugin = updateplugin;
            _x.entitydataproviderid = entitydataproviderid;
            _x.solutionid = solutionid;
            _x.description = description;
            _x.upsertplugin = upsertplugin;
            _x.organizationid = organizationid;
            _x.upsertmultipleplugin = upsertmultipleplugin;
            _x.createplugin = createplugin;
            _x.iscustomizable = iscustomizable;
            _x.name = name;
            _x.entitydataprovideridunique = entitydataprovideridunique;
            _x.introducedversion = introducedversion;
            _x.ismanaged = ismanaged;
            _x.datasourcelogicalname = datasourcelogicalname;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && entitydataproviderid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(entitydataproviderid.toString()));
        }
    }

    @Property(name="retrieveplugin")
    @JsonIgnore
    public Optional<String> getRetrieveplugin() {
        return Optional.ofNullable(retrieveplugin);
    }

    public Entitydataprovider withRetrieveplugin(String retrieveplugin) {
        Entitydataprovider _x = _copy();
        _x.changedFields = changedFields.add("retrieveplugin");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entitydataprovider");
        _x.retrieveplugin = retrieveplugin;
        return _x;
    }

    @Property(name="updatemultipleplugin")
    @JsonIgnore
    public Optional<String> getUpdatemultipleplugin() {
        return Optional.ofNullable(updatemultipleplugin);
    }

    public Entitydataprovider withUpdatemultipleplugin(String updatemultipleplugin) {
        Entitydataprovider _x = _copy();
        _x.changedFields = changedFields.add("updatemultipleplugin");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entitydataprovider");
        _x.updatemultipleplugin = updatemultipleplugin;
        return _x;
    }

    @Property(name="createmultipleplugin")
    @JsonIgnore
    public Optional<String> getCreatemultipleplugin() {
        return Optional.ofNullable(createmultipleplugin);
    }

    public Entitydataprovider withCreatemultipleplugin(String createmultipleplugin) {
        Entitydataprovider _x = _copy();
        _x.changedFields = changedFields.add("createmultipleplugin");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entitydataprovider");
        _x.createmultipleplugin = createmultipleplugin;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Entitydataprovider withOverwritetime(OffsetDateTime overwritetime) {
        Entitydataprovider _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entitydataprovider");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Entitydataprovider withComponentstate(Integer componentstate) {
        Entitydataprovider _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entitydataprovider");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="deleteplugin")
    @JsonIgnore
    public Optional<String> getDeleteplugin() {
        return Optional.ofNullable(deleteplugin);
    }

    public Entitydataprovider withDeleteplugin(String deleteplugin) {
        Entitydataprovider _x = _copy();
        _x.changedFields = changedFields.add("deleteplugin");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entitydataprovider");
        _x.deleteplugin = deleteplugin;
        return _x;
    }

    @Property(name="retrievemultipleplugin")
    @JsonIgnore
    public Optional<String> getRetrievemultipleplugin() {
        return Optional.ofNullable(retrievemultipleplugin);
    }

    public Entitydataprovider withRetrievemultipleplugin(String retrievemultipleplugin) {
        Entitydataprovider _x = _copy();
        _x.changedFields = changedFields.add("retrievemultipleplugin");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entitydataprovider");
        _x.retrievemultipleplugin = retrievemultipleplugin;
        return _x;
    }

    @Property(name="updateplugin")
    @JsonIgnore
    public Optional<String> getUpdateplugin() {
        return Optional.ofNullable(updateplugin);
    }

    public Entitydataprovider withUpdateplugin(String updateplugin) {
        Entitydataprovider _x = _copy();
        _x.changedFields = changedFields.add("updateplugin");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entitydataprovider");
        _x.updateplugin = updateplugin;
        return _x;
    }

    @Property(name="entitydataproviderid")
    @JsonIgnore
    public Optional<String> getEntitydataproviderid() {
        return Optional.ofNullable(entitydataproviderid);
    }

    public Entitydataprovider withEntitydataproviderid(String entitydataproviderid) {
        Entitydataprovider _x = _copy();
        _x.changedFields = changedFields.add("entitydataproviderid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entitydataprovider");
        _x.entitydataproviderid = entitydataproviderid;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Entitydataprovider withSolutionid(String solutionid) {
        Entitydataprovider _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entitydataprovider");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Entitydataprovider withDescription(String description) {
        Checks.checkIsAscii(description);
        Entitydataprovider _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entitydataprovider");
        _x.description = description;
        return _x;
    }

    @Property(name="upsertplugin")
    @JsonIgnore
    public Optional<String> getUpsertplugin() {
        return Optional.ofNullable(upsertplugin);
    }

    public Entitydataprovider withUpsertplugin(String upsertplugin) {
        Entitydataprovider _x = _copy();
        _x.changedFields = changedFields.add("upsertplugin");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entitydataprovider");
        _x.upsertplugin = upsertplugin;
        return _x;
    }

    @Property(name="organizationid")
    @JsonIgnore
    public Optional<String> getOrganizationid() {
        return Optional.ofNullable(organizationid);
    }

    public Entitydataprovider withOrganizationid(String organizationid) {
        Entitydataprovider _x = _copy();
        _x.changedFields = changedFields.add("organizationid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entitydataprovider");
        _x.organizationid = organizationid;
        return _x;
    }

    @Property(name="upsertmultipleplugin")
    @JsonIgnore
    public Optional<String> getUpsertmultipleplugin() {
        return Optional.ofNullable(upsertmultipleplugin);
    }

    public Entitydataprovider withUpsertmultipleplugin(String upsertmultipleplugin) {
        Entitydataprovider _x = _copy();
        _x.changedFields = changedFields.add("upsertmultipleplugin");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entitydataprovider");
        _x.upsertmultipleplugin = upsertmultipleplugin;
        return _x;
    }

    @Property(name="createplugin")
    @JsonIgnore
    public Optional<String> getCreateplugin() {
        return Optional.ofNullable(createplugin);
    }

    public Entitydataprovider withCreateplugin(String createplugin) {
        Entitydataprovider _x = _copy();
        _x.changedFields = changedFields.add("createplugin");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entitydataprovider");
        _x.createplugin = createplugin;
        return _x;
    }

    @Property(name="iscustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIscustomizable() {
        return Optional.ofNullable(iscustomizable);
    }

    public Entitydataprovider withIscustomizable(BooleanManagedProperty iscustomizable) {
        Entitydataprovider _x = _copy();
        _x.changedFields = changedFields.add("iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entitydataprovider");
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Entitydataprovider withName(String name) {
        Checks.checkIsAscii(name);
        Entitydataprovider _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entitydataprovider");
        _x.name = name;
        return _x;
    }

    @Property(name="entitydataprovideridunique")
    @JsonIgnore
    public Optional<String> getEntitydataprovideridunique() {
        return Optional.ofNullable(entitydataprovideridunique);
    }

    public Entitydataprovider withEntitydataprovideridunique(String entitydataprovideridunique) {
        Entitydataprovider _x = _copy();
        _x.changedFields = changedFields.add("entitydataprovideridunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entitydataprovider");
        _x.entitydataprovideridunique = entitydataprovideridunique;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Entitydataprovider withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Entitydataprovider _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entitydataprovider");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Entitydataprovider withIsmanaged(Boolean ismanaged) {
        Entitydataprovider _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entitydataprovider");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="datasourcelogicalname")
    @JsonIgnore
    public Optional<String> getDatasourcelogicalname() {
        return Optional.ofNullable(datasourcelogicalname);
    }

    public Entitydataprovider withDatasourcelogicalname(String datasourcelogicalname) {
        Checks.checkIsAscii(datasourcelogicalname);
        Entitydataprovider _x = _copy();
        _x.changedFields = changedFields.add("datasourcelogicalname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.entitydataprovider");
        _x.datasourcelogicalname = datasourcelogicalname;
        return _x;
    }

    public Entitydataprovider withUnmappedField(String name, String value) {
        Entitydataprovider _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Entitydataprovider patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Entitydataprovider _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Entitydataprovider put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Entitydataprovider _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Entitydataprovider _copy() {
        Entitydataprovider _x = new Entitydataprovider();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.retrieveplugin = retrieveplugin;
        _x.updatemultipleplugin = updatemultipleplugin;
        _x.createmultipleplugin = createmultipleplugin;
        _x.overwritetime = overwritetime;
        _x.componentstate = componentstate;
        _x.deleteplugin = deleteplugin;
        _x.retrievemultipleplugin = retrievemultipleplugin;
        _x.updateplugin = updateplugin;
        _x.entitydataproviderid = entitydataproviderid;
        _x.solutionid = solutionid;
        _x.description = description;
        _x.upsertplugin = upsertplugin;
        _x.organizationid = organizationid;
        _x.upsertmultipleplugin = upsertmultipleplugin;
        _x.createplugin = createplugin;
        _x.iscustomizable = iscustomizable;
        _x.name = name;
        _x.entitydataprovideridunique = entitydataprovideridunique;
        _x.introducedversion = introducedversion;
        _x.ismanaged = ismanaged;
        _x.datasourcelogicalname = datasourcelogicalname;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Entitydataprovider[");
        b.append("retrieveplugin=");
        b.append(this.retrieveplugin);
        b.append(", ");
        b.append("updatemultipleplugin=");
        b.append(this.updatemultipleplugin);
        b.append(", ");
        b.append("createmultipleplugin=");
        b.append(this.createmultipleplugin);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("deleteplugin=");
        b.append(this.deleteplugin);
        b.append(", ");
        b.append("retrievemultipleplugin=");
        b.append(this.retrievemultipleplugin);
        b.append(", ");
        b.append("updateplugin=");
        b.append(this.updateplugin);
        b.append(", ");
        b.append("entitydataproviderid=");
        b.append(this.entitydataproviderid);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("upsertplugin=");
        b.append(this.upsertplugin);
        b.append(", ");
        b.append("organizationid=");
        b.append(this.organizationid);
        b.append(", ");
        b.append("upsertmultipleplugin=");
        b.append(this.upsertmultipleplugin);
        b.append(", ");
        b.append("createplugin=");
        b.append(this.createplugin);
        b.append(", ");
        b.append("iscustomizable=");
        b.append(this.iscustomizable);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("entitydataprovideridunique=");
        b.append(this.entitydataprovideridunique);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("datasourcelogicalname=");
        b.append(this.datasourcelogicalname);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
