package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.ConnectorRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "componentidunique", 
    "statecode", 
    "connectorid", 
    "_customconnectorid_value", 
    "overriddencreatedon", 
    "overwritetime", 
    "createdon", 
    "modifiedon", 
    "iscustomizable", 
    "_owninguser_value", 
    "_modifiedonbehalfby_value", 
    "solutionid", 
    "connectionreferencedisplayname", 
    "_modifiedby_value", 
    "versionnumber", 
    "utcconversiontimezonecode", 
    "connectionreferencelogicalname", 
    "componentstate", 
    "statuscode", 
    "_owningbusinessunit_value", 
    "_createdonbehalfby_value", 
    "_owningteam_value", 
    "ismanaged", 
    "importsequencenumber", 
    "timezoneruleversionnumber", 
    "connectionid", 
    "_ownerid_value", 
    "connectionreferenceid", 
    "_createdby_value"})
@JsonInclude(Include.NON_NULL)
public class Connectionreference extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.connectionreference";
    }

    @JsonProperty("description")
    protected String description;

    @JsonProperty("componentidunique")
    protected String componentidunique;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("connectorid")
    protected String connectorid;

    @JsonProperty("_customconnectorid_value")
    protected String _customconnectorid_value;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("iscustomizable")
    protected BooleanManagedProperty iscustomizable;

    @JsonProperty("_owninguser_value")
    protected String _owninguser_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("connectionreferencedisplayname")
    protected String connectionreferencedisplayname;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("connectionreferencelogicalname")
    protected String connectionreferencelogicalname;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("_owningbusinessunit_value")
    protected String _owningbusinessunit_value;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("_owningteam_value")
    protected String _owningteam_value;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("connectionid")
    protected String connectionid;

    @JsonProperty("_ownerid_value")
    protected String _ownerid_value;

    @JsonProperty("connectionreferenceid")
    protected String connectionreferenceid;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    protected Connectionreference() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderConnectionreference() {
        return new Builder();
    }

    public static final class Builder {
        private String description;
        private String componentidunique;
        private Integer statecode;
        private String connectorid;
        private String _customconnectorid_value;
        private OffsetDateTime overriddencreatedon;
        private OffsetDateTime overwritetime;
        private OffsetDateTime createdon;
        private OffsetDateTime modifiedon;
        private BooleanManagedProperty iscustomizable;
        private String _owninguser_value;
        private String _modifiedonbehalfby_value;
        private String solutionid;
        private String connectionreferencedisplayname;
        private String _modifiedby_value;
        private Long versionnumber;
        private Integer utcconversiontimezonecode;
        private String connectionreferencelogicalname;
        private Integer componentstate;
        private Integer statuscode;
        private String _owningbusinessunit_value;
        private String _createdonbehalfby_value;
        private String _owningteam_value;
        private Boolean ismanaged;
        private Integer importsequencenumber;
        private Integer timezoneruleversionnumber;
        private String connectionid;
        private String _ownerid_value;
        private String connectionreferenceid;
        private String _createdby_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder componentidunique(String componentidunique) {
            this.componentidunique = componentidunique;
            this.changedFields = changedFields.add("componentidunique");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder connectorid(String connectorid) {
            this.connectorid = connectorid;
            this.changedFields = changedFields.add("connectorid");
            return this;
        }

        public Builder _customconnectorid_value(String _customconnectorid_value) {
            this._customconnectorid_value = _customconnectorid_value;
            this.changedFields = changedFields.add("_customconnectorid_value");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder iscustomizable(BooleanManagedProperty iscustomizable) {
            this.iscustomizable = iscustomizable;
            this.changedFields = changedFields.add("iscustomizable");
            return this;
        }

        public Builder _owninguser_value(String _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder connectionreferencedisplayname(String connectionreferencedisplayname) {
            this.connectionreferencedisplayname = connectionreferencedisplayname;
            this.changedFields = changedFields.add("connectionreferencedisplayname");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder connectionreferencelogicalname(String connectionreferencelogicalname) {
            this.connectionreferencelogicalname = connectionreferencelogicalname;
            this.changedFields = changedFields.add("connectionreferencelogicalname");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder _owningbusinessunit_value(String _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _owningteam_value(String _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder connectionid(String connectionid) {
            this.connectionid = connectionid;
            this.changedFields = changedFields.add("connectionid");
            return this;
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder connectionreferenceid(String connectionreferenceid) {
            this.connectionreferenceid = connectionreferenceid;
            this.changedFields = changedFields.add("connectionreferenceid");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Connectionreference build() {
            Connectionreference _x = new Connectionreference();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.connectionreference";
            _x.description = description;
            _x.componentidunique = componentidunique;
            _x.statecode = statecode;
            _x.connectorid = connectorid;
            _x._customconnectorid_value = _customconnectorid_value;
            _x.overriddencreatedon = overriddencreatedon;
            _x.overwritetime = overwritetime;
            _x.createdon = createdon;
            _x.modifiedon = modifiedon;
            _x.iscustomizable = iscustomizable;
            _x._owninguser_value = _owninguser_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.solutionid = solutionid;
            _x.connectionreferencedisplayname = connectionreferencedisplayname;
            _x._modifiedby_value = _modifiedby_value;
            _x.versionnumber = versionnumber;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.connectionreferencelogicalname = connectionreferencelogicalname;
            _x.componentstate = componentstate;
            _x.statuscode = statuscode;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._owningteam_value = _owningteam_value;
            _x.ismanaged = ismanaged;
            _x.importsequencenumber = importsequencenumber;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.connectionid = connectionid;
            _x._ownerid_value = _ownerid_value;
            _x.connectionreferenceid = connectionreferenceid;
            _x._createdby_value = _createdby_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && connectionreferenceid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(connectionreferenceid.toString()));
        }
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Connectionreference withDescription(String description) {
        Checks.checkIsAscii(description);
        Connectionreference _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionreference");
        _x.description = description;
        return _x;
    }

    @Property(name="componentidunique")
    @JsonIgnore
    public Optional<String> getComponentidunique() {
        return Optional.ofNullable(componentidunique);
    }

    public Connectionreference withComponentidunique(String componentidunique) {
        Connectionreference _x = _copy();
        _x.changedFields = changedFields.add("componentidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionreference");
        _x.componentidunique = componentidunique;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Connectionreference withStatecode(Integer statecode) {
        Connectionreference _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionreference");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="connectorid")
    @JsonIgnore
    public Optional<String> getConnectorid() {
        return Optional.ofNullable(connectorid);
    }

    public Connectionreference withConnectorid(String connectorid) {
        Checks.checkIsAscii(connectorid);
        Connectionreference _x = _copy();
        _x.changedFields = changedFields.add("connectorid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionreference");
        _x.connectorid = connectorid;
        return _x;
    }

    @Property(name="_customconnectorid_value")
    @JsonIgnore
    public Optional<String> get_customconnectorid_value() {
        return Optional.ofNullable(_customconnectorid_value);
    }

    public Connectionreference with_customconnectorid_value(String _customconnectorid_value) {
        Connectionreference _x = _copy();
        _x.changedFields = changedFields.add("_customconnectorid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionreference");
        _x._customconnectorid_value = _customconnectorid_value;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Connectionreference withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Connectionreference _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionreference");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Connectionreference withOverwritetime(OffsetDateTime overwritetime) {
        Connectionreference _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionreference");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Connectionreference withCreatedon(OffsetDateTime createdon) {
        Connectionreference _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionreference");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Connectionreference withModifiedon(OffsetDateTime modifiedon) {
        Connectionreference _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionreference");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="iscustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIscustomizable() {
        return Optional.ofNullable(iscustomizable);
    }

    public Connectionreference withIscustomizable(BooleanManagedProperty iscustomizable) {
        Connectionreference _x = _copy();
        _x.changedFields = changedFields.add("iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionreference");
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<String> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Connectionreference with_owninguser_value(String _owninguser_value) {
        Connectionreference _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionreference");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Connectionreference with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Connectionreference _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionreference");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Connectionreference withSolutionid(String solutionid) {
        Connectionreference _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionreference");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="connectionreferencedisplayname")
    @JsonIgnore
    public Optional<String> getConnectionreferencedisplayname() {
        return Optional.ofNullable(connectionreferencedisplayname);
    }

    public Connectionreference withConnectionreferencedisplayname(String connectionreferencedisplayname) {
        Checks.checkIsAscii(connectionreferencedisplayname);
        Connectionreference _x = _copy();
        _x.changedFields = changedFields.add("connectionreferencedisplayname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionreference");
        _x.connectionreferencedisplayname = connectionreferencedisplayname;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Connectionreference with_modifiedby_value(String _modifiedby_value) {
        Connectionreference _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionreference");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Connectionreference withVersionnumber(Long versionnumber) {
        Connectionreference _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionreference");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Connectionreference withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Connectionreference _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionreference");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="connectionreferencelogicalname")
    @JsonIgnore
    public Optional<String> getConnectionreferencelogicalname() {
        return Optional.ofNullable(connectionreferencelogicalname);
    }

    public Connectionreference withConnectionreferencelogicalname(String connectionreferencelogicalname) {
        Checks.checkIsAscii(connectionreferencelogicalname);
        Connectionreference _x = _copy();
        _x.changedFields = changedFields.add("connectionreferencelogicalname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionreference");
        _x.connectionreferencelogicalname = connectionreferencelogicalname;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Connectionreference withComponentstate(Integer componentstate) {
        Connectionreference _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionreference");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Connectionreference withStatuscode(Integer statuscode) {
        Connectionreference _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionreference");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<String> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Connectionreference with_owningbusinessunit_value(String _owningbusinessunit_value) {
        Connectionreference _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionreference");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Connectionreference with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Connectionreference _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionreference");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<String> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Connectionreference with_owningteam_value(String _owningteam_value) {
        Connectionreference _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionreference");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Connectionreference withIsmanaged(Boolean ismanaged) {
        Connectionreference _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionreference");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Connectionreference withImportsequencenumber(Integer importsequencenumber) {
        Connectionreference _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionreference");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Connectionreference withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Connectionreference _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionreference");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="connectionid")
    @JsonIgnore
    public Optional<String> getConnectionid() {
        return Optional.ofNullable(connectionid);
    }

    public Connectionreference withConnectionid(String connectionid) {
        Checks.checkIsAscii(connectionid);
        Connectionreference _x = _copy();
        _x.changedFields = changedFields.add("connectionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionreference");
        _x.connectionid = connectionid;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<String> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Connectionreference with_ownerid_value(String _ownerid_value) {
        Connectionreference _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionreference");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="connectionreferenceid")
    @JsonIgnore
    public Optional<String> getConnectionreferenceid() {
        return Optional.ofNullable(connectionreferenceid);
    }

    public Connectionreference withConnectionreferenceid(String connectionreferenceid) {
        Connectionreference _x = _copy();
        _x.changedFields = changedFields.add("connectionreferenceid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionreference");
        _x.connectionreferenceid = connectionreferenceid;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Connectionreference with_createdby_value(String _createdby_value) {
        Connectionreference _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connectionreference");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    public Connectionreference withUnmappedField(String name, String value) {
        Connectionreference _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="connectionreference_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getConnectionreference_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("connectionreference_SyncErrors"), RequestHelper.getValue(unmappedFields, "connectionreference_SyncErrors"));
    }

    @NavigationProperty(name="connectionreference_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getConnectionreference_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("connectionreference_AsyncOperations"), RequestHelper.getValue(unmappedFields, "connectionreference_AsyncOperations"));
    }

    @NavigationProperty(name="connectionreference_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getConnectionreference_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("connectionreference_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "connectionreference_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="connectionreference_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getConnectionreference_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("connectionreference_ProcessSession"), RequestHelper.getValue(unmappedFields, "connectionreference_ProcessSession"));
    }

    @NavigationProperty(name="connectionreference_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getConnectionreference_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("connectionreference_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "connectionreference_BulkDeleteFailures"));
    }

    @NavigationProperty(name="connectionreference_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getConnectionreference_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("connectionreference_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "connectionreference_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="CustomConnectorId")
    @JsonIgnore
    public ConnectorRequest getCustomConnectorId() {
        return new ConnectorRequest(contextPath.addSegment("CustomConnectorId"), RequestHelper.getValue(unmappedFields, "CustomConnectorId"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Connectionreference patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Connectionreference _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Connectionreference put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Connectionreference _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Connectionreference _copy() {
        Connectionreference _x = new Connectionreference();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.description = description;
        _x.componentidunique = componentidunique;
        _x.statecode = statecode;
        _x.connectorid = connectorid;
        _x._customconnectorid_value = _customconnectorid_value;
        _x.overriddencreatedon = overriddencreatedon;
        _x.overwritetime = overwritetime;
        _x.createdon = createdon;
        _x.modifiedon = modifiedon;
        _x.iscustomizable = iscustomizable;
        _x._owninguser_value = _owninguser_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.solutionid = solutionid;
        _x.connectionreferencedisplayname = connectionreferencedisplayname;
        _x._modifiedby_value = _modifiedby_value;
        _x.versionnumber = versionnumber;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.connectionreferencelogicalname = connectionreferencelogicalname;
        _x.componentstate = componentstate;
        _x.statuscode = statuscode;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._owningteam_value = _owningteam_value;
        _x.ismanaged = ismanaged;
        _x.importsequencenumber = importsequencenumber;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.connectionid = connectionid;
        _x._ownerid_value = _ownerid_value;
        _x.connectionreferenceid = connectionreferenceid;
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Connectionreference[");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("componentidunique=");
        b.append(this.componentidunique);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("connectorid=");
        b.append(this.connectorid);
        b.append(", ");
        b.append("_customconnectorid_value=");
        b.append(this._customconnectorid_value);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("iscustomizable=");
        b.append(this.iscustomizable);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("connectionreferencedisplayname=");
        b.append(this.connectionreferencedisplayname);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("connectionreferencelogicalname=");
        b.append(this.connectionreferencelogicalname);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("connectionid=");
        b.append(this.connectionid);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("connectionreferenceid=");
        b.append(this.connectionreferenceid);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
