package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.RelationshipattributeCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SolutioncomponentattributeconfigurationCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "componentstate", 
    "overwritetime", 
    "externalname", 
    "logicalname", 
    "managedpropertyparentattributename", 
    "name", 
    "managedpropertylogicalname", 
    "attributeid", 
    "physicalname", 
    "solutionid", 
    "tablecolumnname"})
@JsonInclude(Include.NON_NULL)
public class Attribute extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.attribute";
    }

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("externalname")
    protected String externalname;

    @JsonProperty("logicalname")
    protected String logicalname;

    @JsonProperty("managedpropertyparentattributename")
    protected String managedpropertyparentattributename;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("managedpropertylogicalname")
    protected String managedpropertylogicalname;

    @JsonProperty("attributeid")
    protected String attributeid;

    @JsonProperty("physicalname")
    protected String physicalname;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("tablecolumnname")
    protected String tablecolumnname;

    protected Attribute() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAttribute() {
        return new Builder();
    }

    public static final class Builder {
        private Integer componentstate;
        private OffsetDateTime overwritetime;
        private String externalname;
        private String logicalname;
        private String managedpropertyparentattributename;
        private String name;
        private String managedpropertylogicalname;
        private String attributeid;
        private String physicalname;
        private String solutionid;
        private String tablecolumnname;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder externalname(String externalname) {
            this.externalname = externalname;
            this.changedFields = changedFields.add("externalname");
            return this;
        }

        public Builder logicalname(String logicalname) {
            this.logicalname = logicalname;
            this.changedFields = changedFields.add("logicalname");
            return this;
        }

        public Builder managedpropertyparentattributename(String managedpropertyparentattributename) {
            this.managedpropertyparentattributename = managedpropertyparentattributename;
            this.changedFields = changedFields.add("managedpropertyparentattributename");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder managedpropertylogicalname(String managedpropertylogicalname) {
            this.managedpropertylogicalname = managedpropertylogicalname;
            this.changedFields = changedFields.add("managedpropertylogicalname");
            return this;
        }

        public Builder attributeid(String attributeid) {
            this.attributeid = attributeid;
            this.changedFields = changedFields.add("attributeid");
            return this;
        }

        public Builder physicalname(String physicalname) {
            this.physicalname = physicalname;
            this.changedFields = changedFields.add("physicalname");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder tablecolumnname(String tablecolumnname) {
            this.tablecolumnname = tablecolumnname;
            this.changedFields = changedFields.add("tablecolumnname");
            return this;
        }

        public Attribute build() {
            Attribute _x = new Attribute();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.attribute";
            _x.componentstate = componentstate;
            _x.overwritetime = overwritetime;
            _x.externalname = externalname;
            _x.logicalname = logicalname;
            _x.managedpropertyparentattributename = managedpropertyparentattributename;
            _x.name = name;
            _x.managedpropertylogicalname = managedpropertylogicalname;
            _x.attributeid = attributeid;
            _x.physicalname = physicalname;
            _x.solutionid = solutionid;
            _x.tablecolumnname = tablecolumnname;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && attributeid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(attributeid.toString()));
        }
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Attribute withComponentstate(Integer componentstate) {
        Attribute _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.attribute");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Attribute withOverwritetime(OffsetDateTime overwritetime) {
        Attribute _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.attribute");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="externalname")
    @JsonIgnore
    public Optional<String> getExternalname() {
        return Optional.ofNullable(externalname);
    }

    public Attribute withExternalname(String externalname) {
        Checks.checkIsAscii(externalname);
        Attribute _x = _copy();
        _x.changedFields = changedFields.add("externalname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.attribute");
        _x.externalname = externalname;
        return _x;
    }

    @Property(name="logicalname")
    @JsonIgnore
    public Optional<String> getLogicalname() {
        return Optional.ofNullable(logicalname);
    }

    public Attribute withLogicalname(String logicalname) {
        Checks.checkIsAscii(logicalname);
        Attribute _x = _copy();
        _x.changedFields = changedFields.add("logicalname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.attribute");
        _x.logicalname = logicalname;
        return _x;
    }

    @Property(name="managedpropertyparentattributename")
    @JsonIgnore
    public Optional<String> getManagedpropertyparentattributename() {
        return Optional.ofNullable(managedpropertyparentattributename);
    }

    public Attribute withManagedpropertyparentattributename(String managedpropertyparentattributename) {
        Checks.checkIsAscii(managedpropertyparentattributename);
        Attribute _x = _copy();
        _x.changedFields = changedFields.add("managedpropertyparentattributename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.attribute");
        _x.managedpropertyparentattributename = managedpropertyparentattributename;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Attribute withName(String name) {
        Checks.checkIsAscii(name);
        Attribute _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.attribute");
        _x.name = name;
        return _x;
    }

    @Property(name="managedpropertylogicalname")
    @JsonIgnore
    public Optional<String> getManagedpropertylogicalname() {
        return Optional.ofNullable(managedpropertylogicalname);
    }

    public Attribute withManagedpropertylogicalname(String managedpropertylogicalname) {
        Checks.checkIsAscii(managedpropertylogicalname);
        Attribute _x = _copy();
        _x.changedFields = changedFields.add("managedpropertylogicalname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.attribute");
        _x.managedpropertylogicalname = managedpropertylogicalname;
        return _x;
    }

    @Property(name="attributeid")
    @JsonIgnore
    public Optional<String> getAttributeid() {
        return Optional.ofNullable(attributeid);
    }

    public Attribute withAttributeid(String attributeid) {
        Attribute _x = _copy();
        _x.changedFields = changedFields.add("attributeid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.attribute");
        _x.attributeid = attributeid;
        return _x;
    }

    @Property(name="physicalname")
    @JsonIgnore
    public Optional<String> getPhysicalname() {
        return Optional.ofNullable(physicalname);
    }

    public Attribute withPhysicalname(String physicalname) {
        Checks.checkIsAscii(physicalname);
        Attribute _x = _copy();
        _x.changedFields = changedFields.add("physicalname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.attribute");
        _x.physicalname = physicalname;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Attribute withSolutionid(String solutionid) {
        Attribute _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.attribute");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="tablecolumnname")
    @JsonIgnore
    public Optional<String> getTablecolumnname() {
        return Optional.ofNullable(tablecolumnname);
    }

    public Attribute withTablecolumnname(String tablecolumnname) {
        Checks.checkIsAscii(tablecolumnname);
        Attribute _x = _copy();
        _x.changedFields = changedFields.add("tablecolumnname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.attribute");
        _x.tablecolumnname = tablecolumnname;
        return _x;
    }

    public Attribute withUnmappedField(String name, String value) {
        Attribute _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="attribute_solutioncomponentattrconfig")
    @JsonIgnore
    public SolutioncomponentattributeconfigurationCollectionRequest getAttribute_solutioncomponentattrconfig() {
        return new SolutioncomponentattributeconfigurationCollectionRequest(
                        contextPath.addSegment("attribute_solutioncomponentattrconfig"), RequestHelper.getValue(unmappedFields, "attribute_solutioncomponentattrconfig"));
    }

    @NavigationProperty(name="referencingdattribute_relationshipattribute")
    @JsonIgnore
    public RelationshipattributeCollectionRequest getReferencingdattribute_relationshipattribute() {
        return new RelationshipattributeCollectionRequest(
                        contextPath.addSegment("referencingdattribute_relationshipattribute"), RequestHelper.getValue(unmappedFields, "referencingdattribute_relationshipattribute"));
    }

    @NavigationProperty(name="referencedattribute_relationshipattribute")
    @JsonIgnore
    public RelationshipattributeCollectionRequest getReferencedattribute_relationshipattribute() {
        return new RelationshipattributeCollectionRequest(
                        contextPath.addSegment("referencedattribute_relationshipattribute"), RequestHelper.getValue(unmappedFields, "referencedattribute_relationshipattribute"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Attribute patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Attribute _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Attribute put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Attribute _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Attribute _copy() {
        Attribute _x = new Attribute();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.componentstate = componentstate;
        _x.overwritetime = overwritetime;
        _x.externalname = externalname;
        _x.logicalname = logicalname;
        _x.managedpropertyparentattributename = managedpropertyparentattributename;
        _x.name = name;
        _x.managedpropertylogicalname = managedpropertylogicalname;
        _x.attributeid = attributeid;
        _x.physicalname = physicalname;
        _x.solutionid = solutionid;
        _x.tablecolumnname = tablecolumnname;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Attribute[");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("externalname=");
        b.append(this.externalname);
        b.append(", ");
        b.append("logicalname=");
        b.append(this.logicalname);
        b.append(", ");
        b.append("managedpropertyparentattributename=");
        b.append(this.managedpropertyparentattributename);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("managedpropertylogicalname=");
        b.append(this.managedpropertylogicalname);
        b.append(", ");
        b.append("attributeid=");
        b.append(this.attributeid);
        b.append(", ");
        b.append("physicalname=");
        b.append(this.physicalname);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("tablecolumnname=");
        b.append(this.tablecolumnname);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
