package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "Name", 
    "Type", 
    "TrueOption", 
    "FalseOption", 
    "Options"})
@JsonInclude(Include.NON_NULL)
public class DependentOptionSetMetadata implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Name")
    protected String name;

    @JsonProperty("Type")
    protected String type;

    @JsonProperty("TrueOption")
    protected DependentOptionMetadata trueOption;

    @JsonProperty("FalseOption")
    protected DependentOptionMetadata falseOption;

    @JsonProperty("Options")
    protected DependentOptionMetadataCollection options;

    protected DependentOptionSetMetadata() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.DependentOptionSetMetadata";
    }

    @Property(name="Name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public DependentOptionSetMetadata withName(String name) {
        Checks.checkIsAscii(name);
        DependentOptionSetMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.DependentOptionSetMetadata");
        _x.name = name;
        return _x;
    }

    @Property(name="Type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    public DependentOptionSetMetadata withType(String type) {
        Checks.checkIsAscii(type);
        DependentOptionSetMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.DependentOptionSetMetadata");
        _x.type = type;
        return _x;
    }

    @Property(name="TrueOption")
    @JsonIgnore
    public Optional<DependentOptionMetadata> getTrueOption() {
        return Optional.ofNullable(trueOption);
    }

    public DependentOptionSetMetadata withTrueOption(DependentOptionMetadata trueOption) {
        DependentOptionSetMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.DependentOptionSetMetadata");
        _x.trueOption = trueOption;
        return _x;
    }

    @Property(name="FalseOption")
    @JsonIgnore
    public Optional<DependentOptionMetadata> getFalseOption() {
        return Optional.ofNullable(falseOption);
    }

    public DependentOptionSetMetadata withFalseOption(DependentOptionMetadata falseOption) {
        DependentOptionSetMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.DependentOptionSetMetadata");
        _x.falseOption = falseOption;
        return _x;
    }

    @Property(name="Options")
    @JsonIgnore
    public Optional<DependentOptionMetadataCollection> getOptions() {
        return Optional.ofNullable(options);
    }

    public DependentOptionSetMetadata withOptions(DependentOptionMetadataCollection options) {
        DependentOptionSetMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.DependentOptionSetMetadata");
        _x.options = options;
        return _x;
    }

    public DependentOptionSetMetadata withUnmappedField(String name, String value) {
        DependentOptionSetMetadata _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String type;
        private DependentOptionMetadata trueOption;
        private DependentOptionMetadata falseOption;
        private DependentOptionMetadataCollection options;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("Name");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("Type");
            return this;
        }

        public Builder trueOption(DependentOptionMetadata trueOption) {
            this.trueOption = trueOption;
            this.changedFields = changedFields.add("TrueOption");
            return this;
        }

        public Builder falseOption(DependentOptionMetadata falseOption) {
            this.falseOption = falseOption;
            this.changedFields = changedFields.add("FalseOption");
            return this;
        }

        public Builder options(DependentOptionMetadataCollection options) {
            this.options = options;
            this.changedFields = changedFields.add("Options");
            return this;
        }

        public DependentOptionSetMetadata build() {
            DependentOptionSetMetadata _x = new DependentOptionSetMetadata();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.DependentOptionSetMetadata";
            _x.name = name;
            _x.type = type;
            _x.trueOption = trueOption;
            _x.falseOption = falseOption;
            _x.options = options;
            return _x;
        }
    }

    private DependentOptionSetMetadata _copy() {
        DependentOptionSetMetadata _x = new DependentOptionSetMetadata();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.name = name;
        _x.type = type;
        _x.trueOption = trueOption;
        _x.falseOption = falseOption;
        _x.options = options;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DependentOptionSetMetadata[");
        b.append("Name=");
        b.append(this.name);
        b.append(", ");
        b.append("Type=");
        b.append(this.type);
        b.append(", ");
        b.append("TrueOption=");
        b.append(this.trueOption);
        b.append(", ");
        b.append("FalseOption=");
        b.append(this.falseOption);
        b.append(", ");
        b.append("Options=");
        b.append(this.options);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
