package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "CanBeActivated", 
    "ValidationIssueList"})
@JsonInclude(Include.NON_NULL)
public class AppModuleValidationResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("CanBeActivated")
    protected Boolean canBeActivated;

    @JsonProperty("ValidationIssueList")
    protected List<ValidationIssue> validationIssueList;

    @JsonProperty("ValidationIssueList@nextLink")
    protected String validationIssueListNextLink;

    protected AppModuleValidationResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.AppModuleValidationResponse";
    }

    @Property(name="CanBeActivated")
    @JsonIgnore
    public Optional<Boolean> getCanBeActivated() {
        return Optional.ofNullable(canBeActivated);
    }

    public AppModuleValidationResponse withCanBeActivated(Boolean canBeActivated) {
        AppModuleValidationResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppModuleValidationResponse");
        _x.canBeActivated = canBeActivated;
        return _x;
    }

    @Property(name="ValidationIssueList")
    @JsonIgnore
    public CollectionPage<ValidationIssue> getValidationIssueList() {
        return new CollectionPage<ValidationIssue>(contextPath, ValidationIssue.class, this.validationIssueList, Optional.ofNullable(validationIssueListNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="ValidationIssueList")
    @JsonIgnore
    public CollectionPage<ValidationIssue> getValidationIssueList(HttpRequestOptions options) {
        return new CollectionPage<ValidationIssue>(contextPath, ValidationIssue.class, this.validationIssueList, Optional.ofNullable(validationIssueListNextLink), Collections.emptyList(), options);
    }

    public AppModuleValidationResponse withUnmappedField(String name, String value) {
        AppModuleValidationResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean canBeActivated;
        private List<ValidationIssue> validationIssueList;
        private String validationIssueListNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder canBeActivated(Boolean canBeActivated) {
            this.canBeActivated = canBeActivated;
            this.changedFields = changedFields.add("CanBeActivated");
            return this;
        }

        public Builder validationIssueList(List<ValidationIssue> validationIssueList) {
            this.validationIssueList = validationIssueList;
            this.changedFields = changedFields.add("ValidationIssueList");
            return this;
        }

        public Builder validationIssueList(ValidationIssue... validationIssueList) {
            return validationIssueList(Arrays.asList(validationIssueList));
        }

        public Builder validationIssueListNextLink(String validationIssueListNextLink) {
            this.validationIssueListNextLink = validationIssueListNextLink;
            this.changedFields = changedFields.add("ValidationIssueList");
            return this;
        }

        public AppModuleValidationResponse build() {
            AppModuleValidationResponse _x = new AppModuleValidationResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.AppModuleValidationResponse";
            _x.canBeActivated = canBeActivated;
            _x.validationIssueList = validationIssueList;
            _x.validationIssueListNextLink = validationIssueListNextLink;
            return _x;
        }
    }

    private AppModuleValidationResponse _copy() {
        AppModuleValidationResponse _x = new AppModuleValidationResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.canBeActivated = canBeActivated;
        _x.validationIssueList = validationIssueList;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppModuleValidationResponse[");
        b.append("CanBeActivated=");
        b.append(this.canBeActivated);
        b.append(", ");
        b.append("ValidationIssueList=");
        b.append(this.validationIssueList);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
