package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ImeMode implements Enum {

    @JsonProperty("Auto")
    AUTO("Auto", "0"),

    @JsonProperty("Inactive")
    INACTIVE("Inactive", "1"),

    @JsonProperty("Active")
    ACTIVE("Active", "2"),

    @JsonProperty("Disabled")
    DISABLED("Disabled", "3");

    private final String name;
    private final String value;

    private ImeMode(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
