package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Socialprofile;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SocialactivityCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class SocialprofileRequest extends EntityRequest<Socialprofile> {

    public SocialprofileRequest(ContextPath contextPath, Optional<Object> value) {
        super(Socialprofile.class, contextPath, value, false);
    }

    public DuplicaterecordRequest socialProfile_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("SocialProfile_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest socialProfile_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("SocialProfile_DuplicateBaseRecord"), Optional.empty());
    }

    public AsyncoperationRequest socialProfile_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("SocialProfile_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest socialProfile_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("SocialProfile_AsyncOperations"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public ConnectionRequest socialprofile_connections1(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("socialprofile_connections1").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public ConnectionCollectionRequest socialprofile_connections1() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("socialprofile_connections1"), Optional.empty());
    }

    public ConnectionRequest socialprofile_connections2(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("socialprofile_connections2").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public ConnectionCollectionRequest socialprofile_connections2() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("socialprofile_connections2"), Optional.empty());
    }

    public SystemuserRequest owninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), Optional.empty());
    }

    public ContactRequest customerid_contact() {
        return new ContactRequest(contextPath.addSegment("customerid_contact"), Optional.empty());
    }

    public SyncerrorRequest socialProfile_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("SocialProfile_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest socialProfile_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("SocialProfile_SyncErrors"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest socialprofile_principalobjectattributeaccess(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("socialprofile_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest socialprofile_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("socialprofile_principalobjectattributeaccess"), Optional.empty());
    }

    public SocialactivityRequest socialprofile_SocialActivities(String activityid) {
        return new SocialactivityRequest(contextPath.addSegment("Socialprofile_SocialActivities").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public SocialactivityCollectionRequest socialprofile_SocialActivities() {
        return new SocialactivityCollectionRequest(
                        contextPath.addSegment("Socialprofile_SocialActivities"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), Optional.empty());
    }

    public ProcesssessionRequest socialProfile_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("SocialProfile_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest socialProfile_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("SocialProfile_ProcessSessions"), Optional.empty());
    }

    public DuplicaterecordRequest socialProfile_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("SocialProfile_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest socialProfile_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("SocialProfile_DuplicateMatchingRecord"), Optional.empty());
    }

    public AccountRequest customerid_account() {
        return new AccountRequest(contextPath.addSegment("customerid_account"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

}
