package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Newprocess;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.WorkflowlogCollectionRequest;

@JsonIgnoreType
public class NewprocessRequest extends EntityRequest<Newprocess> {

    public NewprocessRequest(ContextPath contextPath, Optional<Object> value) {
        super(Newprocess.class, contextPath, value, false);
    }

    public SystemuserRequest createdbyname() {
        return new SystemuserRequest(contextPath.addSegment("createdbyname"), Optional.empty());
    }

    public SystemuserRequest modifiedbyname() {
        return new SystemuserRequest(contextPath.addSegment("modifiedbyname"), Optional.empty());
    }

    public KnowledgearticleRequest knowledgearticleid() {
        return new KnowledgearticleRequest(contextPath.addSegment("knowledgearticleid"), Optional.empty());
    }

    public ProcesssessionRequest newProcess_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("NewProcess_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest newProcess_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("NewProcess_ProcessSessions"), Optional.empty());
    }

    public ProcessstageRequest activestageid() {
        return new ProcessstageRequest(contextPath.addSegment("activestageid"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfbyname() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfbyname"), Optional.empty());
    }

    public WorkflowlogRequest workflowlogs_newprocess(String workflowlogid) {
        return new WorkflowlogRequest(contextPath.addSegment("workflowlogs_newprocess").addKeys(new NameValue(workflowlogid.toString())), Optional.empty());
    }

    public WorkflowlogCollectionRequest workflowlogs_newprocess() {
        return new WorkflowlogCollectionRequest(
                        contextPath.addSegment("workflowlogs_newprocess"), Optional.empty());
    }

    public WorkflowRequest processid() {
        return new WorkflowRequest(contextPath.addSegment("processid"), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfbyname() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfbyname"), Optional.empty());
    }

    public SyncerrorRequest newProcess_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("NewProcess_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest newProcess_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("NewProcess_SyncErrors"), Optional.empty());
    }

}
