package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Knowledgearticleviews;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class KnowledgearticleviewsRequest extends EntityRequest<Knowledgearticleviews> {

    public KnowledgearticleviewsRequest(ContextPath contextPath, Optional<Object> value) {
        super(Knowledgearticleviews.class, contextPath, value, false);
    }

    public SyncerrorRequest knowledgeArticleViews_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("KnowledgeArticleViews_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest knowledgeArticleViews_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("KnowledgeArticleViews_SyncErrors"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public KnowledgearticleRequest knowledgearticleid() {
        return new KnowledgearticleRequest(contextPath.addSegment("knowledgearticleid"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest knowledgearticleviews_principalobjectattributeaccess(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("knowledgearticleviews_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest knowledgearticleviews_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("knowledgearticleviews_principalobjectattributeaccess"), Optional.empty());
    }

}
