package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Businessunitnewsarticle;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;

@JsonIgnoreType
public class BusinessunitnewsarticleRequest extends EntityRequest<Businessunitnewsarticle> {

    public BusinessunitnewsarticleRequest(ContextPath contextPath, Optional<Object> value) {
        super(Businessunitnewsarticle.class, contextPath, value, false);
    }

    public BulkdeletefailureRequest businessUnitNewsArticle_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("BusinessUnitNewsArticle_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest businessUnitNewsArticle_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("BusinessUnitNewsArticle_BulkDeleteFailures"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public AsyncoperationRequest businessUnitNewsArticle_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("BusinessUnitNewsArticle_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest businessUnitNewsArticle_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("BusinessUnitNewsArticle_AsyncOperations"), Optional.empty());
    }

    public ProcesssessionRequest businessUnitNewsArticle_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("BusinessUnitNewsArticle_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest businessUnitNewsArticle_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("BusinessUnitNewsArticle_ProcessSessions"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

}
