package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Usermapping;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.UsermappingRequest;

public class UsermappingCollectionRequest extends CollectionPageEntityRequest<Usermapping, UsermappingRequest>{

    protected ContextPath contextPath;

    public UsermappingCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Usermapping.class, cp -> new UsermappingRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AsyncoperationRequest usermapping_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("usermapping_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest usermapping_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("usermapping_AsyncOperations"), Optional.empty());
    }

    public ProcesssessionRequest usermapping_ProcessSession(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("usermapping_ProcessSession").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest usermapping_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("usermapping_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest usermapping_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("usermapping_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest usermapping_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("usermapping_BulkDeleteFailures"), Optional.empty());
    }

}
