package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Solutioncomponent;
import microsoft.dynamics.crm.entity.request.SolutioncomponentRequest;

public class SolutioncomponentCollectionRequest extends CollectionPageEntityRequest<Solutioncomponent, SolutioncomponentRequest>{

    protected ContextPath contextPath;

    public SolutioncomponentCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Solutioncomponent.class, cp -> new SolutioncomponentRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SolutioncomponentRequest solutioncomponent_parent_solutioncomponent(String solutioncomponentid) {
        return new SolutioncomponentRequest(contextPath.addSegment("solutioncomponent_parent_solutioncomponent").addKeys(new NameValue(solutioncomponentid.toString())), Optional.empty());
    }

    public SolutioncomponentCollectionRequest solutioncomponent_parent_solutioncomponent() {
        return new SolutioncomponentCollectionRequest(contextPath.addSegment("solutioncomponent_parent_solutioncomponent"), Optional.empty());
    }

}
