package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Semiannualfiscalcalendar;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.SemiannualfiscalcalendarRequest;

public class SemiannualfiscalcalendarCollectionRequest extends CollectionPageEntityRequest<Semiannualfiscalcalendar, SemiannualfiscalcalendarRequest>{

    protected ContextPath contextPath;

    public SemiannualfiscalcalendarCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Semiannualfiscalcalendar.class, cp -> new SemiannualfiscalcalendarRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public BulkdeletefailureRequest semiAnnualFiscalCalendar_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("SemiAnnualFiscalCalendar_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest semiAnnualFiscalCalendar_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("SemiAnnualFiscalCalendar_BulkDeleteFailures"), Optional.empty());
    }

    public AsyncoperationRequest semiAnnualFiscalCalendar_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("SemiAnnualFiscalCalendar_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest semiAnnualFiscalCalendar_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("SemiAnnualFiscalCalendar_AsyncOperations"), Optional.empty());
    }

}
