package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Relationship;
import microsoft.dynamics.crm.entity.request.RelationshipRequest;
import microsoft.dynamics.crm.entity.request.RelationshipattributeRequest;

public class RelationshipCollectionRequest extends CollectionPageEntityRequest<Relationship, RelationshipRequest>{

    protected ContextPath contextPath;

    public RelationshipCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Relationship.class, cp -> new RelationshipRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public RelationshipattributeRequest relationship_relationshipattribute(String relationshipattributeid) {
        return new RelationshipattributeRequest(contextPath.addSegment("relationship_relationshipattribute").addKeys(new NameValue(relationshipattributeid.toString())), Optional.empty());
    }

    public RelationshipattributeCollectionRequest relationship_relationshipattribute() {
        return new RelationshipattributeCollectionRequest(contextPath.addSegment("relationship_relationshipattribute"), Optional.empty());
    }

}
