package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Queue;
import microsoft.dynamics.crm.entity.request.ActivitypartyRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.EmailRequest;
import microsoft.dynamics.crm.entity.request.MailboxRequest;
import microsoft.dynamics.crm.entity.request.PostfollowRequest;
import microsoft.dynamics.crm.entity.request.PostregardingRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.QueueRequest;
import microsoft.dynamics.crm.entity.request.QueueitemRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

public class QueueCollectionRequest extends CollectionPageEntityRequest<Queue, QueueRequest>{

    protected ContextPath contextPath;

    public QueueCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Queue.class, cp -> new QueueRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ProcesssessionRequest queue_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("Queue_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest queue_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("Queue_ProcessSessions"), Optional.empty());
    }

    public BulkdeletefailureRequest queue_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("Queue_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest queue_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("Queue_BulkDeleteFailures"), Optional.empty());
    }

    public PostfollowRequest queue_PostFollows(String postfollowid) {
        return new PostfollowRequest(contextPath.addSegment("queue_PostFollows").addKeys(new NameValue(postfollowid.toString())), Optional.empty());
    }

    public PostfollowCollectionRequest queue_PostFollows() {
        return new PostfollowCollectionRequest(contextPath.addSegment("queue_PostFollows"), Optional.empty());
    }

    public MailboxRequest mailbox_regarding_queue(String mailboxid) {
        return new MailboxRequest(contextPath.addSegment("mailbox_regarding_queue").addKeys(new NameValue(mailboxid.toString())), Optional.empty());
    }

    public MailboxCollectionRequest mailbox_regarding_queue() {
        return new MailboxCollectionRequest(contextPath.addSegment("mailbox_regarding_queue"), Optional.empty());
    }

    public TeamRequest queue_team(String ownerid) {
        return new TeamRequest(contextPath.addSegment("queue_team").addKeys(new NameValue(ownerid.toString())), Optional.empty());
    }

    public TeamCollectionRequest queue_team() {
        return new TeamCollectionRequest(contextPath.addSegment("queue_team"), Optional.empty());
    }

    public QueueitemRequest queue_entries(String queueitemid) {
        return new QueueitemRequest(contextPath.addSegment("queue_entries").addKeys(new NameValue(queueitemid.toString())), Optional.empty());
    }

    public QueueitemCollectionRequest queue_entries() {
        return new QueueitemCollectionRequest(contextPath.addSegment("queue_entries"), Optional.empty());
    }

    public ActivitypartyRequest queue_activity_parties(String activitypartyid) {
        return new ActivitypartyRequest(contextPath.addSegment("queue_activity_parties").addKeys(new NameValue(activitypartyid.toString())), Optional.empty());
    }

    public ActivitypartyCollectionRequest queue_activity_parties() {
        return new ActivitypartyCollectionRequest(contextPath.addSegment("queue_activity_parties"), Optional.empty());
    }

    public AsyncoperationRequest queue_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Queue_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest queue_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("Queue_AsyncOperations"), Optional.empty());
    }

    public EmailRequest queue_Email_EmailSender(String activityid) {
        return new EmailRequest(contextPath.addSegment("Queue_Email_EmailSender").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public EmailCollectionRequest queue_Email_EmailSender() {
        return new EmailCollectionRequest(contextPath.addSegment("Queue_Email_EmailSender"), Optional.empty());
    }

    public SystemuserRequest queuemembership_association(String ownerid) {
        return new SystemuserRequest(contextPath.addSegment("queuemembership_association").addKeys(new NameValue(ownerid.toString())), Optional.empty());
    }

    public SystemuserCollectionRequest queuemembership_association() {
        return new SystemuserCollectionRequest(contextPath.addSegment("queuemembership_association"), Optional.empty());
    }

    public SyncerrorRequest queue_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Queue_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest queue_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("Queue_SyncErrors"), Optional.empty());
    }

    public SystemuserRequest queue_system_user(String ownerid) {
        return new SystemuserRequest(contextPath.addSegment("queue_system_user").addKeys(new NameValue(ownerid.toString())), Optional.empty());
    }

    public SystemuserCollectionRequest queue_system_user() {
        return new SystemuserCollectionRequest(contextPath.addSegment("queue_system_user"), Optional.empty());
    }

    public PostregardingRequest queue_PostRegardings(String postregardingid) {
        return new PostregardingRequest(contextPath.addSegment("queue_PostRegardings").addKeys(new NameValue(postregardingid.toString())), Optional.empty());
    }

    public PostregardingCollectionRequest queue_PostRegardings() {
        return new PostregardingCollectionRequest(contextPath.addSegment("queue_PostRegardings"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest queue_principalobjectattributeaccess(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("queue_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest queue_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("queue_principalobjectattributeaccess"), Optional.empty());
    }

    public DuplicaterecordRequest queue_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("Queue_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest queue_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("Queue_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest queue_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("Queue_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest queue_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("Queue_DuplicateBaseRecord"), Optional.empty());
    }

}
