package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Postfollow;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.PostfollowRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class PostfollowCollectionRequest extends CollectionPageEntityRequest<Postfollow, PostfollowRequest>{

    protected ContextPath contextPath;

    public PostfollowCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Postfollow.class, cp -> new PostfollowRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AsyncoperationRequest postFollow_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("PostFollow_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest postFollow_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("PostFollow_AsyncOperations"), Optional.empty());
    }

    public SyncerrorRequest postFollow_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("PostFollow_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest postFollow_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("PostFollow_SyncErrors"), Optional.empty());
    }

}
