package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Fax;
import microsoft.dynamics.crm.entity.request.ActioncardRequest;
import microsoft.dynamics.crm.entity.request.ActivitypartyRequest;
import microsoft.dynamics.crm.entity.request.AnnotationRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.ConnectionRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.FaxRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.QueueitemRequest;
import microsoft.dynamics.crm.entity.request.SlakpiinstanceRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class FaxCollectionRequest extends CollectionPageEntityRequest<Fax, FaxRequest>{

    protected ContextPath contextPath;

    public FaxCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Fax.class, cp -> new FaxRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public BulkdeletefailureRequest fax_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("Fax_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest fax_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("Fax_BulkDeleteFailures"), Optional.empty());
    }

    public AnnotationRequest fax_Annotation(String annotationid) {
        return new AnnotationRequest(contextPath.addSegment("Fax_Annotation").addKeys(new NameValue(annotationid.toString())), Optional.empty());
    }

    public AnnotationCollectionRequest fax_Annotation() {
        return new AnnotationCollectionRequest(contextPath.addSegment("Fax_Annotation"), Optional.empty());
    }

    public ActioncardRequest fax_actioncard(String actioncardid) {
        return new ActioncardRequest(contextPath.addSegment("fax_actioncard").addKeys(new NameValue(actioncardid.toString())), Optional.empty());
    }

    public ActioncardCollectionRequest fax_actioncard() {
        return new ActioncardCollectionRequest(contextPath.addSegment("fax_actioncard"), Optional.empty());
    }

    public DuplicaterecordRequest fax_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("Fax_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest fax_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("Fax_DuplicateMatchingRecord"), Optional.empty());
    }

    public QueueitemRequest fax_QueueItem(String queueitemid) {
        return new QueueitemRequest(contextPath.addSegment("Fax_QueueItem").addKeys(new NameValue(queueitemid.toString())), Optional.empty());
    }

    public QueueitemCollectionRequest fax_QueueItem() {
        return new QueueitemCollectionRequest(contextPath.addSegment("Fax_QueueItem"), Optional.empty());
    }

    public ActivitypartyRequest fax_activity_parties(String activitypartyid) {
        return new ActivitypartyRequest(contextPath.addSegment("fax_activity_parties").addKeys(new NameValue(activitypartyid.toString())), Optional.empty());
    }

    public ActivitypartyCollectionRequest fax_activity_parties() {
        return new ActivitypartyCollectionRequest(contextPath.addSegment("fax_activity_parties"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest fax_principalobjectattributeaccess(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("fax_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest fax_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("fax_principalobjectattributeaccess"), Optional.empty());
    }

    public ConnectionRequest fax_connections2(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("fax_connections2").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public ConnectionCollectionRequest fax_connections2() {
        return new ConnectionCollectionRequest(contextPath.addSegment("fax_connections2"), Optional.empty());
    }

    public ProcesssessionRequest fax_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("Fax_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest fax_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("Fax_ProcessSessions"), Optional.empty());
    }

    public SlakpiinstanceRequest slakpiinstance_fax(String slakpiinstanceid) {
        return new SlakpiinstanceRequest(contextPath.addSegment("slakpiinstance_fax").addKeys(new NameValue(slakpiinstanceid.toString())), Optional.empty());
    }

    public SlakpiinstanceCollectionRequest slakpiinstance_fax() {
        return new SlakpiinstanceCollectionRequest(contextPath.addSegment("slakpiinstance_fax"), Optional.empty());
    }

    public ConnectionRequest fax_connections1(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("fax_connections1").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public ConnectionCollectionRequest fax_connections1() {
        return new ConnectionCollectionRequest(contextPath.addSegment("fax_connections1"), Optional.empty());
    }

    public SyncerrorRequest fax_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Fax_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest fax_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("Fax_SyncErrors"), Optional.empty());
    }

    public DuplicaterecordRequest fax_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("Fax_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest fax_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("Fax_DuplicateBaseRecord"), Optional.empty());
    }

    public AsyncoperationRequest fax_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Fax_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest fax_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("Fax_AsyncOperations"), Optional.empty());
    }

}
