package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Calendar;
import microsoft.dynamics.crm.entity.request.AnnotationRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.CalendarRequest;
import microsoft.dynamics.crm.entity.request.CalendarruleRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SlaRequest;
import microsoft.dynamics.crm.entity.request.SlaitemRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

public class CalendarCollectionRequest extends CollectionPageEntityRequest<Calendar, CalendarRequest>{

    protected ContextPath contextPath;

    public CalendarCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Calendar.class, cp -> new CalendarRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public CalendarruleRequest calendar_calendar_rules(String calendarruleid) {
        return new CalendarruleRequest(contextPath.addSegment("calendar_calendar_rules").addKeys(new NameValue(calendarruleid.toString())), Optional.empty());
    }

    public CalendarruleCollectionRequest calendar_calendar_rules() {
        return new CalendarruleCollectionRequest(contextPath.addSegment("calendar_calendar_rules"), Optional.empty());
    }

    public BulkdeletefailureRequest calendar_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("Calendar_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest calendar_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("Calendar_BulkDeleteFailures"), Optional.empty());
    }

    public SlaRequest slabase_businesshoursid(String slaid) {
        return new SlaRequest(contextPath.addSegment("slabase_businesshoursid").addKeys(new NameValue(slaid.toString())), Optional.empty());
    }

    public SlaCollectionRequest slabase_businesshoursid() {
        return new SlaCollectionRequest(contextPath.addSegment("slabase_businesshoursid"), Optional.empty());
    }

    public OrganizationRequest calendar_organization(String organizationid) {
        return new OrganizationRequest(contextPath.addSegment("calendar_organization").addKeys(new NameValue(organizationid.toString())), Optional.empty());
    }

    public OrganizationCollectionRequest calendar_organization() {
        return new OrganizationCollectionRequest(contextPath.addSegment("calendar_organization"), Optional.empty());
    }

    public BusinessunitRequest businessUnit_Calendar(String businessunitid) {
        return new BusinessunitRequest(contextPath.addSegment("BusinessUnit_Calendar").addKeys(new NameValue(businessunitid.toString())), Optional.empty());
    }

    public BusinessunitCollectionRequest businessUnit_Calendar() {
        return new BusinessunitCollectionRequest(contextPath.addSegment("BusinessUnit_Calendar"), Optional.empty());
    }

    public AnnotationRequest calendar_Annotation(String annotationid) {
        return new AnnotationRequest(contextPath.addSegment("Calendar_Annotation").addKeys(new NameValue(annotationid.toString())), Optional.empty());
    }

    public AnnotationCollectionRequest calendar_Annotation() {
        return new AnnotationCollectionRequest(contextPath.addSegment("Calendar_Annotation"), Optional.empty());
    }

    public CalendarRequest calendar_customercalendar_holidaycalendar(String calendarid) {
        return new CalendarRequest(contextPath.addSegment("calendar_customercalendar_holidaycalendar").addKeys(new NameValue(calendarid.toString())), Optional.empty());
    }

    public CalendarCollectionRequest calendar_customercalendar_holidaycalendar() {
        return new CalendarCollectionRequest(contextPath.addSegment("calendar_customercalendar_holidaycalendar"), Optional.empty());
    }

    public SystemuserRequest calendar_system_users(String ownerid) {
        return new SystemuserRequest(contextPath.addSegment("calendar_system_users").addKeys(new NameValue(ownerid.toString())), Optional.empty());
    }

    public SystemuserCollectionRequest calendar_system_users() {
        return new SystemuserCollectionRequest(contextPath.addSegment("calendar_system_users"), Optional.empty());
    }

    public AsyncoperationRequest calendar_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Calendar_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest calendar_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("Calendar_AsyncOperations"), Optional.empty());
    }

    public CalendarruleRequest inner_calendar_calendar_rules(String calendarruleid) {
        return new CalendarruleRequest(contextPath.addSegment("inner_calendar_calendar_rules").addKeys(new NameValue(calendarruleid.toString())), Optional.empty());
    }

    public CalendarruleCollectionRequest inner_calendar_calendar_rules() {
        return new CalendarruleCollectionRequest(contextPath.addSegment("inner_calendar_calendar_rules"), Optional.empty());
    }

    public SlaitemRequest calendar_slaitem(String slaitemid) {
        return new SlaitemRequest(contextPath.addSegment("calendar_slaitem").addKeys(new NameValue(slaitemid.toString())), Optional.empty());
    }

    public SlaitemCollectionRequest calendar_slaitem() {
        return new SlaitemCollectionRequest(contextPath.addSegment("calendar_slaitem"), Optional.empty());
    }

}
