package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Businessunitnewsarticle;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitnewsarticleRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;

public class BusinessunitnewsarticleCollectionRequest extends CollectionPageEntityRequest<Businessunitnewsarticle, BusinessunitnewsarticleRequest>{

    protected ContextPath contextPath;

    public BusinessunitnewsarticleCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Businessunitnewsarticle.class, cp -> new BusinessunitnewsarticleRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public BulkdeletefailureRequest businessUnitNewsArticle_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("BusinessUnitNewsArticle_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest businessUnitNewsArticle_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("BusinessUnitNewsArticle_BulkDeleteFailures"), Optional.empty());
    }

    public AsyncoperationRequest businessUnitNewsArticle_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("BusinessUnitNewsArticle_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest businessUnitNewsArticle_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("BusinessUnitNewsArticle_AsyncOperations"), Optional.empty());
    }

    public ProcesssessionRequest businessUnitNewsArticle_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("BusinessUnitNewsArticle_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest businessUnitNewsArticle_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("BusinessUnitNewsArticle_ProcessSessions"), Optional.empty());
    }

}
