package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SdkmessageprocessingstepRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "componentstate", 
    "_createdonbehalfby_value", 
    "entityalias", 
    "description", 
    "introducedversion", 
    "attributes", 
    "ismanaged", 
    "_modifiedonbehalfby_value", 
    "sdkmessageprocessingstepimageidunique", 
    "name", 
    "_modifiedby_value", 
    "iscustomizable", 
    "_organizationid_value", 
    "versionnumber", 
    "messagepropertyname", 
    "sdkmessageprocessingstepimageid", 
    "modifiedon", 
    "_sdkmessageprocessingstepid_value", 
    "solutionid", 
    "overwritetime", 
    "createdon", 
    "imagetype", 
    "customizationlevel", 
    "relatedattributename", 
    "_createdby_value"})
@JsonInclude(Include.NON_NULL)
public class Sdkmessageprocessingstepimage extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.sdkmessageprocessingstepimage";
    }

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("entityalias")
    protected String entityalias;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("attributes")
    protected String attributes;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("sdkmessageprocessingstepimageidunique")
    protected String sdkmessageprocessingstepimageidunique;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("iscustomizable")
    protected BooleanManagedProperty iscustomizable;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("messagepropertyname")
    protected String messagepropertyname;

    @JsonProperty("sdkmessageprocessingstepimageid")
    protected String sdkmessageprocessingstepimageid;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_sdkmessageprocessingstepid_value")
    protected String _sdkmessageprocessingstepid_value;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("imagetype")
    protected Integer imagetype;

    @JsonProperty("customizationlevel")
    protected Integer customizationlevel;

    @JsonProperty("relatedattributename")
    protected String relatedattributename;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    protected Sdkmessageprocessingstepimage() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSdkmessageprocessingstepimage() {
        return new Builder();
    }

    public static final class Builder {
        private Integer componentstate;
        private String _createdonbehalfby_value;
        private String entityalias;
        private String description;
        private String introducedversion;
        private String attributes;
        private Boolean ismanaged;
        private String _modifiedonbehalfby_value;
        private String sdkmessageprocessingstepimageidunique;
        private String name;
        private String _modifiedby_value;
        private BooleanManagedProperty iscustomizable;
        private String _organizationid_value;
        private Long versionnumber;
        private String messagepropertyname;
        private String sdkmessageprocessingstepimageid;
        private OffsetDateTime modifiedon;
        private String _sdkmessageprocessingstepid_value;
        private String solutionid;
        private OffsetDateTime overwritetime;
        private OffsetDateTime createdon;
        private Integer imagetype;
        private Integer customizationlevel;
        private String relatedattributename;
        private String _createdby_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder entityalias(String entityalias) {
            this.entityalias = entityalias;
            this.changedFields = changedFields.add("entityalias");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder attributes(String attributes) {
            this.attributes = attributes;
            this.changedFields = changedFields.add("attributes");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder sdkmessageprocessingstepimageidunique(String sdkmessageprocessingstepimageidunique) {
            this.sdkmessageprocessingstepimageidunique = sdkmessageprocessingstepimageidunique;
            this.changedFields = changedFields.add("sdkmessageprocessingstepimageidunique");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder iscustomizable(BooleanManagedProperty iscustomizable) {
            this.iscustomizable = iscustomizable;
            this.changedFields = changedFields.add("iscustomizable");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder messagepropertyname(String messagepropertyname) {
            this.messagepropertyname = messagepropertyname;
            this.changedFields = changedFields.add("messagepropertyname");
            return this;
        }

        public Builder sdkmessageprocessingstepimageid(String sdkmessageprocessingstepimageid) {
            this.sdkmessageprocessingstepimageid = sdkmessageprocessingstepimageid;
            this.changedFields = changedFields.add("sdkmessageprocessingstepimageid");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _sdkmessageprocessingstepid_value(String _sdkmessageprocessingstepid_value) {
            this._sdkmessageprocessingstepid_value = _sdkmessageprocessingstepid_value;
            this.changedFields = changedFields.add("_sdkmessageprocessingstepid_value");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder imagetype(Integer imagetype) {
            this.imagetype = imagetype;
            this.changedFields = changedFields.add("imagetype");
            return this;
        }

        public Builder customizationlevel(Integer customizationlevel) {
            this.customizationlevel = customizationlevel;
            this.changedFields = changedFields.add("customizationlevel");
            return this;
        }

        public Builder relatedattributename(String relatedattributename) {
            this.relatedattributename = relatedattributename;
            this.changedFields = changedFields.add("relatedattributename");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Sdkmessageprocessingstepimage build() {
            Sdkmessageprocessingstepimage _x = new Sdkmessageprocessingstepimage();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.sdkmessageprocessingstepimage";
            _x.componentstate = componentstate;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.entityalias = entityalias;
            _x.description = description;
            _x.introducedversion = introducedversion;
            _x.attributes = attributes;
            _x.ismanaged = ismanaged;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.sdkmessageprocessingstepimageidunique = sdkmessageprocessingstepimageidunique;
            _x.name = name;
            _x._modifiedby_value = _modifiedby_value;
            _x.iscustomizable = iscustomizable;
            _x._organizationid_value = _organizationid_value;
            _x.versionnumber = versionnumber;
            _x.messagepropertyname = messagepropertyname;
            _x.sdkmessageprocessingstepimageid = sdkmessageprocessingstepimageid;
            _x.modifiedon = modifiedon;
            _x._sdkmessageprocessingstepid_value = _sdkmessageprocessingstepid_value;
            _x.solutionid = solutionid;
            _x.overwritetime = overwritetime;
            _x.createdon = createdon;
            _x.imagetype = imagetype;
            _x.customizationlevel = customizationlevel;
            _x.relatedattributename = relatedattributename;
            _x._createdby_value = _createdby_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && sdkmessageprocessingstepimageid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(sdkmessageprocessingstepimageid.toString()));
        }
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Sdkmessageprocessingstepimage withComponentstate(Integer componentstate) {
        Sdkmessageprocessingstepimage _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepimage");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Sdkmessageprocessingstepimage with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Sdkmessageprocessingstepimage _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepimage");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="entityalias")
    @JsonIgnore
    public Optional<String> getEntityalias() {
        return Optional.ofNullable(entityalias);
    }

    public Sdkmessageprocessingstepimage withEntityalias(String entityalias) {
        Checks.checkIsAscii(entityalias);
        Sdkmessageprocessingstepimage _x = _copy();
        _x.changedFields = changedFields.add("entityalias");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepimage");
        _x.entityalias = entityalias;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Sdkmessageprocessingstepimage withDescription(String description) {
        Checks.checkIsAscii(description);
        Sdkmessageprocessingstepimage _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepimage");
        _x.description = description;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Sdkmessageprocessingstepimage withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Sdkmessageprocessingstepimage _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepimage");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="attributes")
    @JsonIgnore
    public Optional<String> getAttributes() {
        return Optional.ofNullable(attributes);
    }

    public Sdkmessageprocessingstepimage withAttributes(String attributes) {
        Checks.checkIsAscii(attributes);
        Sdkmessageprocessingstepimage _x = _copy();
        _x.changedFields = changedFields.add("attributes");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepimage");
        _x.attributes = attributes;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Sdkmessageprocessingstepimage withIsmanaged(Boolean ismanaged) {
        Sdkmessageprocessingstepimage _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepimage");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Sdkmessageprocessingstepimage with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Sdkmessageprocessingstepimage _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepimage");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="sdkmessageprocessingstepimageidunique")
    @JsonIgnore
    public Optional<String> getSdkmessageprocessingstepimageidunique() {
        return Optional.ofNullable(sdkmessageprocessingstepimageidunique);
    }

    public Sdkmessageprocessingstepimage withSdkmessageprocessingstepimageidunique(String sdkmessageprocessingstepimageidunique) {
        Sdkmessageprocessingstepimage _x = _copy();
        _x.changedFields = changedFields.add("sdkmessageprocessingstepimageidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepimage");
        _x.sdkmessageprocessingstepimageidunique = sdkmessageprocessingstepimageidunique;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Sdkmessageprocessingstepimage withName(String name) {
        Checks.checkIsAscii(name);
        Sdkmessageprocessingstepimage _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepimage");
        _x.name = name;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Sdkmessageprocessingstepimage with_modifiedby_value(String _modifiedby_value) {
        Sdkmessageprocessingstepimage _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepimage");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="iscustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIscustomizable() {
        return Optional.ofNullable(iscustomizable);
    }

    public Sdkmessageprocessingstepimage withIscustomizable(BooleanManagedProperty iscustomizable) {
        Sdkmessageprocessingstepimage _x = _copy();
        _x.changedFields = changedFields.add("iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepimage");
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Sdkmessageprocessingstepimage with_organizationid_value(String _organizationid_value) {
        Sdkmessageprocessingstepimage _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepimage");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Sdkmessageprocessingstepimage withVersionnumber(Long versionnumber) {
        Sdkmessageprocessingstepimage _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepimage");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="messagepropertyname")
    @JsonIgnore
    public Optional<String> getMessagepropertyname() {
        return Optional.ofNullable(messagepropertyname);
    }

    public Sdkmessageprocessingstepimage withMessagepropertyname(String messagepropertyname) {
        Checks.checkIsAscii(messagepropertyname);
        Sdkmessageprocessingstepimage _x = _copy();
        _x.changedFields = changedFields.add("messagepropertyname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepimage");
        _x.messagepropertyname = messagepropertyname;
        return _x;
    }

    @Property(name="sdkmessageprocessingstepimageid")
    @JsonIgnore
    public Optional<String> getSdkmessageprocessingstepimageid() {
        return Optional.ofNullable(sdkmessageprocessingstepimageid);
    }

    public Sdkmessageprocessingstepimage withSdkmessageprocessingstepimageid(String sdkmessageprocessingstepimageid) {
        Sdkmessageprocessingstepimage _x = _copy();
        _x.changedFields = changedFields.add("sdkmessageprocessingstepimageid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepimage");
        _x.sdkmessageprocessingstepimageid = sdkmessageprocessingstepimageid;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Sdkmessageprocessingstepimage withModifiedon(OffsetDateTime modifiedon) {
        Sdkmessageprocessingstepimage _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepimage");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_sdkmessageprocessingstepid_value")
    @JsonIgnore
    public Optional<String> get_sdkmessageprocessingstepid_value() {
        return Optional.ofNullable(_sdkmessageprocessingstepid_value);
    }

    public Sdkmessageprocessingstepimage with_sdkmessageprocessingstepid_value(String _sdkmessageprocessingstepid_value) {
        Sdkmessageprocessingstepimage _x = _copy();
        _x.changedFields = changedFields.add("_sdkmessageprocessingstepid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepimage");
        _x._sdkmessageprocessingstepid_value = _sdkmessageprocessingstepid_value;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Sdkmessageprocessingstepimage withSolutionid(String solutionid) {
        Sdkmessageprocessingstepimage _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepimage");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Sdkmessageprocessingstepimage withOverwritetime(OffsetDateTime overwritetime) {
        Sdkmessageprocessingstepimage _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepimage");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Sdkmessageprocessingstepimage withCreatedon(OffsetDateTime createdon) {
        Sdkmessageprocessingstepimage _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepimage");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="imagetype")
    @JsonIgnore
    public Optional<Integer> getImagetype() {
        return Optional.ofNullable(imagetype);
    }

    public Sdkmessageprocessingstepimage withImagetype(Integer imagetype) {
        Sdkmessageprocessingstepimage _x = _copy();
        _x.changedFields = changedFields.add("imagetype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepimage");
        _x.imagetype = imagetype;
        return _x;
    }

    @Property(name="customizationlevel")
    @JsonIgnore
    public Optional<Integer> getCustomizationlevel() {
        return Optional.ofNullable(customizationlevel);
    }

    public Sdkmessageprocessingstepimage withCustomizationlevel(Integer customizationlevel) {
        Sdkmessageprocessingstepimage _x = _copy();
        _x.changedFields = changedFields.add("customizationlevel");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepimage");
        _x.customizationlevel = customizationlevel;
        return _x;
    }

    @Property(name="relatedattributename")
    @JsonIgnore
    public Optional<String> getRelatedattributename() {
        return Optional.ofNullable(relatedattributename);
    }

    public Sdkmessageprocessingstepimage withRelatedattributename(String relatedattributename) {
        Checks.checkIsAscii(relatedattributename);
        Sdkmessageprocessingstepimage _x = _copy();
        _x.changedFields = changedFields.add("relatedattributename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepimage");
        _x.relatedattributename = relatedattributename;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Sdkmessageprocessingstepimage with_createdby_value(String _createdby_value) {
        Sdkmessageprocessingstepimage _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessageprocessingstepimage");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    public Sdkmessageprocessingstepimage withUnmappedField(String name, String value) {
        Sdkmessageprocessingstepimage _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="sdkmessageprocessingstepid")
    @JsonIgnore
    public SdkmessageprocessingstepRequest getSdkmessageprocessingstepid() {
        return new SdkmessageprocessingstepRequest(contextPath.addSegment("sdkmessageprocessingstepid"), RequestHelper.getValue(unmappedFields, "sdkmessageprocessingstepid"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Sdkmessageprocessingstepimage patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Sdkmessageprocessingstepimage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Sdkmessageprocessingstepimage put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Sdkmessageprocessingstepimage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Sdkmessageprocessingstepimage _copy() {
        Sdkmessageprocessingstepimage _x = new Sdkmessageprocessingstepimage();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.componentstate = componentstate;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.entityalias = entityalias;
        _x.description = description;
        _x.introducedversion = introducedversion;
        _x.attributes = attributes;
        _x.ismanaged = ismanaged;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.sdkmessageprocessingstepimageidunique = sdkmessageprocessingstepimageidunique;
        _x.name = name;
        _x._modifiedby_value = _modifiedby_value;
        _x.iscustomizable = iscustomizable;
        _x._organizationid_value = _organizationid_value;
        _x.versionnumber = versionnumber;
        _x.messagepropertyname = messagepropertyname;
        _x.sdkmessageprocessingstepimageid = sdkmessageprocessingstepimageid;
        _x.modifiedon = modifiedon;
        _x._sdkmessageprocessingstepid_value = _sdkmessageprocessingstepid_value;
        _x.solutionid = solutionid;
        _x.overwritetime = overwritetime;
        _x.createdon = createdon;
        _x.imagetype = imagetype;
        _x.customizationlevel = customizationlevel;
        _x.relatedattributename = relatedattributename;
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Sdkmessageprocessingstepimage[");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("entityalias=");
        b.append(this.entityalias);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("attributes=");
        b.append(this.attributes);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("sdkmessageprocessingstepimageidunique=");
        b.append(this.sdkmessageprocessingstepimageidunique);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("iscustomizable=");
        b.append(this.iscustomizable);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("messagepropertyname=");
        b.append(this.messagepropertyname);
        b.append(", ");
        b.append("sdkmessageprocessingstepimageid=");
        b.append(this.sdkmessageprocessingstepimageid);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_sdkmessageprocessingstepid_value=");
        b.append(this._sdkmessageprocessingstepid_value);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("imagetype=");
        b.append(this.imagetype);
        b.append(", ");
        b.append("customizationlevel=");
        b.append(this.customizationlevel);
        b.append(", ");
        b.append("relatedattributename=");
        b.append(this.relatedattributename);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
