package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aiodtrainingboundingboxCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiconfigurationRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodimageRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_ownerid_value", 
    "overriddencreatedon", 
    "msdyn_name", 
    "_createdonbehalfby_value", 
    "_owningbusinessunit_value", 
    "msdyn_aiodtrainingimageid", 
    "_owninguser_value", 
    "_modifiedby_value", 
    "_createdby_value", 
    "_modifiedonbehalfby_value", 
    "timezoneruleversionnumber", 
    "_msdyn_aiconfigurationid_value", 
    "_owningteam_value", 
    "msdyn_sourcetype", 
    "utcconversiontimezonecode", 
    "createdon", 
    "statecode", 
    "msdyn_lastmodifieddate", 
    "statuscode", 
    "modifiedon", 
    "versionnumber", 
    "importsequencenumber", 
    "_msdyn_aiodimageid_value"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_aiodtrainingimage extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_aiodtrainingimage";
    }

    @JsonProperty("_ownerid_value")
    protected String _ownerid_value;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("msdyn_name")
    protected String msdyn_name;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("_owningbusinessunit_value")
    protected String _owningbusinessunit_value;

    @JsonProperty("msdyn_aiodtrainingimageid")
    protected String msdyn_aiodtrainingimageid;

    @JsonProperty("_owninguser_value")
    protected String _owninguser_value;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("_msdyn_aiconfigurationid_value")
    protected String _msdyn_aiconfigurationid_value;

    @JsonProperty("_owningteam_value")
    protected String _owningteam_value;

    @JsonProperty("msdyn_sourcetype")
    protected String msdyn_sourcetype;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("msdyn_lastmodifieddate")
    protected OffsetDateTime msdyn_lastmodifieddate;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("_msdyn_aiodimageid_value")
    protected String _msdyn_aiodimageid_value;

    protected Msdyn_aiodtrainingimage() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMsdyn_aiodtrainingimage() {
        return new Builder();
    }

    public static final class Builder {
        private String _ownerid_value;
        private OffsetDateTime overriddencreatedon;
        private String msdyn_name;
        private String _createdonbehalfby_value;
        private String _owningbusinessunit_value;
        private String msdyn_aiodtrainingimageid;
        private String _owninguser_value;
        private String _modifiedby_value;
        private String _createdby_value;
        private String _modifiedonbehalfby_value;
        private Integer timezoneruleversionnumber;
        private String _msdyn_aiconfigurationid_value;
        private String _owningteam_value;
        private String msdyn_sourcetype;
        private Integer utcconversiontimezonecode;
        private OffsetDateTime createdon;
        private Integer statecode;
        private OffsetDateTime msdyn_lastmodifieddate;
        private Integer statuscode;
        private OffsetDateTime modifiedon;
        private Long versionnumber;
        private Integer importsequencenumber;
        private String _msdyn_aiodimageid_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder msdyn_name(String msdyn_name) {
            this.msdyn_name = msdyn_name;
            this.changedFields = changedFields.add("msdyn_name");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _owningbusinessunit_value(String _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder msdyn_aiodtrainingimageid(String msdyn_aiodtrainingimageid) {
            this.msdyn_aiodtrainingimageid = msdyn_aiodtrainingimageid;
            this.changedFields = changedFields.add("msdyn_aiodtrainingimageid");
            return this;
        }

        public Builder _owninguser_value(String _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder _msdyn_aiconfigurationid_value(String _msdyn_aiconfigurationid_value) {
            this._msdyn_aiconfigurationid_value = _msdyn_aiconfigurationid_value;
            this.changedFields = changedFields.add("_msdyn_aiconfigurationid_value");
            return this;
        }

        public Builder _owningteam_value(String _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder msdyn_sourcetype(String msdyn_sourcetype) {
            this.msdyn_sourcetype = msdyn_sourcetype;
            this.changedFields = changedFields.add("msdyn_sourcetype");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder msdyn_lastmodifieddate(OffsetDateTime msdyn_lastmodifieddate) {
            this.msdyn_lastmodifieddate = msdyn_lastmodifieddate;
            this.changedFields = changedFields.add("msdyn_lastmodifieddate");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder _msdyn_aiodimageid_value(String _msdyn_aiodimageid_value) {
            this._msdyn_aiodimageid_value = _msdyn_aiodimageid_value;
            this.changedFields = changedFields.add("_msdyn_aiodimageid_value");
            return this;
        }

        public Msdyn_aiodtrainingimage build() {
            Msdyn_aiodtrainingimage _x = new Msdyn_aiodtrainingimage();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_aiodtrainingimage";
            _x._ownerid_value = _ownerid_value;
            _x.overriddencreatedon = overriddencreatedon;
            _x.msdyn_name = msdyn_name;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.msdyn_aiodtrainingimageid = msdyn_aiodtrainingimageid;
            _x._owninguser_value = _owninguser_value;
            _x._modifiedby_value = _modifiedby_value;
            _x._createdby_value = _createdby_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x._msdyn_aiconfigurationid_value = _msdyn_aiconfigurationid_value;
            _x._owningteam_value = _owningteam_value;
            _x.msdyn_sourcetype = msdyn_sourcetype;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.createdon = createdon;
            _x.statecode = statecode;
            _x.msdyn_lastmodifieddate = msdyn_lastmodifieddate;
            _x.statuscode = statuscode;
            _x.modifiedon = modifiedon;
            _x.versionnumber = versionnumber;
            _x.importsequencenumber = importsequencenumber;
            _x._msdyn_aiodimageid_value = _msdyn_aiodimageid_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && msdyn_aiodtrainingimageid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(msdyn_aiodtrainingimageid.toString()));
        }
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<String> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Msdyn_aiodtrainingimage with_ownerid_value(String _ownerid_value) {
        Msdyn_aiodtrainingimage _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingimage");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Msdyn_aiodtrainingimage withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Msdyn_aiodtrainingimage _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingimage");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="msdyn_name")
    @JsonIgnore
    public Optional<String> getMsdyn_name() {
        return Optional.ofNullable(msdyn_name);
    }

    public Msdyn_aiodtrainingimage withMsdyn_name(String msdyn_name) {
        Checks.checkIsAscii(msdyn_name);
        Msdyn_aiodtrainingimage _x = _copy();
        _x.changedFields = changedFields.add("msdyn_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingimage");
        _x.msdyn_name = msdyn_name;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Msdyn_aiodtrainingimage with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Msdyn_aiodtrainingimage _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingimage");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<String> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Msdyn_aiodtrainingimage with_owningbusinessunit_value(String _owningbusinessunit_value) {
        Msdyn_aiodtrainingimage _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingimage");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="msdyn_aiodtrainingimageid")
    @JsonIgnore
    public Optional<String> getMsdyn_aiodtrainingimageid() {
        return Optional.ofNullable(msdyn_aiodtrainingimageid);
    }

    public Msdyn_aiodtrainingimage withMsdyn_aiodtrainingimageid(String msdyn_aiodtrainingimageid) {
        Msdyn_aiodtrainingimage _x = _copy();
        _x.changedFields = changedFields.add("msdyn_aiodtrainingimageid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingimage");
        _x.msdyn_aiodtrainingimageid = msdyn_aiodtrainingimageid;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<String> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Msdyn_aiodtrainingimage with_owninguser_value(String _owninguser_value) {
        Msdyn_aiodtrainingimage _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingimage");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Msdyn_aiodtrainingimage with_modifiedby_value(String _modifiedby_value) {
        Msdyn_aiodtrainingimage _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingimage");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Msdyn_aiodtrainingimage with_createdby_value(String _createdby_value) {
        Msdyn_aiodtrainingimage _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingimage");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Msdyn_aiodtrainingimage with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Msdyn_aiodtrainingimage _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingimage");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Msdyn_aiodtrainingimage withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Msdyn_aiodtrainingimage _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingimage");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="_msdyn_aiconfigurationid_value")
    @JsonIgnore
    public Optional<String> get_msdyn_aiconfigurationid_value() {
        return Optional.ofNullable(_msdyn_aiconfigurationid_value);
    }

    public Msdyn_aiodtrainingimage with_msdyn_aiconfigurationid_value(String _msdyn_aiconfigurationid_value) {
        Msdyn_aiodtrainingimage _x = _copy();
        _x.changedFields = changedFields.add("_msdyn_aiconfigurationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingimage");
        _x._msdyn_aiconfigurationid_value = _msdyn_aiconfigurationid_value;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<String> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Msdyn_aiodtrainingimage with_owningteam_value(String _owningteam_value) {
        Msdyn_aiodtrainingimage _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingimage");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="msdyn_sourcetype")
    @JsonIgnore
    public Optional<String> getMsdyn_sourcetype() {
        return Optional.ofNullable(msdyn_sourcetype);
    }

    public Msdyn_aiodtrainingimage withMsdyn_sourcetype(String msdyn_sourcetype) {
        Checks.checkIsAscii(msdyn_sourcetype);
        Msdyn_aiodtrainingimage _x = _copy();
        _x.changedFields = changedFields.add("msdyn_sourcetype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingimage");
        _x.msdyn_sourcetype = msdyn_sourcetype;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Msdyn_aiodtrainingimage withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Msdyn_aiodtrainingimage _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingimage");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Msdyn_aiodtrainingimage withCreatedon(OffsetDateTime createdon) {
        Msdyn_aiodtrainingimage _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingimage");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Msdyn_aiodtrainingimage withStatecode(Integer statecode) {
        Msdyn_aiodtrainingimage _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingimage");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="msdyn_lastmodifieddate")
    @JsonIgnore
    public Optional<OffsetDateTime> getMsdyn_lastmodifieddate() {
        return Optional.ofNullable(msdyn_lastmodifieddate);
    }

    public Msdyn_aiodtrainingimage withMsdyn_lastmodifieddate(OffsetDateTime msdyn_lastmodifieddate) {
        Msdyn_aiodtrainingimage _x = _copy();
        _x.changedFields = changedFields.add("msdyn_lastmodifieddate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingimage");
        _x.msdyn_lastmodifieddate = msdyn_lastmodifieddate;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Msdyn_aiodtrainingimage withStatuscode(Integer statuscode) {
        Msdyn_aiodtrainingimage _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingimage");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Msdyn_aiodtrainingimage withModifiedon(OffsetDateTime modifiedon) {
        Msdyn_aiodtrainingimage _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingimage");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Msdyn_aiodtrainingimage withVersionnumber(Long versionnumber) {
        Msdyn_aiodtrainingimage _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingimage");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Msdyn_aiodtrainingimage withImportsequencenumber(Integer importsequencenumber) {
        Msdyn_aiodtrainingimage _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingimage");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="_msdyn_aiodimageid_value")
    @JsonIgnore
    public Optional<String> get_msdyn_aiodimageid_value() {
        return Optional.ofNullable(_msdyn_aiodimageid_value);
    }

    public Msdyn_aiodtrainingimage with_msdyn_aiodimageid_value(String _msdyn_aiodimageid_value) {
        Msdyn_aiodtrainingimage _x = _copy();
        _x.changedFields = changedFields.add("_msdyn_aiodimageid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingimage");
        _x._msdyn_aiodimageid_value = _msdyn_aiodimageid_value;
        return _x;
    }

    public Msdyn_aiodtrainingimage withUnmappedField(String name, String value) {
        Msdyn_aiodtrainingimage _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="msdyn_aiodtrainingimage_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getMsdyn_aiodtrainingimage_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("msdyn_aiodtrainingimage_SyncErrors"), RequestHelper.getValue(unmappedFields, "msdyn_aiodtrainingimage_SyncErrors"));
    }

    @NavigationProperty(name="msdyn_aiodtrainingimage_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getMsdyn_aiodtrainingimage_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_aiodtrainingimage_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "msdyn_aiodtrainingimage_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="msdyn_aiodtrainingimage_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getMsdyn_aiodtrainingimage_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_aiodtrainingimage_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "msdyn_aiodtrainingimage_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="msdyn_aiodtrainingimage_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getMsdyn_aiodtrainingimage_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("msdyn_aiodtrainingimage_AsyncOperations"), RequestHelper.getValue(unmappedFields, "msdyn_aiodtrainingimage_AsyncOperations"));
    }

    @NavigationProperty(name="msdyn_aiodtrainingimage_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getMsdyn_aiodtrainingimage_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("msdyn_aiodtrainingimage_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "msdyn_aiodtrainingimage_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="msdyn_aiodtrainingimage_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getMsdyn_aiodtrainingimage_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("msdyn_aiodtrainingimage_ProcessSession"), RequestHelper.getValue(unmappedFields, "msdyn_aiodtrainingimage_ProcessSession"));
    }

    @NavigationProperty(name="msdyn_aiodtrainingimage_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getMsdyn_aiodtrainingimage_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("msdyn_aiodtrainingimage_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "msdyn_aiodtrainingimage_BulkDeleteFailures"));
    }

    @NavigationProperty(name="msdyn_aiodtrainingimage_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getMsdyn_aiodtrainingimage_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("msdyn_aiodtrainingimage_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "msdyn_aiodtrainingimage_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="msdyn_AIConfigurationId")
    @JsonIgnore
    public Msdyn_aiconfigurationRequest getMsdyn_AIConfigurationId() {
        return new Msdyn_aiconfigurationRequest(contextPath.addSegment("msdyn_AIConfigurationId"), RequestHelper.getValue(unmappedFields, "msdyn_AIConfigurationId"));
    }

    @NavigationProperty(name="msdyn_AIOdImageId")
    @JsonIgnore
    public Msdyn_aiodimageRequest getMsdyn_AIOdImageId() {
        return new Msdyn_aiodimageRequest(contextPath.addSegment("msdyn_AIOdImageId"), RequestHelper.getValue(unmappedFields, "msdyn_AIOdImageId"));
    }

    @NavigationProperty(name="msdyn_aiodtrainingimage_msdyn_aiodtrainingboundingbox")
    @JsonIgnore
    public Msdyn_aiodtrainingboundingboxCollectionRequest getMsdyn_aiodtrainingimage_msdyn_aiodtrainingboundingbox() {
        return new Msdyn_aiodtrainingboundingboxCollectionRequest(
                        contextPath.addSegment("msdyn_aiodtrainingimage_msdyn_aiodtrainingboundingbox"), RequestHelper.getValue(unmappedFields, "msdyn_aiodtrainingimage_msdyn_aiodtrainingboundingbox"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_aiodtrainingimage patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Msdyn_aiodtrainingimage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_aiodtrainingimage put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Msdyn_aiodtrainingimage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Msdyn_aiodtrainingimage _copy() {
        Msdyn_aiodtrainingimage _x = new Msdyn_aiodtrainingimage();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._ownerid_value = _ownerid_value;
        _x.overriddencreatedon = overriddencreatedon;
        _x.msdyn_name = msdyn_name;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.msdyn_aiodtrainingimageid = msdyn_aiodtrainingimageid;
        _x._owninguser_value = _owninguser_value;
        _x._modifiedby_value = _modifiedby_value;
        _x._createdby_value = _createdby_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x._msdyn_aiconfigurationid_value = _msdyn_aiconfigurationid_value;
        _x._owningteam_value = _owningteam_value;
        _x.msdyn_sourcetype = msdyn_sourcetype;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.createdon = createdon;
        _x.statecode = statecode;
        _x.msdyn_lastmodifieddate = msdyn_lastmodifieddate;
        _x.statuscode = statuscode;
        _x.modifiedon = modifiedon;
        _x.versionnumber = versionnumber;
        _x.importsequencenumber = importsequencenumber;
        _x._msdyn_aiodimageid_value = _msdyn_aiodimageid_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_aiodtrainingimage[");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("msdyn_name=");
        b.append(this.msdyn_name);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("msdyn_aiodtrainingimageid=");
        b.append(this.msdyn_aiodtrainingimageid);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("_msdyn_aiconfigurationid_value=");
        b.append(this._msdyn_aiconfigurationid_value);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("msdyn_sourcetype=");
        b.append(this.msdyn_sourcetype);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("msdyn_lastmodifieddate=");
        b.append(this.msdyn_lastmodifieddate);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("_msdyn_aiodimageid_value=");
        b.append(this._msdyn_aiodimageid_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
