package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportlogCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.ImportfileRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "haserror", 
    "_owninguser_value", 
    "linenumber", 
    "createdon", 
    "_ownerid_value", 
    "_importfileid_value", 
    "_createdonbehalfby_value", 
    "statecode", 
    "errortype", 
    "modifiedon", 
    "_owningteam_value", 
    "_modifiedby_value", 
    "_owningbusinessunit_value", 
    "statuscode", 
    "_modifiedonbehalfby_value", 
    "recordid", 
    "_createdby_value", 
    "data", 
    "importdataid"})
@JsonInclude(Include.NON_NULL)
public class Importdata extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.importdata";
    }

    @JsonProperty("haserror")
    protected Boolean haserror;

    @JsonProperty("_owninguser_value")
    protected String _owninguser_value;

    @JsonProperty("linenumber")
    protected Integer linenumber;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_ownerid_value")
    protected String _ownerid_value;

    @JsonProperty("_importfileid_value")
    protected String _importfileid_value;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("errortype")
    protected Integer errortype;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_owningteam_value")
    protected String _owningteam_value;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("_owningbusinessunit_value")
    protected String _owningbusinessunit_value;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("recordid")
    protected String recordid;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("data")
    protected String data;

    @JsonProperty("importdataid")
    protected String importdataid;

    protected Importdata() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderImportdata() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean haserror;
        private String _owninguser_value;
        private Integer linenumber;
        private OffsetDateTime createdon;
        private String _ownerid_value;
        private String _importfileid_value;
        private String _createdonbehalfby_value;
        private Integer statecode;
        private Integer errortype;
        private OffsetDateTime modifiedon;
        private String _owningteam_value;
        private String _modifiedby_value;
        private String _owningbusinessunit_value;
        private Integer statuscode;
        private String _modifiedonbehalfby_value;
        private String recordid;
        private String _createdby_value;
        private String data;
        private String importdataid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder haserror(Boolean haserror) {
            this.haserror = haserror;
            this.changedFields = changedFields.add("haserror");
            return this;
        }

        public Builder _owninguser_value(String _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder linenumber(Integer linenumber) {
            this.linenumber = linenumber;
            this.changedFields = changedFields.add("linenumber");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder _importfileid_value(String _importfileid_value) {
            this._importfileid_value = _importfileid_value;
            this.changedFields = changedFields.add("_importfileid_value");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder errortype(Integer errortype) {
            this.errortype = errortype;
            this.changedFields = changedFields.add("errortype");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _owningteam_value(String _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _owningbusinessunit_value(String _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder recordid(String recordid) {
            this.recordid = recordid;
            this.changedFields = changedFields.add("recordid");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder data(String data) {
            this.data = data;
            this.changedFields = changedFields.add("data");
            return this;
        }

        public Builder importdataid(String importdataid) {
            this.importdataid = importdataid;
            this.changedFields = changedFields.add("importdataid");
            return this;
        }

        public Importdata build() {
            Importdata _x = new Importdata();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.importdata";
            _x.haserror = haserror;
            _x._owninguser_value = _owninguser_value;
            _x.linenumber = linenumber;
            _x.createdon = createdon;
            _x._ownerid_value = _ownerid_value;
            _x._importfileid_value = _importfileid_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.statecode = statecode;
            _x.errortype = errortype;
            _x.modifiedon = modifiedon;
            _x._owningteam_value = _owningteam_value;
            _x._modifiedby_value = _modifiedby_value;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.statuscode = statuscode;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.recordid = recordid;
            _x._createdby_value = _createdby_value;
            _x.data = data;
            _x.importdataid = importdataid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && importdataid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(importdataid.toString()));
        }
    }

    @Property(name="haserror")
    @JsonIgnore
    public Optional<Boolean> getHaserror() {
        return Optional.ofNullable(haserror);
    }

    public Importdata withHaserror(Boolean haserror) {
        Importdata _x = _copy();
        _x.changedFields = changedFields.add("haserror");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importdata");
        _x.haserror = haserror;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<String> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Importdata with_owninguser_value(String _owninguser_value) {
        Importdata _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importdata");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="linenumber")
    @JsonIgnore
    public Optional<Integer> getLinenumber() {
        return Optional.ofNullable(linenumber);
    }

    public Importdata withLinenumber(Integer linenumber) {
        Importdata _x = _copy();
        _x.changedFields = changedFields.add("linenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importdata");
        _x.linenumber = linenumber;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Importdata withCreatedon(OffsetDateTime createdon) {
        Importdata _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importdata");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<String> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Importdata with_ownerid_value(String _ownerid_value) {
        Importdata _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importdata");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="_importfileid_value")
    @JsonIgnore
    public Optional<String> get_importfileid_value() {
        return Optional.ofNullable(_importfileid_value);
    }

    public Importdata with_importfileid_value(String _importfileid_value) {
        Importdata _x = _copy();
        _x.changedFields = changedFields.add("_importfileid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importdata");
        _x._importfileid_value = _importfileid_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Importdata with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Importdata _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importdata");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Importdata withStatecode(Integer statecode) {
        Importdata _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importdata");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="errortype")
    @JsonIgnore
    public Optional<Integer> getErrortype() {
        return Optional.ofNullable(errortype);
    }

    public Importdata withErrortype(Integer errortype) {
        Importdata _x = _copy();
        _x.changedFields = changedFields.add("errortype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importdata");
        _x.errortype = errortype;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Importdata withModifiedon(OffsetDateTime modifiedon) {
        Importdata _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importdata");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<String> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Importdata with_owningteam_value(String _owningteam_value) {
        Importdata _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importdata");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Importdata with_modifiedby_value(String _modifiedby_value) {
        Importdata _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importdata");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<String> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Importdata with_owningbusinessunit_value(String _owningbusinessunit_value) {
        Importdata _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importdata");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Importdata withStatuscode(Integer statuscode) {
        Importdata _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importdata");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Importdata with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Importdata _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importdata");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="recordid")
    @JsonIgnore
    public Optional<String> getRecordid() {
        return Optional.ofNullable(recordid);
    }

    public Importdata withRecordid(String recordid) {
        Importdata _x = _copy();
        _x.changedFields = changedFields.add("recordid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importdata");
        _x.recordid = recordid;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Importdata with_createdby_value(String _createdby_value) {
        Importdata _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importdata");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="data")
    @JsonIgnore
    public Optional<String> getData() {
        return Optional.ofNullable(data);
    }

    public Importdata withData(String data) {
        Checks.checkIsAscii(data);
        Importdata _x = _copy();
        _x.changedFields = changedFields.add("data");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importdata");
        _x.data = data;
        return _x;
    }

    @Property(name="importdataid")
    @JsonIgnore
    public Optional<String> getImportdataid() {
        return Optional.ofNullable(importdataid);
    }

    public Importdata withImportdataid(String importdataid) {
        Importdata _x = _copy();
        _x.changedFields = changedFields.add("importdataid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importdata");
        _x.importdataid = importdataid;
        return _x;
    }

    public Importdata withUnmappedField(String name, String value) {
        Importdata _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="ImportData_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getImportData_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("ImportData_AsyncOperations"), RequestHelper.getValue(unmappedFields, "ImportData_AsyncOperations"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="importfileid")
    @JsonIgnore
    public ImportfileRequest getImportfileid() {
        return new ImportfileRequest(contextPath.addSegment("importfileid"), RequestHelper.getValue(unmappedFields, "importfileid"));
    }

    @NavigationProperty(name="ImportLog_ImportData")
    @JsonIgnore
    public ImportlogCollectionRequest getImportLog_ImportData() {
        return new ImportlogCollectionRequest(
                        contextPath.addSegment("ImportLog_ImportData"), RequestHelper.getValue(unmappedFields, "ImportLog_ImportData"));
    }

    @NavigationProperty(name="ImportData_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getImportData_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("ImportData_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "ImportData_BulkDeleteFailures"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Importdata patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Importdata _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Importdata put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Importdata _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Importdata _copy() {
        Importdata _x = new Importdata();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.haserror = haserror;
        _x._owninguser_value = _owninguser_value;
        _x.linenumber = linenumber;
        _x.createdon = createdon;
        _x._ownerid_value = _ownerid_value;
        _x._importfileid_value = _importfileid_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.statecode = statecode;
        _x.errortype = errortype;
        _x.modifiedon = modifiedon;
        _x._owningteam_value = _owningteam_value;
        _x._modifiedby_value = _modifiedby_value;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.statuscode = statuscode;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.recordid = recordid;
        _x._createdby_value = _createdby_value;
        _x.data = data;
        _x.importdataid = importdataid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Importdata[");
        b.append("haserror=");
        b.append(this.haserror);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("linenumber=");
        b.append(this.linenumber);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("_importfileid_value=");
        b.append(this._importfileid_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("errortype=");
        b.append(this.errortype);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("recordid=");
        b.append(this.recordid);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("data=");
        b.append(this.data);
        b.append(", ");
        b.append("importdataid=");
        b.append(this.importdataid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
