package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FileattachmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "solutionuniquename", 
    "_createdonbehalfby_value", 
    "createdon", 
    "timezoneruleversionnumber", 
    "_asyncoperationid_value", 
    "_modifiedby_value", 
    "importsequencenumber", 
    "statecode", 
    "versionnumber", 
    "modifiedon", 
    "statuscode", 
    "_modifiedonbehalfby_value", 
    "_owninguser_value", 
    "utcconversiontimezonecode", 
    "_owningteam_value", 
    "_ownerid_value", 
    "_owningbusinessunit_value", 
    "solutionfilename", 
    "overriddencreatedon", 
    "solutionfile_name", 
    "name", 
    "_createdby_value", 
    "solutionfile", 
    "exportsolutionuploadid"})
@JsonInclude(Include.NON_NULL)
public class Exportsolutionupload extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.exportsolutionupload";
    }

    @JsonProperty("solutionuniquename")
    protected String solutionuniquename;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("_asyncoperationid_value")
    protected String _asyncoperationid_value;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("_owninguser_value")
    protected String _owninguser_value;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("_owningteam_value")
    protected String _owningteam_value;

    @JsonProperty("_ownerid_value")
    protected String _ownerid_value;

    @JsonProperty("_owningbusinessunit_value")
    protected String _owningbusinessunit_value;

    @JsonProperty("solutionfilename")
    protected String solutionfilename;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("solutionfile_name")
    protected String solutionfile_name;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("solutionfile")
    protected byte[] solutionfile;

    @JsonProperty("exportsolutionuploadid")
    protected String exportsolutionuploadid;

    protected Exportsolutionupload() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderExportsolutionupload() {
        return new Builder();
    }

    public static final class Builder {
        private String solutionuniquename;
        private String _createdonbehalfby_value;
        private OffsetDateTime createdon;
        private Integer timezoneruleversionnumber;
        private String _asyncoperationid_value;
        private String _modifiedby_value;
        private Integer importsequencenumber;
        private Integer statecode;
        private Long versionnumber;
        private OffsetDateTime modifiedon;
        private Integer statuscode;
        private String _modifiedonbehalfby_value;
        private String _owninguser_value;
        private Integer utcconversiontimezonecode;
        private String _owningteam_value;
        private String _ownerid_value;
        private String _owningbusinessunit_value;
        private String solutionfilename;
        private OffsetDateTime overriddencreatedon;
        private String solutionfile_name;
        private String name;
        private String _createdby_value;
        private byte[] solutionfile;
        private String exportsolutionuploadid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder solutionuniquename(String solutionuniquename) {
            this.solutionuniquename = solutionuniquename;
            this.changedFields = changedFields.add("solutionuniquename");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder _asyncoperationid_value(String _asyncoperationid_value) {
            this._asyncoperationid_value = _asyncoperationid_value;
            this.changedFields = changedFields.add("_asyncoperationid_value");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _owninguser_value(String _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder _owningteam_value(String _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder _owningbusinessunit_value(String _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder solutionfilename(String solutionfilename) {
            this.solutionfilename = solutionfilename;
            this.changedFields = changedFields.add("solutionfilename");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder solutionfile_name(String solutionfile_name) {
            this.solutionfile_name = solutionfile_name;
            this.changedFields = changedFields.add("solutionfile_name");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder solutionfile(byte[] solutionfile) {
            this.solutionfile = solutionfile;
            this.changedFields = changedFields.add("solutionfile");
            return this;
        }

        public Builder exportsolutionuploadid(String exportsolutionuploadid) {
            this.exportsolutionuploadid = exportsolutionuploadid;
            this.changedFields = changedFields.add("exportsolutionuploadid");
            return this;
        }

        public Exportsolutionupload build() {
            Exportsolutionupload _x = new Exportsolutionupload();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.exportsolutionupload";
            _x.solutionuniquename = solutionuniquename;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.createdon = createdon;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x._asyncoperationid_value = _asyncoperationid_value;
            _x._modifiedby_value = _modifiedby_value;
            _x.importsequencenumber = importsequencenumber;
            _x.statecode = statecode;
            _x.versionnumber = versionnumber;
            _x.modifiedon = modifiedon;
            _x.statuscode = statuscode;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._owninguser_value = _owninguser_value;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x._owningteam_value = _owningteam_value;
            _x._ownerid_value = _ownerid_value;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.solutionfilename = solutionfilename;
            _x.overriddencreatedon = overriddencreatedon;
            _x.solutionfile_name = solutionfile_name;
            _x.name = name;
            _x._createdby_value = _createdby_value;
            _x.solutionfile = solutionfile;
            _x.exportsolutionuploadid = exportsolutionuploadid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && exportsolutionuploadid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(exportsolutionuploadid.toString()));
        }
    }

    @Property(name="solutionuniquename")
    @JsonIgnore
    public Optional<String> getSolutionuniquename() {
        return Optional.ofNullable(solutionuniquename);
    }

    public Exportsolutionupload withSolutionuniquename(String solutionuniquename) {
        Checks.checkIsAscii(solutionuniquename);
        Exportsolutionupload _x = _copy();
        _x.changedFields = changedFields.add("solutionuniquename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exportsolutionupload");
        _x.solutionuniquename = solutionuniquename;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Exportsolutionupload with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Exportsolutionupload _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exportsolutionupload");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Exportsolutionupload withCreatedon(OffsetDateTime createdon) {
        Exportsolutionupload _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exportsolutionupload");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Exportsolutionupload withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Exportsolutionupload _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exportsolutionupload");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="_asyncoperationid_value")
    @JsonIgnore
    public Optional<String> get_asyncoperationid_value() {
        return Optional.ofNullable(_asyncoperationid_value);
    }

    public Exportsolutionupload with_asyncoperationid_value(String _asyncoperationid_value) {
        Exportsolutionupload _x = _copy();
        _x.changedFields = changedFields.add("_asyncoperationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exportsolutionupload");
        _x._asyncoperationid_value = _asyncoperationid_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Exportsolutionupload with_modifiedby_value(String _modifiedby_value) {
        Exportsolutionupload _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exportsolutionupload");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Exportsolutionupload withImportsequencenumber(Integer importsequencenumber) {
        Exportsolutionupload _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exportsolutionupload");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Exportsolutionupload withStatecode(Integer statecode) {
        Exportsolutionupload _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exportsolutionupload");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Exportsolutionupload withVersionnumber(Long versionnumber) {
        Exportsolutionupload _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exportsolutionupload");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Exportsolutionupload withModifiedon(OffsetDateTime modifiedon) {
        Exportsolutionupload _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exportsolutionupload");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Exportsolutionupload withStatuscode(Integer statuscode) {
        Exportsolutionupload _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exportsolutionupload");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Exportsolutionupload with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Exportsolutionupload _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exportsolutionupload");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<String> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Exportsolutionupload with_owninguser_value(String _owninguser_value) {
        Exportsolutionupload _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exportsolutionupload");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Exportsolutionupload withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Exportsolutionupload _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exportsolutionupload");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<String> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Exportsolutionupload with_owningteam_value(String _owningteam_value) {
        Exportsolutionupload _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exportsolutionupload");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<String> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Exportsolutionupload with_ownerid_value(String _ownerid_value) {
        Exportsolutionupload _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exportsolutionupload");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<String> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Exportsolutionupload with_owningbusinessunit_value(String _owningbusinessunit_value) {
        Exportsolutionupload _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exportsolutionupload");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="solutionfilename")
    @JsonIgnore
    public Optional<String> getSolutionfilename() {
        return Optional.ofNullable(solutionfilename);
    }

    public Exportsolutionupload withSolutionfilename(String solutionfilename) {
        Checks.checkIsAscii(solutionfilename);
        Exportsolutionupload _x = _copy();
        _x.changedFields = changedFields.add("solutionfilename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exportsolutionupload");
        _x.solutionfilename = solutionfilename;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Exportsolutionupload withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Exportsolutionupload _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exportsolutionupload");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="solutionfile_name")
    @JsonIgnore
    public Optional<String> getSolutionfile_name() {
        return Optional.ofNullable(solutionfile_name);
    }

    public Exportsolutionupload withSolutionfile_name(String solutionfile_name) {
        Checks.checkIsAscii(solutionfile_name);
        Exportsolutionupload _x = _copy();
        _x.changedFields = changedFields.add("solutionfile_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exportsolutionupload");
        _x.solutionfile_name = solutionfile_name;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Exportsolutionupload withName(String name) {
        Checks.checkIsAscii(name);
        Exportsolutionupload _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exportsolutionupload");
        _x.name = name;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Exportsolutionupload with_createdby_value(String _createdby_value) {
        Exportsolutionupload _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exportsolutionupload");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="solutionfile")
    @JsonIgnore
    public Optional<byte[]> getSolutionfile() {
        return Optional.ofNullable(solutionfile);
    }

    public Exportsolutionupload withSolutionfile(byte[] solutionfile) {
        Exportsolutionupload _x = _copy();
        _x.changedFields = changedFields.add("solutionfile");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exportsolutionupload");
        _x.solutionfile = solutionfile;
        return _x;
    }

    @Property(name="exportsolutionuploadid")
    @JsonIgnore
    public Optional<String> getExportsolutionuploadid() {
        return Optional.ofNullable(exportsolutionuploadid);
    }

    public Exportsolutionupload withExportsolutionuploadid(String exportsolutionuploadid) {
        Exportsolutionupload _x = _copy();
        _x.changedFields = changedFields.add("exportsolutionuploadid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exportsolutionupload");
        _x.exportsolutionuploadid = exportsolutionuploadid;
        return _x;
    }

    public Exportsolutionupload withUnmappedField(String name, String value) {
        Exportsolutionupload _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="exportsolutionupload_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getExportsolutionupload_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("exportsolutionupload_SyncErrors"), RequestHelper.getValue(unmappedFields, "exportsolutionupload_SyncErrors"));
    }

    @NavigationProperty(name="exportsolutionupload_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getExportsolutionupload_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("exportsolutionupload_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "exportsolutionupload_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="exportsolutionupload_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getExportsolutionupload_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("exportsolutionupload_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "exportsolutionupload_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="exportsolutionupload_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getExportsolutionupload_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("exportsolutionupload_AsyncOperations"), RequestHelper.getValue(unmappedFields, "exportsolutionupload_AsyncOperations"));
    }

    @NavigationProperty(name="exportsolutionupload_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getExportsolutionupload_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("exportsolutionupload_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "exportsolutionupload_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="exportsolutionupload_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getExportsolutionupload_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("exportsolutionupload_ProcessSession"), RequestHelper.getValue(unmappedFields, "exportsolutionupload_ProcessSession"));
    }

    @NavigationProperty(name="exportsolutionupload_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getExportsolutionupload_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("exportsolutionupload_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "exportsolutionupload_BulkDeleteFailures"));
    }

    @NavigationProperty(name="exportsolutionupload_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getExportsolutionupload_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("exportsolutionupload_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "exportsolutionupload_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="exportsolutionupload_FileAttachments")
    @JsonIgnore
    public FileattachmentCollectionRequest getExportsolutionupload_FileAttachments() {
        return new FileattachmentCollectionRequest(
                        contextPath.addSegment("exportsolutionupload_FileAttachments"), RequestHelper.getValue(unmappedFields, "exportsolutionupload_FileAttachments"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Exportsolutionupload patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Exportsolutionupload _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Exportsolutionupload put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Exportsolutionupload _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Exportsolutionupload _copy() {
        Exportsolutionupload _x = new Exportsolutionupload();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.solutionuniquename = solutionuniquename;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.createdon = createdon;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x._asyncoperationid_value = _asyncoperationid_value;
        _x._modifiedby_value = _modifiedby_value;
        _x.importsequencenumber = importsequencenumber;
        _x.statecode = statecode;
        _x.versionnumber = versionnumber;
        _x.modifiedon = modifiedon;
        _x.statuscode = statuscode;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._owninguser_value = _owninguser_value;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x._owningteam_value = _owningteam_value;
        _x._ownerid_value = _ownerid_value;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.solutionfilename = solutionfilename;
        _x.overriddencreatedon = overriddencreatedon;
        _x.solutionfile_name = solutionfile_name;
        _x.name = name;
        _x._createdby_value = _createdby_value;
        _x.solutionfile = solutionfile;
        _x.exportsolutionuploadid = exportsolutionuploadid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Exportsolutionupload[");
        b.append("solutionuniquename=");
        b.append(this.solutionuniquename);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("_asyncoperationid_value=");
        b.append(this._asyncoperationid_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("solutionfilename=");
        b.append(this.solutionfilename);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("solutionfile_name=");
        b.append(this.solutionfile_name);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("solutionfile=");
        b.append(this.solutionfile);
        b.append(", ");
        b.append("exportsolutionuploadid=");
        b.append(this.exportsolutionuploadid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
