package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.complex.EntitySetting;
import microsoft.dynamics.crm.complex.Label;
import microsoft.dynamics.crm.complex.SecurityPrivilegeMetadata;
import microsoft.dynamics.crm.entity.collection.request.AttributeMetadataCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EntityKeyMetadataCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ManyToManyRelationshipMetadataCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.OneToManyRelationshipMetadataCollectionRequest;
import microsoft.dynamics.crm.enums.OwnershipTypes;

@JsonPropertyOrder({
    "@odata.type", 
    "ActivityTypeMask", 
    "AutoRouteToOwnerQueue", 
    "CanTriggerWorkflow", 
    "Description", 
    "DisplayCollectionName", 
    "DisplayName", 
    "EntityHelpUrlEnabled", 
    "EntityHelpUrl", 
    "IsDocumentManagementEnabled", 
    "IsOneNoteIntegrationEnabled", 
    "IsInteractionCentricEnabled", 
    "IsKnowledgeManagementEnabled", 
    "IsSLAEnabled", 
    "IsBPFEntity", 
    "IsDocumentRecommendationsEnabled", 
    "IsMSTeamsIntegrationEnabled", 
    "SettingOf", 
    "DataProviderId", 
    "DataSourceId", 
    "AutoCreateAccessTeams", 
    "IsActivity", 
    "IsActivityParty", 
    "IsAuditEnabled", 
    "IsAvailableOffline", 
    "IsChildEntity", 
    "IsAIRUpdated", 
    "IsValidForQueue", 
    "IsConnectionsEnabled", 
    "IconLargeName", 
    "IconMediumName", 
    "IconSmallName", 
    "IconVectorName", 
    "IsCustomEntity", 
    "IsBusinessProcessEnabled", 
    "IsCustomizable", 
    "IsRenameable", 
    "IsMappable", 
    "IsDuplicateDetectionEnabled", 
    "CanCreateAttributes", 
    "CanCreateForms", 
    "CanCreateViews", 
    "CanCreateCharts", 
    "CanBeRelatedEntityInRelationship", 
    "CanBePrimaryEntityInRelationship", 
    "CanBeInManyToMany", 
    "CanBeInCustomEntityAssociation", 
    "CanEnableSyncToExternalSearchIndex", 
    "SyncToExternalSearchIndex", 
    "CanModifyAdditionalSettings", 
    "CanChangeHierarchicalRelationship", 
    "IsOptimisticConcurrencyEnabled", 
    "ChangeTrackingEnabled", 
    "CanChangeTrackingBeEnabled", 
    "IsImportable", 
    "IsIntersect", 
    "IsMailMergeEnabled", 
    "IsManaged", 
    "IsEnabledForCharts", 
    "IsEnabledForTrace", 
    "IsValidForAdvancedFind", 
    "IsVisibleInMobile", 
    "IsVisibleInMobileClient", 
    "IsReadOnlyInMobileClient", 
    "IsOfflineInMobileClient", 
    "DaysSinceRecordLastModified", 
    "MobileOfflineFilters", 
    "IsReadingPaneEnabled", 
    "IsQuickCreateEnabled", 
    "LogicalName", 
    "ObjectTypeCode", 
    "OwnershipType", 
    "PrimaryNameAttribute", 
    "PrimaryImageAttribute", 
    "PrimaryIdAttribute", 
    "Privileges", 
    "RecurrenceBaseEntityLogicalName", 
    "ReportViewName", 
    "SchemaName", 
    "IntroducedVersion", 
    "IsStateModelAware", 
    "EnforceStateTransitions", 
    "ExternalName", 
    "EntityColor", 
    "LogicalCollectionName", 
    "ExternalCollectionName", 
    "CollectionSchemaName", 
    "EntitySetName", 
    "IsEnabledForExternalChannels", 
    "IsPrivate", 
    "UsesBusinessDataLabelTable", 
    "IsLogicalEntity", 
    "HasNotes", 
    "HasActivities", 
    "HasFeedback", 
    "IsSolutionAware", 
    "Settings", 
    "CreatedOn", 
    "ModifiedOn"})
@JsonInclude(Include.NON_NULL)
public class EntityMetadata extends MetadataBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.EntityMetadata";
    }

    @JsonProperty("ActivityTypeMask")
    protected Integer activityTypeMask;

    @JsonProperty("AutoRouteToOwnerQueue")
    protected Boolean autoRouteToOwnerQueue;

    @JsonProperty("CanTriggerWorkflow")
    protected Boolean canTriggerWorkflow;

    @JsonProperty("Description")
    protected Label description;

    @JsonProperty("DisplayCollectionName")
    protected Label displayCollectionName;

    @JsonProperty("DisplayName")
    protected Label displayName;

    @JsonProperty("EntityHelpUrlEnabled")
    protected Boolean entityHelpUrlEnabled;

    @JsonProperty("EntityHelpUrl")
    protected String entityHelpUrl;

    @JsonProperty("IsDocumentManagementEnabled")
    protected Boolean isDocumentManagementEnabled;

    @JsonProperty("IsOneNoteIntegrationEnabled")
    protected Boolean isOneNoteIntegrationEnabled;

    @JsonProperty("IsInteractionCentricEnabled")
    protected Boolean isInteractionCentricEnabled;

    @JsonProperty("IsKnowledgeManagementEnabled")
    protected Boolean isKnowledgeManagementEnabled;

    @JsonProperty("IsSLAEnabled")
    protected Boolean isSLAEnabled;

    @JsonProperty("IsBPFEntity")
    protected Boolean isBPFEntity;

    @JsonProperty("IsDocumentRecommendationsEnabled")
    protected Boolean isDocumentRecommendationsEnabled;

    @JsonProperty("IsMSTeamsIntegrationEnabled")
    protected Boolean isMSTeamsIntegrationEnabled;

    @JsonProperty("SettingOf")
    protected String settingOf;

    @JsonProperty("DataProviderId")
    protected String dataProviderId;

    @JsonProperty("DataSourceId")
    protected String dataSourceId;

    @JsonProperty("AutoCreateAccessTeams")
    protected Boolean autoCreateAccessTeams;

    @JsonProperty("IsActivity")
    protected Boolean isActivity;

    @JsonProperty("IsActivityParty")
    protected Boolean isActivityParty;

    @JsonProperty("IsAuditEnabled")
    protected BooleanManagedProperty isAuditEnabled;

    @JsonProperty("IsAvailableOffline")
    protected Boolean isAvailableOffline;

    @JsonProperty("IsChildEntity")
    protected Boolean isChildEntity;

    @JsonProperty("IsAIRUpdated")
    protected Boolean isAIRUpdated;

    @JsonProperty("IsValidForQueue")
    protected BooleanManagedProperty isValidForQueue;

    @JsonProperty("IsConnectionsEnabled")
    protected BooleanManagedProperty isConnectionsEnabled;

    @JsonProperty("IconLargeName")
    protected String iconLargeName;

    @JsonProperty("IconMediumName")
    protected String iconMediumName;

    @JsonProperty("IconSmallName")
    protected String iconSmallName;

    @JsonProperty("IconVectorName")
    protected String iconVectorName;

    @JsonProperty("IsCustomEntity")
    protected Boolean isCustomEntity;

    @JsonProperty("IsBusinessProcessEnabled")
    protected Boolean isBusinessProcessEnabled;

    @JsonProperty("IsCustomizable")
    protected BooleanManagedProperty isCustomizable;

    @JsonProperty("IsRenameable")
    protected BooleanManagedProperty isRenameable;

    @JsonProperty("IsMappable")
    protected BooleanManagedProperty isMappable;

    @JsonProperty("IsDuplicateDetectionEnabled")
    protected BooleanManagedProperty isDuplicateDetectionEnabled;

    @JsonProperty("CanCreateAttributes")
    protected BooleanManagedProperty canCreateAttributes;

    @JsonProperty("CanCreateForms")
    protected BooleanManagedProperty canCreateForms;

    @JsonProperty("CanCreateViews")
    protected BooleanManagedProperty canCreateViews;

    @JsonProperty("CanCreateCharts")
    protected BooleanManagedProperty canCreateCharts;

    @JsonProperty("CanBeRelatedEntityInRelationship")
    protected BooleanManagedProperty canBeRelatedEntityInRelationship;

    @JsonProperty("CanBePrimaryEntityInRelationship")
    protected BooleanManagedProperty canBePrimaryEntityInRelationship;

    @JsonProperty("CanBeInManyToMany")
    protected BooleanManagedProperty canBeInManyToMany;

    @JsonProperty("CanBeInCustomEntityAssociation")
    protected BooleanManagedProperty canBeInCustomEntityAssociation;

    @JsonProperty("CanEnableSyncToExternalSearchIndex")
    protected BooleanManagedProperty canEnableSyncToExternalSearchIndex;

    @JsonProperty("SyncToExternalSearchIndex")
    protected Boolean syncToExternalSearchIndex;

    @JsonProperty("CanModifyAdditionalSettings")
    protected BooleanManagedProperty canModifyAdditionalSettings;

    @JsonProperty("CanChangeHierarchicalRelationship")
    protected BooleanManagedProperty canChangeHierarchicalRelationship;

    @JsonProperty("IsOptimisticConcurrencyEnabled")
    protected Boolean isOptimisticConcurrencyEnabled;

    @JsonProperty("ChangeTrackingEnabled")
    protected Boolean changeTrackingEnabled;

    @JsonProperty("CanChangeTrackingBeEnabled")
    protected BooleanManagedProperty canChangeTrackingBeEnabled;

    @JsonProperty("IsImportable")
    protected Boolean isImportable;

    @JsonProperty("IsIntersect")
    protected Boolean isIntersect;

    @JsonProperty("IsMailMergeEnabled")
    protected BooleanManagedProperty isMailMergeEnabled;

    @JsonProperty("IsManaged")
    protected Boolean isManaged;

    @JsonProperty("IsEnabledForCharts")
    protected Boolean isEnabledForCharts;

    @JsonProperty("IsEnabledForTrace")
    protected Boolean isEnabledForTrace;

    @JsonProperty("IsValidForAdvancedFind")
    protected Boolean isValidForAdvancedFind;

    @JsonProperty("IsVisibleInMobile")
    protected BooleanManagedProperty isVisibleInMobile;

    @JsonProperty("IsVisibleInMobileClient")
    protected BooleanManagedProperty isVisibleInMobileClient;

    @JsonProperty("IsReadOnlyInMobileClient")
    protected BooleanManagedProperty isReadOnlyInMobileClient;

    @JsonProperty("IsOfflineInMobileClient")
    protected BooleanManagedProperty isOfflineInMobileClient;

    @JsonProperty("DaysSinceRecordLastModified")
    protected Integer daysSinceRecordLastModified;

    @JsonProperty("MobileOfflineFilters")
    protected String mobileOfflineFilters;

    @JsonProperty("IsReadingPaneEnabled")
    protected Boolean isReadingPaneEnabled;

    @JsonProperty("IsQuickCreateEnabled")
    protected Boolean isQuickCreateEnabled;

    @JsonProperty("LogicalName")
    protected String logicalName;

    @JsonProperty("ObjectTypeCode")
    protected Integer objectTypeCode;

    @JsonProperty("OwnershipType")
    protected OwnershipTypes ownershipType;

    @JsonProperty("PrimaryNameAttribute")
    protected String primaryNameAttribute;

    @JsonProperty("PrimaryImageAttribute")
    protected String primaryImageAttribute;

    @JsonProperty("PrimaryIdAttribute")
    protected String primaryIdAttribute;

    @JsonProperty("Privileges")
    protected List<SecurityPrivilegeMetadata> privileges;

    @JsonProperty("Privileges@nextLink")
    protected String privilegesNextLink;

    @JsonProperty("RecurrenceBaseEntityLogicalName")
    protected String recurrenceBaseEntityLogicalName;

    @JsonProperty("ReportViewName")
    protected String reportViewName;

    @JsonProperty("SchemaName")
    protected String schemaName;

    @JsonProperty("IntroducedVersion")
    protected String introducedVersion;

    @JsonProperty("IsStateModelAware")
    protected Boolean isStateModelAware;

    @JsonProperty("EnforceStateTransitions")
    protected Boolean enforceStateTransitions;

    @JsonProperty("ExternalName")
    protected String externalName;

    @JsonProperty("EntityColor")
    protected String entityColor;

    @JsonProperty("LogicalCollectionName")
    protected String logicalCollectionName;

    @JsonProperty("ExternalCollectionName")
    protected String externalCollectionName;

    @JsonProperty("CollectionSchemaName")
    protected String collectionSchemaName;

    @JsonProperty("EntitySetName")
    protected String entitySetName;

    @JsonProperty("IsEnabledForExternalChannels")
    protected Boolean isEnabledForExternalChannels;

    @JsonProperty("IsPrivate")
    protected Boolean isPrivate;

    @JsonProperty("UsesBusinessDataLabelTable")
    protected Boolean usesBusinessDataLabelTable;

    @JsonProperty("IsLogicalEntity")
    protected Boolean isLogicalEntity;

    @JsonProperty("HasNotes")
    protected Boolean hasNotes;

    @JsonProperty("HasActivities")
    protected Boolean hasActivities;

    @JsonProperty("HasFeedback")
    protected Boolean hasFeedback;

    @JsonProperty("IsSolutionAware")
    protected Boolean isSolutionAware;

    @JsonProperty("Settings")
    protected List<EntitySetting> settings;

    @JsonProperty("Settings@nextLink")
    protected String settingsNextLink;

    @JsonProperty("CreatedOn")
    protected OffsetDateTime createdOn;

    @JsonProperty("ModifiedOn")
    protected OffsetDateTime modifiedOn;

    protected EntityMetadata() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEntityMetadata() {
        return new Builder();
    }

    public static final class Builder {
        private String metadataId;
        private Boolean hasChanged;
        private Integer activityTypeMask;
        private Boolean autoRouteToOwnerQueue;
        private Boolean canTriggerWorkflow;
        private Label description;
        private Label displayCollectionName;
        private Label displayName;
        private Boolean entityHelpUrlEnabled;
        private String entityHelpUrl;
        private Boolean isDocumentManagementEnabled;
        private Boolean isOneNoteIntegrationEnabled;
        private Boolean isInteractionCentricEnabled;
        private Boolean isKnowledgeManagementEnabled;
        private Boolean isSLAEnabled;
        private Boolean isBPFEntity;
        private Boolean isDocumentRecommendationsEnabled;
        private Boolean isMSTeamsIntegrationEnabled;
        private String settingOf;
        private String dataProviderId;
        private String dataSourceId;
        private Boolean autoCreateAccessTeams;
        private Boolean isActivity;
        private Boolean isActivityParty;
        private BooleanManagedProperty isAuditEnabled;
        private Boolean isAvailableOffline;
        private Boolean isChildEntity;
        private Boolean isAIRUpdated;
        private BooleanManagedProperty isValidForQueue;
        private BooleanManagedProperty isConnectionsEnabled;
        private String iconLargeName;
        private String iconMediumName;
        private String iconSmallName;
        private String iconVectorName;
        private Boolean isCustomEntity;
        private Boolean isBusinessProcessEnabled;
        private BooleanManagedProperty isCustomizable;
        private BooleanManagedProperty isRenameable;
        private BooleanManagedProperty isMappable;
        private BooleanManagedProperty isDuplicateDetectionEnabled;
        private BooleanManagedProperty canCreateAttributes;
        private BooleanManagedProperty canCreateForms;
        private BooleanManagedProperty canCreateViews;
        private BooleanManagedProperty canCreateCharts;
        private BooleanManagedProperty canBeRelatedEntityInRelationship;
        private BooleanManagedProperty canBePrimaryEntityInRelationship;
        private BooleanManagedProperty canBeInManyToMany;
        private BooleanManagedProperty canBeInCustomEntityAssociation;
        private BooleanManagedProperty canEnableSyncToExternalSearchIndex;
        private Boolean syncToExternalSearchIndex;
        private BooleanManagedProperty canModifyAdditionalSettings;
        private BooleanManagedProperty canChangeHierarchicalRelationship;
        private Boolean isOptimisticConcurrencyEnabled;
        private Boolean changeTrackingEnabled;
        private BooleanManagedProperty canChangeTrackingBeEnabled;
        private Boolean isImportable;
        private Boolean isIntersect;
        private BooleanManagedProperty isMailMergeEnabled;
        private Boolean isManaged;
        private Boolean isEnabledForCharts;
        private Boolean isEnabledForTrace;
        private Boolean isValidForAdvancedFind;
        private BooleanManagedProperty isVisibleInMobile;
        private BooleanManagedProperty isVisibleInMobileClient;
        private BooleanManagedProperty isReadOnlyInMobileClient;
        private BooleanManagedProperty isOfflineInMobileClient;
        private Integer daysSinceRecordLastModified;
        private String mobileOfflineFilters;
        private Boolean isReadingPaneEnabled;
        private Boolean isQuickCreateEnabled;
        private String logicalName;
        private Integer objectTypeCode;
        private OwnershipTypes ownershipType;
        private String primaryNameAttribute;
        private String primaryImageAttribute;
        private String primaryIdAttribute;
        private List<SecurityPrivilegeMetadata> privileges;
        private String privilegesNextLink;
        private String recurrenceBaseEntityLogicalName;
        private String reportViewName;
        private String schemaName;
        private String introducedVersion;
        private Boolean isStateModelAware;
        private Boolean enforceStateTransitions;
        private String externalName;
        private String entityColor;
        private String logicalCollectionName;
        private String externalCollectionName;
        private String collectionSchemaName;
        private String entitySetName;
        private Boolean isEnabledForExternalChannels;
        private Boolean isPrivate;
        private Boolean usesBusinessDataLabelTable;
        private Boolean isLogicalEntity;
        private Boolean hasNotes;
        private Boolean hasActivities;
        private Boolean hasFeedback;
        private Boolean isSolutionAware;
        private List<EntitySetting> settings;
        private String settingsNextLink;
        private OffsetDateTime createdOn;
        private OffsetDateTime modifiedOn;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder metadataId(String metadataId) {
            this.metadataId = metadataId;
            this.changedFields = changedFields.add("MetadataId");
            return this;
        }

        public Builder hasChanged(Boolean hasChanged) {
            this.hasChanged = hasChanged;
            this.changedFields = changedFields.add("HasChanged");
            return this;
        }

        public Builder activityTypeMask(Integer activityTypeMask) {
            this.activityTypeMask = activityTypeMask;
            this.changedFields = changedFields.add("ActivityTypeMask");
            return this;
        }

        public Builder autoRouteToOwnerQueue(Boolean autoRouteToOwnerQueue) {
            this.autoRouteToOwnerQueue = autoRouteToOwnerQueue;
            this.changedFields = changedFields.add("AutoRouteToOwnerQueue");
            return this;
        }

        public Builder canTriggerWorkflow(Boolean canTriggerWorkflow) {
            this.canTriggerWorkflow = canTriggerWorkflow;
            this.changedFields = changedFields.add("CanTriggerWorkflow");
            return this;
        }

        public Builder description(Label description) {
            this.description = description;
            this.changedFields = changedFields.add("Description");
            return this;
        }

        public Builder displayCollectionName(Label displayCollectionName) {
            this.displayCollectionName = displayCollectionName;
            this.changedFields = changedFields.add("DisplayCollectionName");
            return this;
        }

        public Builder displayName(Label displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("DisplayName");
            return this;
        }

        public Builder entityHelpUrlEnabled(Boolean entityHelpUrlEnabled) {
            this.entityHelpUrlEnabled = entityHelpUrlEnabled;
            this.changedFields = changedFields.add("EntityHelpUrlEnabled");
            return this;
        }

        public Builder entityHelpUrl(String entityHelpUrl) {
            this.entityHelpUrl = entityHelpUrl;
            this.changedFields = changedFields.add("EntityHelpUrl");
            return this;
        }

        public Builder isDocumentManagementEnabled(Boolean isDocumentManagementEnabled) {
            this.isDocumentManagementEnabled = isDocumentManagementEnabled;
            this.changedFields = changedFields.add("IsDocumentManagementEnabled");
            return this;
        }

        public Builder isOneNoteIntegrationEnabled(Boolean isOneNoteIntegrationEnabled) {
            this.isOneNoteIntegrationEnabled = isOneNoteIntegrationEnabled;
            this.changedFields = changedFields.add("IsOneNoteIntegrationEnabled");
            return this;
        }

        public Builder isInteractionCentricEnabled(Boolean isInteractionCentricEnabled) {
            this.isInteractionCentricEnabled = isInteractionCentricEnabled;
            this.changedFields = changedFields.add("IsInteractionCentricEnabled");
            return this;
        }

        public Builder isKnowledgeManagementEnabled(Boolean isKnowledgeManagementEnabled) {
            this.isKnowledgeManagementEnabled = isKnowledgeManagementEnabled;
            this.changedFields = changedFields.add("IsKnowledgeManagementEnabled");
            return this;
        }

        public Builder isSLAEnabled(Boolean isSLAEnabled) {
            this.isSLAEnabled = isSLAEnabled;
            this.changedFields = changedFields.add("IsSLAEnabled");
            return this;
        }

        public Builder isBPFEntity(Boolean isBPFEntity) {
            this.isBPFEntity = isBPFEntity;
            this.changedFields = changedFields.add("IsBPFEntity");
            return this;
        }

        public Builder isDocumentRecommendationsEnabled(Boolean isDocumentRecommendationsEnabled) {
            this.isDocumentRecommendationsEnabled = isDocumentRecommendationsEnabled;
            this.changedFields = changedFields.add("IsDocumentRecommendationsEnabled");
            return this;
        }

        public Builder isMSTeamsIntegrationEnabled(Boolean isMSTeamsIntegrationEnabled) {
            this.isMSTeamsIntegrationEnabled = isMSTeamsIntegrationEnabled;
            this.changedFields = changedFields.add("IsMSTeamsIntegrationEnabled");
            return this;
        }

        public Builder settingOf(String settingOf) {
            this.settingOf = settingOf;
            this.changedFields = changedFields.add("SettingOf");
            return this;
        }

        public Builder dataProviderId(String dataProviderId) {
            this.dataProviderId = dataProviderId;
            this.changedFields = changedFields.add("DataProviderId");
            return this;
        }

        public Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            this.changedFields = changedFields.add("DataSourceId");
            return this;
        }

        public Builder autoCreateAccessTeams(Boolean autoCreateAccessTeams) {
            this.autoCreateAccessTeams = autoCreateAccessTeams;
            this.changedFields = changedFields.add("AutoCreateAccessTeams");
            return this;
        }

        public Builder isActivity(Boolean isActivity) {
            this.isActivity = isActivity;
            this.changedFields = changedFields.add("IsActivity");
            return this;
        }

        public Builder isActivityParty(Boolean isActivityParty) {
            this.isActivityParty = isActivityParty;
            this.changedFields = changedFields.add("IsActivityParty");
            return this;
        }

        public Builder isAuditEnabled(BooleanManagedProperty isAuditEnabled) {
            this.isAuditEnabled = isAuditEnabled;
            this.changedFields = changedFields.add("IsAuditEnabled");
            return this;
        }

        public Builder isAvailableOffline(Boolean isAvailableOffline) {
            this.isAvailableOffline = isAvailableOffline;
            this.changedFields = changedFields.add("IsAvailableOffline");
            return this;
        }

        public Builder isChildEntity(Boolean isChildEntity) {
            this.isChildEntity = isChildEntity;
            this.changedFields = changedFields.add("IsChildEntity");
            return this;
        }

        public Builder isAIRUpdated(Boolean isAIRUpdated) {
            this.isAIRUpdated = isAIRUpdated;
            this.changedFields = changedFields.add("IsAIRUpdated");
            return this;
        }

        public Builder isValidForQueue(BooleanManagedProperty isValidForQueue) {
            this.isValidForQueue = isValidForQueue;
            this.changedFields = changedFields.add("IsValidForQueue");
            return this;
        }

        public Builder isConnectionsEnabled(BooleanManagedProperty isConnectionsEnabled) {
            this.isConnectionsEnabled = isConnectionsEnabled;
            this.changedFields = changedFields.add("IsConnectionsEnabled");
            return this;
        }

        public Builder iconLargeName(String iconLargeName) {
            this.iconLargeName = iconLargeName;
            this.changedFields = changedFields.add("IconLargeName");
            return this;
        }

        public Builder iconMediumName(String iconMediumName) {
            this.iconMediumName = iconMediumName;
            this.changedFields = changedFields.add("IconMediumName");
            return this;
        }

        public Builder iconSmallName(String iconSmallName) {
            this.iconSmallName = iconSmallName;
            this.changedFields = changedFields.add("IconSmallName");
            return this;
        }

        public Builder iconVectorName(String iconVectorName) {
            this.iconVectorName = iconVectorName;
            this.changedFields = changedFields.add("IconVectorName");
            return this;
        }

        public Builder isCustomEntity(Boolean isCustomEntity) {
            this.isCustomEntity = isCustomEntity;
            this.changedFields = changedFields.add("IsCustomEntity");
            return this;
        }

        public Builder isBusinessProcessEnabled(Boolean isBusinessProcessEnabled) {
            this.isBusinessProcessEnabled = isBusinessProcessEnabled;
            this.changedFields = changedFields.add("IsBusinessProcessEnabled");
            return this;
        }

        public Builder isCustomizable(BooleanManagedProperty isCustomizable) {
            this.isCustomizable = isCustomizable;
            this.changedFields = changedFields.add("IsCustomizable");
            return this;
        }

        public Builder isRenameable(BooleanManagedProperty isRenameable) {
            this.isRenameable = isRenameable;
            this.changedFields = changedFields.add("IsRenameable");
            return this;
        }

        public Builder isMappable(BooleanManagedProperty isMappable) {
            this.isMappable = isMappable;
            this.changedFields = changedFields.add("IsMappable");
            return this;
        }

        public Builder isDuplicateDetectionEnabled(BooleanManagedProperty isDuplicateDetectionEnabled) {
            this.isDuplicateDetectionEnabled = isDuplicateDetectionEnabled;
            this.changedFields = changedFields.add("IsDuplicateDetectionEnabled");
            return this;
        }

        public Builder canCreateAttributes(BooleanManagedProperty canCreateAttributes) {
            this.canCreateAttributes = canCreateAttributes;
            this.changedFields = changedFields.add("CanCreateAttributes");
            return this;
        }

        public Builder canCreateForms(BooleanManagedProperty canCreateForms) {
            this.canCreateForms = canCreateForms;
            this.changedFields = changedFields.add("CanCreateForms");
            return this;
        }

        public Builder canCreateViews(BooleanManagedProperty canCreateViews) {
            this.canCreateViews = canCreateViews;
            this.changedFields = changedFields.add("CanCreateViews");
            return this;
        }

        public Builder canCreateCharts(BooleanManagedProperty canCreateCharts) {
            this.canCreateCharts = canCreateCharts;
            this.changedFields = changedFields.add("CanCreateCharts");
            return this;
        }

        public Builder canBeRelatedEntityInRelationship(BooleanManagedProperty canBeRelatedEntityInRelationship) {
            this.canBeRelatedEntityInRelationship = canBeRelatedEntityInRelationship;
            this.changedFields = changedFields.add("CanBeRelatedEntityInRelationship");
            return this;
        }

        public Builder canBePrimaryEntityInRelationship(BooleanManagedProperty canBePrimaryEntityInRelationship) {
            this.canBePrimaryEntityInRelationship = canBePrimaryEntityInRelationship;
            this.changedFields = changedFields.add("CanBePrimaryEntityInRelationship");
            return this;
        }

        public Builder canBeInManyToMany(BooleanManagedProperty canBeInManyToMany) {
            this.canBeInManyToMany = canBeInManyToMany;
            this.changedFields = changedFields.add("CanBeInManyToMany");
            return this;
        }

        public Builder canBeInCustomEntityAssociation(BooleanManagedProperty canBeInCustomEntityAssociation) {
            this.canBeInCustomEntityAssociation = canBeInCustomEntityAssociation;
            this.changedFields = changedFields.add("CanBeInCustomEntityAssociation");
            return this;
        }

        public Builder canEnableSyncToExternalSearchIndex(BooleanManagedProperty canEnableSyncToExternalSearchIndex) {
            this.canEnableSyncToExternalSearchIndex = canEnableSyncToExternalSearchIndex;
            this.changedFields = changedFields.add("CanEnableSyncToExternalSearchIndex");
            return this;
        }

        public Builder syncToExternalSearchIndex(Boolean syncToExternalSearchIndex) {
            this.syncToExternalSearchIndex = syncToExternalSearchIndex;
            this.changedFields = changedFields.add("SyncToExternalSearchIndex");
            return this;
        }

        public Builder canModifyAdditionalSettings(BooleanManagedProperty canModifyAdditionalSettings) {
            this.canModifyAdditionalSettings = canModifyAdditionalSettings;
            this.changedFields = changedFields.add("CanModifyAdditionalSettings");
            return this;
        }

        public Builder canChangeHierarchicalRelationship(BooleanManagedProperty canChangeHierarchicalRelationship) {
            this.canChangeHierarchicalRelationship = canChangeHierarchicalRelationship;
            this.changedFields = changedFields.add("CanChangeHierarchicalRelationship");
            return this;
        }

        public Builder isOptimisticConcurrencyEnabled(Boolean isOptimisticConcurrencyEnabled) {
            this.isOptimisticConcurrencyEnabled = isOptimisticConcurrencyEnabled;
            this.changedFields = changedFields.add("IsOptimisticConcurrencyEnabled");
            return this;
        }

        public Builder changeTrackingEnabled(Boolean changeTrackingEnabled) {
            this.changeTrackingEnabled = changeTrackingEnabled;
            this.changedFields = changedFields.add("ChangeTrackingEnabled");
            return this;
        }

        public Builder canChangeTrackingBeEnabled(BooleanManagedProperty canChangeTrackingBeEnabled) {
            this.canChangeTrackingBeEnabled = canChangeTrackingBeEnabled;
            this.changedFields = changedFields.add("CanChangeTrackingBeEnabled");
            return this;
        }

        public Builder isImportable(Boolean isImportable) {
            this.isImportable = isImportable;
            this.changedFields = changedFields.add("IsImportable");
            return this;
        }

        public Builder isIntersect(Boolean isIntersect) {
            this.isIntersect = isIntersect;
            this.changedFields = changedFields.add("IsIntersect");
            return this;
        }

        public Builder isMailMergeEnabled(BooleanManagedProperty isMailMergeEnabled) {
            this.isMailMergeEnabled = isMailMergeEnabled;
            this.changedFields = changedFields.add("IsMailMergeEnabled");
            return this;
        }

        public Builder isManaged(Boolean isManaged) {
            this.isManaged = isManaged;
            this.changedFields = changedFields.add("IsManaged");
            return this;
        }

        public Builder isEnabledForCharts(Boolean isEnabledForCharts) {
            this.isEnabledForCharts = isEnabledForCharts;
            this.changedFields = changedFields.add("IsEnabledForCharts");
            return this;
        }

        public Builder isEnabledForTrace(Boolean isEnabledForTrace) {
            this.isEnabledForTrace = isEnabledForTrace;
            this.changedFields = changedFields.add("IsEnabledForTrace");
            return this;
        }

        public Builder isValidForAdvancedFind(Boolean isValidForAdvancedFind) {
            this.isValidForAdvancedFind = isValidForAdvancedFind;
            this.changedFields = changedFields.add("IsValidForAdvancedFind");
            return this;
        }

        public Builder isVisibleInMobile(BooleanManagedProperty isVisibleInMobile) {
            this.isVisibleInMobile = isVisibleInMobile;
            this.changedFields = changedFields.add("IsVisibleInMobile");
            return this;
        }

        public Builder isVisibleInMobileClient(BooleanManagedProperty isVisibleInMobileClient) {
            this.isVisibleInMobileClient = isVisibleInMobileClient;
            this.changedFields = changedFields.add("IsVisibleInMobileClient");
            return this;
        }

        public Builder isReadOnlyInMobileClient(BooleanManagedProperty isReadOnlyInMobileClient) {
            this.isReadOnlyInMobileClient = isReadOnlyInMobileClient;
            this.changedFields = changedFields.add("IsReadOnlyInMobileClient");
            return this;
        }

        public Builder isOfflineInMobileClient(BooleanManagedProperty isOfflineInMobileClient) {
            this.isOfflineInMobileClient = isOfflineInMobileClient;
            this.changedFields = changedFields.add("IsOfflineInMobileClient");
            return this;
        }

        public Builder daysSinceRecordLastModified(Integer daysSinceRecordLastModified) {
            this.daysSinceRecordLastModified = daysSinceRecordLastModified;
            this.changedFields = changedFields.add("DaysSinceRecordLastModified");
            return this;
        }

        public Builder mobileOfflineFilters(String mobileOfflineFilters) {
            this.mobileOfflineFilters = mobileOfflineFilters;
            this.changedFields = changedFields.add("MobileOfflineFilters");
            return this;
        }

        public Builder isReadingPaneEnabled(Boolean isReadingPaneEnabled) {
            this.isReadingPaneEnabled = isReadingPaneEnabled;
            this.changedFields = changedFields.add("IsReadingPaneEnabled");
            return this;
        }

        public Builder isQuickCreateEnabled(Boolean isQuickCreateEnabled) {
            this.isQuickCreateEnabled = isQuickCreateEnabled;
            this.changedFields = changedFields.add("IsQuickCreateEnabled");
            return this;
        }

        public Builder logicalName(String logicalName) {
            this.logicalName = logicalName;
            this.changedFields = changedFields.add("LogicalName");
            return this;
        }

        public Builder objectTypeCode(Integer objectTypeCode) {
            this.objectTypeCode = objectTypeCode;
            this.changedFields = changedFields.add("ObjectTypeCode");
            return this;
        }

        public Builder ownershipType(OwnershipTypes ownershipType) {
            this.ownershipType = ownershipType;
            this.changedFields = changedFields.add("OwnershipType");
            return this;
        }

        public Builder primaryNameAttribute(String primaryNameAttribute) {
            this.primaryNameAttribute = primaryNameAttribute;
            this.changedFields = changedFields.add("PrimaryNameAttribute");
            return this;
        }

        public Builder primaryImageAttribute(String primaryImageAttribute) {
            this.primaryImageAttribute = primaryImageAttribute;
            this.changedFields = changedFields.add("PrimaryImageAttribute");
            return this;
        }

        public Builder primaryIdAttribute(String primaryIdAttribute) {
            this.primaryIdAttribute = primaryIdAttribute;
            this.changedFields = changedFields.add("PrimaryIdAttribute");
            return this;
        }

        public Builder privileges(List<SecurityPrivilegeMetadata> privileges) {
            this.privileges = privileges;
            this.changedFields = changedFields.add("Privileges");
            return this;
        }

        public Builder privileges(SecurityPrivilegeMetadata... privileges) {
            return privileges(Arrays.asList(privileges));
        }

        public Builder privilegesNextLink(String privilegesNextLink) {
            this.privilegesNextLink = privilegesNextLink;
            this.changedFields = changedFields.add("Privileges");
            return this;
        }

        public Builder recurrenceBaseEntityLogicalName(String recurrenceBaseEntityLogicalName) {
            this.recurrenceBaseEntityLogicalName = recurrenceBaseEntityLogicalName;
            this.changedFields = changedFields.add("RecurrenceBaseEntityLogicalName");
            return this;
        }

        public Builder reportViewName(String reportViewName) {
            this.reportViewName = reportViewName;
            this.changedFields = changedFields.add("ReportViewName");
            return this;
        }

        public Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            this.changedFields = changedFields.add("SchemaName");
            return this;
        }

        public Builder introducedVersion(String introducedVersion) {
            this.introducedVersion = introducedVersion;
            this.changedFields = changedFields.add("IntroducedVersion");
            return this;
        }

        public Builder isStateModelAware(Boolean isStateModelAware) {
            this.isStateModelAware = isStateModelAware;
            this.changedFields = changedFields.add("IsStateModelAware");
            return this;
        }

        public Builder enforceStateTransitions(Boolean enforceStateTransitions) {
            this.enforceStateTransitions = enforceStateTransitions;
            this.changedFields = changedFields.add("EnforceStateTransitions");
            return this;
        }

        public Builder externalName(String externalName) {
            this.externalName = externalName;
            this.changedFields = changedFields.add("ExternalName");
            return this;
        }

        public Builder entityColor(String entityColor) {
            this.entityColor = entityColor;
            this.changedFields = changedFields.add("EntityColor");
            return this;
        }

        public Builder logicalCollectionName(String logicalCollectionName) {
            this.logicalCollectionName = logicalCollectionName;
            this.changedFields = changedFields.add("LogicalCollectionName");
            return this;
        }

        public Builder externalCollectionName(String externalCollectionName) {
            this.externalCollectionName = externalCollectionName;
            this.changedFields = changedFields.add("ExternalCollectionName");
            return this;
        }

        public Builder collectionSchemaName(String collectionSchemaName) {
            this.collectionSchemaName = collectionSchemaName;
            this.changedFields = changedFields.add("CollectionSchemaName");
            return this;
        }

        public Builder entitySetName(String entitySetName) {
            this.entitySetName = entitySetName;
            this.changedFields = changedFields.add("EntitySetName");
            return this;
        }

        public Builder isEnabledForExternalChannels(Boolean isEnabledForExternalChannels) {
            this.isEnabledForExternalChannels = isEnabledForExternalChannels;
            this.changedFields = changedFields.add("IsEnabledForExternalChannels");
            return this;
        }

        public Builder isPrivate(Boolean isPrivate) {
            this.isPrivate = isPrivate;
            this.changedFields = changedFields.add("IsPrivate");
            return this;
        }

        public Builder usesBusinessDataLabelTable(Boolean usesBusinessDataLabelTable) {
            this.usesBusinessDataLabelTable = usesBusinessDataLabelTable;
            this.changedFields = changedFields.add("UsesBusinessDataLabelTable");
            return this;
        }

        public Builder isLogicalEntity(Boolean isLogicalEntity) {
            this.isLogicalEntity = isLogicalEntity;
            this.changedFields = changedFields.add("IsLogicalEntity");
            return this;
        }

        public Builder hasNotes(Boolean hasNotes) {
            this.hasNotes = hasNotes;
            this.changedFields = changedFields.add("HasNotes");
            return this;
        }

        public Builder hasActivities(Boolean hasActivities) {
            this.hasActivities = hasActivities;
            this.changedFields = changedFields.add("HasActivities");
            return this;
        }

        public Builder hasFeedback(Boolean hasFeedback) {
            this.hasFeedback = hasFeedback;
            this.changedFields = changedFields.add("HasFeedback");
            return this;
        }

        public Builder isSolutionAware(Boolean isSolutionAware) {
            this.isSolutionAware = isSolutionAware;
            this.changedFields = changedFields.add("IsSolutionAware");
            return this;
        }

        public Builder settings(List<EntitySetting> settings) {
            this.settings = settings;
            this.changedFields = changedFields.add("Settings");
            return this;
        }

        public Builder settings(EntitySetting... settings) {
            return settings(Arrays.asList(settings));
        }

        public Builder settingsNextLink(String settingsNextLink) {
            this.settingsNextLink = settingsNextLink;
            this.changedFields = changedFields.add("Settings");
            return this;
        }

        public Builder createdOn(OffsetDateTime createdOn) {
            this.createdOn = createdOn;
            this.changedFields = changedFields.add("CreatedOn");
            return this;
        }

        public Builder modifiedOn(OffsetDateTime modifiedOn) {
            this.modifiedOn = modifiedOn;
            this.changedFields = changedFields.add("ModifiedOn");
            return this;
        }

        public EntityMetadata build() {
            EntityMetadata _x = new EntityMetadata();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.EntityMetadata";
            _x.metadataId = metadataId;
            _x.hasChanged = hasChanged;
            _x.activityTypeMask = activityTypeMask;
            _x.autoRouteToOwnerQueue = autoRouteToOwnerQueue;
            _x.canTriggerWorkflow = canTriggerWorkflow;
            _x.description = description;
            _x.displayCollectionName = displayCollectionName;
            _x.displayName = displayName;
            _x.entityHelpUrlEnabled = entityHelpUrlEnabled;
            _x.entityHelpUrl = entityHelpUrl;
            _x.isDocumentManagementEnabled = isDocumentManagementEnabled;
            _x.isOneNoteIntegrationEnabled = isOneNoteIntegrationEnabled;
            _x.isInteractionCentricEnabled = isInteractionCentricEnabled;
            _x.isKnowledgeManagementEnabled = isKnowledgeManagementEnabled;
            _x.isSLAEnabled = isSLAEnabled;
            _x.isBPFEntity = isBPFEntity;
            _x.isDocumentRecommendationsEnabled = isDocumentRecommendationsEnabled;
            _x.isMSTeamsIntegrationEnabled = isMSTeamsIntegrationEnabled;
            _x.settingOf = settingOf;
            _x.dataProviderId = dataProviderId;
            _x.dataSourceId = dataSourceId;
            _x.autoCreateAccessTeams = autoCreateAccessTeams;
            _x.isActivity = isActivity;
            _x.isActivityParty = isActivityParty;
            _x.isAuditEnabled = isAuditEnabled;
            _x.isAvailableOffline = isAvailableOffline;
            _x.isChildEntity = isChildEntity;
            _x.isAIRUpdated = isAIRUpdated;
            _x.isValidForQueue = isValidForQueue;
            _x.isConnectionsEnabled = isConnectionsEnabled;
            _x.iconLargeName = iconLargeName;
            _x.iconMediumName = iconMediumName;
            _x.iconSmallName = iconSmallName;
            _x.iconVectorName = iconVectorName;
            _x.isCustomEntity = isCustomEntity;
            _x.isBusinessProcessEnabled = isBusinessProcessEnabled;
            _x.isCustomizable = isCustomizable;
            _x.isRenameable = isRenameable;
            _x.isMappable = isMappable;
            _x.isDuplicateDetectionEnabled = isDuplicateDetectionEnabled;
            _x.canCreateAttributes = canCreateAttributes;
            _x.canCreateForms = canCreateForms;
            _x.canCreateViews = canCreateViews;
            _x.canCreateCharts = canCreateCharts;
            _x.canBeRelatedEntityInRelationship = canBeRelatedEntityInRelationship;
            _x.canBePrimaryEntityInRelationship = canBePrimaryEntityInRelationship;
            _x.canBeInManyToMany = canBeInManyToMany;
            _x.canBeInCustomEntityAssociation = canBeInCustomEntityAssociation;
            _x.canEnableSyncToExternalSearchIndex = canEnableSyncToExternalSearchIndex;
            _x.syncToExternalSearchIndex = syncToExternalSearchIndex;
            _x.canModifyAdditionalSettings = canModifyAdditionalSettings;
            _x.canChangeHierarchicalRelationship = canChangeHierarchicalRelationship;
            _x.isOptimisticConcurrencyEnabled = isOptimisticConcurrencyEnabled;
            _x.changeTrackingEnabled = changeTrackingEnabled;
            _x.canChangeTrackingBeEnabled = canChangeTrackingBeEnabled;
            _x.isImportable = isImportable;
            _x.isIntersect = isIntersect;
            _x.isMailMergeEnabled = isMailMergeEnabled;
            _x.isManaged = isManaged;
            _x.isEnabledForCharts = isEnabledForCharts;
            _x.isEnabledForTrace = isEnabledForTrace;
            _x.isValidForAdvancedFind = isValidForAdvancedFind;
            _x.isVisibleInMobile = isVisibleInMobile;
            _x.isVisibleInMobileClient = isVisibleInMobileClient;
            _x.isReadOnlyInMobileClient = isReadOnlyInMobileClient;
            _x.isOfflineInMobileClient = isOfflineInMobileClient;
            _x.daysSinceRecordLastModified = daysSinceRecordLastModified;
            _x.mobileOfflineFilters = mobileOfflineFilters;
            _x.isReadingPaneEnabled = isReadingPaneEnabled;
            _x.isQuickCreateEnabled = isQuickCreateEnabled;
            _x.logicalName = logicalName;
            _x.objectTypeCode = objectTypeCode;
            _x.ownershipType = ownershipType;
            _x.primaryNameAttribute = primaryNameAttribute;
            _x.primaryImageAttribute = primaryImageAttribute;
            _x.primaryIdAttribute = primaryIdAttribute;
            _x.privileges = privileges;
            _x.privilegesNextLink = privilegesNextLink;
            _x.recurrenceBaseEntityLogicalName = recurrenceBaseEntityLogicalName;
            _x.reportViewName = reportViewName;
            _x.schemaName = schemaName;
            _x.introducedVersion = introducedVersion;
            _x.isStateModelAware = isStateModelAware;
            _x.enforceStateTransitions = enforceStateTransitions;
            _x.externalName = externalName;
            _x.entityColor = entityColor;
            _x.logicalCollectionName = logicalCollectionName;
            _x.externalCollectionName = externalCollectionName;
            _x.collectionSchemaName = collectionSchemaName;
            _x.entitySetName = entitySetName;
            _x.isEnabledForExternalChannels = isEnabledForExternalChannels;
            _x.isPrivate = isPrivate;
            _x.usesBusinessDataLabelTable = usesBusinessDataLabelTable;
            _x.isLogicalEntity = isLogicalEntity;
            _x.hasNotes = hasNotes;
            _x.hasActivities = hasActivities;
            _x.hasFeedback = hasFeedback;
            _x.isSolutionAware = isSolutionAware;
            _x.settings = settings;
            _x.settingsNextLink = settingsNextLink;
            _x.createdOn = createdOn;
            _x.modifiedOn = modifiedOn;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && metadataId != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(metadataId.toString()));
        }
    }

    @Property(name="ActivityTypeMask")
    @JsonIgnore
    public Optional<Integer> getActivityTypeMask() {
        return Optional.ofNullable(activityTypeMask);
    }

    public EntityMetadata withActivityTypeMask(Integer activityTypeMask) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("ActivityTypeMask");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.activityTypeMask = activityTypeMask;
        return _x;
    }

    @Property(name="AutoRouteToOwnerQueue")
    @JsonIgnore
    public Optional<Boolean> getAutoRouteToOwnerQueue() {
        return Optional.ofNullable(autoRouteToOwnerQueue);
    }

    public EntityMetadata withAutoRouteToOwnerQueue(Boolean autoRouteToOwnerQueue) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("AutoRouteToOwnerQueue");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.autoRouteToOwnerQueue = autoRouteToOwnerQueue;
        return _x;
    }

    @Property(name="CanTriggerWorkflow")
    @JsonIgnore
    public Optional<Boolean> getCanTriggerWorkflow() {
        return Optional.ofNullable(canTriggerWorkflow);
    }

    public EntityMetadata withCanTriggerWorkflow(Boolean canTriggerWorkflow) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("CanTriggerWorkflow");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.canTriggerWorkflow = canTriggerWorkflow;
        return _x;
    }

    @Property(name="Description")
    @JsonIgnore
    public Optional<Label> getDescription() {
        return Optional.ofNullable(description);
    }

    public EntityMetadata withDescription(Label description) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("Description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.description = description;
        return _x;
    }

    @Property(name="DisplayCollectionName")
    @JsonIgnore
    public Optional<Label> getDisplayCollectionName() {
        return Optional.ofNullable(displayCollectionName);
    }

    public EntityMetadata withDisplayCollectionName(Label displayCollectionName) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("DisplayCollectionName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.displayCollectionName = displayCollectionName;
        return _x;
    }

    @Property(name="DisplayName")
    @JsonIgnore
    public Optional<Label> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public EntityMetadata withDisplayName(Label displayName) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("DisplayName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="EntityHelpUrlEnabled")
    @JsonIgnore
    public Optional<Boolean> getEntityHelpUrlEnabled() {
        return Optional.ofNullable(entityHelpUrlEnabled);
    }

    public EntityMetadata withEntityHelpUrlEnabled(Boolean entityHelpUrlEnabled) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("EntityHelpUrlEnabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.entityHelpUrlEnabled = entityHelpUrlEnabled;
        return _x;
    }

    @Property(name="EntityHelpUrl")
    @JsonIgnore
    public Optional<String> getEntityHelpUrl() {
        return Optional.ofNullable(entityHelpUrl);
    }

    public EntityMetadata withEntityHelpUrl(String entityHelpUrl) {
        Checks.checkIsAscii(entityHelpUrl);
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("EntityHelpUrl");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.entityHelpUrl = entityHelpUrl;
        return _x;
    }

    @Property(name="IsDocumentManagementEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsDocumentManagementEnabled() {
        return Optional.ofNullable(isDocumentManagementEnabled);
    }

    public EntityMetadata withIsDocumentManagementEnabled(Boolean isDocumentManagementEnabled) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsDocumentManagementEnabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isDocumentManagementEnabled = isDocumentManagementEnabled;
        return _x;
    }

    @Property(name="IsOneNoteIntegrationEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsOneNoteIntegrationEnabled() {
        return Optional.ofNullable(isOneNoteIntegrationEnabled);
    }

    public EntityMetadata withIsOneNoteIntegrationEnabled(Boolean isOneNoteIntegrationEnabled) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsOneNoteIntegrationEnabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isOneNoteIntegrationEnabled = isOneNoteIntegrationEnabled;
        return _x;
    }

    @Property(name="IsInteractionCentricEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsInteractionCentricEnabled() {
        return Optional.ofNullable(isInteractionCentricEnabled);
    }

    public EntityMetadata withIsInteractionCentricEnabled(Boolean isInteractionCentricEnabled) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsInteractionCentricEnabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isInteractionCentricEnabled = isInteractionCentricEnabled;
        return _x;
    }

    @Property(name="IsKnowledgeManagementEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsKnowledgeManagementEnabled() {
        return Optional.ofNullable(isKnowledgeManagementEnabled);
    }

    public EntityMetadata withIsKnowledgeManagementEnabled(Boolean isKnowledgeManagementEnabled) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsKnowledgeManagementEnabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isKnowledgeManagementEnabled = isKnowledgeManagementEnabled;
        return _x;
    }

    @Property(name="IsSLAEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsSLAEnabled() {
        return Optional.ofNullable(isSLAEnabled);
    }

    public EntityMetadata withIsSLAEnabled(Boolean isSLAEnabled) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsSLAEnabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isSLAEnabled = isSLAEnabled;
        return _x;
    }

    @Property(name="IsBPFEntity")
    @JsonIgnore
    public Optional<Boolean> getIsBPFEntity() {
        return Optional.ofNullable(isBPFEntity);
    }

    public EntityMetadata withIsBPFEntity(Boolean isBPFEntity) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsBPFEntity");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isBPFEntity = isBPFEntity;
        return _x;
    }

    @Property(name="IsDocumentRecommendationsEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsDocumentRecommendationsEnabled() {
        return Optional.ofNullable(isDocumentRecommendationsEnabled);
    }

    public EntityMetadata withIsDocumentRecommendationsEnabled(Boolean isDocumentRecommendationsEnabled) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsDocumentRecommendationsEnabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isDocumentRecommendationsEnabled = isDocumentRecommendationsEnabled;
        return _x;
    }

    @Property(name="IsMSTeamsIntegrationEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsMSTeamsIntegrationEnabled() {
        return Optional.ofNullable(isMSTeamsIntegrationEnabled);
    }

    public EntityMetadata withIsMSTeamsIntegrationEnabled(Boolean isMSTeamsIntegrationEnabled) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsMSTeamsIntegrationEnabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isMSTeamsIntegrationEnabled = isMSTeamsIntegrationEnabled;
        return _x;
    }

    @Property(name="SettingOf")
    @JsonIgnore
    public Optional<String> getSettingOf() {
        return Optional.ofNullable(settingOf);
    }

    public EntityMetadata withSettingOf(String settingOf) {
        Checks.checkIsAscii(settingOf);
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("SettingOf");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.settingOf = settingOf;
        return _x;
    }

    @Property(name="DataProviderId")
    @JsonIgnore
    public Optional<String> getDataProviderId() {
        return Optional.ofNullable(dataProviderId);
    }

    public EntityMetadata withDataProviderId(String dataProviderId) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("DataProviderId");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.dataProviderId = dataProviderId;
        return _x;
    }

    @Property(name="DataSourceId")
    @JsonIgnore
    public Optional<String> getDataSourceId() {
        return Optional.ofNullable(dataSourceId);
    }

    public EntityMetadata withDataSourceId(String dataSourceId) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("DataSourceId");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.dataSourceId = dataSourceId;
        return _x;
    }

    @Property(name="AutoCreateAccessTeams")
    @JsonIgnore
    public Optional<Boolean> getAutoCreateAccessTeams() {
        return Optional.ofNullable(autoCreateAccessTeams);
    }

    public EntityMetadata withAutoCreateAccessTeams(Boolean autoCreateAccessTeams) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("AutoCreateAccessTeams");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.autoCreateAccessTeams = autoCreateAccessTeams;
        return _x;
    }

    @Property(name="IsActivity")
    @JsonIgnore
    public Optional<Boolean> getIsActivity() {
        return Optional.ofNullable(isActivity);
    }

    public EntityMetadata withIsActivity(Boolean isActivity) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsActivity");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isActivity = isActivity;
        return _x;
    }

    @Property(name="IsActivityParty")
    @JsonIgnore
    public Optional<Boolean> getIsActivityParty() {
        return Optional.ofNullable(isActivityParty);
    }

    public EntityMetadata withIsActivityParty(Boolean isActivityParty) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsActivityParty");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isActivityParty = isActivityParty;
        return _x;
    }

    @Property(name="IsAuditEnabled")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsAuditEnabled() {
        return Optional.ofNullable(isAuditEnabled);
    }

    public EntityMetadata withIsAuditEnabled(BooleanManagedProperty isAuditEnabled) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsAuditEnabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isAuditEnabled = isAuditEnabled;
        return _x;
    }

    @Property(name="IsAvailableOffline")
    @JsonIgnore
    public Optional<Boolean> getIsAvailableOffline() {
        return Optional.ofNullable(isAvailableOffline);
    }

    public EntityMetadata withIsAvailableOffline(Boolean isAvailableOffline) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsAvailableOffline");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isAvailableOffline = isAvailableOffline;
        return _x;
    }

    @Property(name="IsChildEntity")
    @JsonIgnore
    public Optional<Boolean> getIsChildEntity() {
        return Optional.ofNullable(isChildEntity);
    }

    public EntityMetadata withIsChildEntity(Boolean isChildEntity) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsChildEntity");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isChildEntity = isChildEntity;
        return _x;
    }

    @Property(name="IsAIRUpdated")
    @JsonIgnore
    public Optional<Boolean> getIsAIRUpdated() {
        return Optional.ofNullable(isAIRUpdated);
    }

    public EntityMetadata withIsAIRUpdated(Boolean isAIRUpdated) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsAIRUpdated");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isAIRUpdated = isAIRUpdated;
        return _x;
    }

    @Property(name="IsValidForQueue")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsValidForQueue() {
        return Optional.ofNullable(isValidForQueue);
    }

    public EntityMetadata withIsValidForQueue(BooleanManagedProperty isValidForQueue) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsValidForQueue");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isValidForQueue = isValidForQueue;
        return _x;
    }

    @Property(name="IsConnectionsEnabled")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsConnectionsEnabled() {
        return Optional.ofNullable(isConnectionsEnabled);
    }

    public EntityMetadata withIsConnectionsEnabled(BooleanManagedProperty isConnectionsEnabled) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsConnectionsEnabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isConnectionsEnabled = isConnectionsEnabled;
        return _x;
    }

    @Property(name="IconLargeName")
    @JsonIgnore
    public Optional<String> getIconLargeName() {
        return Optional.ofNullable(iconLargeName);
    }

    public EntityMetadata withIconLargeName(String iconLargeName) {
        Checks.checkIsAscii(iconLargeName);
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IconLargeName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.iconLargeName = iconLargeName;
        return _x;
    }

    @Property(name="IconMediumName")
    @JsonIgnore
    public Optional<String> getIconMediumName() {
        return Optional.ofNullable(iconMediumName);
    }

    public EntityMetadata withIconMediumName(String iconMediumName) {
        Checks.checkIsAscii(iconMediumName);
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IconMediumName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.iconMediumName = iconMediumName;
        return _x;
    }

    @Property(name="IconSmallName")
    @JsonIgnore
    public Optional<String> getIconSmallName() {
        return Optional.ofNullable(iconSmallName);
    }

    public EntityMetadata withIconSmallName(String iconSmallName) {
        Checks.checkIsAscii(iconSmallName);
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IconSmallName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.iconSmallName = iconSmallName;
        return _x;
    }

    @Property(name="IconVectorName")
    @JsonIgnore
    public Optional<String> getIconVectorName() {
        return Optional.ofNullable(iconVectorName);
    }

    public EntityMetadata withIconVectorName(String iconVectorName) {
        Checks.checkIsAscii(iconVectorName);
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IconVectorName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.iconVectorName = iconVectorName;
        return _x;
    }

    @Property(name="IsCustomEntity")
    @JsonIgnore
    public Optional<Boolean> getIsCustomEntity() {
        return Optional.ofNullable(isCustomEntity);
    }

    public EntityMetadata withIsCustomEntity(Boolean isCustomEntity) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsCustomEntity");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isCustomEntity = isCustomEntity;
        return _x;
    }

    @Property(name="IsBusinessProcessEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsBusinessProcessEnabled() {
        return Optional.ofNullable(isBusinessProcessEnabled);
    }

    public EntityMetadata withIsBusinessProcessEnabled(Boolean isBusinessProcessEnabled) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsBusinessProcessEnabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isBusinessProcessEnabled = isBusinessProcessEnabled;
        return _x;
    }

    @Property(name="IsCustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsCustomizable() {
        return Optional.ofNullable(isCustomizable);
    }

    public EntityMetadata withIsCustomizable(BooleanManagedProperty isCustomizable) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsCustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isCustomizable = isCustomizable;
        return _x;
    }

    @Property(name="IsRenameable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsRenameable() {
        return Optional.ofNullable(isRenameable);
    }

    public EntityMetadata withIsRenameable(BooleanManagedProperty isRenameable) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsRenameable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isRenameable = isRenameable;
        return _x;
    }

    @Property(name="IsMappable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsMappable() {
        return Optional.ofNullable(isMappable);
    }

    public EntityMetadata withIsMappable(BooleanManagedProperty isMappable) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsMappable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isMappable = isMappable;
        return _x;
    }

    @Property(name="IsDuplicateDetectionEnabled")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsDuplicateDetectionEnabled() {
        return Optional.ofNullable(isDuplicateDetectionEnabled);
    }

    public EntityMetadata withIsDuplicateDetectionEnabled(BooleanManagedProperty isDuplicateDetectionEnabled) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsDuplicateDetectionEnabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isDuplicateDetectionEnabled = isDuplicateDetectionEnabled;
        return _x;
    }

    @Property(name="CanCreateAttributes")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getCanCreateAttributes() {
        return Optional.ofNullable(canCreateAttributes);
    }

    public EntityMetadata withCanCreateAttributes(BooleanManagedProperty canCreateAttributes) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("CanCreateAttributes");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.canCreateAttributes = canCreateAttributes;
        return _x;
    }

    @Property(name="CanCreateForms")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getCanCreateForms() {
        return Optional.ofNullable(canCreateForms);
    }

    public EntityMetadata withCanCreateForms(BooleanManagedProperty canCreateForms) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("CanCreateForms");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.canCreateForms = canCreateForms;
        return _x;
    }

    @Property(name="CanCreateViews")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getCanCreateViews() {
        return Optional.ofNullable(canCreateViews);
    }

    public EntityMetadata withCanCreateViews(BooleanManagedProperty canCreateViews) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("CanCreateViews");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.canCreateViews = canCreateViews;
        return _x;
    }

    @Property(name="CanCreateCharts")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getCanCreateCharts() {
        return Optional.ofNullable(canCreateCharts);
    }

    public EntityMetadata withCanCreateCharts(BooleanManagedProperty canCreateCharts) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("CanCreateCharts");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.canCreateCharts = canCreateCharts;
        return _x;
    }

    @Property(name="CanBeRelatedEntityInRelationship")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getCanBeRelatedEntityInRelationship() {
        return Optional.ofNullable(canBeRelatedEntityInRelationship);
    }

    public EntityMetadata withCanBeRelatedEntityInRelationship(BooleanManagedProperty canBeRelatedEntityInRelationship) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("CanBeRelatedEntityInRelationship");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.canBeRelatedEntityInRelationship = canBeRelatedEntityInRelationship;
        return _x;
    }

    @Property(name="CanBePrimaryEntityInRelationship")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getCanBePrimaryEntityInRelationship() {
        return Optional.ofNullable(canBePrimaryEntityInRelationship);
    }

    public EntityMetadata withCanBePrimaryEntityInRelationship(BooleanManagedProperty canBePrimaryEntityInRelationship) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("CanBePrimaryEntityInRelationship");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.canBePrimaryEntityInRelationship = canBePrimaryEntityInRelationship;
        return _x;
    }

    @Property(name="CanBeInManyToMany")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getCanBeInManyToMany() {
        return Optional.ofNullable(canBeInManyToMany);
    }

    public EntityMetadata withCanBeInManyToMany(BooleanManagedProperty canBeInManyToMany) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("CanBeInManyToMany");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.canBeInManyToMany = canBeInManyToMany;
        return _x;
    }

    @Property(name="CanBeInCustomEntityAssociation")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getCanBeInCustomEntityAssociation() {
        return Optional.ofNullable(canBeInCustomEntityAssociation);
    }

    public EntityMetadata withCanBeInCustomEntityAssociation(BooleanManagedProperty canBeInCustomEntityAssociation) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("CanBeInCustomEntityAssociation");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.canBeInCustomEntityAssociation = canBeInCustomEntityAssociation;
        return _x;
    }

    @Property(name="CanEnableSyncToExternalSearchIndex")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getCanEnableSyncToExternalSearchIndex() {
        return Optional.ofNullable(canEnableSyncToExternalSearchIndex);
    }

    public EntityMetadata withCanEnableSyncToExternalSearchIndex(BooleanManagedProperty canEnableSyncToExternalSearchIndex) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("CanEnableSyncToExternalSearchIndex");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.canEnableSyncToExternalSearchIndex = canEnableSyncToExternalSearchIndex;
        return _x;
    }

    @Property(name="SyncToExternalSearchIndex")
    @JsonIgnore
    public Optional<Boolean> getSyncToExternalSearchIndex() {
        return Optional.ofNullable(syncToExternalSearchIndex);
    }

    public EntityMetadata withSyncToExternalSearchIndex(Boolean syncToExternalSearchIndex) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("SyncToExternalSearchIndex");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.syncToExternalSearchIndex = syncToExternalSearchIndex;
        return _x;
    }

    @Property(name="CanModifyAdditionalSettings")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getCanModifyAdditionalSettings() {
        return Optional.ofNullable(canModifyAdditionalSettings);
    }

    public EntityMetadata withCanModifyAdditionalSettings(BooleanManagedProperty canModifyAdditionalSettings) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("CanModifyAdditionalSettings");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.canModifyAdditionalSettings = canModifyAdditionalSettings;
        return _x;
    }

    @Property(name="CanChangeHierarchicalRelationship")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getCanChangeHierarchicalRelationship() {
        return Optional.ofNullable(canChangeHierarchicalRelationship);
    }

    public EntityMetadata withCanChangeHierarchicalRelationship(BooleanManagedProperty canChangeHierarchicalRelationship) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("CanChangeHierarchicalRelationship");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.canChangeHierarchicalRelationship = canChangeHierarchicalRelationship;
        return _x;
    }

    @Property(name="IsOptimisticConcurrencyEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsOptimisticConcurrencyEnabled() {
        return Optional.ofNullable(isOptimisticConcurrencyEnabled);
    }

    public EntityMetadata withIsOptimisticConcurrencyEnabled(Boolean isOptimisticConcurrencyEnabled) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsOptimisticConcurrencyEnabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isOptimisticConcurrencyEnabled = isOptimisticConcurrencyEnabled;
        return _x;
    }

    @Property(name="ChangeTrackingEnabled")
    @JsonIgnore
    public Optional<Boolean> getChangeTrackingEnabled() {
        return Optional.ofNullable(changeTrackingEnabled);
    }

    public EntityMetadata withChangeTrackingEnabled(Boolean changeTrackingEnabled) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("ChangeTrackingEnabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.changeTrackingEnabled = changeTrackingEnabled;
        return _x;
    }

    @Property(name="CanChangeTrackingBeEnabled")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getCanChangeTrackingBeEnabled() {
        return Optional.ofNullable(canChangeTrackingBeEnabled);
    }

    public EntityMetadata withCanChangeTrackingBeEnabled(BooleanManagedProperty canChangeTrackingBeEnabled) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("CanChangeTrackingBeEnabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.canChangeTrackingBeEnabled = canChangeTrackingBeEnabled;
        return _x;
    }

    @Property(name="IsImportable")
    @JsonIgnore
    public Optional<Boolean> getIsImportable() {
        return Optional.ofNullable(isImportable);
    }

    public EntityMetadata withIsImportable(Boolean isImportable) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsImportable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isImportable = isImportable;
        return _x;
    }

    @Property(name="IsIntersect")
    @JsonIgnore
    public Optional<Boolean> getIsIntersect() {
        return Optional.ofNullable(isIntersect);
    }

    public EntityMetadata withIsIntersect(Boolean isIntersect) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsIntersect");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isIntersect = isIntersect;
        return _x;
    }

    @Property(name="IsMailMergeEnabled")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsMailMergeEnabled() {
        return Optional.ofNullable(isMailMergeEnabled);
    }

    public EntityMetadata withIsMailMergeEnabled(BooleanManagedProperty isMailMergeEnabled) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsMailMergeEnabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isMailMergeEnabled = isMailMergeEnabled;
        return _x;
    }

    @Property(name="IsManaged")
    @JsonIgnore
    public Optional<Boolean> getIsManaged() {
        return Optional.ofNullable(isManaged);
    }

    public EntityMetadata withIsManaged(Boolean isManaged) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsManaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isManaged = isManaged;
        return _x;
    }

    @Property(name="IsEnabledForCharts")
    @JsonIgnore
    public Optional<Boolean> getIsEnabledForCharts() {
        return Optional.ofNullable(isEnabledForCharts);
    }

    public EntityMetadata withIsEnabledForCharts(Boolean isEnabledForCharts) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsEnabledForCharts");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isEnabledForCharts = isEnabledForCharts;
        return _x;
    }

    @Property(name="IsEnabledForTrace")
    @JsonIgnore
    public Optional<Boolean> getIsEnabledForTrace() {
        return Optional.ofNullable(isEnabledForTrace);
    }

    public EntityMetadata withIsEnabledForTrace(Boolean isEnabledForTrace) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsEnabledForTrace");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isEnabledForTrace = isEnabledForTrace;
        return _x;
    }

    @Property(name="IsValidForAdvancedFind")
    @JsonIgnore
    public Optional<Boolean> getIsValidForAdvancedFind() {
        return Optional.ofNullable(isValidForAdvancedFind);
    }

    public EntityMetadata withIsValidForAdvancedFind(Boolean isValidForAdvancedFind) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsValidForAdvancedFind");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isValidForAdvancedFind = isValidForAdvancedFind;
        return _x;
    }

    @Property(name="IsVisibleInMobile")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsVisibleInMobile() {
        return Optional.ofNullable(isVisibleInMobile);
    }

    public EntityMetadata withIsVisibleInMobile(BooleanManagedProperty isVisibleInMobile) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsVisibleInMobile");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isVisibleInMobile = isVisibleInMobile;
        return _x;
    }

    @Property(name="IsVisibleInMobileClient")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsVisibleInMobileClient() {
        return Optional.ofNullable(isVisibleInMobileClient);
    }

    public EntityMetadata withIsVisibleInMobileClient(BooleanManagedProperty isVisibleInMobileClient) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsVisibleInMobileClient");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isVisibleInMobileClient = isVisibleInMobileClient;
        return _x;
    }

    @Property(name="IsReadOnlyInMobileClient")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsReadOnlyInMobileClient() {
        return Optional.ofNullable(isReadOnlyInMobileClient);
    }

    public EntityMetadata withIsReadOnlyInMobileClient(BooleanManagedProperty isReadOnlyInMobileClient) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsReadOnlyInMobileClient");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isReadOnlyInMobileClient = isReadOnlyInMobileClient;
        return _x;
    }

    @Property(name="IsOfflineInMobileClient")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsOfflineInMobileClient() {
        return Optional.ofNullable(isOfflineInMobileClient);
    }

    public EntityMetadata withIsOfflineInMobileClient(BooleanManagedProperty isOfflineInMobileClient) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsOfflineInMobileClient");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isOfflineInMobileClient = isOfflineInMobileClient;
        return _x;
    }

    @Property(name="DaysSinceRecordLastModified")
    @JsonIgnore
    public Optional<Integer> getDaysSinceRecordLastModified() {
        return Optional.ofNullable(daysSinceRecordLastModified);
    }

    public EntityMetadata withDaysSinceRecordLastModified(Integer daysSinceRecordLastModified) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("DaysSinceRecordLastModified");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.daysSinceRecordLastModified = daysSinceRecordLastModified;
        return _x;
    }

    @Property(name="MobileOfflineFilters")
    @JsonIgnore
    public Optional<String> getMobileOfflineFilters() {
        return Optional.ofNullable(mobileOfflineFilters);
    }

    public EntityMetadata withMobileOfflineFilters(String mobileOfflineFilters) {
        Checks.checkIsAscii(mobileOfflineFilters);
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("MobileOfflineFilters");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.mobileOfflineFilters = mobileOfflineFilters;
        return _x;
    }

    @Property(name="IsReadingPaneEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsReadingPaneEnabled() {
        return Optional.ofNullable(isReadingPaneEnabled);
    }

    public EntityMetadata withIsReadingPaneEnabled(Boolean isReadingPaneEnabled) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsReadingPaneEnabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isReadingPaneEnabled = isReadingPaneEnabled;
        return _x;
    }

    @Property(name="IsQuickCreateEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsQuickCreateEnabled() {
        return Optional.ofNullable(isQuickCreateEnabled);
    }

    public EntityMetadata withIsQuickCreateEnabled(Boolean isQuickCreateEnabled) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsQuickCreateEnabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isQuickCreateEnabled = isQuickCreateEnabled;
        return _x;
    }

    @Property(name="LogicalName")
    @JsonIgnore
    public Optional<String> getLogicalName() {
        return Optional.ofNullable(logicalName);
    }

    public EntityMetadata withLogicalName(String logicalName) {
        Checks.checkIsAscii(logicalName);
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("LogicalName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.logicalName = logicalName;
        return _x;
    }

    @Property(name="ObjectTypeCode")
    @JsonIgnore
    public Optional<Integer> getObjectTypeCode() {
        return Optional.ofNullable(objectTypeCode);
    }

    public EntityMetadata withObjectTypeCode(Integer objectTypeCode) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("ObjectTypeCode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.objectTypeCode = objectTypeCode;
        return _x;
    }

    @Property(name="OwnershipType")
    @JsonIgnore
    public Optional<OwnershipTypes> getOwnershipType() {
        return Optional.ofNullable(ownershipType);
    }

    public EntityMetadata withOwnershipType(OwnershipTypes ownershipType) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("OwnershipType");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.ownershipType = ownershipType;
        return _x;
    }

    @Property(name="PrimaryNameAttribute")
    @JsonIgnore
    public Optional<String> getPrimaryNameAttribute() {
        return Optional.ofNullable(primaryNameAttribute);
    }

    public EntityMetadata withPrimaryNameAttribute(String primaryNameAttribute) {
        Checks.checkIsAscii(primaryNameAttribute);
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("PrimaryNameAttribute");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.primaryNameAttribute = primaryNameAttribute;
        return _x;
    }

    @Property(name="PrimaryImageAttribute")
    @JsonIgnore
    public Optional<String> getPrimaryImageAttribute() {
        return Optional.ofNullable(primaryImageAttribute);
    }

    public EntityMetadata withPrimaryImageAttribute(String primaryImageAttribute) {
        Checks.checkIsAscii(primaryImageAttribute);
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("PrimaryImageAttribute");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.primaryImageAttribute = primaryImageAttribute;
        return _x;
    }

    @Property(name="PrimaryIdAttribute")
    @JsonIgnore
    public Optional<String> getPrimaryIdAttribute() {
        return Optional.ofNullable(primaryIdAttribute);
    }

    public EntityMetadata withPrimaryIdAttribute(String primaryIdAttribute) {
        Checks.checkIsAscii(primaryIdAttribute);
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("PrimaryIdAttribute");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.primaryIdAttribute = primaryIdAttribute;
        return _x;
    }

    @Property(name="Privileges")
    @JsonIgnore
    public CollectionPage<SecurityPrivilegeMetadata> getPrivileges() {
        return new CollectionPage<SecurityPrivilegeMetadata>(contextPath, SecurityPrivilegeMetadata.class, this.privileges, Optional.ofNullable(privilegesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public EntityMetadata withPrivileges(List<SecurityPrivilegeMetadata> privileges) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("Privileges");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.privileges = privileges;
        return _x;
    }

    @Property(name="Privileges")
    @JsonIgnore
    public CollectionPage<SecurityPrivilegeMetadata> getPrivileges(HttpRequestOptions options) {
        return new CollectionPage<SecurityPrivilegeMetadata>(contextPath, SecurityPrivilegeMetadata.class, this.privileges, Optional.ofNullable(privilegesNextLink), Collections.emptyList(), options);
    }

    @Property(name="RecurrenceBaseEntityLogicalName")
    @JsonIgnore
    public Optional<String> getRecurrenceBaseEntityLogicalName() {
        return Optional.ofNullable(recurrenceBaseEntityLogicalName);
    }

    public EntityMetadata withRecurrenceBaseEntityLogicalName(String recurrenceBaseEntityLogicalName) {
        Checks.checkIsAscii(recurrenceBaseEntityLogicalName);
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("RecurrenceBaseEntityLogicalName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.recurrenceBaseEntityLogicalName = recurrenceBaseEntityLogicalName;
        return _x;
    }

    @Property(name="ReportViewName")
    @JsonIgnore
    public Optional<String> getReportViewName() {
        return Optional.ofNullable(reportViewName);
    }

    public EntityMetadata withReportViewName(String reportViewName) {
        Checks.checkIsAscii(reportViewName);
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("ReportViewName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.reportViewName = reportViewName;
        return _x;
    }

    @Property(name="SchemaName")
    @JsonIgnore
    public Optional<String> getSchemaName() {
        return Optional.ofNullable(schemaName);
    }

    public EntityMetadata withSchemaName(String schemaName) {
        Checks.checkIsAscii(schemaName);
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("SchemaName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.schemaName = schemaName;
        return _x;
    }

    @Property(name="IntroducedVersion")
    @JsonIgnore
    public Optional<String> getIntroducedVersion() {
        return Optional.ofNullable(introducedVersion);
    }

    public EntityMetadata withIntroducedVersion(String introducedVersion) {
        Checks.checkIsAscii(introducedVersion);
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IntroducedVersion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.introducedVersion = introducedVersion;
        return _x;
    }

    @Property(name="IsStateModelAware")
    @JsonIgnore
    public Optional<Boolean> getIsStateModelAware() {
        return Optional.ofNullable(isStateModelAware);
    }

    public EntityMetadata withIsStateModelAware(Boolean isStateModelAware) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsStateModelAware");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isStateModelAware = isStateModelAware;
        return _x;
    }

    @Property(name="EnforceStateTransitions")
    @JsonIgnore
    public Optional<Boolean> getEnforceStateTransitions() {
        return Optional.ofNullable(enforceStateTransitions);
    }

    public EntityMetadata withEnforceStateTransitions(Boolean enforceStateTransitions) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("EnforceStateTransitions");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.enforceStateTransitions = enforceStateTransitions;
        return _x;
    }

    @Property(name="ExternalName")
    @JsonIgnore
    public Optional<String> getExternalName() {
        return Optional.ofNullable(externalName);
    }

    public EntityMetadata withExternalName(String externalName) {
        Checks.checkIsAscii(externalName);
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("ExternalName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.externalName = externalName;
        return _x;
    }

    @Property(name="EntityColor")
    @JsonIgnore
    public Optional<String> getEntityColor() {
        return Optional.ofNullable(entityColor);
    }

    public EntityMetadata withEntityColor(String entityColor) {
        Checks.checkIsAscii(entityColor);
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("EntityColor");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.entityColor = entityColor;
        return _x;
    }

    @Property(name="LogicalCollectionName")
    @JsonIgnore
    public Optional<String> getLogicalCollectionName() {
        return Optional.ofNullable(logicalCollectionName);
    }

    public EntityMetadata withLogicalCollectionName(String logicalCollectionName) {
        Checks.checkIsAscii(logicalCollectionName);
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("LogicalCollectionName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.logicalCollectionName = logicalCollectionName;
        return _x;
    }

    @Property(name="ExternalCollectionName")
    @JsonIgnore
    public Optional<String> getExternalCollectionName() {
        return Optional.ofNullable(externalCollectionName);
    }

    public EntityMetadata withExternalCollectionName(String externalCollectionName) {
        Checks.checkIsAscii(externalCollectionName);
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("ExternalCollectionName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.externalCollectionName = externalCollectionName;
        return _x;
    }

    @Property(name="CollectionSchemaName")
    @JsonIgnore
    public Optional<String> getCollectionSchemaName() {
        return Optional.ofNullable(collectionSchemaName);
    }

    public EntityMetadata withCollectionSchemaName(String collectionSchemaName) {
        Checks.checkIsAscii(collectionSchemaName);
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("CollectionSchemaName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.collectionSchemaName = collectionSchemaName;
        return _x;
    }

    @Property(name="EntitySetName")
    @JsonIgnore
    public Optional<String> getEntitySetName() {
        return Optional.ofNullable(entitySetName);
    }

    public EntityMetadata withEntitySetName(String entitySetName) {
        Checks.checkIsAscii(entitySetName);
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("EntitySetName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.entitySetName = entitySetName;
        return _x;
    }

    @Property(name="IsEnabledForExternalChannels")
    @JsonIgnore
    public Optional<Boolean> getIsEnabledForExternalChannels() {
        return Optional.ofNullable(isEnabledForExternalChannels);
    }

    public EntityMetadata withIsEnabledForExternalChannels(Boolean isEnabledForExternalChannels) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsEnabledForExternalChannels");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isEnabledForExternalChannels = isEnabledForExternalChannels;
        return _x;
    }

    @Property(name="IsPrivate")
    @JsonIgnore
    public Optional<Boolean> getIsPrivate() {
        return Optional.ofNullable(isPrivate);
    }

    public EntityMetadata withIsPrivate(Boolean isPrivate) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsPrivate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isPrivate = isPrivate;
        return _x;
    }

    @Property(name="UsesBusinessDataLabelTable")
    @JsonIgnore
    public Optional<Boolean> getUsesBusinessDataLabelTable() {
        return Optional.ofNullable(usesBusinessDataLabelTable);
    }

    public EntityMetadata withUsesBusinessDataLabelTable(Boolean usesBusinessDataLabelTable) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("UsesBusinessDataLabelTable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.usesBusinessDataLabelTable = usesBusinessDataLabelTable;
        return _x;
    }

    @Property(name="IsLogicalEntity")
    @JsonIgnore
    public Optional<Boolean> getIsLogicalEntity() {
        return Optional.ofNullable(isLogicalEntity);
    }

    public EntityMetadata withIsLogicalEntity(Boolean isLogicalEntity) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsLogicalEntity");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isLogicalEntity = isLogicalEntity;
        return _x;
    }

    @Property(name="HasNotes")
    @JsonIgnore
    public Optional<Boolean> getHasNotes() {
        return Optional.ofNullable(hasNotes);
    }

    public EntityMetadata withHasNotes(Boolean hasNotes) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("HasNotes");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.hasNotes = hasNotes;
        return _x;
    }

    @Property(name="HasActivities")
    @JsonIgnore
    public Optional<Boolean> getHasActivities() {
        return Optional.ofNullable(hasActivities);
    }

    public EntityMetadata withHasActivities(Boolean hasActivities) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("HasActivities");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.hasActivities = hasActivities;
        return _x;
    }

    @Property(name="HasFeedback")
    @JsonIgnore
    public Optional<Boolean> getHasFeedback() {
        return Optional.ofNullable(hasFeedback);
    }

    public EntityMetadata withHasFeedback(Boolean hasFeedback) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("HasFeedback");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.hasFeedback = hasFeedback;
        return _x;
    }

    @Property(name="IsSolutionAware")
    @JsonIgnore
    public Optional<Boolean> getIsSolutionAware() {
        return Optional.ofNullable(isSolutionAware);
    }

    public EntityMetadata withIsSolutionAware(Boolean isSolutionAware) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsSolutionAware");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.isSolutionAware = isSolutionAware;
        return _x;
    }

    @Property(name="Settings")
    @JsonIgnore
    public CollectionPage<EntitySetting> getSettings() {
        return new CollectionPage<EntitySetting>(contextPath, EntitySetting.class, this.settings, Optional.ofNullable(settingsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public EntityMetadata withSettings(List<EntitySetting> settings) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("Settings");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.settings = settings;
        return _x;
    }

    @Property(name="Settings")
    @JsonIgnore
    public CollectionPage<EntitySetting> getSettings(HttpRequestOptions options) {
        return new CollectionPage<EntitySetting>(contextPath, EntitySetting.class, this.settings, Optional.ofNullable(settingsNextLink), Collections.emptyList(), options);
    }

    @Property(name="CreatedOn")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedOn() {
        return Optional.ofNullable(createdOn);
    }

    public EntityMetadata withCreatedOn(OffsetDateTime createdOn) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("CreatedOn");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.createdOn = createdOn;
        return _x;
    }

    @Property(name="ModifiedOn")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedOn() {
        return Optional.ofNullable(modifiedOn);
    }

    public EntityMetadata withModifiedOn(OffsetDateTime modifiedOn) {
        EntityMetadata _x = _copy();
        _x.changedFields = changedFields.add("ModifiedOn");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityMetadata");
        _x.modifiedOn = modifiedOn;
        return _x;
    }

    public EntityMetadata withUnmappedField(String name, String value) {
        EntityMetadata _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="Attributes")
    @JsonIgnore
    public AttributeMetadataCollectionRequest getAttributes() {
        return new AttributeMetadataCollectionRequest(
                        contextPath.addSegment("Attributes"), RequestHelper.getValue(unmappedFields, "Attributes"));
    }

    @NavigationProperty(name="ManyToManyRelationships2")
    @JsonIgnore
    public ManyToManyRelationshipMetadataCollectionRequest getManyToManyRelationships2() {
        return new ManyToManyRelationshipMetadataCollectionRequest(
                        contextPath.addSegment("ManyToManyRelationships2"), RequestHelper.getValue(unmappedFields, "ManyToManyRelationships2"));
    }

    @NavigationProperty(name="ManyToOneRelationships2")
    @JsonIgnore
    public OneToManyRelationshipMetadataCollectionRequest getManyToOneRelationships2() {
        return new OneToManyRelationshipMetadataCollectionRequest(
                        contextPath.addSegment("ManyToOneRelationships2"), RequestHelper.getValue(unmappedFields, "ManyToOneRelationships2"));
    }

    @NavigationProperty(name="OneToManyRelationships2")
    @JsonIgnore
    public OneToManyRelationshipMetadataCollectionRequest getOneToManyRelationships2() {
        return new OneToManyRelationshipMetadataCollectionRequest(
                        contextPath.addSegment("OneToManyRelationships2"), RequestHelper.getValue(unmappedFields, "OneToManyRelationships2"));
    }

    @NavigationProperty(name="Keys")
    @JsonIgnore
    public EntityKeyMetadataCollectionRequest getKeys() {
        return new EntityKeyMetadataCollectionRequest(
                        contextPath.addSegment("Keys"), RequestHelper.getValue(unmappedFields, "Keys"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EntityMetadata patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EntityMetadata _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EntityMetadata put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EntityMetadata _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EntityMetadata _copy() {
        EntityMetadata _x = new EntityMetadata();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.metadataId = metadataId;
        _x.hasChanged = hasChanged;
        _x.activityTypeMask = activityTypeMask;
        _x.autoRouteToOwnerQueue = autoRouteToOwnerQueue;
        _x.canTriggerWorkflow = canTriggerWorkflow;
        _x.description = description;
        _x.displayCollectionName = displayCollectionName;
        _x.displayName = displayName;
        _x.entityHelpUrlEnabled = entityHelpUrlEnabled;
        _x.entityHelpUrl = entityHelpUrl;
        _x.isDocumentManagementEnabled = isDocumentManagementEnabled;
        _x.isOneNoteIntegrationEnabled = isOneNoteIntegrationEnabled;
        _x.isInteractionCentricEnabled = isInteractionCentricEnabled;
        _x.isKnowledgeManagementEnabled = isKnowledgeManagementEnabled;
        _x.isSLAEnabled = isSLAEnabled;
        _x.isBPFEntity = isBPFEntity;
        _x.isDocumentRecommendationsEnabled = isDocumentRecommendationsEnabled;
        _x.isMSTeamsIntegrationEnabled = isMSTeamsIntegrationEnabled;
        _x.settingOf = settingOf;
        _x.dataProviderId = dataProviderId;
        _x.dataSourceId = dataSourceId;
        _x.autoCreateAccessTeams = autoCreateAccessTeams;
        _x.isActivity = isActivity;
        _x.isActivityParty = isActivityParty;
        _x.isAuditEnabled = isAuditEnabled;
        _x.isAvailableOffline = isAvailableOffline;
        _x.isChildEntity = isChildEntity;
        _x.isAIRUpdated = isAIRUpdated;
        _x.isValidForQueue = isValidForQueue;
        _x.isConnectionsEnabled = isConnectionsEnabled;
        _x.iconLargeName = iconLargeName;
        _x.iconMediumName = iconMediumName;
        _x.iconSmallName = iconSmallName;
        _x.iconVectorName = iconVectorName;
        _x.isCustomEntity = isCustomEntity;
        _x.isBusinessProcessEnabled = isBusinessProcessEnabled;
        _x.isCustomizable = isCustomizable;
        _x.isRenameable = isRenameable;
        _x.isMappable = isMappable;
        _x.isDuplicateDetectionEnabled = isDuplicateDetectionEnabled;
        _x.canCreateAttributes = canCreateAttributes;
        _x.canCreateForms = canCreateForms;
        _x.canCreateViews = canCreateViews;
        _x.canCreateCharts = canCreateCharts;
        _x.canBeRelatedEntityInRelationship = canBeRelatedEntityInRelationship;
        _x.canBePrimaryEntityInRelationship = canBePrimaryEntityInRelationship;
        _x.canBeInManyToMany = canBeInManyToMany;
        _x.canBeInCustomEntityAssociation = canBeInCustomEntityAssociation;
        _x.canEnableSyncToExternalSearchIndex = canEnableSyncToExternalSearchIndex;
        _x.syncToExternalSearchIndex = syncToExternalSearchIndex;
        _x.canModifyAdditionalSettings = canModifyAdditionalSettings;
        _x.canChangeHierarchicalRelationship = canChangeHierarchicalRelationship;
        _x.isOptimisticConcurrencyEnabled = isOptimisticConcurrencyEnabled;
        _x.changeTrackingEnabled = changeTrackingEnabled;
        _x.canChangeTrackingBeEnabled = canChangeTrackingBeEnabled;
        _x.isImportable = isImportable;
        _x.isIntersect = isIntersect;
        _x.isMailMergeEnabled = isMailMergeEnabled;
        _x.isManaged = isManaged;
        _x.isEnabledForCharts = isEnabledForCharts;
        _x.isEnabledForTrace = isEnabledForTrace;
        _x.isValidForAdvancedFind = isValidForAdvancedFind;
        _x.isVisibleInMobile = isVisibleInMobile;
        _x.isVisibleInMobileClient = isVisibleInMobileClient;
        _x.isReadOnlyInMobileClient = isReadOnlyInMobileClient;
        _x.isOfflineInMobileClient = isOfflineInMobileClient;
        _x.daysSinceRecordLastModified = daysSinceRecordLastModified;
        _x.mobileOfflineFilters = mobileOfflineFilters;
        _x.isReadingPaneEnabled = isReadingPaneEnabled;
        _x.isQuickCreateEnabled = isQuickCreateEnabled;
        _x.logicalName = logicalName;
        _x.objectTypeCode = objectTypeCode;
        _x.ownershipType = ownershipType;
        _x.primaryNameAttribute = primaryNameAttribute;
        _x.primaryImageAttribute = primaryImageAttribute;
        _x.primaryIdAttribute = primaryIdAttribute;
        _x.privileges = privileges;
        _x.recurrenceBaseEntityLogicalName = recurrenceBaseEntityLogicalName;
        _x.reportViewName = reportViewName;
        _x.schemaName = schemaName;
        _x.introducedVersion = introducedVersion;
        _x.isStateModelAware = isStateModelAware;
        _x.enforceStateTransitions = enforceStateTransitions;
        _x.externalName = externalName;
        _x.entityColor = entityColor;
        _x.logicalCollectionName = logicalCollectionName;
        _x.externalCollectionName = externalCollectionName;
        _x.collectionSchemaName = collectionSchemaName;
        _x.entitySetName = entitySetName;
        _x.isEnabledForExternalChannels = isEnabledForExternalChannels;
        _x.isPrivate = isPrivate;
        _x.usesBusinessDataLabelTable = usesBusinessDataLabelTable;
        _x.isLogicalEntity = isLogicalEntity;
        _x.hasNotes = hasNotes;
        _x.hasActivities = hasActivities;
        _x.hasFeedback = hasFeedback;
        _x.isSolutionAware = isSolutionAware;
        _x.settings = settings;
        _x.createdOn = createdOn;
        _x.modifiedOn = modifiedOn;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EntityMetadata[");
        b.append("MetadataId=");
        b.append(this.metadataId);
        b.append(", ");
        b.append("HasChanged=");
        b.append(this.hasChanged);
        b.append(", ");
        b.append("ActivityTypeMask=");
        b.append(this.activityTypeMask);
        b.append(", ");
        b.append("AutoRouteToOwnerQueue=");
        b.append(this.autoRouteToOwnerQueue);
        b.append(", ");
        b.append("CanTriggerWorkflow=");
        b.append(this.canTriggerWorkflow);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("DisplayCollectionName=");
        b.append(this.displayCollectionName);
        b.append(", ");
        b.append("DisplayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("EntityHelpUrlEnabled=");
        b.append(this.entityHelpUrlEnabled);
        b.append(", ");
        b.append("EntityHelpUrl=");
        b.append(this.entityHelpUrl);
        b.append(", ");
        b.append("IsDocumentManagementEnabled=");
        b.append(this.isDocumentManagementEnabled);
        b.append(", ");
        b.append("IsOneNoteIntegrationEnabled=");
        b.append(this.isOneNoteIntegrationEnabled);
        b.append(", ");
        b.append("IsInteractionCentricEnabled=");
        b.append(this.isInteractionCentricEnabled);
        b.append(", ");
        b.append("IsKnowledgeManagementEnabled=");
        b.append(this.isKnowledgeManagementEnabled);
        b.append(", ");
        b.append("IsSLAEnabled=");
        b.append(this.isSLAEnabled);
        b.append(", ");
        b.append("IsBPFEntity=");
        b.append(this.isBPFEntity);
        b.append(", ");
        b.append("IsDocumentRecommendationsEnabled=");
        b.append(this.isDocumentRecommendationsEnabled);
        b.append(", ");
        b.append("IsMSTeamsIntegrationEnabled=");
        b.append(this.isMSTeamsIntegrationEnabled);
        b.append(", ");
        b.append("SettingOf=");
        b.append(this.settingOf);
        b.append(", ");
        b.append("DataProviderId=");
        b.append(this.dataProviderId);
        b.append(", ");
        b.append("DataSourceId=");
        b.append(this.dataSourceId);
        b.append(", ");
        b.append("AutoCreateAccessTeams=");
        b.append(this.autoCreateAccessTeams);
        b.append(", ");
        b.append("IsActivity=");
        b.append(this.isActivity);
        b.append(", ");
        b.append("IsActivityParty=");
        b.append(this.isActivityParty);
        b.append(", ");
        b.append("IsAuditEnabled=");
        b.append(this.isAuditEnabled);
        b.append(", ");
        b.append("IsAvailableOffline=");
        b.append(this.isAvailableOffline);
        b.append(", ");
        b.append("IsChildEntity=");
        b.append(this.isChildEntity);
        b.append(", ");
        b.append("IsAIRUpdated=");
        b.append(this.isAIRUpdated);
        b.append(", ");
        b.append("IsValidForQueue=");
        b.append(this.isValidForQueue);
        b.append(", ");
        b.append("IsConnectionsEnabled=");
        b.append(this.isConnectionsEnabled);
        b.append(", ");
        b.append("IconLargeName=");
        b.append(this.iconLargeName);
        b.append(", ");
        b.append("IconMediumName=");
        b.append(this.iconMediumName);
        b.append(", ");
        b.append("IconSmallName=");
        b.append(this.iconSmallName);
        b.append(", ");
        b.append("IconVectorName=");
        b.append(this.iconVectorName);
        b.append(", ");
        b.append("IsCustomEntity=");
        b.append(this.isCustomEntity);
        b.append(", ");
        b.append("IsBusinessProcessEnabled=");
        b.append(this.isBusinessProcessEnabled);
        b.append(", ");
        b.append("IsCustomizable=");
        b.append(this.isCustomizable);
        b.append(", ");
        b.append("IsRenameable=");
        b.append(this.isRenameable);
        b.append(", ");
        b.append("IsMappable=");
        b.append(this.isMappable);
        b.append(", ");
        b.append("IsDuplicateDetectionEnabled=");
        b.append(this.isDuplicateDetectionEnabled);
        b.append(", ");
        b.append("CanCreateAttributes=");
        b.append(this.canCreateAttributes);
        b.append(", ");
        b.append("CanCreateForms=");
        b.append(this.canCreateForms);
        b.append(", ");
        b.append("CanCreateViews=");
        b.append(this.canCreateViews);
        b.append(", ");
        b.append("CanCreateCharts=");
        b.append(this.canCreateCharts);
        b.append(", ");
        b.append("CanBeRelatedEntityInRelationship=");
        b.append(this.canBeRelatedEntityInRelationship);
        b.append(", ");
        b.append("CanBePrimaryEntityInRelationship=");
        b.append(this.canBePrimaryEntityInRelationship);
        b.append(", ");
        b.append("CanBeInManyToMany=");
        b.append(this.canBeInManyToMany);
        b.append(", ");
        b.append("CanBeInCustomEntityAssociation=");
        b.append(this.canBeInCustomEntityAssociation);
        b.append(", ");
        b.append("CanEnableSyncToExternalSearchIndex=");
        b.append(this.canEnableSyncToExternalSearchIndex);
        b.append(", ");
        b.append("SyncToExternalSearchIndex=");
        b.append(this.syncToExternalSearchIndex);
        b.append(", ");
        b.append("CanModifyAdditionalSettings=");
        b.append(this.canModifyAdditionalSettings);
        b.append(", ");
        b.append("CanChangeHierarchicalRelationship=");
        b.append(this.canChangeHierarchicalRelationship);
        b.append(", ");
        b.append("IsOptimisticConcurrencyEnabled=");
        b.append(this.isOptimisticConcurrencyEnabled);
        b.append(", ");
        b.append("ChangeTrackingEnabled=");
        b.append(this.changeTrackingEnabled);
        b.append(", ");
        b.append("CanChangeTrackingBeEnabled=");
        b.append(this.canChangeTrackingBeEnabled);
        b.append(", ");
        b.append("IsImportable=");
        b.append(this.isImportable);
        b.append(", ");
        b.append("IsIntersect=");
        b.append(this.isIntersect);
        b.append(", ");
        b.append("IsMailMergeEnabled=");
        b.append(this.isMailMergeEnabled);
        b.append(", ");
        b.append("IsManaged=");
        b.append(this.isManaged);
        b.append(", ");
        b.append("IsEnabledForCharts=");
        b.append(this.isEnabledForCharts);
        b.append(", ");
        b.append("IsEnabledForTrace=");
        b.append(this.isEnabledForTrace);
        b.append(", ");
        b.append("IsValidForAdvancedFind=");
        b.append(this.isValidForAdvancedFind);
        b.append(", ");
        b.append("IsVisibleInMobile=");
        b.append(this.isVisibleInMobile);
        b.append(", ");
        b.append("IsVisibleInMobileClient=");
        b.append(this.isVisibleInMobileClient);
        b.append(", ");
        b.append("IsReadOnlyInMobileClient=");
        b.append(this.isReadOnlyInMobileClient);
        b.append(", ");
        b.append("IsOfflineInMobileClient=");
        b.append(this.isOfflineInMobileClient);
        b.append(", ");
        b.append("DaysSinceRecordLastModified=");
        b.append(this.daysSinceRecordLastModified);
        b.append(", ");
        b.append("MobileOfflineFilters=");
        b.append(this.mobileOfflineFilters);
        b.append(", ");
        b.append("IsReadingPaneEnabled=");
        b.append(this.isReadingPaneEnabled);
        b.append(", ");
        b.append("IsQuickCreateEnabled=");
        b.append(this.isQuickCreateEnabled);
        b.append(", ");
        b.append("LogicalName=");
        b.append(this.logicalName);
        b.append(", ");
        b.append("ObjectTypeCode=");
        b.append(this.objectTypeCode);
        b.append(", ");
        b.append("OwnershipType=");
        b.append(this.ownershipType);
        b.append(", ");
        b.append("PrimaryNameAttribute=");
        b.append(this.primaryNameAttribute);
        b.append(", ");
        b.append("PrimaryImageAttribute=");
        b.append(this.primaryImageAttribute);
        b.append(", ");
        b.append("PrimaryIdAttribute=");
        b.append(this.primaryIdAttribute);
        b.append(", ");
        b.append("Privileges=");
        b.append(this.privileges);
        b.append(", ");
        b.append("RecurrenceBaseEntityLogicalName=");
        b.append(this.recurrenceBaseEntityLogicalName);
        b.append(", ");
        b.append("ReportViewName=");
        b.append(this.reportViewName);
        b.append(", ");
        b.append("SchemaName=");
        b.append(this.schemaName);
        b.append(", ");
        b.append("IntroducedVersion=");
        b.append(this.introducedVersion);
        b.append(", ");
        b.append("IsStateModelAware=");
        b.append(this.isStateModelAware);
        b.append(", ");
        b.append("EnforceStateTransitions=");
        b.append(this.enforceStateTransitions);
        b.append(", ");
        b.append("ExternalName=");
        b.append(this.externalName);
        b.append(", ");
        b.append("EntityColor=");
        b.append(this.entityColor);
        b.append(", ");
        b.append("LogicalCollectionName=");
        b.append(this.logicalCollectionName);
        b.append(", ");
        b.append("ExternalCollectionName=");
        b.append(this.externalCollectionName);
        b.append(", ");
        b.append("CollectionSchemaName=");
        b.append(this.collectionSchemaName);
        b.append(", ");
        b.append("EntitySetName=");
        b.append(this.entitySetName);
        b.append(", ");
        b.append("IsEnabledForExternalChannels=");
        b.append(this.isEnabledForExternalChannels);
        b.append(", ");
        b.append("IsPrivate=");
        b.append(this.isPrivate);
        b.append(", ");
        b.append("UsesBusinessDataLabelTable=");
        b.append(this.usesBusinessDataLabelTable);
        b.append(", ");
        b.append("IsLogicalEntity=");
        b.append(this.isLogicalEntity);
        b.append(", ");
        b.append("HasNotes=");
        b.append(this.hasNotes);
        b.append(", ");
        b.append("HasActivities=");
        b.append(this.hasActivities);
        b.append(", ");
        b.append("HasFeedback=");
        b.append(this.hasFeedback);
        b.append(", ");
        b.append("IsSolutionAware=");
        b.append(this.isSolutionAware);
        b.append(", ");
        b.append("Settings=");
        b.append(this.settings);
        b.append(", ");
        b.append("CreatedOn=");
        b.append(this.createdOn);
        b.append(", ");
        b.append("ModifiedOn=");
        b.append(this.modifiedOn);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
