package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DatalakeworkspacepermissionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "componentstate", 
    "whitelistedappid", 
    "versionnumber", 
    "_createdby_value", 
    "tenantid", 
    "utcconversiontimezonecode", 
    "statuscode", 
    "iscustomercapacity", 
    "overwritetime", 
    "path", 
    "isprivate", 
    "name", 
    "componentidunique", 
    "ismanaged", 
    "overriddencreatedon", 
    "containerendpoint", 
    "owningappid", 
    "_createdonbehalfby_value", 
    "datalakeworkspace_uniquename", 
    "timezoneruleversionnumber", 
    "importsequencenumber", 
    "_modifiedby_value", 
    "createdon", 
    "modifiedon", 
    "_modifiedonbehalfby_value", 
    "_organizationid_value", 
    "statecode", 
    "isdeepcopyenabled", 
    "iscustomizable", 
    "solutionid", 
    "datalakeworkspaceid"})
@JsonInclude(Include.NON_NULL)
public class Datalakeworkspace extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.datalakeworkspace";
    }

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("whitelistedappid")
    protected String whitelistedappid;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("tenantid")
    protected String tenantid;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("iscustomercapacity")
    protected Boolean iscustomercapacity;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("path")
    protected String path;

    @JsonProperty("isprivate")
    protected Boolean isprivate;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("componentidunique")
    protected String componentidunique;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("containerendpoint")
    protected String containerendpoint;

    @JsonProperty("owningappid")
    protected String owningappid;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("datalakeworkspace_uniquename")
    protected String datalakeworkspace_uniquename;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("isdeepcopyenabled")
    protected Boolean isdeepcopyenabled;

    @JsonProperty("iscustomizable")
    protected BooleanManagedProperty iscustomizable;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("datalakeworkspaceid")
    protected String datalakeworkspaceid;

    protected Datalakeworkspace() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDatalakeworkspace() {
        return new Builder();
    }

    public static final class Builder {
        private Integer componentstate;
        private String whitelistedappid;
        private Long versionnumber;
        private String _createdby_value;
        private String tenantid;
        private Integer utcconversiontimezonecode;
        private Integer statuscode;
        private Boolean iscustomercapacity;
        private OffsetDateTime overwritetime;
        private String path;
        private Boolean isprivate;
        private String name;
        private String componentidunique;
        private Boolean ismanaged;
        private OffsetDateTime overriddencreatedon;
        private String containerendpoint;
        private String owningappid;
        private String _createdonbehalfby_value;
        private String datalakeworkspace_uniquename;
        private Integer timezoneruleversionnumber;
        private Integer importsequencenumber;
        private String _modifiedby_value;
        private OffsetDateTime createdon;
        private OffsetDateTime modifiedon;
        private String _modifiedonbehalfby_value;
        private String _organizationid_value;
        private Integer statecode;
        private Boolean isdeepcopyenabled;
        private BooleanManagedProperty iscustomizable;
        private String solutionid;
        private String datalakeworkspaceid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder whitelistedappid(String whitelistedappid) {
            this.whitelistedappid = whitelistedappid;
            this.changedFields = changedFields.add("whitelistedappid");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder tenantid(String tenantid) {
            this.tenantid = tenantid;
            this.changedFields = changedFields.add("tenantid");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder iscustomercapacity(Boolean iscustomercapacity) {
            this.iscustomercapacity = iscustomercapacity;
            this.changedFields = changedFields.add("iscustomercapacity");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            this.changedFields = changedFields.add("path");
            return this;
        }

        public Builder isprivate(Boolean isprivate) {
            this.isprivate = isprivate;
            this.changedFields = changedFields.add("isprivate");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder componentidunique(String componentidunique) {
            this.componentidunique = componentidunique;
            this.changedFields = changedFields.add("componentidunique");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder containerendpoint(String containerendpoint) {
            this.containerendpoint = containerendpoint;
            this.changedFields = changedFields.add("containerendpoint");
            return this;
        }

        public Builder owningappid(String owningappid) {
            this.owningappid = owningappid;
            this.changedFields = changedFields.add("owningappid");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder datalakeworkspace_uniquename(String datalakeworkspace_uniquename) {
            this.datalakeworkspace_uniquename = datalakeworkspace_uniquename;
            this.changedFields = changedFields.add("datalakeworkspace_uniquename");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder isdeepcopyenabled(Boolean isdeepcopyenabled) {
            this.isdeepcopyenabled = isdeepcopyenabled;
            this.changedFields = changedFields.add("isdeepcopyenabled");
            return this;
        }

        public Builder iscustomizable(BooleanManagedProperty iscustomizable) {
            this.iscustomizable = iscustomizable;
            this.changedFields = changedFields.add("iscustomizable");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder datalakeworkspaceid(String datalakeworkspaceid) {
            this.datalakeworkspaceid = datalakeworkspaceid;
            this.changedFields = changedFields.add("datalakeworkspaceid");
            return this;
        }

        public Datalakeworkspace build() {
            Datalakeworkspace _x = new Datalakeworkspace();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.datalakeworkspace";
            _x.componentstate = componentstate;
            _x.whitelistedappid = whitelistedappid;
            _x.versionnumber = versionnumber;
            _x._createdby_value = _createdby_value;
            _x.tenantid = tenantid;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.statuscode = statuscode;
            _x.iscustomercapacity = iscustomercapacity;
            _x.overwritetime = overwritetime;
            _x.path = path;
            _x.isprivate = isprivate;
            _x.name = name;
            _x.componentidunique = componentidunique;
            _x.ismanaged = ismanaged;
            _x.overriddencreatedon = overriddencreatedon;
            _x.containerendpoint = containerendpoint;
            _x.owningappid = owningappid;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.datalakeworkspace_uniquename = datalakeworkspace_uniquename;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.importsequencenumber = importsequencenumber;
            _x._modifiedby_value = _modifiedby_value;
            _x.createdon = createdon;
            _x.modifiedon = modifiedon;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._organizationid_value = _organizationid_value;
            _x.statecode = statecode;
            _x.isdeepcopyenabled = isdeepcopyenabled;
            _x.iscustomizable = iscustomizable;
            _x.solutionid = solutionid;
            _x.datalakeworkspaceid = datalakeworkspaceid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && datalakeworkspaceid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(datalakeworkspaceid.toString()));
        }
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Datalakeworkspace withComponentstate(Integer componentstate) {
        Datalakeworkspace _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspace");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="whitelistedappid")
    @JsonIgnore
    public Optional<String> getWhitelistedappid() {
        return Optional.ofNullable(whitelistedappid);
    }

    public Datalakeworkspace withWhitelistedappid(String whitelistedappid) {
        Datalakeworkspace _x = _copy();
        _x.changedFields = changedFields.add("whitelistedappid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspace");
        _x.whitelistedappid = whitelistedappid;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Datalakeworkspace withVersionnumber(Long versionnumber) {
        Datalakeworkspace _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspace");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Datalakeworkspace with_createdby_value(String _createdby_value) {
        Datalakeworkspace _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspace");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="tenantid")
    @JsonIgnore
    public Optional<String> getTenantid() {
        return Optional.ofNullable(tenantid);
    }

    public Datalakeworkspace withTenantid(String tenantid) {
        Datalakeworkspace _x = _copy();
        _x.changedFields = changedFields.add("tenantid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspace");
        _x.tenantid = tenantid;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Datalakeworkspace withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Datalakeworkspace _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspace");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Datalakeworkspace withStatuscode(Integer statuscode) {
        Datalakeworkspace _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspace");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="iscustomercapacity")
    @JsonIgnore
    public Optional<Boolean> getIscustomercapacity() {
        return Optional.ofNullable(iscustomercapacity);
    }

    public Datalakeworkspace withIscustomercapacity(Boolean iscustomercapacity) {
        Datalakeworkspace _x = _copy();
        _x.changedFields = changedFields.add("iscustomercapacity");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspace");
        _x.iscustomercapacity = iscustomercapacity;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Datalakeworkspace withOverwritetime(OffsetDateTime overwritetime) {
        Datalakeworkspace _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspace");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="path")
    @JsonIgnore
    public Optional<String> getPath() {
        return Optional.ofNullable(path);
    }

    public Datalakeworkspace withPath(String path) {
        Checks.checkIsAscii(path);
        Datalakeworkspace _x = _copy();
        _x.changedFields = changedFields.add("path");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspace");
        _x.path = path;
        return _x;
    }

    @Property(name="isprivate")
    @JsonIgnore
    public Optional<Boolean> getIsprivate() {
        return Optional.ofNullable(isprivate);
    }

    public Datalakeworkspace withIsprivate(Boolean isprivate) {
        Datalakeworkspace _x = _copy();
        _x.changedFields = changedFields.add("isprivate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspace");
        _x.isprivate = isprivate;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Datalakeworkspace withName(String name) {
        Checks.checkIsAscii(name);
        Datalakeworkspace _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspace");
        _x.name = name;
        return _x;
    }

    @Property(name="componentidunique")
    @JsonIgnore
    public Optional<String> getComponentidunique() {
        return Optional.ofNullable(componentidunique);
    }

    public Datalakeworkspace withComponentidunique(String componentidunique) {
        Datalakeworkspace _x = _copy();
        _x.changedFields = changedFields.add("componentidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspace");
        _x.componentidunique = componentidunique;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Datalakeworkspace withIsmanaged(Boolean ismanaged) {
        Datalakeworkspace _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspace");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Datalakeworkspace withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Datalakeworkspace _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspace");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="containerendpoint")
    @JsonIgnore
    public Optional<String> getContainerendpoint() {
        return Optional.ofNullable(containerendpoint);
    }

    public Datalakeworkspace withContainerendpoint(String containerendpoint) {
        Checks.checkIsAscii(containerendpoint);
        Datalakeworkspace _x = _copy();
        _x.changedFields = changedFields.add("containerendpoint");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspace");
        _x.containerendpoint = containerendpoint;
        return _x;
    }

    @Property(name="owningappid")
    @JsonIgnore
    public Optional<String> getOwningappid() {
        return Optional.ofNullable(owningappid);
    }

    public Datalakeworkspace withOwningappid(String owningappid) {
        Datalakeworkspace _x = _copy();
        _x.changedFields = changedFields.add("owningappid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspace");
        _x.owningappid = owningappid;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Datalakeworkspace with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Datalakeworkspace _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspace");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="datalakeworkspace_uniquename")
    @JsonIgnore
    public Optional<String> getDatalakeworkspace_uniquename() {
        return Optional.ofNullable(datalakeworkspace_uniquename);
    }

    public Datalakeworkspace withDatalakeworkspace_uniquename(String datalakeworkspace_uniquename) {
        Checks.checkIsAscii(datalakeworkspace_uniquename);
        Datalakeworkspace _x = _copy();
        _x.changedFields = changedFields.add("datalakeworkspace_uniquename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspace");
        _x.datalakeworkspace_uniquename = datalakeworkspace_uniquename;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Datalakeworkspace withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Datalakeworkspace _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspace");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Datalakeworkspace withImportsequencenumber(Integer importsequencenumber) {
        Datalakeworkspace _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspace");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Datalakeworkspace with_modifiedby_value(String _modifiedby_value) {
        Datalakeworkspace _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspace");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Datalakeworkspace withCreatedon(OffsetDateTime createdon) {
        Datalakeworkspace _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspace");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Datalakeworkspace withModifiedon(OffsetDateTime modifiedon) {
        Datalakeworkspace _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspace");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Datalakeworkspace with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Datalakeworkspace _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspace");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Datalakeworkspace with_organizationid_value(String _organizationid_value) {
        Datalakeworkspace _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspace");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Datalakeworkspace withStatecode(Integer statecode) {
        Datalakeworkspace _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspace");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="isdeepcopyenabled")
    @JsonIgnore
    public Optional<Boolean> getIsdeepcopyenabled() {
        return Optional.ofNullable(isdeepcopyenabled);
    }

    public Datalakeworkspace withIsdeepcopyenabled(Boolean isdeepcopyenabled) {
        Datalakeworkspace _x = _copy();
        _x.changedFields = changedFields.add("isdeepcopyenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspace");
        _x.isdeepcopyenabled = isdeepcopyenabled;
        return _x;
    }

    @Property(name="iscustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIscustomizable() {
        return Optional.ofNullable(iscustomizable);
    }

    public Datalakeworkspace withIscustomizable(BooleanManagedProperty iscustomizable) {
        Datalakeworkspace _x = _copy();
        _x.changedFields = changedFields.add("iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspace");
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Datalakeworkspace withSolutionid(String solutionid) {
        Datalakeworkspace _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspace");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="datalakeworkspaceid")
    @JsonIgnore
    public Optional<String> getDatalakeworkspaceid() {
        return Optional.ofNullable(datalakeworkspaceid);
    }

    public Datalakeworkspace withDatalakeworkspaceid(String datalakeworkspaceid) {
        Datalakeworkspace _x = _copy();
        _x.changedFields = changedFields.add("datalakeworkspaceid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.datalakeworkspace");
        _x.datalakeworkspaceid = datalakeworkspaceid;
        return _x;
    }

    public Datalakeworkspace withUnmappedField(String name, String value) {
        Datalakeworkspace _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="datalakeworkspace_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getDatalakeworkspace_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("datalakeworkspace_SyncErrors"), RequestHelper.getValue(unmappedFields, "datalakeworkspace_SyncErrors"));
    }

    @NavigationProperty(name="datalakeworkspace_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getDatalakeworkspace_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("datalakeworkspace_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "datalakeworkspace_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="datalakeworkspace_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getDatalakeworkspace_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("datalakeworkspace_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "datalakeworkspace_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="datalakeworkspace_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getDatalakeworkspace_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("datalakeworkspace_AsyncOperations"), RequestHelper.getValue(unmappedFields, "datalakeworkspace_AsyncOperations"));
    }

    @NavigationProperty(name="datalakeworkspace_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getDatalakeworkspace_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("datalakeworkspace_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "datalakeworkspace_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="datalakeworkspace_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getDatalakeworkspace_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("datalakeworkspace_ProcessSession"), RequestHelper.getValue(unmappedFields, "datalakeworkspace_ProcessSession"));
    }

    @NavigationProperty(name="datalakeworkspace_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getDatalakeworkspace_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("datalakeworkspace_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "datalakeworkspace_BulkDeleteFailures"));
    }

    @NavigationProperty(name="datalakeworkspace_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getDatalakeworkspace_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("datalakeworkspace_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "datalakeworkspace_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="datalakeworkspace_workspacepermission")
    @JsonIgnore
    public DatalakeworkspacepermissionCollectionRequest getDatalakeworkspace_workspacepermission() {
        return new DatalakeworkspacepermissionCollectionRequest(
                        contextPath.addSegment("datalakeworkspace_workspacepermission"), RequestHelper.getValue(unmappedFields, "datalakeworkspace_workspacepermission"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Datalakeworkspace patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Datalakeworkspace _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Datalakeworkspace put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Datalakeworkspace _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Datalakeworkspace _copy() {
        Datalakeworkspace _x = new Datalakeworkspace();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.componentstate = componentstate;
        _x.whitelistedappid = whitelistedappid;
        _x.versionnumber = versionnumber;
        _x._createdby_value = _createdby_value;
        _x.tenantid = tenantid;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.statuscode = statuscode;
        _x.iscustomercapacity = iscustomercapacity;
        _x.overwritetime = overwritetime;
        _x.path = path;
        _x.isprivate = isprivate;
        _x.name = name;
        _x.componentidunique = componentidunique;
        _x.ismanaged = ismanaged;
        _x.overriddencreatedon = overriddencreatedon;
        _x.containerendpoint = containerendpoint;
        _x.owningappid = owningappid;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.datalakeworkspace_uniquename = datalakeworkspace_uniquename;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.importsequencenumber = importsequencenumber;
        _x._modifiedby_value = _modifiedby_value;
        _x.createdon = createdon;
        _x.modifiedon = modifiedon;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._organizationid_value = _organizationid_value;
        _x.statecode = statecode;
        _x.isdeepcopyenabled = isdeepcopyenabled;
        _x.iscustomizable = iscustomizable;
        _x.solutionid = solutionid;
        _x.datalakeworkspaceid = datalakeworkspaceid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Datalakeworkspace[");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("whitelistedappid=");
        b.append(this.whitelistedappid);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("tenantid=");
        b.append(this.tenantid);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("iscustomercapacity=");
        b.append(this.iscustomercapacity);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("path=");
        b.append(this.path);
        b.append(", ");
        b.append("isprivate=");
        b.append(this.isprivate);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("componentidunique=");
        b.append(this.componentidunique);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("containerendpoint=");
        b.append(this.containerendpoint);
        b.append(", ");
        b.append("owningappid=");
        b.append(this.owningappid);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("datalakeworkspace_uniquename=");
        b.append(this.datalakeworkspace_uniquename);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("isdeepcopyenabled=");
        b.append(this.isdeepcopyenabled);
        b.append(", ");
        b.append("iscustomizable=");
        b.append(this.iscustomizable);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("datalakeworkspaceid=");
        b.append(this.datalakeworkspaceid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
