package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.complex.Label;
import microsoft.dynamics.crm.complex.OptionMetadata;
import microsoft.dynamics.crm.enums.OptionSetType;

@JsonPropertyOrder({
    "@odata.type", 
    "TrueOption", 
    "FalseOption"})
@JsonInclude(Include.NON_NULL)
public class BooleanOptionSetMetadata extends OptionSetMetadataBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.BooleanOptionSetMetadata";
    }

    @JsonProperty("TrueOption")
    protected OptionMetadata trueOption;

    @JsonProperty("FalseOption")
    protected OptionMetadata falseOption;

    protected BooleanOptionSetMetadata() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderBooleanOptionSetMetadata() {
        return new Builder();
    }

    public static final class Builder {
        private String metadataId;
        private Boolean hasChanged;
        private Label description;
        private Label displayName;
        private Boolean isCustomOptionSet;
        private Boolean isGlobal;
        private Boolean isManaged;
        private BooleanManagedProperty isCustomizable;
        private String name;
        private String externalTypeName;
        private OptionSetType optionSetType;
        private String introducedVersion;
        private OptionMetadata trueOption;
        private OptionMetadata falseOption;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder metadataId(String metadataId) {
            this.metadataId = metadataId;
            this.changedFields = changedFields.add("MetadataId");
            return this;
        }

        public Builder hasChanged(Boolean hasChanged) {
            this.hasChanged = hasChanged;
            this.changedFields = changedFields.add("HasChanged");
            return this;
        }

        public Builder description(Label description) {
            this.description = description;
            this.changedFields = changedFields.add("Description");
            return this;
        }

        public Builder displayName(Label displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("DisplayName");
            return this;
        }

        public Builder isCustomOptionSet(Boolean isCustomOptionSet) {
            this.isCustomOptionSet = isCustomOptionSet;
            this.changedFields = changedFields.add("IsCustomOptionSet");
            return this;
        }

        public Builder isGlobal(Boolean isGlobal) {
            this.isGlobal = isGlobal;
            this.changedFields = changedFields.add("IsGlobal");
            return this;
        }

        public Builder isManaged(Boolean isManaged) {
            this.isManaged = isManaged;
            this.changedFields = changedFields.add("IsManaged");
            return this;
        }

        public Builder isCustomizable(BooleanManagedProperty isCustomizable) {
            this.isCustomizable = isCustomizable;
            this.changedFields = changedFields.add("IsCustomizable");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("Name");
            return this;
        }

        public Builder externalTypeName(String externalTypeName) {
            this.externalTypeName = externalTypeName;
            this.changedFields = changedFields.add("ExternalTypeName");
            return this;
        }

        public Builder optionSetType(OptionSetType optionSetType) {
            this.optionSetType = optionSetType;
            this.changedFields = changedFields.add("OptionSetType");
            return this;
        }

        public Builder introducedVersion(String introducedVersion) {
            this.introducedVersion = introducedVersion;
            this.changedFields = changedFields.add("IntroducedVersion");
            return this;
        }

        public Builder trueOption(OptionMetadata trueOption) {
            this.trueOption = trueOption;
            this.changedFields = changedFields.add("TrueOption");
            return this;
        }

        public Builder falseOption(OptionMetadata falseOption) {
            this.falseOption = falseOption;
            this.changedFields = changedFields.add("FalseOption");
            return this;
        }

        public BooleanOptionSetMetadata build() {
            BooleanOptionSetMetadata _x = new BooleanOptionSetMetadata();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.BooleanOptionSetMetadata";
            _x.metadataId = metadataId;
            _x.hasChanged = hasChanged;
            _x.description = description;
            _x.displayName = displayName;
            _x.isCustomOptionSet = isCustomOptionSet;
            _x.isGlobal = isGlobal;
            _x.isManaged = isManaged;
            _x.isCustomizable = isCustomizable;
            _x.name = name;
            _x.externalTypeName = externalTypeName;
            _x.optionSetType = optionSetType;
            _x.introducedVersion = introducedVersion;
            _x.trueOption = trueOption;
            _x.falseOption = falseOption;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && metadataId != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(metadataId.toString()));
        }
    }

    @Property(name="TrueOption")
    @JsonIgnore
    public Optional<OptionMetadata> getTrueOption() {
        return Optional.ofNullable(trueOption);
    }

    public BooleanOptionSetMetadata withTrueOption(OptionMetadata trueOption) {
        BooleanOptionSetMetadata _x = _copy();
        _x.changedFields = changedFields.add("TrueOption");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.BooleanOptionSetMetadata");
        _x.trueOption = trueOption;
        return _x;
    }

    @Property(name="FalseOption")
    @JsonIgnore
    public Optional<OptionMetadata> getFalseOption() {
        return Optional.ofNullable(falseOption);
    }

    public BooleanOptionSetMetadata withFalseOption(OptionMetadata falseOption) {
        BooleanOptionSetMetadata _x = _copy();
        _x.changedFields = changedFields.add("FalseOption");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.BooleanOptionSetMetadata");
        _x.falseOption = falseOption;
        return _x;
    }

    public BooleanOptionSetMetadata withUnmappedField(String name, String value) {
        BooleanOptionSetMetadata _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public BooleanOptionSetMetadata patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        BooleanOptionSetMetadata _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public BooleanOptionSetMetadata put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        BooleanOptionSetMetadata _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private BooleanOptionSetMetadata _copy() {
        BooleanOptionSetMetadata _x = new BooleanOptionSetMetadata();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.metadataId = metadataId;
        _x.hasChanged = hasChanged;
        _x.description = description;
        _x.displayName = displayName;
        _x.isCustomOptionSet = isCustomOptionSet;
        _x.isGlobal = isGlobal;
        _x.isManaged = isManaged;
        _x.isCustomizable = isCustomizable;
        _x.name = name;
        _x.externalTypeName = externalTypeName;
        _x.optionSetType = optionSetType;
        _x.introducedVersion = introducedVersion;
        _x.trueOption = trueOption;
        _x.falseOption = falseOption;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BooleanOptionSetMetadata[");
        b.append("MetadataId=");
        b.append(this.metadataId);
        b.append(", ");
        b.append("HasChanged=");
        b.append(this.hasChanged);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("DisplayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("IsCustomOptionSet=");
        b.append(this.isCustomOptionSet);
        b.append(", ");
        b.append("IsGlobal=");
        b.append(this.isGlobal);
        b.append(", ");
        b.append("IsManaged=");
        b.append(this.isManaged);
        b.append(", ");
        b.append("IsCustomizable=");
        b.append(this.isCustomizable);
        b.append(", ");
        b.append("Name=");
        b.append(this.name);
        b.append(", ");
        b.append("ExternalTypeName=");
        b.append(this.externalTypeName);
        b.append(", ");
        b.append("OptionSetType=");
        b.append(this.optionSetType);
        b.append(", ");
        b.append("IntroducedVersion=");
        b.append(this.introducedVersion);
        b.append(", ");
        b.append("TrueOption=");
        b.append(this.trueOption);
        b.append(", ");
        b.append("FalseOption=");
        b.append(this.falseOption);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
