package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import microsoft.dynamics.crm.enums.RecentlyViewedRecordType;

@JsonPropertyOrder({
    "@odata.type", 
    "DisplayName", 
    "IconPath", 
    "LastAccessedStr", 
    "EntityTypeName", 
    "ObjectId", 
    "PinStatus", 
    "RecordType", 
    "IsUserView", 
    "Title", 
    "IsDeleted"})
@JsonInclude(Include.NON_NULL)
public class RecentItem implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("DisplayName")
    protected String displayName;

    @JsonProperty("IconPath")
    protected String iconPath;

    @JsonProperty("LastAccessedStr")
    protected String lastAccessedStr;

    @JsonProperty("EntityTypeName")
    protected String entityTypeName;

    @JsonProperty("ObjectId")
    protected String objectId;

    @JsonProperty("PinStatus")
    protected Boolean pinStatus;

    @JsonProperty("RecordType")
    protected RecentlyViewedRecordType recordType;

    @JsonProperty("IsUserView")
    protected Boolean isUserView;

    @JsonProperty("Title")
    protected String title;

    @JsonProperty("IsDeleted")
    protected Boolean isDeleted;

    protected RecentItem() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.RecentItem";
    }

    @Property(name="DisplayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public RecentItem withDisplayName(String displayName) {
        Checks.checkIsAscii(displayName);
        RecentItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.RecentItem");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="IconPath")
    @JsonIgnore
    public Optional<String> getIconPath() {
        return Optional.ofNullable(iconPath);
    }

    public RecentItem withIconPath(String iconPath) {
        Checks.checkIsAscii(iconPath);
        RecentItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.RecentItem");
        _x.iconPath = iconPath;
        return _x;
    }

    @Property(name="LastAccessedStr")
    @JsonIgnore
    public Optional<String> getLastAccessedStr() {
        return Optional.ofNullable(lastAccessedStr);
    }

    public RecentItem withLastAccessedStr(String lastAccessedStr) {
        Checks.checkIsAscii(lastAccessedStr);
        RecentItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.RecentItem");
        _x.lastAccessedStr = lastAccessedStr;
        return _x;
    }

    @Property(name="EntityTypeName")
    @JsonIgnore
    public Optional<String> getEntityTypeName() {
        return Optional.ofNullable(entityTypeName);
    }

    public RecentItem withEntityTypeName(String entityTypeName) {
        Checks.checkIsAscii(entityTypeName);
        RecentItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.RecentItem");
        _x.entityTypeName = entityTypeName;
        return _x;
    }

    @Property(name="ObjectId")
    @JsonIgnore
    public Optional<String> getObjectId() {
        return Optional.ofNullable(objectId);
    }

    public RecentItem withObjectId(String objectId) {
        Checks.checkIsAscii(objectId);
        RecentItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.RecentItem");
        _x.objectId = objectId;
        return _x;
    }

    @Property(name="PinStatus")
    @JsonIgnore
    public Optional<Boolean> getPinStatus() {
        return Optional.ofNullable(pinStatus);
    }

    public RecentItem withPinStatus(Boolean pinStatus) {
        RecentItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.RecentItem");
        _x.pinStatus = pinStatus;
        return _x;
    }

    @Property(name="RecordType")
    @JsonIgnore
    public Optional<RecentlyViewedRecordType> getRecordType() {
        return Optional.ofNullable(recordType);
    }

    public RecentItem withRecordType(RecentlyViewedRecordType recordType) {
        RecentItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.RecentItem");
        _x.recordType = recordType;
        return _x;
    }

    @Property(name="IsUserView")
    @JsonIgnore
    public Optional<Boolean> getIsUserView() {
        return Optional.ofNullable(isUserView);
    }

    public RecentItem withIsUserView(Boolean isUserView) {
        RecentItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.RecentItem");
        _x.isUserView = isUserView;
        return _x;
    }

    @Property(name="Title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    public RecentItem withTitle(String title) {
        Checks.checkIsAscii(title);
        RecentItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.RecentItem");
        _x.title = title;
        return _x;
    }

    @Property(name="IsDeleted")
    @JsonIgnore
    public Optional<Boolean> getIsDeleted() {
        return Optional.ofNullable(isDeleted);
    }

    public RecentItem withIsDeleted(Boolean isDeleted) {
        RecentItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.RecentItem");
        _x.isDeleted = isDeleted;
        return _x;
    }

    public RecentItem withUnmappedField(String name, String value) {
        RecentItem _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private String iconPath;
        private String lastAccessedStr;
        private String entityTypeName;
        private String objectId;
        private Boolean pinStatus;
        private RecentlyViewedRecordType recordType;
        private Boolean isUserView;
        private String title;
        private Boolean isDeleted;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("DisplayName");
            return this;
        }

        public Builder iconPath(String iconPath) {
            this.iconPath = iconPath;
            this.changedFields = changedFields.add("IconPath");
            return this;
        }

        public Builder lastAccessedStr(String lastAccessedStr) {
            this.lastAccessedStr = lastAccessedStr;
            this.changedFields = changedFields.add("LastAccessedStr");
            return this;
        }

        public Builder entityTypeName(String entityTypeName) {
            this.entityTypeName = entityTypeName;
            this.changedFields = changedFields.add("EntityTypeName");
            return this;
        }

        public Builder objectId(String objectId) {
            this.objectId = objectId;
            this.changedFields = changedFields.add("ObjectId");
            return this;
        }

        public Builder pinStatus(Boolean pinStatus) {
            this.pinStatus = pinStatus;
            this.changedFields = changedFields.add("PinStatus");
            return this;
        }

        public Builder recordType(RecentlyViewedRecordType recordType) {
            this.recordType = recordType;
            this.changedFields = changedFields.add("RecordType");
            return this;
        }

        public Builder isUserView(Boolean isUserView) {
            this.isUserView = isUserView;
            this.changedFields = changedFields.add("IsUserView");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("Title");
            return this;
        }

        public Builder isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            this.changedFields = changedFields.add("IsDeleted");
            return this;
        }

        public RecentItem build() {
            RecentItem _x = new RecentItem();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.RecentItem";
            _x.displayName = displayName;
            _x.iconPath = iconPath;
            _x.lastAccessedStr = lastAccessedStr;
            _x.entityTypeName = entityTypeName;
            _x.objectId = objectId;
            _x.pinStatus = pinStatus;
            _x.recordType = recordType;
            _x.isUserView = isUserView;
            _x.title = title;
            _x.isDeleted = isDeleted;
            return _x;
        }
    }

    private RecentItem _copy() {
        RecentItem _x = new RecentItem();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.iconPath = iconPath;
        _x.lastAccessedStr = lastAccessedStr;
        _x.entityTypeName = entityTypeName;
        _x.objectId = objectId;
        _x.pinStatus = pinStatus;
        _x.recordType = recordType;
        _x.isUserView = isUserView;
        _x.title = title;
        _x.isDeleted = isDeleted;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RecentItem[");
        b.append("DisplayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("IconPath=");
        b.append(this.iconPath);
        b.append(", ");
        b.append("LastAccessedStr=");
        b.append(this.lastAccessedStr);
        b.append(", ");
        b.append("EntityTypeName=");
        b.append(this.entityTypeName);
        b.append(", ");
        b.append("ObjectId=");
        b.append(this.objectId);
        b.append(", ");
        b.append("PinStatus=");
        b.append(this.pinStatus);
        b.append(", ");
        b.append("RecordType=");
        b.append(this.recordType);
        b.append(", ");
        b.append("IsUserView=");
        b.append(this.isUserView);
        b.append(", ");
        b.append("Title=");
        b.append(this.title);
        b.append(", ");
        b.append("IsDeleted=");
        b.append(this.isDeleted);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
