package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "EntityId", 
    "LogicalName", 
    "LogicalCollectionName", 
    "ObjectTypeCode", 
    "DisplayName", 
    "PrimaryNameAttribute", 
    "PrimaryIdAttribute", 
    "Attributes", 
    "Relationships"})
@JsonInclude(Include.NON_NULL)
public class DependentEntityMetadata implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("EntityId")
    protected String entityId;

    @JsonProperty("LogicalName")
    protected String logicalName;

    @JsonProperty("LogicalCollectionName")
    protected String logicalCollectionName;

    @JsonProperty("ObjectTypeCode")
    protected Integer objectTypeCode;

    @JsonProperty("DisplayName")
    protected String displayName;

    @JsonProperty("PrimaryNameAttribute")
    protected String primaryNameAttribute;

    @JsonProperty("PrimaryIdAttribute")
    protected String primaryIdAttribute;

    @JsonProperty("Attributes")
    protected DependentAttributeMetadataCollection attributes;

    @JsonProperty("Relationships")
    protected DependentRelationshipCollection relationships;

    protected DependentEntityMetadata() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.DependentEntityMetadata";
    }

    @Property(name="EntityId")
    @JsonIgnore
    public Optional<String> getEntityId() {
        return Optional.ofNullable(entityId);
    }

    public DependentEntityMetadata withEntityId(String entityId) {
        Checks.checkIsAscii(entityId);
        DependentEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.DependentEntityMetadata");
        _x.entityId = entityId;
        return _x;
    }

    @Property(name="LogicalName")
    @JsonIgnore
    public Optional<String> getLogicalName() {
        return Optional.ofNullable(logicalName);
    }

    public DependentEntityMetadata withLogicalName(String logicalName) {
        Checks.checkIsAscii(logicalName);
        DependentEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.DependentEntityMetadata");
        _x.logicalName = logicalName;
        return _x;
    }

    @Property(name="LogicalCollectionName")
    @JsonIgnore
    public Optional<String> getLogicalCollectionName() {
        return Optional.ofNullable(logicalCollectionName);
    }

    public DependentEntityMetadata withLogicalCollectionName(String logicalCollectionName) {
        Checks.checkIsAscii(logicalCollectionName);
        DependentEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.DependentEntityMetadata");
        _x.logicalCollectionName = logicalCollectionName;
        return _x;
    }

    @Property(name="ObjectTypeCode")
    @JsonIgnore
    public Optional<Integer> getObjectTypeCode() {
        return Optional.ofNullable(objectTypeCode);
    }

    public DependentEntityMetadata withObjectTypeCode(Integer objectTypeCode) {
        DependentEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.DependentEntityMetadata");
        _x.objectTypeCode = objectTypeCode;
        return _x;
    }

    @Property(name="DisplayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public DependentEntityMetadata withDisplayName(String displayName) {
        Checks.checkIsAscii(displayName);
        DependentEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.DependentEntityMetadata");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="PrimaryNameAttribute")
    @JsonIgnore
    public Optional<String> getPrimaryNameAttribute() {
        return Optional.ofNullable(primaryNameAttribute);
    }

    public DependentEntityMetadata withPrimaryNameAttribute(String primaryNameAttribute) {
        Checks.checkIsAscii(primaryNameAttribute);
        DependentEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.DependentEntityMetadata");
        _x.primaryNameAttribute = primaryNameAttribute;
        return _x;
    }

    @Property(name="PrimaryIdAttribute")
    @JsonIgnore
    public Optional<String> getPrimaryIdAttribute() {
        return Optional.ofNullable(primaryIdAttribute);
    }

    public DependentEntityMetadata withPrimaryIdAttribute(String primaryIdAttribute) {
        Checks.checkIsAscii(primaryIdAttribute);
        DependentEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.DependentEntityMetadata");
        _x.primaryIdAttribute = primaryIdAttribute;
        return _x;
    }

    @Property(name="Attributes")
    @JsonIgnore
    public Optional<DependentAttributeMetadataCollection> getAttributes() {
        return Optional.ofNullable(attributes);
    }

    public DependentEntityMetadata withAttributes(DependentAttributeMetadataCollection attributes) {
        DependentEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.DependentEntityMetadata");
        _x.attributes = attributes;
        return _x;
    }

    @Property(name="Relationships")
    @JsonIgnore
    public Optional<DependentRelationshipCollection> getRelationships() {
        return Optional.ofNullable(relationships);
    }

    public DependentEntityMetadata withRelationships(DependentRelationshipCollection relationships) {
        DependentEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.DependentEntityMetadata");
        _x.relationships = relationships;
        return _x;
    }

    public DependentEntityMetadata withUnmappedField(String name, String value) {
        DependentEntityMetadata _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String entityId;
        private String logicalName;
        private String logicalCollectionName;
        private Integer objectTypeCode;
        private String displayName;
        private String primaryNameAttribute;
        private String primaryIdAttribute;
        private DependentAttributeMetadataCollection attributes;
        private DependentRelationshipCollection relationships;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder entityId(String entityId) {
            this.entityId = entityId;
            this.changedFields = changedFields.add("EntityId");
            return this;
        }

        public Builder logicalName(String logicalName) {
            this.logicalName = logicalName;
            this.changedFields = changedFields.add("LogicalName");
            return this;
        }

        public Builder logicalCollectionName(String logicalCollectionName) {
            this.logicalCollectionName = logicalCollectionName;
            this.changedFields = changedFields.add("LogicalCollectionName");
            return this;
        }

        public Builder objectTypeCode(Integer objectTypeCode) {
            this.objectTypeCode = objectTypeCode;
            this.changedFields = changedFields.add("ObjectTypeCode");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("DisplayName");
            return this;
        }

        public Builder primaryNameAttribute(String primaryNameAttribute) {
            this.primaryNameAttribute = primaryNameAttribute;
            this.changedFields = changedFields.add("PrimaryNameAttribute");
            return this;
        }

        public Builder primaryIdAttribute(String primaryIdAttribute) {
            this.primaryIdAttribute = primaryIdAttribute;
            this.changedFields = changedFields.add("PrimaryIdAttribute");
            return this;
        }

        public Builder attributes(DependentAttributeMetadataCollection attributes) {
            this.attributes = attributes;
            this.changedFields = changedFields.add("Attributes");
            return this;
        }

        public Builder relationships(DependentRelationshipCollection relationships) {
            this.relationships = relationships;
            this.changedFields = changedFields.add("Relationships");
            return this;
        }

        public DependentEntityMetadata build() {
            DependentEntityMetadata _x = new DependentEntityMetadata();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.DependentEntityMetadata";
            _x.entityId = entityId;
            _x.logicalName = logicalName;
            _x.logicalCollectionName = logicalCollectionName;
            _x.objectTypeCode = objectTypeCode;
            _x.displayName = displayName;
            _x.primaryNameAttribute = primaryNameAttribute;
            _x.primaryIdAttribute = primaryIdAttribute;
            _x.attributes = attributes;
            _x.relationships = relationships;
            return _x;
        }
    }

    private DependentEntityMetadata _copy() {
        DependentEntityMetadata _x = new DependentEntityMetadata();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.entityId = entityId;
        _x.logicalName = logicalName;
        _x.logicalCollectionName = logicalCollectionName;
        _x.objectTypeCode = objectTypeCode;
        _x.displayName = displayName;
        _x.primaryNameAttribute = primaryNameAttribute;
        _x.primaryIdAttribute = primaryIdAttribute;
        _x.attributes = attributes;
        _x.relationships = relationships;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DependentEntityMetadata[");
        b.append("EntityId=");
        b.append(this.entityId);
        b.append(", ");
        b.append("LogicalName=");
        b.append(this.logicalName);
        b.append(", ");
        b.append("LogicalCollectionName=");
        b.append(this.logicalCollectionName);
        b.append(", ");
        b.append("ObjectTypeCode=");
        b.append(this.objectTypeCode);
        b.append(", ");
        b.append("DisplayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("PrimaryNameAttribute=");
        b.append(this.primaryNameAttribute);
        b.append(", ");
        b.append("PrimaryIdAttribute=");
        b.append(this.primaryIdAttribute);
        b.append(", ");
        b.append("Attributes=");
        b.append(this.attributes);
        b.append(", ");
        b.append("Relationships=");
        b.append(this.relationships);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
