package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import microsoft.dynamics.crm.enums.OwnershipTypes;

@JsonPropertyOrder({
    "@odata.type", 
    "ActivityTypeMask", 
    "Attributes", 
    "AutoRouteToOwnerQueue", 
    "CanTriggerWorkflow", 
    "Description", 
    "DisplayCollectionName", 
    "DisplayName", 
    "EntityHelpUrlEnabled", 
    "EntityHelpUrl", 
    "IsDocumentManagementEnabled", 
    "IsOneNoteIntegrationEnabled", 
    "IsInteractionCentricEnabled", 
    "IsKnowledgeManagementEnabled", 
    "IsSLAEnabled", 
    "IsBPFEntity", 
    "IsDocumentRecommendationsEnabled", 
    "IsMSTeamsIntegrationEnabled", 
    "SettingOf", 
    "DataProviderId", 
    "DataSourceId", 
    "AutoCreateAccessTeams", 
    "IsActivity", 
    "IsActivityParty", 
    "IsAuditEnabled", 
    "IsAvailableOffline", 
    "IsChildEntity", 
    "IsAIRUpdated", 
    "IsValidForQueue", 
    "IsConnectionsEnabled", 
    "IconLargeName", 
    "IconMediumName", 
    "IconSmallName", 
    "IconVectorName", 
    "IsCustomEntity", 
    "IsBusinessProcessEnabled", 
    "IsCustomizable", 
    "IsRenameable", 
    "IsMappable", 
    "IsDuplicateDetectionEnabled", 
    "CanCreateAttributes", 
    "CanCreateForms", 
    "CanCreateViews", 
    "CanCreateCharts", 
    "CanBeRelatedEntityInRelationship", 
    "CanBePrimaryEntityInRelationship", 
    "CanBeInManyToMany", 
    "CanBeInCustomEntityAssociation", 
    "CanEnableSyncToExternalSearchIndex", 
    "SyncToExternalSearchIndex", 
    "CanModifyAdditionalSettings", 
    "CanChangeHierarchicalRelationship", 
    "IsOptimisticConcurrencyEnabled", 
    "ChangeTrackingEnabled", 
    "CanChangeTrackingBeEnabled", 
    "IsImportable", 
    "IsIntersect", 
    "IsMailMergeEnabled", 
    "IsManaged", 
    "IsEnabledForCharts", 
    "IsEnabledForTrace", 
    "IsValidForAdvancedFind", 
    "IsVisibleInMobile", 
    "IsVisibleInMobileClient", 
    "IsReadOnlyInMobileClient", 
    "IsOfflineInMobileClient", 
    "DaysSinceRecordLastModified", 
    "MobileOfflineFilters", 
    "IsReadingPaneEnabled", 
    "IsQuickCreateEnabled", 
    "LogicalName", 
    "ManyToManyRelationships", 
    "ManyToOneRelationships", 
    "OneToManyRelationships", 
    "ObjectTypeCode", 
    "OwnershipType", 
    "PrimaryNameAttribute", 
    "PrimaryImageAttribute", 
    "PrimaryIdAttribute", 
    "Privileges", 
    "RecurrenceBaseEntityLogicalName", 
    "ReportViewName", 
    "SchemaName", 
    "IntroducedVersion", 
    "IsStateModelAware", 
    "EnforceStateTransitions", 
    "ExternalName", 
    "EntityColor", 
    "Keys", 
    "LogicalCollectionName", 
    "ExternalCollectionName", 
    "CollectionSchemaName", 
    "EntitySetName", 
    "IsEnabledForExternalChannels", 
    "IsPrivate", 
    "UsesBusinessDataLabelTable", 
    "IsLogicalEntity", 
    "HasNotes", 
    "HasActivities", 
    "HasFeedback", 
    "IsSolutionAware", 
    "Settings", 
    "CreatedOn", 
    "ModifiedOn", 
    "MetadataId", 
    "HasChanged"})
@JsonInclude(Include.NON_NULL)
public class ComplexEntityMetadata implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ActivityTypeMask")
    protected Integer activityTypeMask;

    @JsonProperty("Attributes")
    protected List<ComplexAttributeMetadata> attributes;

    @JsonProperty("Attributes@nextLink")
    protected String attributesNextLink;

    @JsonProperty("AutoRouteToOwnerQueue")
    protected Boolean autoRouteToOwnerQueue;

    @JsonProperty("CanTriggerWorkflow")
    protected Boolean canTriggerWorkflow;

    @JsonProperty("Description")
    protected Label description;

    @JsonProperty("DisplayCollectionName")
    protected Label displayCollectionName;

    @JsonProperty("DisplayName")
    protected Label displayName;

    @JsonProperty("EntityHelpUrlEnabled")
    protected Boolean entityHelpUrlEnabled;

    @JsonProperty("EntityHelpUrl")
    protected String entityHelpUrl;

    @JsonProperty("IsDocumentManagementEnabled")
    protected Boolean isDocumentManagementEnabled;

    @JsonProperty("IsOneNoteIntegrationEnabled")
    protected Boolean isOneNoteIntegrationEnabled;

    @JsonProperty("IsInteractionCentricEnabled")
    protected Boolean isInteractionCentricEnabled;

    @JsonProperty("IsKnowledgeManagementEnabled")
    protected Boolean isKnowledgeManagementEnabled;

    @JsonProperty("IsSLAEnabled")
    protected Boolean isSLAEnabled;

    @JsonProperty("IsBPFEntity")
    protected Boolean isBPFEntity;

    @JsonProperty("IsDocumentRecommendationsEnabled")
    protected Boolean isDocumentRecommendationsEnabled;

    @JsonProperty("IsMSTeamsIntegrationEnabled")
    protected Boolean isMSTeamsIntegrationEnabled;

    @JsonProperty("SettingOf")
    protected String settingOf;

    @JsonProperty("DataProviderId")
    protected String dataProviderId;

    @JsonProperty("DataSourceId")
    protected String dataSourceId;

    @JsonProperty("AutoCreateAccessTeams")
    protected Boolean autoCreateAccessTeams;

    @JsonProperty("IsActivity")
    protected Boolean isActivity;

    @JsonProperty("IsActivityParty")
    protected Boolean isActivityParty;

    @JsonProperty("IsAuditEnabled")
    protected BooleanManagedProperty isAuditEnabled;

    @JsonProperty("IsAvailableOffline")
    protected Boolean isAvailableOffline;

    @JsonProperty("IsChildEntity")
    protected Boolean isChildEntity;

    @JsonProperty("IsAIRUpdated")
    protected Boolean isAIRUpdated;

    @JsonProperty("IsValidForQueue")
    protected BooleanManagedProperty isValidForQueue;

    @JsonProperty("IsConnectionsEnabled")
    protected BooleanManagedProperty isConnectionsEnabled;

    @JsonProperty("IconLargeName")
    protected String iconLargeName;

    @JsonProperty("IconMediumName")
    protected String iconMediumName;

    @JsonProperty("IconSmallName")
    protected String iconSmallName;

    @JsonProperty("IconVectorName")
    protected String iconVectorName;

    @JsonProperty("IsCustomEntity")
    protected Boolean isCustomEntity;

    @JsonProperty("IsBusinessProcessEnabled")
    protected Boolean isBusinessProcessEnabled;

    @JsonProperty("IsCustomizable")
    protected BooleanManagedProperty isCustomizable;

    @JsonProperty("IsRenameable")
    protected BooleanManagedProperty isRenameable;

    @JsonProperty("IsMappable")
    protected BooleanManagedProperty isMappable;

    @JsonProperty("IsDuplicateDetectionEnabled")
    protected BooleanManagedProperty isDuplicateDetectionEnabled;

    @JsonProperty("CanCreateAttributes")
    protected BooleanManagedProperty canCreateAttributes;

    @JsonProperty("CanCreateForms")
    protected BooleanManagedProperty canCreateForms;

    @JsonProperty("CanCreateViews")
    protected BooleanManagedProperty canCreateViews;

    @JsonProperty("CanCreateCharts")
    protected BooleanManagedProperty canCreateCharts;

    @JsonProperty("CanBeRelatedEntityInRelationship")
    protected BooleanManagedProperty canBeRelatedEntityInRelationship;

    @JsonProperty("CanBePrimaryEntityInRelationship")
    protected BooleanManagedProperty canBePrimaryEntityInRelationship;

    @JsonProperty("CanBeInManyToMany")
    protected BooleanManagedProperty canBeInManyToMany;

    @JsonProperty("CanBeInCustomEntityAssociation")
    protected BooleanManagedProperty canBeInCustomEntityAssociation;

    @JsonProperty("CanEnableSyncToExternalSearchIndex")
    protected BooleanManagedProperty canEnableSyncToExternalSearchIndex;

    @JsonProperty("SyncToExternalSearchIndex")
    protected Boolean syncToExternalSearchIndex;

    @JsonProperty("CanModifyAdditionalSettings")
    protected BooleanManagedProperty canModifyAdditionalSettings;

    @JsonProperty("CanChangeHierarchicalRelationship")
    protected BooleanManagedProperty canChangeHierarchicalRelationship;

    @JsonProperty("IsOptimisticConcurrencyEnabled")
    protected Boolean isOptimisticConcurrencyEnabled;

    @JsonProperty("ChangeTrackingEnabled")
    protected Boolean changeTrackingEnabled;

    @JsonProperty("CanChangeTrackingBeEnabled")
    protected BooleanManagedProperty canChangeTrackingBeEnabled;

    @JsonProperty("IsImportable")
    protected Boolean isImportable;

    @JsonProperty("IsIntersect")
    protected Boolean isIntersect;

    @JsonProperty("IsMailMergeEnabled")
    protected BooleanManagedProperty isMailMergeEnabled;

    @JsonProperty("IsManaged")
    protected Boolean isManaged;

    @JsonProperty("IsEnabledForCharts")
    protected Boolean isEnabledForCharts;

    @JsonProperty("IsEnabledForTrace")
    protected Boolean isEnabledForTrace;

    @JsonProperty("IsValidForAdvancedFind")
    protected Boolean isValidForAdvancedFind;

    @JsonProperty("IsVisibleInMobile")
    protected BooleanManagedProperty isVisibleInMobile;

    @JsonProperty("IsVisibleInMobileClient")
    protected BooleanManagedProperty isVisibleInMobileClient;

    @JsonProperty("IsReadOnlyInMobileClient")
    protected BooleanManagedProperty isReadOnlyInMobileClient;

    @JsonProperty("IsOfflineInMobileClient")
    protected BooleanManagedProperty isOfflineInMobileClient;

    @JsonProperty("DaysSinceRecordLastModified")
    protected Integer daysSinceRecordLastModified;

    @JsonProperty("MobileOfflineFilters")
    protected String mobileOfflineFilters;

    @JsonProperty("IsReadingPaneEnabled")
    protected Boolean isReadingPaneEnabled;

    @JsonProperty("IsQuickCreateEnabled")
    protected Boolean isQuickCreateEnabled;

    @JsonProperty("LogicalName")
    protected String logicalName;

    @JsonProperty("ManyToManyRelationships")
    protected List<ComplexManyToManyRelationshipMetadata> manyToManyRelationships;

    @JsonProperty("ManyToManyRelationships@nextLink")
    protected String manyToManyRelationshipsNextLink;

    @JsonProperty("ManyToOneRelationships")
    protected List<ComplexOneToManyRelationshipMetadata> manyToOneRelationships;

    @JsonProperty("ManyToOneRelationships@nextLink")
    protected String manyToOneRelationshipsNextLink;

    @JsonProperty("OneToManyRelationships")
    protected List<ComplexOneToManyRelationshipMetadata> oneToManyRelationships;

    @JsonProperty("OneToManyRelationships@nextLink")
    protected String oneToManyRelationshipsNextLink;

    @JsonProperty("ObjectTypeCode")
    protected Integer objectTypeCode;

    @JsonProperty("OwnershipType")
    protected OwnershipTypes ownershipType;

    @JsonProperty("PrimaryNameAttribute")
    protected String primaryNameAttribute;

    @JsonProperty("PrimaryImageAttribute")
    protected String primaryImageAttribute;

    @JsonProperty("PrimaryIdAttribute")
    protected String primaryIdAttribute;

    @JsonProperty("Privileges")
    protected List<SecurityPrivilegeMetadata> privileges;

    @JsonProperty("Privileges@nextLink")
    protected String privilegesNextLink;

    @JsonProperty("RecurrenceBaseEntityLogicalName")
    protected String recurrenceBaseEntityLogicalName;

    @JsonProperty("ReportViewName")
    protected String reportViewName;

    @JsonProperty("SchemaName")
    protected String schemaName;

    @JsonProperty("IntroducedVersion")
    protected String introducedVersion;

    @JsonProperty("IsStateModelAware")
    protected Boolean isStateModelAware;

    @JsonProperty("EnforceStateTransitions")
    protected Boolean enforceStateTransitions;

    @JsonProperty("ExternalName")
    protected String externalName;

    @JsonProperty("EntityColor")
    protected String entityColor;

    @JsonProperty("Keys")
    protected List<ComplexEntityKeyMetadata> keys;

    @JsonProperty("Keys@nextLink")
    protected String keysNextLink;

    @JsonProperty("LogicalCollectionName")
    protected String logicalCollectionName;

    @JsonProperty("ExternalCollectionName")
    protected String externalCollectionName;

    @JsonProperty("CollectionSchemaName")
    protected String collectionSchemaName;

    @JsonProperty("EntitySetName")
    protected String entitySetName;

    @JsonProperty("IsEnabledForExternalChannels")
    protected Boolean isEnabledForExternalChannels;

    @JsonProperty("IsPrivate")
    protected Boolean isPrivate;

    @JsonProperty("UsesBusinessDataLabelTable")
    protected Boolean usesBusinessDataLabelTable;

    @JsonProperty("IsLogicalEntity")
    protected Boolean isLogicalEntity;

    @JsonProperty("HasNotes")
    protected Boolean hasNotes;

    @JsonProperty("HasActivities")
    protected Boolean hasActivities;

    @JsonProperty("HasFeedback")
    protected Boolean hasFeedback;

    @JsonProperty("IsSolutionAware")
    protected Boolean isSolutionAware;

    @JsonProperty("Settings")
    protected List<EntitySetting> settings;

    @JsonProperty("Settings@nextLink")
    protected String settingsNextLink;

    @JsonProperty("CreatedOn")
    protected OffsetDateTime createdOn;

    @JsonProperty("ModifiedOn")
    protected OffsetDateTime modifiedOn;

    @JsonProperty("MetadataId")
    protected String metadataId;

    @JsonProperty("HasChanged")
    protected Boolean hasChanged;

    protected ComplexEntityMetadata() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ComplexEntityMetadata";
    }

    @Property(name="ActivityTypeMask")
    @JsonIgnore
    public Optional<Integer> getActivityTypeMask() {
        return Optional.ofNullable(activityTypeMask);
    }

    public ComplexEntityMetadata withActivityTypeMask(Integer activityTypeMask) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.activityTypeMask = activityTypeMask;
        return _x;
    }

    @Property(name="Attributes")
    @JsonIgnore
    public CollectionPage<ComplexAttributeMetadata> getAttributes() {
        return new CollectionPage<ComplexAttributeMetadata>(contextPath, ComplexAttributeMetadata.class, this.attributes, Optional.ofNullable(attributesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Attributes")
    @JsonIgnore
    public CollectionPage<ComplexAttributeMetadata> getAttributes(HttpRequestOptions options) {
        return new CollectionPage<ComplexAttributeMetadata>(contextPath, ComplexAttributeMetadata.class, this.attributes, Optional.ofNullable(attributesNextLink), Collections.emptyList(), options);
    }

    @Property(name="AutoRouteToOwnerQueue")
    @JsonIgnore
    public Optional<Boolean> getAutoRouteToOwnerQueue() {
        return Optional.ofNullable(autoRouteToOwnerQueue);
    }

    public ComplexEntityMetadata withAutoRouteToOwnerQueue(Boolean autoRouteToOwnerQueue) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.autoRouteToOwnerQueue = autoRouteToOwnerQueue;
        return _x;
    }

    @Property(name="CanTriggerWorkflow")
    @JsonIgnore
    public Optional<Boolean> getCanTriggerWorkflow() {
        return Optional.ofNullable(canTriggerWorkflow);
    }

    public ComplexEntityMetadata withCanTriggerWorkflow(Boolean canTriggerWorkflow) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.canTriggerWorkflow = canTriggerWorkflow;
        return _x;
    }

    @Property(name="Description")
    @JsonIgnore
    public Optional<Label> getDescription() {
        return Optional.ofNullable(description);
    }

    public ComplexEntityMetadata withDescription(Label description) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.description = description;
        return _x;
    }

    @Property(name="DisplayCollectionName")
    @JsonIgnore
    public Optional<Label> getDisplayCollectionName() {
        return Optional.ofNullable(displayCollectionName);
    }

    public ComplexEntityMetadata withDisplayCollectionName(Label displayCollectionName) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.displayCollectionName = displayCollectionName;
        return _x;
    }

    @Property(name="DisplayName")
    @JsonIgnore
    public Optional<Label> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ComplexEntityMetadata withDisplayName(Label displayName) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="EntityHelpUrlEnabled")
    @JsonIgnore
    public Optional<Boolean> getEntityHelpUrlEnabled() {
        return Optional.ofNullable(entityHelpUrlEnabled);
    }

    public ComplexEntityMetadata withEntityHelpUrlEnabled(Boolean entityHelpUrlEnabled) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.entityHelpUrlEnabled = entityHelpUrlEnabled;
        return _x;
    }

    @Property(name="EntityHelpUrl")
    @JsonIgnore
    public Optional<String> getEntityHelpUrl() {
        return Optional.ofNullable(entityHelpUrl);
    }

    public ComplexEntityMetadata withEntityHelpUrl(String entityHelpUrl) {
        Checks.checkIsAscii(entityHelpUrl);
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.entityHelpUrl = entityHelpUrl;
        return _x;
    }

    @Property(name="IsDocumentManagementEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsDocumentManagementEnabled() {
        return Optional.ofNullable(isDocumentManagementEnabled);
    }

    public ComplexEntityMetadata withIsDocumentManagementEnabled(Boolean isDocumentManagementEnabled) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isDocumentManagementEnabled = isDocumentManagementEnabled;
        return _x;
    }

    @Property(name="IsOneNoteIntegrationEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsOneNoteIntegrationEnabled() {
        return Optional.ofNullable(isOneNoteIntegrationEnabled);
    }

    public ComplexEntityMetadata withIsOneNoteIntegrationEnabled(Boolean isOneNoteIntegrationEnabled) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isOneNoteIntegrationEnabled = isOneNoteIntegrationEnabled;
        return _x;
    }

    @Property(name="IsInteractionCentricEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsInteractionCentricEnabled() {
        return Optional.ofNullable(isInteractionCentricEnabled);
    }

    public ComplexEntityMetadata withIsInteractionCentricEnabled(Boolean isInteractionCentricEnabled) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isInteractionCentricEnabled = isInteractionCentricEnabled;
        return _x;
    }

    @Property(name="IsKnowledgeManagementEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsKnowledgeManagementEnabled() {
        return Optional.ofNullable(isKnowledgeManagementEnabled);
    }

    public ComplexEntityMetadata withIsKnowledgeManagementEnabled(Boolean isKnowledgeManagementEnabled) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isKnowledgeManagementEnabled = isKnowledgeManagementEnabled;
        return _x;
    }

    @Property(name="IsSLAEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsSLAEnabled() {
        return Optional.ofNullable(isSLAEnabled);
    }

    public ComplexEntityMetadata withIsSLAEnabled(Boolean isSLAEnabled) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isSLAEnabled = isSLAEnabled;
        return _x;
    }

    @Property(name="IsBPFEntity")
    @JsonIgnore
    public Optional<Boolean> getIsBPFEntity() {
        return Optional.ofNullable(isBPFEntity);
    }

    public ComplexEntityMetadata withIsBPFEntity(Boolean isBPFEntity) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isBPFEntity = isBPFEntity;
        return _x;
    }

    @Property(name="IsDocumentRecommendationsEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsDocumentRecommendationsEnabled() {
        return Optional.ofNullable(isDocumentRecommendationsEnabled);
    }

    public ComplexEntityMetadata withIsDocumentRecommendationsEnabled(Boolean isDocumentRecommendationsEnabled) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isDocumentRecommendationsEnabled = isDocumentRecommendationsEnabled;
        return _x;
    }

    @Property(name="IsMSTeamsIntegrationEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsMSTeamsIntegrationEnabled() {
        return Optional.ofNullable(isMSTeamsIntegrationEnabled);
    }

    public ComplexEntityMetadata withIsMSTeamsIntegrationEnabled(Boolean isMSTeamsIntegrationEnabled) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isMSTeamsIntegrationEnabled = isMSTeamsIntegrationEnabled;
        return _x;
    }

    @Property(name="SettingOf")
    @JsonIgnore
    public Optional<String> getSettingOf() {
        return Optional.ofNullable(settingOf);
    }

    public ComplexEntityMetadata withSettingOf(String settingOf) {
        Checks.checkIsAscii(settingOf);
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.settingOf = settingOf;
        return _x;
    }

    @Property(name="DataProviderId")
    @JsonIgnore
    public Optional<String> getDataProviderId() {
        return Optional.ofNullable(dataProviderId);
    }

    public ComplexEntityMetadata withDataProviderId(String dataProviderId) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.dataProviderId = dataProviderId;
        return _x;
    }

    @Property(name="DataSourceId")
    @JsonIgnore
    public Optional<String> getDataSourceId() {
        return Optional.ofNullable(dataSourceId);
    }

    public ComplexEntityMetadata withDataSourceId(String dataSourceId) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.dataSourceId = dataSourceId;
        return _x;
    }

    @Property(name="AutoCreateAccessTeams")
    @JsonIgnore
    public Optional<Boolean> getAutoCreateAccessTeams() {
        return Optional.ofNullable(autoCreateAccessTeams);
    }

    public ComplexEntityMetadata withAutoCreateAccessTeams(Boolean autoCreateAccessTeams) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.autoCreateAccessTeams = autoCreateAccessTeams;
        return _x;
    }

    @Property(name="IsActivity")
    @JsonIgnore
    public Optional<Boolean> getIsActivity() {
        return Optional.ofNullable(isActivity);
    }

    public ComplexEntityMetadata withIsActivity(Boolean isActivity) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isActivity = isActivity;
        return _x;
    }

    @Property(name="IsActivityParty")
    @JsonIgnore
    public Optional<Boolean> getIsActivityParty() {
        return Optional.ofNullable(isActivityParty);
    }

    public ComplexEntityMetadata withIsActivityParty(Boolean isActivityParty) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isActivityParty = isActivityParty;
        return _x;
    }

    @Property(name="IsAuditEnabled")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsAuditEnabled() {
        return Optional.ofNullable(isAuditEnabled);
    }

    public ComplexEntityMetadata withIsAuditEnabled(BooleanManagedProperty isAuditEnabled) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isAuditEnabled = isAuditEnabled;
        return _x;
    }

    @Property(name="IsAvailableOffline")
    @JsonIgnore
    public Optional<Boolean> getIsAvailableOffline() {
        return Optional.ofNullable(isAvailableOffline);
    }

    public ComplexEntityMetadata withIsAvailableOffline(Boolean isAvailableOffline) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isAvailableOffline = isAvailableOffline;
        return _x;
    }

    @Property(name="IsChildEntity")
    @JsonIgnore
    public Optional<Boolean> getIsChildEntity() {
        return Optional.ofNullable(isChildEntity);
    }

    public ComplexEntityMetadata withIsChildEntity(Boolean isChildEntity) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isChildEntity = isChildEntity;
        return _x;
    }

    @Property(name="IsAIRUpdated")
    @JsonIgnore
    public Optional<Boolean> getIsAIRUpdated() {
        return Optional.ofNullable(isAIRUpdated);
    }

    public ComplexEntityMetadata withIsAIRUpdated(Boolean isAIRUpdated) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isAIRUpdated = isAIRUpdated;
        return _x;
    }

    @Property(name="IsValidForQueue")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsValidForQueue() {
        return Optional.ofNullable(isValidForQueue);
    }

    public ComplexEntityMetadata withIsValidForQueue(BooleanManagedProperty isValidForQueue) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isValidForQueue = isValidForQueue;
        return _x;
    }

    @Property(name="IsConnectionsEnabled")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsConnectionsEnabled() {
        return Optional.ofNullable(isConnectionsEnabled);
    }

    public ComplexEntityMetadata withIsConnectionsEnabled(BooleanManagedProperty isConnectionsEnabled) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isConnectionsEnabled = isConnectionsEnabled;
        return _x;
    }

    @Property(name="IconLargeName")
    @JsonIgnore
    public Optional<String> getIconLargeName() {
        return Optional.ofNullable(iconLargeName);
    }

    public ComplexEntityMetadata withIconLargeName(String iconLargeName) {
        Checks.checkIsAscii(iconLargeName);
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.iconLargeName = iconLargeName;
        return _x;
    }

    @Property(name="IconMediumName")
    @JsonIgnore
    public Optional<String> getIconMediumName() {
        return Optional.ofNullable(iconMediumName);
    }

    public ComplexEntityMetadata withIconMediumName(String iconMediumName) {
        Checks.checkIsAscii(iconMediumName);
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.iconMediumName = iconMediumName;
        return _x;
    }

    @Property(name="IconSmallName")
    @JsonIgnore
    public Optional<String> getIconSmallName() {
        return Optional.ofNullable(iconSmallName);
    }

    public ComplexEntityMetadata withIconSmallName(String iconSmallName) {
        Checks.checkIsAscii(iconSmallName);
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.iconSmallName = iconSmallName;
        return _x;
    }

    @Property(name="IconVectorName")
    @JsonIgnore
    public Optional<String> getIconVectorName() {
        return Optional.ofNullable(iconVectorName);
    }

    public ComplexEntityMetadata withIconVectorName(String iconVectorName) {
        Checks.checkIsAscii(iconVectorName);
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.iconVectorName = iconVectorName;
        return _x;
    }

    @Property(name="IsCustomEntity")
    @JsonIgnore
    public Optional<Boolean> getIsCustomEntity() {
        return Optional.ofNullable(isCustomEntity);
    }

    public ComplexEntityMetadata withIsCustomEntity(Boolean isCustomEntity) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isCustomEntity = isCustomEntity;
        return _x;
    }

    @Property(name="IsBusinessProcessEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsBusinessProcessEnabled() {
        return Optional.ofNullable(isBusinessProcessEnabled);
    }

    public ComplexEntityMetadata withIsBusinessProcessEnabled(Boolean isBusinessProcessEnabled) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isBusinessProcessEnabled = isBusinessProcessEnabled;
        return _x;
    }

    @Property(name="IsCustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsCustomizable() {
        return Optional.ofNullable(isCustomizable);
    }

    public ComplexEntityMetadata withIsCustomizable(BooleanManagedProperty isCustomizable) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isCustomizable = isCustomizable;
        return _x;
    }

    @Property(name="IsRenameable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsRenameable() {
        return Optional.ofNullable(isRenameable);
    }

    public ComplexEntityMetadata withIsRenameable(BooleanManagedProperty isRenameable) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isRenameable = isRenameable;
        return _x;
    }

    @Property(name="IsMappable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsMappable() {
        return Optional.ofNullable(isMappable);
    }

    public ComplexEntityMetadata withIsMappable(BooleanManagedProperty isMappable) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isMappable = isMappable;
        return _x;
    }

    @Property(name="IsDuplicateDetectionEnabled")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsDuplicateDetectionEnabled() {
        return Optional.ofNullable(isDuplicateDetectionEnabled);
    }

    public ComplexEntityMetadata withIsDuplicateDetectionEnabled(BooleanManagedProperty isDuplicateDetectionEnabled) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isDuplicateDetectionEnabled = isDuplicateDetectionEnabled;
        return _x;
    }

    @Property(name="CanCreateAttributes")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getCanCreateAttributes() {
        return Optional.ofNullable(canCreateAttributes);
    }

    public ComplexEntityMetadata withCanCreateAttributes(BooleanManagedProperty canCreateAttributes) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.canCreateAttributes = canCreateAttributes;
        return _x;
    }

    @Property(name="CanCreateForms")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getCanCreateForms() {
        return Optional.ofNullable(canCreateForms);
    }

    public ComplexEntityMetadata withCanCreateForms(BooleanManagedProperty canCreateForms) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.canCreateForms = canCreateForms;
        return _x;
    }

    @Property(name="CanCreateViews")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getCanCreateViews() {
        return Optional.ofNullable(canCreateViews);
    }

    public ComplexEntityMetadata withCanCreateViews(BooleanManagedProperty canCreateViews) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.canCreateViews = canCreateViews;
        return _x;
    }

    @Property(name="CanCreateCharts")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getCanCreateCharts() {
        return Optional.ofNullable(canCreateCharts);
    }

    public ComplexEntityMetadata withCanCreateCharts(BooleanManagedProperty canCreateCharts) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.canCreateCharts = canCreateCharts;
        return _x;
    }

    @Property(name="CanBeRelatedEntityInRelationship")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getCanBeRelatedEntityInRelationship() {
        return Optional.ofNullable(canBeRelatedEntityInRelationship);
    }

    public ComplexEntityMetadata withCanBeRelatedEntityInRelationship(BooleanManagedProperty canBeRelatedEntityInRelationship) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.canBeRelatedEntityInRelationship = canBeRelatedEntityInRelationship;
        return _x;
    }

    @Property(name="CanBePrimaryEntityInRelationship")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getCanBePrimaryEntityInRelationship() {
        return Optional.ofNullable(canBePrimaryEntityInRelationship);
    }

    public ComplexEntityMetadata withCanBePrimaryEntityInRelationship(BooleanManagedProperty canBePrimaryEntityInRelationship) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.canBePrimaryEntityInRelationship = canBePrimaryEntityInRelationship;
        return _x;
    }

    @Property(name="CanBeInManyToMany")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getCanBeInManyToMany() {
        return Optional.ofNullable(canBeInManyToMany);
    }

    public ComplexEntityMetadata withCanBeInManyToMany(BooleanManagedProperty canBeInManyToMany) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.canBeInManyToMany = canBeInManyToMany;
        return _x;
    }

    @Property(name="CanBeInCustomEntityAssociation")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getCanBeInCustomEntityAssociation() {
        return Optional.ofNullable(canBeInCustomEntityAssociation);
    }

    public ComplexEntityMetadata withCanBeInCustomEntityAssociation(BooleanManagedProperty canBeInCustomEntityAssociation) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.canBeInCustomEntityAssociation = canBeInCustomEntityAssociation;
        return _x;
    }

    @Property(name="CanEnableSyncToExternalSearchIndex")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getCanEnableSyncToExternalSearchIndex() {
        return Optional.ofNullable(canEnableSyncToExternalSearchIndex);
    }

    public ComplexEntityMetadata withCanEnableSyncToExternalSearchIndex(BooleanManagedProperty canEnableSyncToExternalSearchIndex) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.canEnableSyncToExternalSearchIndex = canEnableSyncToExternalSearchIndex;
        return _x;
    }

    @Property(name="SyncToExternalSearchIndex")
    @JsonIgnore
    public Optional<Boolean> getSyncToExternalSearchIndex() {
        return Optional.ofNullable(syncToExternalSearchIndex);
    }

    public ComplexEntityMetadata withSyncToExternalSearchIndex(Boolean syncToExternalSearchIndex) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.syncToExternalSearchIndex = syncToExternalSearchIndex;
        return _x;
    }

    @Property(name="CanModifyAdditionalSettings")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getCanModifyAdditionalSettings() {
        return Optional.ofNullable(canModifyAdditionalSettings);
    }

    public ComplexEntityMetadata withCanModifyAdditionalSettings(BooleanManagedProperty canModifyAdditionalSettings) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.canModifyAdditionalSettings = canModifyAdditionalSettings;
        return _x;
    }

    @Property(name="CanChangeHierarchicalRelationship")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getCanChangeHierarchicalRelationship() {
        return Optional.ofNullable(canChangeHierarchicalRelationship);
    }

    public ComplexEntityMetadata withCanChangeHierarchicalRelationship(BooleanManagedProperty canChangeHierarchicalRelationship) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.canChangeHierarchicalRelationship = canChangeHierarchicalRelationship;
        return _x;
    }

    @Property(name="IsOptimisticConcurrencyEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsOptimisticConcurrencyEnabled() {
        return Optional.ofNullable(isOptimisticConcurrencyEnabled);
    }

    public ComplexEntityMetadata withIsOptimisticConcurrencyEnabled(Boolean isOptimisticConcurrencyEnabled) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isOptimisticConcurrencyEnabled = isOptimisticConcurrencyEnabled;
        return _x;
    }

    @Property(name="ChangeTrackingEnabled")
    @JsonIgnore
    public Optional<Boolean> getChangeTrackingEnabled() {
        return Optional.ofNullable(changeTrackingEnabled);
    }

    public ComplexEntityMetadata withChangeTrackingEnabled(Boolean changeTrackingEnabled) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.changeTrackingEnabled = changeTrackingEnabled;
        return _x;
    }

    @Property(name="CanChangeTrackingBeEnabled")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getCanChangeTrackingBeEnabled() {
        return Optional.ofNullable(canChangeTrackingBeEnabled);
    }

    public ComplexEntityMetadata withCanChangeTrackingBeEnabled(BooleanManagedProperty canChangeTrackingBeEnabled) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.canChangeTrackingBeEnabled = canChangeTrackingBeEnabled;
        return _x;
    }

    @Property(name="IsImportable")
    @JsonIgnore
    public Optional<Boolean> getIsImportable() {
        return Optional.ofNullable(isImportable);
    }

    public ComplexEntityMetadata withIsImportable(Boolean isImportable) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isImportable = isImportable;
        return _x;
    }

    @Property(name="IsIntersect")
    @JsonIgnore
    public Optional<Boolean> getIsIntersect() {
        return Optional.ofNullable(isIntersect);
    }

    public ComplexEntityMetadata withIsIntersect(Boolean isIntersect) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isIntersect = isIntersect;
        return _x;
    }

    @Property(name="IsMailMergeEnabled")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsMailMergeEnabled() {
        return Optional.ofNullable(isMailMergeEnabled);
    }

    public ComplexEntityMetadata withIsMailMergeEnabled(BooleanManagedProperty isMailMergeEnabled) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isMailMergeEnabled = isMailMergeEnabled;
        return _x;
    }

    @Property(name="IsManaged")
    @JsonIgnore
    public Optional<Boolean> getIsManaged() {
        return Optional.ofNullable(isManaged);
    }

    public ComplexEntityMetadata withIsManaged(Boolean isManaged) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isManaged = isManaged;
        return _x;
    }

    @Property(name="IsEnabledForCharts")
    @JsonIgnore
    public Optional<Boolean> getIsEnabledForCharts() {
        return Optional.ofNullable(isEnabledForCharts);
    }

    public ComplexEntityMetadata withIsEnabledForCharts(Boolean isEnabledForCharts) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isEnabledForCharts = isEnabledForCharts;
        return _x;
    }

    @Property(name="IsEnabledForTrace")
    @JsonIgnore
    public Optional<Boolean> getIsEnabledForTrace() {
        return Optional.ofNullable(isEnabledForTrace);
    }

    public ComplexEntityMetadata withIsEnabledForTrace(Boolean isEnabledForTrace) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isEnabledForTrace = isEnabledForTrace;
        return _x;
    }

    @Property(name="IsValidForAdvancedFind")
    @JsonIgnore
    public Optional<Boolean> getIsValidForAdvancedFind() {
        return Optional.ofNullable(isValidForAdvancedFind);
    }

    public ComplexEntityMetadata withIsValidForAdvancedFind(Boolean isValidForAdvancedFind) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isValidForAdvancedFind = isValidForAdvancedFind;
        return _x;
    }

    @Property(name="IsVisibleInMobile")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsVisibleInMobile() {
        return Optional.ofNullable(isVisibleInMobile);
    }

    public ComplexEntityMetadata withIsVisibleInMobile(BooleanManagedProperty isVisibleInMobile) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isVisibleInMobile = isVisibleInMobile;
        return _x;
    }

    @Property(name="IsVisibleInMobileClient")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsVisibleInMobileClient() {
        return Optional.ofNullable(isVisibleInMobileClient);
    }

    public ComplexEntityMetadata withIsVisibleInMobileClient(BooleanManagedProperty isVisibleInMobileClient) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isVisibleInMobileClient = isVisibleInMobileClient;
        return _x;
    }

    @Property(name="IsReadOnlyInMobileClient")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsReadOnlyInMobileClient() {
        return Optional.ofNullable(isReadOnlyInMobileClient);
    }

    public ComplexEntityMetadata withIsReadOnlyInMobileClient(BooleanManagedProperty isReadOnlyInMobileClient) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isReadOnlyInMobileClient = isReadOnlyInMobileClient;
        return _x;
    }

    @Property(name="IsOfflineInMobileClient")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsOfflineInMobileClient() {
        return Optional.ofNullable(isOfflineInMobileClient);
    }

    public ComplexEntityMetadata withIsOfflineInMobileClient(BooleanManagedProperty isOfflineInMobileClient) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isOfflineInMobileClient = isOfflineInMobileClient;
        return _x;
    }

    @Property(name="DaysSinceRecordLastModified")
    @JsonIgnore
    public Optional<Integer> getDaysSinceRecordLastModified() {
        return Optional.ofNullable(daysSinceRecordLastModified);
    }

    public ComplexEntityMetadata withDaysSinceRecordLastModified(Integer daysSinceRecordLastModified) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.daysSinceRecordLastModified = daysSinceRecordLastModified;
        return _x;
    }

    @Property(name="MobileOfflineFilters")
    @JsonIgnore
    public Optional<String> getMobileOfflineFilters() {
        return Optional.ofNullable(mobileOfflineFilters);
    }

    public ComplexEntityMetadata withMobileOfflineFilters(String mobileOfflineFilters) {
        Checks.checkIsAscii(mobileOfflineFilters);
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.mobileOfflineFilters = mobileOfflineFilters;
        return _x;
    }

    @Property(name="IsReadingPaneEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsReadingPaneEnabled() {
        return Optional.ofNullable(isReadingPaneEnabled);
    }

    public ComplexEntityMetadata withIsReadingPaneEnabled(Boolean isReadingPaneEnabled) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isReadingPaneEnabled = isReadingPaneEnabled;
        return _x;
    }

    @Property(name="IsQuickCreateEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsQuickCreateEnabled() {
        return Optional.ofNullable(isQuickCreateEnabled);
    }

    public ComplexEntityMetadata withIsQuickCreateEnabled(Boolean isQuickCreateEnabled) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isQuickCreateEnabled = isQuickCreateEnabled;
        return _x;
    }

    @Property(name="LogicalName")
    @JsonIgnore
    public Optional<String> getLogicalName() {
        return Optional.ofNullable(logicalName);
    }

    public ComplexEntityMetadata withLogicalName(String logicalName) {
        Checks.checkIsAscii(logicalName);
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.logicalName = logicalName;
        return _x;
    }

    @Property(name="ManyToManyRelationships")
    @JsonIgnore
    public CollectionPage<ComplexManyToManyRelationshipMetadata> getManyToManyRelationships() {
        return new CollectionPage<ComplexManyToManyRelationshipMetadata>(contextPath, ComplexManyToManyRelationshipMetadata.class, this.manyToManyRelationships, Optional.ofNullable(manyToManyRelationshipsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="ManyToManyRelationships")
    @JsonIgnore
    public CollectionPage<ComplexManyToManyRelationshipMetadata> getManyToManyRelationships(HttpRequestOptions options) {
        return new CollectionPage<ComplexManyToManyRelationshipMetadata>(contextPath, ComplexManyToManyRelationshipMetadata.class, this.manyToManyRelationships, Optional.ofNullable(manyToManyRelationshipsNextLink), Collections.emptyList(), options);
    }

    @Property(name="ManyToOneRelationships")
    @JsonIgnore
    public CollectionPage<ComplexOneToManyRelationshipMetadata> getManyToOneRelationships() {
        return new CollectionPage<ComplexOneToManyRelationshipMetadata>(contextPath, ComplexOneToManyRelationshipMetadata.class, this.manyToOneRelationships, Optional.ofNullable(manyToOneRelationshipsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="ManyToOneRelationships")
    @JsonIgnore
    public CollectionPage<ComplexOneToManyRelationshipMetadata> getManyToOneRelationships(HttpRequestOptions options) {
        return new CollectionPage<ComplexOneToManyRelationshipMetadata>(contextPath, ComplexOneToManyRelationshipMetadata.class, this.manyToOneRelationships, Optional.ofNullable(manyToOneRelationshipsNextLink), Collections.emptyList(), options);
    }

    @Property(name="OneToManyRelationships")
    @JsonIgnore
    public CollectionPage<ComplexOneToManyRelationshipMetadata> getOneToManyRelationships() {
        return new CollectionPage<ComplexOneToManyRelationshipMetadata>(contextPath, ComplexOneToManyRelationshipMetadata.class, this.oneToManyRelationships, Optional.ofNullable(oneToManyRelationshipsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="OneToManyRelationships")
    @JsonIgnore
    public CollectionPage<ComplexOneToManyRelationshipMetadata> getOneToManyRelationships(HttpRequestOptions options) {
        return new CollectionPage<ComplexOneToManyRelationshipMetadata>(contextPath, ComplexOneToManyRelationshipMetadata.class, this.oneToManyRelationships, Optional.ofNullable(oneToManyRelationshipsNextLink), Collections.emptyList(), options);
    }

    @Property(name="ObjectTypeCode")
    @JsonIgnore
    public Optional<Integer> getObjectTypeCode() {
        return Optional.ofNullable(objectTypeCode);
    }

    public ComplexEntityMetadata withObjectTypeCode(Integer objectTypeCode) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.objectTypeCode = objectTypeCode;
        return _x;
    }

    @Property(name="OwnershipType")
    @JsonIgnore
    public Optional<OwnershipTypes> getOwnershipType() {
        return Optional.ofNullable(ownershipType);
    }

    public ComplexEntityMetadata withOwnershipType(OwnershipTypes ownershipType) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.ownershipType = ownershipType;
        return _x;
    }

    @Property(name="PrimaryNameAttribute")
    @JsonIgnore
    public Optional<String> getPrimaryNameAttribute() {
        return Optional.ofNullable(primaryNameAttribute);
    }

    public ComplexEntityMetadata withPrimaryNameAttribute(String primaryNameAttribute) {
        Checks.checkIsAscii(primaryNameAttribute);
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.primaryNameAttribute = primaryNameAttribute;
        return _x;
    }

    @Property(name="PrimaryImageAttribute")
    @JsonIgnore
    public Optional<String> getPrimaryImageAttribute() {
        return Optional.ofNullable(primaryImageAttribute);
    }

    public ComplexEntityMetadata withPrimaryImageAttribute(String primaryImageAttribute) {
        Checks.checkIsAscii(primaryImageAttribute);
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.primaryImageAttribute = primaryImageAttribute;
        return _x;
    }

    @Property(name="PrimaryIdAttribute")
    @JsonIgnore
    public Optional<String> getPrimaryIdAttribute() {
        return Optional.ofNullable(primaryIdAttribute);
    }

    public ComplexEntityMetadata withPrimaryIdAttribute(String primaryIdAttribute) {
        Checks.checkIsAscii(primaryIdAttribute);
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.primaryIdAttribute = primaryIdAttribute;
        return _x;
    }

    @Property(name="Privileges")
    @JsonIgnore
    public CollectionPage<SecurityPrivilegeMetadata> getPrivileges() {
        return new CollectionPage<SecurityPrivilegeMetadata>(contextPath, SecurityPrivilegeMetadata.class, this.privileges, Optional.ofNullable(privilegesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Privileges")
    @JsonIgnore
    public CollectionPage<SecurityPrivilegeMetadata> getPrivileges(HttpRequestOptions options) {
        return new CollectionPage<SecurityPrivilegeMetadata>(contextPath, SecurityPrivilegeMetadata.class, this.privileges, Optional.ofNullable(privilegesNextLink), Collections.emptyList(), options);
    }

    @Property(name="RecurrenceBaseEntityLogicalName")
    @JsonIgnore
    public Optional<String> getRecurrenceBaseEntityLogicalName() {
        return Optional.ofNullable(recurrenceBaseEntityLogicalName);
    }

    public ComplexEntityMetadata withRecurrenceBaseEntityLogicalName(String recurrenceBaseEntityLogicalName) {
        Checks.checkIsAscii(recurrenceBaseEntityLogicalName);
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.recurrenceBaseEntityLogicalName = recurrenceBaseEntityLogicalName;
        return _x;
    }

    @Property(name="ReportViewName")
    @JsonIgnore
    public Optional<String> getReportViewName() {
        return Optional.ofNullable(reportViewName);
    }

    public ComplexEntityMetadata withReportViewName(String reportViewName) {
        Checks.checkIsAscii(reportViewName);
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.reportViewName = reportViewName;
        return _x;
    }

    @Property(name="SchemaName")
    @JsonIgnore
    public Optional<String> getSchemaName() {
        return Optional.ofNullable(schemaName);
    }

    public ComplexEntityMetadata withSchemaName(String schemaName) {
        Checks.checkIsAscii(schemaName);
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.schemaName = schemaName;
        return _x;
    }

    @Property(name="IntroducedVersion")
    @JsonIgnore
    public Optional<String> getIntroducedVersion() {
        return Optional.ofNullable(introducedVersion);
    }

    public ComplexEntityMetadata withIntroducedVersion(String introducedVersion) {
        Checks.checkIsAscii(introducedVersion);
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.introducedVersion = introducedVersion;
        return _x;
    }

    @Property(name="IsStateModelAware")
    @JsonIgnore
    public Optional<Boolean> getIsStateModelAware() {
        return Optional.ofNullable(isStateModelAware);
    }

    public ComplexEntityMetadata withIsStateModelAware(Boolean isStateModelAware) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isStateModelAware = isStateModelAware;
        return _x;
    }

    @Property(name="EnforceStateTransitions")
    @JsonIgnore
    public Optional<Boolean> getEnforceStateTransitions() {
        return Optional.ofNullable(enforceStateTransitions);
    }

    public ComplexEntityMetadata withEnforceStateTransitions(Boolean enforceStateTransitions) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.enforceStateTransitions = enforceStateTransitions;
        return _x;
    }

    @Property(name="ExternalName")
    @JsonIgnore
    public Optional<String> getExternalName() {
        return Optional.ofNullable(externalName);
    }

    public ComplexEntityMetadata withExternalName(String externalName) {
        Checks.checkIsAscii(externalName);
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.externalName = externalName;
        return _x;
    }

    @Property(name="EntityColor")
    @JsonIgnore
    public Optional<String> getEntityColor() {
        return Optional.ofNullable(entityColor);
    }

    public ComplexEntityMetadata withEntityColor(String entityColor) {
        Checks.checkIsAscii(entityColor);
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.entityColor = entityColor;
        return _x;
    }

    @Property(name="Keys")
    @JsonIgnore
    public CollectionPage<ComplexEntityKeyMetadata> getKeys() {
        return new CollectionPage<ComplexEntityKeyMetadata>(contextPath, ComplexEntityKeyMetadata.class, this.keys, Optional.ofNullable(keysNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Keys")
    @JsonIgnore
    public CollectionPage<ComplexEntityKeyMetadata> getKeys(HttpRequestOptions options) {
        return new CollectionPage<ComplexEntityKeyMetadata>(contextPath, ComplexEntityKeyMetadata.class, this.keys, Optional.ofNullable(keysNextLink), Collections.emptyList(), options);
    }

    @Property(name="LogicalCollectionName")
    @JsonIgnore
    public Optional<String> getLogicalCollectionName() {
        return Optional.ofNullable(logicalCollectionName);
    }

    public ComplexEntityMetadata withLogicalCollectionName(String logicalCollectionName) {
        Checks.checkIsAscii(logicalCollectionName);
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.logicalCollectionName = logicalCollectionName;
        return _x;
    }

    @Property(name="ExternalCollectionName")
    @JsonIgnore
    public Optional<String> getExternalCollectionName() {
        return Optional.ofNullable(externalCollectionName);
    }

    public ComplexEntityMetadata withExternalCollectionName(String externalCollectionName) {
        Checks.checkIsAscii(externalCollectionName);
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.externalCollectionName = externalCollectionName;
        return _x;
    }

    @Property(name="CollectionSchemaName")
    @JsonIgnore
    public Optional<String> getCollectionSchemaName() {
        return Optional.ofNullable(collectionSchemaName);
    }

    public ComplexEntityMetadata withCollectionSchemaName(String collectionSchemaName) {
        Checks.checkIsAscii(collectionSchemaName);
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.collectionSchemaName = collectionSchemaName;
        return _x;
    }

    @Property(name="EntitySetName")
    @JsonIgnore
    public Optional<String> getEntitySetName() {
        return Optional.ofNullable(entitySetName);
    }

    public ComplexEntityMetadata withEntitySetName(String entitySetName) {
        Checks.checkIsAscii(entitySetName);
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.entitySetName = entitySetName;
        return _x;
    }

    @Property(name="IsEnabledForExternalChannels")
    @JsonIgnore
    public Optional<Boolean> getIsEnabledForExternalChannels() {
        return Optional.ofNullable(isEnabledForExternalChannels);
    }

    public ComplexEntityMetadata withIsEnabledForExternalChannels(Boolean isEnabledForExternalChannels) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isEnabledForExternalChannels = isEnabledForExternalChannels;
        return _x;
    }

    @Property(name="IsPrivate")
    @JsonIgnore
    public Optional<Boolean> getIsPrivate() {
        return Optional.ofNullable(isPrivate);
    }

    public ComplexEntityMetadata withIsPrivate(Boolean isPrivate) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isPrivate = isPrivate;
        return _x;
    }

    @Property(name="UsesBusinessDataLabelTable")
    @JsonIgnore
    public Optional<Boolean> getUsesBusinessDataLabelTable() {
        return Optional.ofNullable(usesBusinessDataLabelTable);
    }

    public ComplexEntityMetadata withUsesBusinessDataLabelTable(Boolean usesBusinessDataLabelTable) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.usesBusinessDataLabelTable = usesBusinessDataLabelTable;
        return _x;
    }

    @Property(name="IsLogicalEntity")
    @JsonIgnore
    public Optional<Boolean> getIsLogicalEntity() {
        return Optional.ofNullable(isLogicalEntity);
    }

    public ComplexEntityMetadata withIsLogicalEntity(Boolean isLogicalEntity) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isLogicalEntity = isLogicalEntity;
        return _x;
    }

    @Property(name="HasNotes")
    @JsonIgnore
    public Optional<Boolean> getHasNotes() {
        return Optional.ofNullable(hasNotes);
    }

    public ComplexEntityMetadata withHasNotes(Boolean hasNotes) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.hasNotes = hasNotes;
        return _x;
    }

    @Property(name="HasActivities")
    @JsonIgnore
    public Optional<Boolean> getHasActivities() {
        return Optional.ofNullable(hasActivities);
    }

    public ComplexEntityMetadata withHasActivities(Boolean hasActivities) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.hasActivities = hasActivities;
        return _x;
    }

    @Property(name="HasFeedback")
    @JsonIgnore
    public Optional<Boolean> getHasFeedback() {
        return Optional.ofNullable(hasFeedback);
    }

    public ComplexEntityMetadata withHasFeedback(Boolean hasFeedback) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.hasFeedback = hasFeedback;
        return _x;
    }

    @Property(name="IsSolutionAware")
    @JsonIgnore
    public Optional<Boolean> getIsSolutionAware() {
        return Optional.ofNullable(isSolutionAware);
    }

    public ComplexEntityMetadata withIsSolutionAware(Boolean isSolutionAware) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.isSolutionAware = isSolutionAware;
        return _x;
    }

    @Property(name="Settings")
    @JsonIgnore
    public CollectionPage<EntitySetting> getSettings() {
        return new CollectionPage<EntitySetting>(contextPath, EntitySetting.class, this.settings, Optional.ofNullable(settingsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Settings")
    @JsonIgnore
    public CollectionPage<EntitySetting> getSettings(HttpRequestOptions options) {
        return new CollectionPage<EntitySetting>(contextPath, EntitySetting.class, this.settings, Optional.ofNullable(settingsNextLink), Collections.emptyList(), options);
    }

    @Property(name="CreatedOn")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedOn() {
        return Optional.ofNullable(createdOn);
    }

    public ComplexEntityMetadata withCreatedOn(OffsetDateTime createdOn) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.createdOn = createdOn;
        return _x;
    }

    @Property(name="ModifiedOn")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedOn() {
        return Optional.ofNullable(modifiedOn);
    }

    public ComplexEntityMetadata withModifiedOn(OffsetDateTime modifiedOn) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.modifiedOn = modifiedOn;
        return _x;
    }

    @Property(name="MetadataId")
    @JsonIgnore
    public Optional<String> getMetadataId() {
        return Optional.ofNullable(metadataId);
    }

    public ComplexEntityMetadata withMetadataId(String metadataId) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.metadataId = metadataId;
        return _x;
    }

    @Property(name="HasChanged")
    @JsonIgnore
    public Optional<Boolean> getHasChanged() {
        return Optional.ofNullable(hasChanged);
    }

    public ComplexEntityMetadata withHasChanged(Boolean hasChanged) {
        ComplexEntityMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityMetadata");
        _x.hasChanged = hasChanged;
        return _x;
    }

    public ComplexEntityMetadata withUnmappedField(String name, String value) {
        ComplexEntityMetadata _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer activityTypeMask;
        private List<ComplexAttributeMetadata> attributes;
        private String attributesNextLink;
        private Boolean autoRouteToOwnerQueue;
        private Boolean canTriggerWorkflow;
        private Label description;
        private Label displayCollectionName;
        private Label displayName;
        private Boolean entityHelpUrlEnabled;
        private String entityHelpUrl;
        private Boolean isDocumentManagementEnabled;
        private Boolean isOneNoteIntegrationEnabled;
        private Boolean isInteractionCentricEnabled;
        private Boolean isKnowledgeManagementEnabled;
        private Boolean isSLAEnabled;
        private Boolean isBPFEntity;
        private Boolean isDocumentRecommendationsEnabled;
        private Boolean isMSTeamsIntegrationEnabled;
        private String settingOf;
        private String dataProviderId;
        private String dataSourceId;
        private Boolean autoCreateAccessTeams;
        private Boolean isActivity;
        private Boolean isActivityParty;
        private BooleanManagedProperty isAuditEnabled;
        private Boolean isAvailableOffline;
        private Boolean isChildEntity;
        private Boolean isAIRUpdated;
        private BooleanManagedProperty isValidForQueue;
        private BooleanManagedProperty isConnectionsEnabled;
        private String iconLargeName;
        private String iconMediumName;
        private String iconSmallName;
        private String iconVectorName;
        private Boolean isCustomEntity;
        private Boolean isBusinessProcessEnabled;
        private BooleanManagedProperty isCustomizable;
        private BooleanManagedProperty isRenameable;
        private BooleanManagedProperty isMappable;
        private BooleanManagedProperty isDuplicateDetectionEnabled;
        private BooleanManagedProperty canCreateAttributes;
        private BooleanManagedProperty canCreateForms;
        private BooleanManagedProperty canCreateViews;
        private BooleanManagedProperty canCreateCharts;
        private BooleanManagedProperty canBeRelatedEntityInRelationship;
        private BooleanManagedProperty canBePrimaryEntityInRelationship;
        private BooleanManagedProperty canBeInManyToMany;
        private BooleanManagedProperty canBeInCustomEntityAssociation;
        private BooleanManagedProperty canEnableSyncToExternalSearchIndex;
        private Boolean syncToExternalSearchIndex;
        private BooleanManagedProperty canModifyAdditionalSettings;
        private BooleanManagedProperty canChangeHierarchicalRelationship;
        private Boolean isOptimisticConcurrencyEnabled;
        private Boolean changeTrackingEnabled;
        private BooleanManagedProperty canChangeTrackingBeEnabled;
        private Boolean isImportable;
        private Boolean isIntersect;
        private BooleanManagedProperty isMailMergeEnabled;
        private Boolean isManaged;
        private Boolean isEnabledForCharts;
        private Boolean isEnabledForTrace;
        private Boolean isValidForAdvancedFind;
        private BooleanManagedProperty isVisibleInMobile;
        private BooleanManagedProperty isVisibleInMobileClient;
        private BooleanManagedProperty isReadOnlyInMobileClient;
        private BooleanManagedProperty isOfflineInMobileClient;
        private Integer daysSinceRecordLastModified;
        private String mobileOfflineFilters;
        private Boolean isReadingPaneEnabled;
        private Boolean isQuickCreateEnabled;
        private String logicalName;
        private List<ComplexManyToManyRelationshipMetadata> manyToManyRelationships;
        private String manyToManyRelationshipsNextLink;
        private List<ComplexOneToManyRelationshipMetadata> manyToOneRelationships;
        private String manyToOneRelationshipsNextLink;
        private List<ComplexOneToManyRelationshipMetadata> oneToManyRelationships;
        private String oneToManyRelationshipsNextLink;
        private Integer objectTypeCode;
        private OwnershipTypes ownershipType;
        private String primaryNameAttribute;
        private String primaryImageAttribute;
        private String primaryIdAttribute;
        private List<SecurityPrivilegeMetadata> privileges;
        private String privilegesNextLink;
        private String recurrenceBaseEntityLogicalName;
        private String reportViewName;
        private String schemaName;
        private String introducedVersion;
        private Boolean isStateModelAware;
        private Boolean enforceStateTransitions;
        private String externalName;
        private String entityColor;
        private List<ComplexEntityKeyMetadata> keys;
        private String keysNextLink;
        private String logicalCollectionName;
        private String externalCollectionName;
        private String collectionSchemaName;
        private String entitySetName;
        private Boolean isEnabledForExternalChannels;
        private Boolean isPrivate;
        private Boolean usesBusinessDataLabelTable;
        private Boolean isLogicalEntity;
        private Boolean hasNotes;
        private Boolean hasActivities;
        private Boolean hasFeedback;
        private Boolean isSolutionAware;
        private List<EntitySetting> settings;
        private String settingsNextLink;
        private OffsetDateTime createdOn;
        private OffsetDateTime modifiedOn;
        private String metadataId;
        private Boolean hasChanged;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder activityTypeMask(Integer activityTypeMask) {
            this.activityTypeMask = activityTypeMask;
            this.changedFields = changedFields.add("ActivityTypeMask");
            return this;
        }

        public Builder attributes(List<ComplexAttributeMetadata> attributes) {
            this.attributes = attributes;
            this.changedFields = changedFields.add("Attributes");
            return this;
        }

        public Builder attributes(ComplexAttributeMetadata... attributes) {
            return attributes(Arrays.asList(attributes));
        }

        public Builder attributesNextLink(String attributesNextLink) {
            this.attributesNextLink = attributesNextLink;
            this.changedFields = changedFields.add("Attributes");
            return this;
        }

        public Builder autoRouteToOwnerQueue(Boolean autoRouteToOwnerQueue) {
            this.autoRouteToOwnerQueue = autoRouteToOwnerQueue;
            this.changedFields = changedFields.add("AutoRouteToOwnerQueue");
            return this;
        }

        public Builder canTriggerWorkflow(Boolean canTriggerWorkflow) {
            this.canTriggerWorkflow = canTriggerWorkflow;
            this.changedFields = changedFields.add("CanTriggerWorkflow");
            return this;
        }

        public Builder description(Label description) {
            this.description = description;
            this.changedFields = changedFields.add("Description");
            return this;
        }

        public Builder displayCollectionName(Label displayCollectionName) {
            this.displayCollectionName = displayCollectionName;
            this.changedFields = changedFields.add("DisplayCollectionName");
            return this;
        }

        public Builder displayName(Label displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("DisplayName");
            return this;
        }

        public Builder entityHelpUrlEnabled(Boolean entityHelpUrlEnabled) {
            this.entityHelpUrlEnabled = entityHelpUrlEnabled;
            this.changedFields = changedFields.add("EntityHelpUrlEnabled");
            return this;
        }

        public Builder entityHelpUrl(String entityHelpUrl) {
            this.entityHelpUrl = entityHelpUrl;
            this.changedFields = changedFields.add("EntityHelpUrl");
            return this;
        }

        public Builder isDocumentManagementEnabled(Boolean isDocumentManagementEnabled) {
            this.isDocumentManagementEnabled = isDocumentManagementEnabled;
            this.changedFields = changedFields.add("IsDocumentManagementEnabled");
            return this;
        }

        public Builder isOneNoteIntegrationEnabled(Boolean isOneNoteIntegrationEnabled) {
            this.isOneNoteIntegrationEnabled = isOneNoteIntegrationEnabled;
            this.changedFields = changedFields.add("IsOneNoteIntegrationEnabled");
            return this;
        }

        public Builder isInteractionCentricEnabled(Boolean isInteractionCentricEnabled) {
            this.isInteractionCentricEnabled = isInteractionCentricEnabled;
            this.changedFields = changedFields.add("IsInteractionCentricEnabled");
            return this;
        }

        public Builder isKnowledgeManagementEnabled(Boolean isKnowledgeManagementEnabled) {
            this.isKnowledgeManagementEnabled = isKnowledgeManagementEnabled;
            this.changedFields = changedFields.add("IsKnowledgeManagementEnabled");
            return this;
        }

        public Builder isSLAEnabled(Boolean isSLAEnabled) {
            this.isSLAEnabled = isSLAEnabled;
            this.changedFields = changedFields.add("IsSLAEnabled");
            return this;
        }

        public Builder isBPFEntity(Boolean isBPFEntity) {
            this.isBPFEntity = isBPFEntity;
            this.changedFields = changedFields.add("IsBPFEntity");
            return this;
        }

        public Builder isDocumentRecommendationsEnabled(Boolean isDocumentRecommendationsEnabled) {
            this.isDocumentRecommendationsEnabled = isDocumentRecommendationsEnabled;
            this.changedFields = changedFields.add("IsDocumentRecommendationsEnabled");
            return this;
        }

        public Builder isMSTeamsIntegrationEnabled(Boolean isMSTeamsIntegrationEnabled) {
            this.isMSTeamsIntegrationEnabled = isMSTeamsIntegrationEnabled;
            this.changedFields = changedFields.add("IsMSTeamsIntegrationEnabled");
            return this;
        }

        public Builder settingOf(String settingOf) {
            this.settingOf = settingOf;
            this.changedFields = changedFields.add("SettingOf");
            return this;
        }

        public Builder dataProviderId(String dataProviderId) {
            this.dataProviderId = dataProviderId;
            this.changedFields = changedFields.add("DataProviderId");
            return this;
        }

        public Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            this.changedFields = changedFields.add("DataSourceId");
            return this;
        }

        public Builder autoCreateAccessTeams(Boolean autoCreateAccessTeams) {
            this.autoCreateAccessTeams = autoCreateAccessTeams;
            this.changedFields = changedFields.add("AutoCreateAccessTeams");
            return this;
        }

        public Builder isActivity(Boolean isActivity) {
            this.isActivity = isActivity;
            this.changedFields = changedFields.add("IsActivity");
            return this;
        }

        public Builder isActivityParty(Boolean isActivityParty) {
            this.isActivityParty = isActivityParty;
            this.changedFields = changedFields.add("IsActivityParty");
            return this;
        }

        public Builder isAuditEnabled(BooleanManagedProperty isAuditEnabled) {
            this.isAuditEnabled = isAuditEnabled;
            this.changedFields = changedFields.add("IsAuditEnabled");
            return this;
        }

        public Builder isAvailableOffline(Boolean isAvailableOffline) {
            this.isAvailableOffline = isAvailableOffline;
            this.changedFields = changedFields.add("IsAvailableOffline");
            return this;
        }

        public Builder isChildEntity(Boolean isChildEntity) {
            this.isChildEntity = isChildEntity;
            this.changedFields = changedFields.add("IsChildEntity");
            return this;
        }

        public Builder isAIRUpdated(Boolean isAIRUpdated) {
            this.isAIRUpdated = isAIRUpdated;
            this.changedFields = changedFields.add("IsAIRUpdated");
            return this;
        }

        public Builder isValidForQueue(BooleanManagedProperty isValidForQueue) {
            this.isValidForQueue = isValidForQueue;
            this.changedFields = changedFields.add("IsValidForQueue");
            return this;
        }

        public Builder isConnectionsEnabled(BooleanManagedProperty isConnectionsEnabled) {
            this.isConnectionsEnabled = isConnectionsEnabled;
            this.changedFields = changedFields.add("IsConnectionsEnabled");
            return this;
        }

        public Builder iconLargeName(String iconLargeName) {
            this.iconLargeName = iconLargeName;
            this.changedFields = changedFields.add("IconLargeName");
            return this;
        }

        public Builder iconMediumName(String iconMediumName) {
            this.iconMediumName = iconMediumName;
            this.changedFields = changedFields.add("IconMediumName");
            return this;
        }

        public Builder iconSmallName(String iconSmallName) {
            this.iconSmallName = iconSmallName;
            this.changedFields = changedFields.add("IconSmallName");
            return this;
        }

        public Builder iconVectorName(String iconVectorName) {
            this.iconVectorName = iconVectorName;
            this.changedFields = changedFields.add("IconVectorName");
            return this;
        }

        public Builder isCustomEntity(Boolean isCustomEntity) {
            this.isCustomEntity = isCustomEntity;
            this.changedFields = changedFields.add("IsCustomEntity");
            return this;
        }

        public Builder isBusinessProcessEnabled(Boolean isBusinessProcessEnabled) {
            this.isBusinessProcessEnabled = isBusinessProcessEnabled;
            this.changedFields = changedFields.add("IsBusinessProcessEnabled");
            return this;
        }

        public Builder isCustomizable(BooleanManagedProperty isCustomizable) {
            this.isCustomizable = isCustomizable;
            this.changedFields = changedFields.add("IsCustomizable");
            return this;
        }

        public Builder isRenameable(BooleanManagedProperty isRenameable) {
            this.isRenameable = isRenameable;
            this.changedFields = changedFields.add("IsRenameable");
            return this;
        }

        public Builder isMappable(BooleanManagedProperty isMappable) {
            this.isMappable = isMappable;
            this.changedFields = changedFields.add("IsMappable");
            return this;
        }

        public Builder isDuplicateDetectionEnabled(BooleanManagedProperty isDuplicateDetectionEnabled) {
            this.isDuplicateDetectionEnabled = isDuplicateDetectionEnabled;
            this.changedFields = changedFields.add("IsDuplicateDetectionEnabled");
            return this;
        }

        public Builder canCreateAttributes(BooleanManagedProperty canCreateAttributes) {
            this.canCreateAttributes = canCreateAttributes;
            this.changedFields = changedFields.add("CanCreateAttributes");
            return this;
        }

        public Builder canCreateForms(BooleanManagedProperty canCreateForms) {
            this.canCreateForms = canCreateForms;
            this.changedFields = changedFields.add("CanCreateForms");
            return this;
        }

        public Builder canCreateViews(BooleanManagedProperty canCreateViews) {
            this.canCreateViews = canCreateViews;
            this.changedFields = changedFields.add("CanCreateViews");
            return this;
        }

        public Builder canCreateCharts(BooleanManagedProperty canCreateCharts) {
            this.canCreateCharts = canCreateCharts;
            this.changedFields = changedFields.add("CanCreateCharts");
            return this;
        }

        public Builder canBeRelatedEntityInRelationship(BooleanManagedProperty canBeRelatedEntityInRelationship) {
            this.canBeRelatedEntityInRelationship = canBeRelatedEntityInRelationship;
            this.changedFields = changedFields.add("CanBeRelatedEntityInRelationship");
            return this;
        }

        public Builder canBePrimaryEntityInRelationship(BooleanManagedProperty canBePrimaryEntityInRelationship) {
            this.canBePrimaryEntityInRelationship = canBePrimaryEntityInRelationship;
            this.changedFields = changedFields.add("CanBePrimaryEntityInRelationship");
            return this;
        }

        public Builder canBeInManyToMany(BooleanManagedProperty canBeInManyToMany) {
            this.canBeInManyToMany = canBeInManyToMany;
            this.changedFields = changedFields.add("CanBeInManyToMany");
            return this;
        }

        public Builder canBeInCustomEntityAssociation(BooleanManagedProperty canBeInCustomEntityAssociation) {
            this.canBeInCustomEntityAssociation = canBeInCustomEntityAssociation;
            this.changedFields = changedFields.add("CanBeInCustomEntityAssociation");
            return this;
        }

        public Builder canEnableSyncToExternalSearchIndex(BooleanManagedProperty canEnableSyncToExternalSearchIndex) {
            this.canEnableSyncToExternalSearchIndex = canEnableSyncToExternalSearchIndex;
            this.changedFields = changedFields.add("CanEnableSyncToExternalSearchIndex");
            return this;
        }

        public Builder syncToExternalSearchIndex(Boolean syncToExternalSearchIndex) {
            this.syncToExternalSearchIndex = syncToExternalSearchIndex;
            this.changedFields = changedFields.add("SyncToExternalSearchIndex");
            return this;
        }

        public Builder canModifyAdditionalSettings(BooleanManagedProperty canModifyAdditionalSettings) {
            this.canModifyAdditionalSettings = canModifyAdditionalSettings;
            this.changedFields = changedFields.add("CanModifyAdditionalSettings");
            return this;
        }

        public Builder canChangeHierarchicalRelationship(BooleanManagedProperty canChangeHierarchicalRelationship) {
            this.canChangeHierarchicalRelationship = canChangeHierarchicalRelationship;
            this.changedFields = changedFields.add("CanChangeHierarchicalRelationship");
            return this;
        }

        public Builder isOptimisticConcurrencyEnabled(Boolean isOptimisticConcurrencyEnabled) {
            this.isOptimisticConcurrencyEnabled = isOptimisticConcurrencyEnabled;
            this.changedFields = changedFields.add("IsOptimisticConcurrencyEnabled");
            return this;
        }

        public Builder changeTrackingEnabled(Boolean changeTrackingEnabled) {
            this.changeTrackingEnabled = changeTrackingEnabled;
            this.changedFields = changedFields.add("ChangeTrackingEnabled");
            return this;
        }

        public Builder canChangeTrackingBeEnabled(BooleanManagedProperty canChangeTrackingBeEnabled) {
            this.canChangeTrackingBeEnabled = canChangeTrackingBeEnabled;
            this.changedFields = changedFields.add("CanChangeTrackingBeEnabled");
            return this;
        }

        public Builder isImportable(Boolean isImportable) {
            this.isImportable = isImportable;
            this.changedFields = changedFields.add("IsImportable");
            return this;
        }

        public Builder isIntersect(Boolean isIntersect) {
            this.isIntersect = isIntersect;
            this.changedFields = changedFields.add("IsIntersect");
            return this;
        }

        public Builder isMailMergeEnabled(BooleanManagedProperty isMailMergeEnabled) {
            this.isMailMergeEnabled = isMailMergeEnabled;
            this.changedFields = changedFields.add("IsMailMergeEnabled");
            return this;
        }

        public Builder isManaged(Boolean isManaged) {
            this.isManaged = isManaged;
            this.changedFields = changedFields.add("IsManaged");
            return this;
        }

        public Builder isEnabledForCharts(Boolean isEnabledForCharts) {
            this.isEnabledForCharts = isEnabledForCharts;
            this.changedFields = changedFields.add("IsEnabledForCharts");
            return this;
        }

        public Builder isEnabledForTrace(Boolean isEnabledForTrace) {
            this.isEnabledForTrace = isEnabledForTrace;
            this.changedFields = changedFields.add("IsEnabledForTrace");
            return this;
        }

        public Builder isValidForAdvancedFind(Boolean isValidForAdvancedFind) {
            this.isValidForAdvancedFind = isValidForAdvancedFind;
            this.changedFields = changedFields.add("IsValidForAdvancedFind");
            return this;
        }

        public Builder isVisibleInMobile(BooleanManagedProperty isVisibleInMobile) {
            this.isVisibleInMobile = isVisibleInMobile;
            this.changedFields = changedFields.add("IsVisibleInMobile");
            return this;
        }

        public Builder isVisibleInMobileClient(BooleanManagedProperty isVisibleInMobileClient) {
            this.isVisibleInMobileClient = isVisibleInMobileClient;
            this.changedFields = changedFields.add("IsVisibleInMobileClient");
            return this;
        }

        public Builder isReadOnlyInMobileClient(BooleanManagedProperty isReadOnlyInMobileClient) {
            this.isReadOnlyInMobileClient = isReadOnlyInMobileClient;
            this.changedFields = changedFields.add("IsReadOnlyInMobileClient");
            return this;
        }

        public Builder isOfflineInMobileClient(BooleanManagedProperty isOfflineInMobileClient) {
            this.isOfflineInMobileClient = isOfflineInMobileClient;
            this.changedFields = changedFields.add("IsOfflineInMobileClient");
            return this;
        }

        public Builder daysSinceRecordLastModified(Integer daysSinceRecordLastModified) {
            this.daysSinceRecordLastModified = daysSinceRecordLastModified;
            this.changedFields = changedFields.add("DaysSinceRecordLastModified");
            return this;
        }

        public Builder mobileOfflineFilters(String mobileOfflineFilters) {
            this.mobileOfflineFilters = mobileOfflineFilters;
            this.changedFields = changedFields.add("MobileOfflineFilters");
            return this;
        }

        public Builder isReadingPaneEnabled(Boolean isReadingPaneEnabled) {
            this.isReadingPaneEnabled = isReadingPaneEnabled;
            this.changedFields = changedFields.add("IsReadingPaneEnabled");
            return this;
        }

        public Builder isQuickCreateEnabled(Boolean isQuickCreateEnabled) {
            this.isQuickCreateEnabled = isQuickCreateEnabled;
            this.changedFields = changedFields.add("IsQuickCreateEnabled");
            return this;
        }

        public Builder logicalName(String logicalName) {
            this.logicalName = logicalName;
            this.changedFields = changedFields.add("LogicalName");
            return this;
        }

        public Builder manyToManyRelationships(List<ComplexManyToManyRelationshipMetadata> manyToManyRelationships) {
            this.manyToManyRelationships = manyToManyRelationships;
            this.changedFields = changedFields.add("ManyToManyRelationships");
            return this;
        }

        public Builder manyToManyRelationships(ComplexManyToManyRelationshipMetadata... manyToManyRelationships) {
            return manyToManyRelationships(Arrays.asList(manyToManyRelationships));
        }

        public Builder manyToManyRelationshipsNextLink(String manyToManyRelationshipsNextLink) {
            this.manyToManyRelationshipsNextLink = manyToManyRelationshipsNextLink;
            this.changedFields = changedFields.add("ManyToManyRelationships");
            return this;
        }

        public Builder manyToOneRelationships(List<ComplexOneToManyRelationshipMetadata> manyToOneRelationships) {
            this.manyToOneRelationships = manyToOneRelationships;
            this.changedFields = changedFields.add("ManyToOneRelationships");
            return this;
        }

        public Builder manyToOneRelationships(ComplexOneToManyRelationshipMetadata... manyToOneRelationships) {
            return manyToOneRelationships(Arrays.asList(manyToOneRelationships));
        }

        public Builder manyToOneRelationshipsNextLink(String manyToOneRelationshipsNextLink) {
            this.manyToOneRelationshipsNextLink = manyToOneRelationshipsNextLink;
            this.changedFields = changedFields.add("ManyToOneRelationships");
            return this;
        }

        public Builder oneToManyRelationships(List<ComplexOneToManyRelationshipMetadata> oneToManyRelationships) {
            this.oneToManyRelationships = oneToManyRelationships;
            this.changedFields = changedFields.add("OneToManyRelationships");
            return this;
        }

        public Builder oneToManyRelationships(ComplexOneToManyRelationshipMetadata... oneToManyRelationships) {
            return oneToManyRelationships(Arrays.asList(oneToManyRelationships));
        }

        public Builder oneToManyRelationshipsNextLink(String oneToManyRelationshipsNextLink) {
            this.oneToManyRelationshipsNextLink = oneToManyRelationshipsNextLink;
            this.changedFields = changedFields.add("OneToManyRelationships");
            return this;
        }

        public Builder objectTypeCode(Integer objectTypeCode) {
            this.objectTypeCode = objectTypeCode;
            this.changedFields = changedFields.add("ObjectTypeCode");
            return this;
        }

        public Builder ownershipType(OwnershipTypes ownershipType) {
            this.ownershipType = ownershipType;
            this.changedFields = changedFields.add("OwnershipType");
            return this;
        }

        public Builder primaryNameAttribute(String primaryNameAttribute) {
            this.primaryNameAttribute = primaryNameAttribute;
            this.changedFields = changedFields.add("PrimaryNameAttribute");
            return this;
        }

        public Builder primaryImageAttribute(String primaryImageAttribute) {
            this.primaryImageAttribute = primaryImageAttribute;
            this.changedFields = changedFields.add("PrimaryImageAttribute");
            return this;
        }

        public Builder primaryIdAttribute(String primaryIdAttribute) {
            this.primaryIdAttribute = primaryIdAttribute;
            this.changedFields = changedFields.add("PrimaryIdAttribute");
            return this;
        }

        public Builder privileges(List<SecurityPrivilegeMetadata> privileges) {
            this.privileges = privileges;
            this.changedFields = changedFields.add("Privileges");
            return this;
        }

        public Builder privileges(SecurityPrivilegeMetadata... privileges) {
            return privileges(Arrays.asList(privileges));
        }

        public Builder privilegesNextLink(String privilegesNextLink) {
            this.privilegesNextLink = privilegesNextLink;
            this.changedFields = changedFields.add("Privileges");
            return this;
        }

        public Builder recurrenceBaseEntityLogicalName(String recurrenceBaseEntityLogicalName) {
            this.recurrenceBaseEntityLogicalName = recurrenceBaseEntityLogicalName;
            this.changedFields = changedFields.add("RecurrenceBaseEntityLogicalName");
            return this;
        }

        public Builder reportViewName(String reportViewName) {
            this.reportViewName = reportViewName;
            this.changedFields = changedFields.add("ReportViewName");
            return this;
        }

        public Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            this.changedFields = changedFields.add("SchemaName");
            return this;
        }

        public Builder introducedVersion(String introducedVersion) {
            this.introducedVersion = introducedVersion;
            this.changedFields = changedFields.add("IntroducedVersion");
            return this;
        }

        public Builder isStateModelAware(Boolean isStateModelAware) {
            this.isStateModelAware = isStateModelAware;
            this.changedFields = changedFields.add("IsStateModelAware");
            return this;
        }

        public Builder enforceStateTransitions(Boolean enforceStateTransitions) {
            this.enforceStateTransitions = enforceStateTransitions;
            this.changedFields = changedFields.add("EnforceStateTransitions");
            return this;
        }

        public Builder externalName(String externalName) {
            this.externalName = externalName;
            this.changedFields = changedFields.add("ExternalName");
            return this;
        }

        public Builder entityColor(String entityColor) {
            this.entityColor = entityColor;
            this.changedFields = changedFields.add("EntityColor");
            return this;
        }

        public Builder keys(List<ComplexEntityKeyMetadata> keys) {
            this.keys = keys;
            this.changedFields = changedFields.add("Keys");
            return this;
        }

        public Builder keys(ComplexEntityKeyMetadata... keys) {
            return keys(Arrays.asList(keys));
        }

        public Builder keysNextLink(String keysNextLink) {
            this.keysNextLink = keysNextLink;
            this.changedFields = changedFields.add("Keys");
            return this;
        }

        public Builder logicalCollectionName(String logicalCollectionName) {
            this.logicalCollectionName = logicalCollectionName;
            this.changedFields = changedFields.add("LogicalCollectionName");
            return this;
        }

        public Builder externalCollectionName(String externalCollectionName) {
            this.externalCollectionName = externalCollectionName;
            this.changedFields = changedFields.add("ExternalCollectionName");
            return this;
        }

        public Builder collectionSchemaName(String collectionSchemaName) {
            this.collectionSchemaName = collectionSchemaName;
            this.changedFields = changedFields.add("CollectionSchemaName");
            return this;
        }

        public Builder entitySetName(String entitySetName) {
            this.entitySetName = entitySetName;
            this.changedFields = changedFields.add("EntitySetName");
            return this;
        }

        public Builder isEnabledForExternalChannels(Boolean isEnabledForExternalChannels) {
            this.isEnabledForExternalChannels = isEnabledForExternalChannels;
            this.changedFields = changedFields.add("IsEnabledForExternalChannels");
            return this;
        }

        public Builder isPrivate(Boolean isPrivate) {
            this.isPrivate = isPrivate;
            this.changedFields = changedFields.add("IsPrivate");
            return this;
        }

        public Builder usesBusinessDataLabelTable(Boolean usesBusinessDataLabelTable) {
            this.usesBusinessDataLabelTable = usesBusinessDataLabelTable;
            this.changedFields = changedFields.add("UsesBusinessDataLabelTable");
            return this;
        }

        public Builder isLogicalEntity(Boolean isLogicalEntity) {
            this.isLogicalEntity = isLogicalEntity;
            this.changedFields = changedFields.add("IsLogicalEntity");
            return this;
        }

        public Builder hasNotes(Boolean hasNotes) {
            this.hasNotes = hasNotes;
            this.changedFields = changedFields.add("HasNotes");
            return this;
        }

        public Builder hasActivities(Boolean hasActivities) {
            this.hasActivities = hasActivities;
            this.changedFields = changedFields.add("HasActivities");
            return this;
        }

        public Builder hasFeedback(Boolean hasFeedback) {
            this.hasFeedback = hasFeedback;
            this.changedFields = changedFields.add("HasFeedback");
            return this;
        }

        public Builder isSolutionAware(Boolean isSolutionAware) {
            this.isSolutionAware = isSolutionAware;
            this.changedFields = changedFields.add("IsSolutionAware");
            return this;
        }

        public Builder settings(List<EntitySetting> settings) {
            this.settings = settings;
            this.changedFields = changedFields.add("Settings");
            return this;
        }

        public Builder settings(EntitySetting... settings) {
            return settings(Arrays.asList(settings));
        }

        public Builder settingsNextLink(String settingsNextLink) {
            this.settingsNextLink = settingsNextLink;
            this.changedFields = changedFields.add("Settings");
            return this;
        }

        public Builder createdOn(OffsetDateTime createdOn) {
            this.createdOn = createdOn;
            this.changedFields = changedFields.add("CreatedOn");
            return this;
        }

        public Builder modifiedOn(OffsetDateTime modifiedOn) {
            this.modifiedOn = modifiedOn;
            this.changedFields = changedFields.add("ModifiedOn");
            return this;
        }

        public Builder metadataId(String metadataId) {
            this.metadataId = metadataId;
            this.changedFields = changedFields.add("MetadataId");
            return this;
        }

        public Builder hasChanged(Boolean hasChanged) {
            this.hasChanged = hasChanged;
            this.changedFields = changedFields.add("HasChanged");
            return this;
        }

        public ComplexEntityMetadata build() {
            ComplexEntityMetadata _x = new ComplexEntityMetadata();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ComplexEntityMetadata";
            _x.activityTypeMask = activityTypeMask;
            _x.attributes = attributes;
            _x.attributesNextLink = attributesNextLink;
            _x.autoRouteToOwnerQueue = autoRouteToOwnerQueue;
            _x.canTriggerWorkflow = canTriggerWorkflow;
            _x.description = description;
            _x.displayCollectionName = displayCollectionName;
            _x.displayName = displayName;
            _x.entityHelpUrlEnabled = entityHelpUrlEnabled;
            _x.entityHelpUrl = entityHelpUrl;
            _x.isDocumentManagementEnabled = isDocumentManagementEnabled;
            _x.isOneNoteIntegrationEnabled = isOneNoteIntegrationEnabled;
            _x.isInteractionCentricEnabled = isInteractionCentricEnabled;
            _x.isKnowledgeManagementEnabled = isKnowledgeManagementEnabled;
            _x.isSLAEnabled = isSLAEnabled;
            _x.isBPFEntity = isBPFEntity;
            _x.isDocumentRecommendationsEnabled = isDocumentRecommendationsEnabled;
            _x.isMSTeamsIntegrationEnabled = isMSTeamsIntegrationEnabled;
            _x.settingOf = settingOf;
            _x.dataProviderId = dataProviderId;
            _x.dataSourceId = dataSourceId;
            _x.autoCreateAccessTeams = autoCreateAccessTeams;
            _x.isActivity = isActivity;
            _x.isActivityParty = isActivityParty;
            _x.isAuditEnabled = isAuditEnabled;
            _x.isAvailableOffline = isAvailableOffline;
            _x.isChildEntity = isChildEntity;
            _x.isAIRUpdated = isAIRUpdated;
            _x.isValidForQueue = isValidForQueue;
            _x.isConnectionsEnabled = isConnectionsEnabled;
            _x.iconLargeName = iconLargeName;
            _x.iconMediumName = iconMediumName;
            _x.iconSmallName = iconSmallName;
            _x.iconVectorName = iconVectorName;
            _x.isCustomEntity = isCustomEntity;
            _x.isBusinessProcessEnabled = isBusinessProcessEnabled;
            _x.isCustomizable = isCustomizable;
            _x.isRenameable = isRenameable;
            _x.isMappable = isMappable;
            _x.isDuplicateDetectionEnabled = isDuplicateDetectionEnabled;
            _x.canCreateAttributes = canCreateAttributes;
            _x.canCreateForms = canCreateForms;
            _x.canCreateViews = canCreateViews;
            _x.canCreateCharts = canCreateCharts;
            _x.canBeRelatedEntityInRelationship = canBeRelatedEntityInRelationship;
            _x.canBePrimaryEntityInRelationship = canBePrimaryEntityInRelationship;
            _x.canBeInManyToMany = canBeInManyToMany;
            _x.canBeInCustomEntityAssociation = canBeInCustomEntityAssociation;
            _x.canEnableSyncToExternalSearchIndex = canEnableSyncToExternalSearchIndex;
            _x.syncToExternalSearchIndex = syncToExternalSearchIndex;
            _x.canModifyAdditionalSettings = canModifyAdditionalSettings;
            _x.canChangeHierarchicalRelationship = canChangeHierarchicalRelationship;
            _x.isOptimisticConcurrencyEnabled = isOptimisticConcurrencyEnabled;
            _x.changeTrackingEnabled = changeTrackingEnabled;
            _x.canChangeTrackingBeEnabled = canChangeTrackingBeEnabled;
            _x.isImportable = isImportable;
            _x.isIntersect = isIntersect;
            _x.isMailMergeEnabled = isMailMergeEnabled;
            _x.isManaged = isManaged;
            _x.isEnabledForCharts = isEnabledForCharts;
            _x.isEnabledForTrace = isEnabledForTrace;
            _x.isValidForAdvancedFind = isValidForAdvancedFind;
            _x.isVisibleInMobile = isVisibleInMobile;
            _x.isVisibleInMobileClient = isVisibleInMobileClient;
            _x.isReadOnlyInMobileClient = isReadOnlyInMobileClient;
            _x.isOfflineInMobileClient = isOfflineInMobileClient;
            _x.daysSinceRecordLastModified = daysSinceRecordLastModified;
            _x.mobileOfflineFilters = mobileOfflineFilters;
            _x.isReadingPaneEnabled = isReadingPaneEnabled;
            _x.isQuickCreateEnabled = isQuickCreateEnabled;
            _x.logicalName = logicalName;
            _x.manyToManyRelationships = manyToManyRelationships;
            _x.manyToManyRelationshipsNextLink = manyToManyRelationshipsNextLink;
            _x.manyToOneRelationships = manyToOneRelationships;
            _x.manyToOneRelationshipsNextLink = manyToOneRelationshipsNextLink;
            _x.oneToManyRelationships = oneToManyRelationships;
            _x.oneToManyRelationshipsNextLink = oneToManyRelationshipsNextLink;
            _x.objectTypeCode = objectTypeCode;
            _x.ownershipType = ownershipType;
            _x.primaryNameAttribute = primaryNameAttribute;
            _x.primaryImageAttribute = primaryImageAttribute;
            _x.primaryIdAttribute = primaryIdAttribute;
            _x.privileges = privileges;
            _x.privilegesNextLink = privilegesNextLink;
            _x.recurrenceBaseEntityLogicalName = recurrenceBaseEntityLogicalName;
            _x.reportViewName = reportViewName;
            _x.schemaName = schemaName;
            _x.introducedVersion = introducedVersion;
            _x.isStateModelAware = isStateModelAware;
            _x.enforceStateTransitions = enforceStateTransitions;
            _x.externalName = externalName;
            _x.entityColor = entityColor;
            _x.keys = keys;
            _x.keysNextLink = keysNextLink;
            _x.logicalCollectionName = logicalCollectionName;
            _x.externalCollectionName = externalCollectionName;
            _x.collectionSchemaName = collectionSchemaName;
            _x.entitySetName = entitySetName;
            _x.isEnabledForExternalChannels = isEnabledForExternalChannels;
            _x.isPrivate = isPrivate;
            _x.usesBusinessDataLabelTable = usesBusinessDataLabelTable;
            _x.isLogicalEntity = isLogicalEntity;
            _x.hasNotes = hasNotes;
            _x.hasActivities = hasActivities;
            _x.hasFeedback = hasFeedback;
            _x.isSolutionAware = isSolutionAware;
            _x.settings = settings;
            _x.settingsNextLink = settingsNextLink;
            _x.createdOn = createdOn;
            _x.modifiedOn = modifiedOn;
            _x.metadataId = metadataId;
            _x.hasChanged = hasChanged;
            return _x;
        }
    }

    private ComplexEntityMetadata _copy() {
        ComplexEntityMetadata _x = new ComplexEntityMetadata();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.activityTypeMask = activityTypeMask;
        _x.attributes = attributes;
        _x.autoRouteToOwnerQueue = autoRouteToOwnerQueue;
        _x.canTriggerWorkflow = canTriggerWorkflow;
        _x.description = description;
        _x.displayCollectionName = displayCollectionName;
        _x.displayName = displayName;
        _x.entityHelpUrlEnabled = entityHelpUrlEnabled;
        _x.entityHelpUrl = entityHelpUrl;
        _x.isDocumentManagementEnabled = isDocumentManagementEnabled;
        _x.isOneNoteIntegrationEnabled = isOneNoteIntegrationEnabled;
        _x.isInteractionCentricEnabled = isInteractionCentricEnabled;
        _x.isKnowledgeManagementEnabled = isKnowledgeManagementEnabled;
        _x.isSLAEnabled = isSLAEnabled;
        _x.isBPFEntity = isBPFEntity;
        _x.isDocumentRecommendationsEnabled = isDocumentRecommendationsEnabled;
        _x.isMSTeamsIntegrationEnabled = isMSTeamsIntegrationEnabled;
        _x.settingOf = settingOf;
        _x.dataProviderId = dataProviderId;
        _x.dataSourceId = dataSourceId;
        _x.autoCreateAccessTeams = autoCreateAccessTeams;
        _x.isActivity = isActivity;
        _x.isActivityParty = isActivityParty;
        _x.isAuditEnabled = isAuditEnabled;
        _x.isAvailableOffline = isAvailableOffline;
        _x.isChildEntity = isChildEntity;
        _x.isAIRUpdated = isAIRUpdated;
        _x.isValidForQueue = isValidForQueue;
        _x.isConnectionsEnabled = isConnectionsEnabled;
        _x.iconLargeName = iconLargeName;
        _x.iconMediumName = iconMediumName;
        _x.iconSmallName = iconSmallName;
        _x.iconVectorName = iconVectorName;
        _x.isCustomEntity = isCustomEntity;
        _x.isBusinessProcessEnabled = isBusinessProcessEnabled;
        _x.isCustomizable = isCustomizable;
        _x.isRenameable = isRenameable;
        _x.isMappable = isMappable;
        _x.isDuplicateDetectionEnabled = isDuplicateDetectionEnabled;
        _x.canCreateAttributes = canCreateAttributes;
        _x.canCreateForms = canCreateForms;
        _x.canCreateViews = canCreateViews;
        _x.canCreateCharts = canCreateCharts;
        _x.canBeRelatedEntityInRelationship = canBeRelatedEntityInRelationship;
        _x.canBePrimaryEntityInRelationship = canBePrimaryEntityInRelationship;
        _x.canBeInManyToMany = canBeInManyToMany;
        _x.canBeInCustomEntityAssociation = canBeInCustomEntityAssociation;
        _x.canEnableSyncToExternalSearchIndex = canEnableSyncToExternalSearchIndex;
        _x.syncToExternalSearchIndex = syncToExternalSearchIndex;
        _x.canModifyAdditionalSettings = canModifyAdditionalSettings;
        _x.canChangeHierarchicalRelationship = canChangeHierarchicalRelationship;
        _x.isOptimisticConcurrencyEnabled = isOptimisticConcurrencyEnabled;
        _x.changeTrackingEnabled = changeTrackingEnabled;
        _x.canChangeTrackingBeEnabled = canChangeTrackingBeEnabled;
        _x.isImportable = isImportable;
        _x.isIntersect = isIntersect;
        _x.isMailMergeEnabled = isMailMergeEnabled;
        _x.isManaged = isManaged;
        _x.isEnabledForCharts = isEnabledForCharts;
        _x.isEnabledForTrace = isEnabledForTrace;
        _x.isValidForAdvancedFind = isValidForAdvancedFind;
        _x.isVisibleInMobile = isVisibleInMobile;
        _x.isVisibleInMobileClient = isVisibleInMobileClient;
        _x.isReadOnlyInMobileClient = isReadOnlyInMobileClient;
        _x.isOfflineInMobileClient = isOfflineInMobileClient;
        _x.daysSinceRecordLastModified = daysSinceRecordLastModified;
        _x.mobileOfflineFilters = mobileOfflineFilters;
        _x.isReadingPaneEnabled = isReadingPaneEnabled;
        _x.isQuickCreateEnabled = isQuickCreateEnabled;
        _x.logicalName = logicalName;
        _x.manyToManyRelationships = manyToManyRelationships;
        _x.manyToOneRelationships = manyToOneRelationships;
        _x.oneToManyRelationships = oneToManyRelationships;
        _x.objectTypeCode = objectTypeCode;
        _x.ownershipType = ownershipType;
        _x.primaryNameAttribute = primaryNameAttribute;
        _x.primaryImageAttribute = primaryImageAttribute;
        _x.primaryIdAttribute = primaryIdAttribute;
        _x.privileges = privileges;
        _x.recurrenceBaseEntityLogicalName = recurrenceBaseEntityLogicalName;
        _x.reportViewName = reportViewName;
        _x.schemaName = schemaName;
        _x.introducedVersion = introducedVersion;
        _x.isStateModelAware = isStateModelAware;
        _x.enforceStateTransitions = enforceStateTransitions;
        _x.externalName = externalName;
        _x.entityColor = entityColor;
        _x.keys = keys;
        _x.logicalCollectionName = logicalCollectionName;
        _x.externalCollectionName = externalCollectionName;
        _x.collectionSchemaName = collectionSchemaName;
        _x.entitySetName = entitySetName;
        _x.isEnabledForExternalChannels = isEnabledForExternalChannels;
        _x.isPrivate = isPrivate;
        _x.usesBusinessDataLabelTable = usesBusinessDataLabelTable;
        _x.isLogicalEntity = isLogicalEntity;
        _x.hasNotes = hasNotes;
        _x.hasActivities = hasActivities;
        _x.hasFeedback = hasFeedback;
        _x.isSolutionAware = isSolutionAware;
        _x.settings = settings;
        _x.createdOn = createdOn;
        _x.modifiedOn = modifiedOn;
        _x.metadataId = metadataId;
        _x.hasChanged = hasChanged;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ComplexEntityMetadata[");
        b.append("ActivityTypeMask=");
        b.append(this.activityTypeMask);
        b.append(", ");
        b.append("Attributes=");
        b.append(this.attributes);
        b.append(", ");
        b.append("AutoRouteToOwnerQueue=");
        b.append(this.autoRouteToOwnerQueue);
        b.append(", ");
        b.append("CanTriggerWorkflow=");
        b.append(this.canTriggerWorkflow);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("DisplayCollectionName=");
        b.append(this.displayCollectionName);
        b.append(", ");
        b.append("DisplayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("EntityHelpUrlEnabled=");
        b.append(this.entityHelpUrlEnabled);
        b.append(", ");
        b.append("EntityHelpUrl=");
        b.append(this.entityHelpUrl);
        b.append(", ");
        b.append("IsDocumentManagementEnabled=");
        b.append(this.isDocumentManagementEnabled);
        b.append(", ");
        b.append("IsOneNoteIntegrationEnabled=");
        b.append(this.isOneNoteIntegrationEnabled);
        b.append(", ");
        b.append("IsInteractionCentricEnabled=");
        b.append(this.isInteractionCentricEnabled);
        b.append(", ");
        b.append("IsKnowledgeManagementEnabled=");
        b.append(this.isKnowledgeManagementEnabled);
        b.append(", ");
        b.append("IsSLAEnabled=");
        b.append(this.isSLAEnabled);
        b.append(", ");
        b.append("IsBPFEntity=");
        b.append(this.isBPFEntity);
        b.append(", ");
        b.append("IsDocumentRecommendationsEnabled=");
        b.append(this.isDocumentRecommendationsEnabled);
        b.append(", ");
        b.append("IsMSTeamsIntegrationEnabled=");
        b.append(this.isMSTeamsIntegrationEnabled);
        b.append(", ");
        b.append("SettingOf=");
        b.append(this.settingOf);
        b.append(", ");
        b.append("DataProviderId=");
        b.append(this.dataProviderId);
        b.append(", ");
        b.append("DataSourceId=");
        b.append(this.dataSourceId);
        b.append(", ");
        b.append("AutoCreateAccessTeams=");
        b.append(this.autoCreateAccessTeams);
        b.append(", ");
        b.append("IsActivity=");
        b.append(this.isActivity);
        b.append(", ");
        b.append("IsActivityParty=");
        b.append(this.isActivityParty);
        b.append(", ");
        b.append("IsAuditEnabled=");
        b.append(this.isAuditEnabled);
        b.append(", ");
        b.append("IsAvailableOffline=");
        b.append(this.isAvailableOffline);
        b.append(", ");
        b.append("IsChildEntity=");
        b.append(this.isChildEntity);
        b.append(", ");
        b.append("IsAIRUpdated=");
        b.append(this.isAIRUpdated);
        b.append(", ");
        b.append("IsValidForQueue=");
        b.append(this.isValidForQueue);
        b.append(", ");
        b.append("IsConnectionsEnabled=");
        b.append(this.isConnectionsEnabled);
        b.append(", ");
        b.append("IconLargeName=");
        b.append(this.iconLargeName);
        b.append(", ");
        b.append("IconMediumName=");
        b.append(this.iconMediumName);
        b.append(", ");
        b.append("IconSmallName=");
        b.append(this.iconSmallName);
        b.append(", ");
        b.append("IconVectorName=");
        b.append(this.iconVectorName);
        b.append(", ");
        b.append("IsCustomEntity=");
        b.append(this.isCustomEntity);
        b.append(", ");
        b.append("IsBusinessProcessEnabled=");
        b.append(this.isBusinessProcessEnabled);
        b.append(", ");
        b.append("IsCustomizable=");
        b.append(this.isCustomizable);
        b.append(", ");
        b.append("IsRenameable=");
        b.append(this.isRenameable);
        b.append(", ");
        b.append("IsMappable=");
        b.append(this.isMappable);
        b.append(", ");
        b.append("IsDuplicateDetectionEnabled=");
        b.append(this.isDuplicateDetectionEnabled);
        b.append(", ");
        b.append("CanCreateAttributes=");
        b.append(this.canCreateAttributes);
        b.append(", ");
        b.append("CanCreateForms=");
        b.append(this.canCreateForms);
        b.append(", ");
        b.append("CanCreateViews=");
        b.append(this.canCreateViews);
        b.append(", ");
        b.append("CanCreateCharts=");
        b.append(this.canCreateCharts);
        b.append(", ");
        b.append("CanBeRelatedEntityInRelationship=");
        b.append(this.canBeRelatedEntityInRelationship);
        b.append(", ");
        b.append("CanBePrimaryEntityInRelationship=");
        b.append(this.canBePrimaryEntityInRelationship);
        b.append(", ");
        b.append("CanBeInManyToMany=");
        b.append(this.canBeInManyToMany);
        b.append(", ");
        b.append("CanBeInCustomEntityAssociation=");
        b.append(this.canBeInCustomEntityAssociation);
        b.append(", ");
        b.append("CanEnableSyncToExternalSearchIndex=");
        b.append(this.canEnableSyncToExternalSearchIndex);
        b.append(", ");
        b.append("SyncToExternalSearchIndex=");
        b.append(this.syncToExternalSearchIndex);
        b.append(", ");
        b.append("CanModifyAdditionalSettings=");
        b.append(this.canModifyAdditionalSettings);
        b.append(", ");
        b.append("CanChangeHierarchicalRelationship=");
        b.append(this.canChangeHierarchicalRelationship);
        b.append(", ");
        b.append("IsOptimisticConcurrencyEnabled=");
        b.append(this.isOptimisticConcurrencyEnabled);
        b.append(", ");
        b.append("ChangeTrackingEnabled=");
        b.append(this.changeTrackingEnabled);
        b.append(", ");
        b.append("CanChangeTrackingBeEnabled=");
        b.append(this.canChangeTrackingBeEnabled);
        b.append(", ");
        b.append("IsImportable=");
        b.append(this.isImportable);
        b.append(", ");
        b.append("IsIntersect=");
        b.append(this.isIntersect);
        b.append(", ");
        b.append("IsMailMergeEnabled=");
        b.append(this.isMailMergeEnabled);
        b.append(", ");
        b.append("IsManaged=");
        b.append(this.isManaged);
        b.append(", ");
        b.append("IsEnabledForCharts=");
        b.append(this.isEnabledForCharts);
        b.append(", ");
        b.append("IsEnabledForTrace=");
        b.append(this.isEnabledForTrace);
        b.append(", ");
        b.append("IsValidForAdvancedFind=");
        b.append(this.isValidForAdvancedFind);
        b.append(", ");
        b.append("IsVisibleInMobile=");
        b.append(this.isVisibleInMobile);
        b.append(", ");
        b.append("IsVisibleInMobileClient=");
        b.append(this.isVisibleInMobileClient);
        b.append(", ");
        b.append("IsReadOnlyInMobileClient=");
        b.append(this.isReadOnlyInMobileClient);
        b.append(", ");
        b.append("IsOfflineInMobileClient=");
        b.append(this.isOfflineInMobileClient);
        b.append(", ");
        b.append("DaysSinceRecordLastModified=");
        b.append(this.daysSinceRecordLastModified);
        b.append(", ");
        b.append("MobileOfflineFilters=");
        b.append(this.mobileOfflineFilters);
        b.append(", ");
        b.append("IsReadingPaneEnabled=");
        b.append(this.isReadingPaneEnabled);
        b.append(", ");
        b.append("IsQuickCreateEnabled=");
        b.append(this.isQuickCreateEnabled);
        b.append(", ");
        b.append("LogicalName=");
        b.append(this.logicalName);
        b.append(", ");
        b.append("ManyToManyRelationships=");
        b.append(this.manyToManyRelationships);
        b.append(", ");
        b.append("ManyToOneRelationships=");
        b.append(this.manyToOneRelationships);
        b.append(", ");
        b.append("OneToManyRelationships=");
        b.append(this.oneToManyRelationships);
        b.append(", ");
        b.append("ObjectTypeCode=");
        b.append(this.objectTypeCode);
        b.append(", ");
        b.append("OwnershipType=");
        b.append(this.ownershipType);
        b.append(", ");
        b.append("PrimaryNameAttribute=");
        b.append(this.primaryNameAttribute);
        b.append(", ");
        b.append("PrimaryImageAttribute=");
        b.append(this.primaryImageAttribute);
        b.append(", ");
        b.append("PrimaryIdAttribute=");
        b.append(this.primaryIdAttribute);
        b.append(", ");
        b.append("Privileges=");
        b.append(this.privileges);
        b.append(", ");
        b.append("RecurrenceBaseEntityLogicalName=");
        b.append(this.recurrenceBaseEntityLogicalName);
        b.append(", ");
        b.append("ReportViewName=");
        b.append(this.reportViewName);
        b.append(", ");
        b.append("SchemaName=");
        b.append(this.schemaName);
        b.append(", ");
        b.append("IntroducedVersion=");
        b.append(this.introducedVersion);
        b.append(", ");
        b.append("IsStateModelAware=");
        b.append(this.isStateModelAware);
        b.append(", ");
        b.append("EnforceStateTransitions=");
        b.append(this.enforceStateTransitions);
        b.append(", ");
        b.append("ExternalName=");
        b.append(this.externalName);
        b.append(", ");
        b.append("EntityColor=");
        b.append(this.entityColor);
        b.append(", ");
        b.append("Keys=");
        b.append(this.keys);
        b.append(", ");
        b.append("LogicalCollectionName=");
        b.append(this.logicalCollectionName);
        b.append(", ");
        b.append("ExternalCollectionName=");
        b.append(this.externalCollectionName);
        b.append(", ");
        b.append("CollectionSchemaName=");
        b.append(this.collectionSchemaName);
        b.append(", ");
        b.append("EntitySetName=");
        b.append(this.entitySetName);
        b.append(", ");
        b.append("IsEnabledForExternalChannels=");
        b.append(this.isEnabledForExternalChannels);
        b.append(", ");
        b.append("IsPrivate=");
        b.append(this.isPrivate);
        b.append(", ");
        b.append("UsesBusinessDataLabelTable=");
        b.append(this.usesBusinessDataLabelTable);
        b.append(", ");
        b.append("IsLogicalEntity=");
        b.append(this.isLogicalEntity);
        b.append(", ");
        b.append("HasNotes=");
        b.append(this.hasNotes);
        b.append(", ");
        b.append("HasActivities=");
        b.append(this.hasActivities);
        b.append(", ");
        b.append("HasFeedback=");
        b.append(this.hasFeedback);
        b.append(", ");
        b.append("IsSolutionAware=");
        b.append(this.isSolutionAware);
        b.append(", ");
        b.append("Settings=");
        b.append(this.settings);
        b.append(", ");
        b.append("CreatedOn=");
        b.append(this.createdOn);
        b.append(", ");
        b.append("ModifiedOn=");
        b.append(this.modifiedOn);
        b.append(", ");
        b.append("MetadataId=");
        b.append(this.metadataId);
        b.append(", ");
        b.append("HasChanged=");
        b.append(this.hasChanged);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
