package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import microsoft.dynamics.crm.enums.AssociatedMenuBehavior;
import microsoft.dynamics.crm.enums.AssociatedMenuGroup;

@JsonPropertyOrder({
    "@odata.type", 
    "Behavior", 
    "Group", 
    "Label", 
    "Order", 
    "IsCustomizable", 
    "Icon", 
    "ViewId", 
    "AvailableOffline", 
    "MenuId", 
    "QueryApi"})
@JsonInclude(Include.NON_NULL)
public class AssociatedMenuConfiguration implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Behavior")
    protected AssociatedMenuBehavior behavior;

    @JsonProperty("Group")
    protected AssociatedMenuGroup group;

    @JsonProperty("Label")
    protected Label label;

    @JsonProperty("Order")
    protected Integer order;

    @JsonProperty("IsCustomizable")
    protected Boolean isCustomizable;

    @JsonProperty("Icon")
    protected String icon;

    @JsonProperty("ViewId")
    protected String viewId;

    @JsonProperty("AvailableOffline")
    protected Boolean availableOffline;

    @JsonProperty("MenuId")
    protected String menuId;

    @JsonProperty("QueryApi")
    protected String queryApi;

    protected AssociatedMenuConfiguration() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.AssociatedMenuConfiguration";
    }

    @Property(name="Behavior")
    @JsonIgnore
    public Optional<AssociatedMenuBehavior> getBehavior() {
        return Optional.ofNullable(behavior);
    }

    public AssociatedMenuConfiguration withBehavior(AssociatedMenuBehavior behavior) {
        AssociatedMenuConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AssociatedMenuConfiguration");
        _x.behavior = behavior;
        return _x;
    }

    @Property(name="Group")
    @JsonIgnore
    public Optional<AssociatedMenuGroup> getGroup() {
        return Optional.ofNullable(group);
    }

    public AssociatedMenuConfiguration withGroup(AssociatedMenuGroup group) {
        AssociatedMenuConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AssociatedMenuConfiguration");
        _x.group = group;
        return _x;
    }

    @Property(name="Label")
    @JsonIgnore
    public Optional<Label> getLabel() {
        return Optional.ofNullable(label);
    }

    public AssociatedMenuConfiguration withLabel(Label label) {
        AssociatedMenuConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AssociatedMenuConfiguration");
        _x.label = label;
        return _x;
    }

    @Property(name="Order")
    @JsonIgnore
    public Optional<Integer> getOrder() {
        return Optional.ofNullable(order);
    }

    public AssociatedMenuConfiguration withOrder(Integer order) {
        AssociatedMenuConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AssociatedMenuConfiguration");
        _x.order = order;
        return _x;
    }

    @Property(name="IsCustomizable")
    @JsonIgnore
    public Optional<Boolean> getIsCustomizable() {
        return Optional.ofNullable(isCustomizable);
    }

    public AssociatedMenuConfiguration withIsCustomizable(Boolean isCustomizable) {
        AssociatedMenuConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AssociatedMenuConfiguration");
        _x.isCustomizable = isCustomizable;
        return _x;
    }

    @Property(name="Icon")
    @JsonIgnore
    public Optional<String> getIcon() {
        return Optional.ofNullable(icon);
    }

    public AssociatedMenuConfiguration withIcon(String icon) {
        Checks.checkIsAscii(icon);
        AssociatedMenuConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AssociatedMenuConfiguration");
        _x.icon = icon;
        return _x;
    }

    @Property(name="ViewId")
    @JsonIgnore
    public Optional<String> getViewId() {
        return Optional.ofNullable(viewId);
    }

    public AssociatedMenuConfiguration withViewId(String viewId) {
        AssociatedMenuConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AssociatedMenuConfiguration");
        _x.viewId = viewId;
        return _x;
    }

    @Property(name="AvailableOffline")
    @JsonIgnore
    public Optional<Boolean> getAvailableOffline() {
        return Optional.ofNullable(availableOffline);
    }

    public AssociatedMenuConfiguration withAvailableOffline(Boolean availableOffline) {
        AssociatedMenuConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AssociatedMenuConfiguration");
        _x.availableOffline = availableOffline;
        return _x;
    }

    @Property(name="MenuId")
    @JsonIgnore
    public Optional<String> getMenuId() {
        return Optional.ofNullable(menuId);
    }

    public AssociatedMenuConfiguration withMenuId(String menuId) {
        Checks.checkIsAscii(menuId);
        AssociatedMenuConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AssociatedMenuConfiguration");
        _x.menuId = menuId;
        return _x;
    }

    @Property(name="QueryApi")
    @JsonIgnore
    public Optional<String> getQueryApi() {
        return Optional.ofNullable(queryApi);
    }

    public AssociatedMenuConfiguration withQueryApi(String queryApi) {
        Checks.checkIsAscii(queryApi);
        AssociatedMenuConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AssociatedMenuConfiguration");
        _x.queryApi = queryApi;
        return _x;
    }

    public AssociatedMenuConfiguration withUnmappedField(String name, String value) {
        AssociatedMenuConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AssociatedMenuBehavior behavior;
        private AssociatedMenuGroup group;
        private Label label;
        private Integer order;
        private Boolean isCustomizable;
        private String icon;
        private String viewId;
        private Boolean availableOffline;
        private String menuId;
        private String queryApi;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder behavior(AssociatedMenuBehavior behavior) {
            this.behavior = behavior;
            this.changedFields = changedFields.add("Behavior");
            return this;
        }

        public Builder group(AssociatedMenuGroup group) {
            this.group = group;
            this.changedFields = changedFields.add("Group");
            return this;
        }

        public Builder label(Label label) {
            this.label = label;
            this.changedFields = changedFields.add("Label");
            return this;
        }

        public Builder order(Integer order) {
            this.order = order;
            this.changedFields = changedFields.add("Order");
            return this;
        }

        public Builder isCustomizable(Boolean isCustomizable) {
            this.isCustomizable = isCustomizable;
            this.changedFields = changedFields.add("IsCustomizable");
            return this;
        }

        public Builder icon(String icon) {
            this.icon = icon;
            this.changedFields = changedFields.add("Icon");
            return this;
        }

        public Builder viewId(String viewId) {
            this.viewId = viewId;
            this.changedFields = changedFields.add("ViewId");
            return this;
        }

        public Builder availableOffline(Boolean availableOffline) {
            this.availableOffline = availableOffline;
            this.changedFields = changedFields.add("AvailableOffline");
            return this;
        }

        public Builder menuId(String menuId) {
            this.menuId = menuId;
            this.changedFields = changedFields.add("MenuId");
            return this;
        }

        public Builder queryApi(String queryApi) {
            this.queryApi = queryApi;
            this.changedFields = changedFields.add("QueryApi");
            return this;
        }

        public AssociatedMenuConfiguration build() {
            AssociatedMenuConfiguration _x = new AssociatedMenuConfiguration();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.AssociatedMenuConfiguration";
            _x.behavior = behavior;
            _x.group = group;
            _x.label = label;
            _x.order = order;
            _x.isCustomizable = isCustomizable;
            _x.icon = icon;
            _x.viewId = viewId;
            _x.availableOffline = availableOffline;
            _x.menuId = menuId;
            _x.queryApi = queryApi;
            return _x;
        }
    }

    private AssociatedMenuConfiguration _copy() {
        AssociatedMenuConfiguration _x = new AssociatedMenuConfiguration();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.behavior = behavior;
        _x.group = group;
        _x.label = label;
        _x.order = order;
        _x.isCustomizable = isCustomizable;
        _x.icon = icon;
        _x.viewId = viewId;
        _x.availableOffline = availableOffline;
        _x.menuId = menuId;
        _x.queryApi = queryApi;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AssociatedMenuConfiguration[");
        b.append("Behavior=");
        b.append(this.behavior);
        b.append(", ");
        b.append("Group=");
        b.append(this.group);
        b.append(", ");
        b.append("Label=");
        b.append(this.label);
        b.append(", ");
        b.append("Order=");
        b.append(this.order);
        b.append(", ");
        b.append("IsCustomizable=");
        b.append(this.isCustomizable);
        b.append(", ");
        b.append("Icon=");
        b.append(this.icon);
        b.append(", ");
        b.append("ViewId=");
        b.append(this.viewId);
        b.append(", ");
        b.append("AvailableOffline=");
        b.append(this.availableOffline);
        b.append(", ");
        b.append("MenuId=");
        b.append(this.menuId);
        b.append(", ");
        b.append("QueryApi=");
        b.append(this.queryApi);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
