package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "Start", 
    "End", 
    "SiteId", 
    "SiteName", 
    "ProposalParties"})
@JsonInclude(Include.NON_NULL)
public class AppointmentProposal implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Start")
    protected OffsetDateTime start;

    @JsonProperty("End")
    protected OffsetDateTime end;

    @JsonProperty("SiteId")
    protected String siteId;

    @JsonProperty("SiteName")
    protected String siteName;

    @JsonProperty("ProposalParties")
    protected List<ProposalParty> proposalParties;

    @JsonProperty("ProposalParties@nextLink")
    protected String proposalPartiesNextLink;

    protected AppointmentProposal() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.AppointmentProposal";
    }

    @Property(name="Start")
    @JsonIgnore
    public Optional<OffsetDateTime> getStart() {
        return Optional.ofNullable(start);
    }

    public AppointmentProposal withStart(OffsetDateTime start) {
        AppointmentProposal _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppointmentProposal");
        _x.start = start;
        return _x;
    }

    @Property(name="End")
    @JsonIgnore
    public Optional<OffsetDateTime> getEnd() {
        return Optional.ofNullable(end);
    }

    public AppointmentProposal withEnd(OffsetDateTime end) {
        AppointmentProposal _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppointmentProposal");
        _x.end = end;
        return _x;
    }

    @Property(name="SiteId")
    @JsonIgnore
    public Optional<String> getSiteId() {
        return Optional.ofNullable(siteId);
    }

    public AppointmentProposal withSiteId(String siteId) {
        AppointmentProposal _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppointmentProposal");
        _x.siteId = siteId;
        return _x;
    }

    @Property(name="SiteName")
    @JsonIgnore
    public Optional<String> getSiteName() {
        return Optional.ofNullable(siteName);
    }

    public AppointmentProposal withSiteName(String siteName) {
        Checks.checkIsAscii(siteName);
        AppointmentProposal _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppointmentProposal");
        _x.siteName = siteName;
        return _x;
    }

    @Property(name="ProposalParties")
    @JsonIgnore
    public CollectionPage<ProposalParty> getProposalParties() {
        return new CollectionPage<ProposalParty>(contextPath, ProposalParty.class, this.proposalParties, Optional.ofNullable(proposalPartiesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="ProposalParties")
    @JsonIgnore
    public CollectionPage<ProposalParty> getProposalParties(HttpRequestOptions options) {
        return new CollectionPage<ProposalParty>(contextPath, ProposalParty.class, this.proposalParties, Optional.ofNullable(proposalPartiesNextLink), Collections.emptyList(), options);
    }

    public AppointmentProposal withUnmappedField(String name, String value) {
        AppointmentProposal _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime start;
        private OffsetDateTime end;
        private String siteId;
        private String siteName;
        private List<ProposalParty> proposalParties;
        private String proposalPartiesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder start(OffsetDateTime start) {
            this.start = start;
            this.changedFields = changedFields.add("Start");
            return this;
        }

        public Builder end(OffsetDateTime end) {
            this.end = end;
            this.changedFields = changedFields.add("End");
            return this;
        }

        public Builder siteId(String siteId) {
            this.siteId = siteId;
            this.changedFields = changedFields.add("SiteId");
            return this;
        }

        public Builder siteName(String siteName) {
            this.siteName = siteName;
            this.changedFields = changedFields.add("SiteName");
            return this;
        }

        public Builder proposalParties(List<ProposalParty> proposalParties) {
            this.proposalParties = proposalParties;
            this.changedFields = changedFields.add("ProposalParties");
            return this;
        }

        public Builder proposalParties(ProposalParty... proposalParties) {
            return proposalParties(Arrays.asList(proposalParties));
        }

        public Builder proposalPartiesNextLink(String proposalPartiesNextLink) {
            this.proposalPartiesNextLink = proposalPartiesNextLink;
            this.changedFields = changedFields.add("ProposalParties");
            return this;
        }

        public AppointmentProposal build() {
            AppointmentProposal _x = new AppointmentProposal();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.AppointmentProposal";
            _x.start = start;
            _x.end = end;
            _x.siteId = siteId;
            _x.siteName = siteName;
            _x.proposalParties = proposalParties;
            _x.proposalPartiesNextLink = proposalPartiesNextLink;
            return _x;
        }
    }

    private AppointmentProposal _copy() {
        AppointmentProposal _x = new AppointmentProposal();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.start = start;
        _x.end = end;
        _x.siteId = siteId;
        _x.siteName = siteName;
        _x.proposalParties = proposalParties;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppointmentProposal[");
        b.append("Start=");
        b.append(this.start);
        b.append(", ");
        b.append("End=");
        b.append(this.end);
        b.append(", ");
        b.append("SiteId=");
        b.append(this.siteId);
        b.append(", ");
        b.append("SiteName=");
        b.append(this.siteName);
        b.append(", ");
        b.append("ProposalParties=");
        b.append(this.proposalParties);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
