/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import microsoft.dynamics.crm.enums.SolutionOperationStatus;
import microsoft.dynamics.crm.enums.SolutionOperationType;

@JsonPropertyOrder(value={"@odata.type", "FormattedResults", "Type", "Status", "WarningMessages", "ErrorMessages"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SolutionOperationResult
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="FormattedResults")
    protected String formattedResults;
    @JsonProperty(value="Type")
    protected SolutionOperationType type;
    @JsonProperty(value="Status")
    protected SolutionOperationStatus status;
    @JsonProperty(value="WarningMessages")
    protected List<String> warningMessages;
    @JsonProperty(value="WarningMessages@nextLink")
    protected String warningMessagesNextLink;
    @JsonProperty(value="ErrorMessages")
    protected List<String> errorMessages;
    @JsonProperty(value="ErrorMessages@nextLink")
    protected String errorMessagesNextLink;

    protected SolutionOperationResult() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.SolutionOperationResult";
    }

    @Property(name="FormattedResults")
    @JsonIgnore
    public Optional<String> getFormattedResults() {
        return Optional.ofNullable(this.formattedResults);
    }

    public SolutionOperationResult withFormattedResults(String formattedResults) {
        Checks.checkIsAscii((String)formattedResults);
        SolutionOperationResult _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.SolutionOperationResult");
        _x.formattedResults = formattedResults;
        return _x;
    }

    @Property(name="Type")
    @JsonIgnore
    public Optional<SolutionOperationType> getType() {
        return Optional.ofNullable(this.type);
    }

    public SolutionOperationResult withType(SolutionOperationType type) {
        SolutionOperationResult _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.SolutionOperationResult");
        _x.type = type;
        return _x;
    }

    @Property(name="Status")
    @JsonIgnore
    public Optional<SolutionOperationStatus> getStatus() {
        return Optional.ofNullable(this.status);
    }

    public SolutionOperationResult withStatus(SolutionOperationStatus status) {
        SolutionOperationResult _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.SolutionOperationResult");
        _x.status = status;
        return _x;
    }

    @Property(name="WarningMessages")
    @JsonIgnore
    public CollectionPage<String> getWarningMessages() {
        return new CollectionPage(this.contextPath, String.class, this.warningMessages, Optional.ofNullable(this.warningMessagesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="WarningMessages")
    @JsonIgnore
    public CollectionPage<String> getWarningMessages(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, String.class, this.warningMessages, Optional.ofNullable(this.warningMessagesNextLink), Collections.emptyList(), options);
    }

    @Property(name="ErrorMessages")
    @JsonIgnore
    public CollectionPage<String> getErrorMessages() {
        return new CollectionPage(this.contextPath, String.class, this.errorMessages, Optional.ofNullable(this.errorMessagesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="ErrorMessages")
    @JsonIgnore
    public CollectionPage<String> getErrorMessages(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, String.class, this.errorMessages, Optional.ofNullable(this.errorMessagesNextLink), Collections.emptyList(), options);
    }

    public SolutionOperationResult withUnmappedField(String name, String value) {
        SolutionOperationResult _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private SolutionOperationResult _copy() {
        SolutionOperationResult _x = new SolutionOperationResult();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.formattedResults = this.formattedResults;
        _x.type = this.type;
        _x.status = this.status;
        _x.warningMessages = this.warningMessages;
        _x.errorMessages = this.errorMessages;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SolutionOperationResult[");
        b.append("FormattedResults=");
        b.append(this.formattedResults);
        b.append(", ");
        b.append("Type=");
        b.append((Object)this.type);
        b.append(", ");
        b.append("Status=");
        b.append((Object)this.status);
        b.append(", ");
        b.append("WarningMessages=");
        b.append(this.warningMessages);
        b.append(", ");
        b.append("ErrorMessages=");
        b.append(this.errorMessages);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String formattedResults;
        private SolutionOperationType type;
        private SolutionOperationStatus status;
        private List<String> warningMessages;
        private String warningMessagesNextLink;
        private List<String> errorMessages;
        private String errorMessagesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder formattedResults(String formattedResults) {
            this.formattedResults = formattedResults;
            this.changedFields = this.changedFields.add("FormattedResults");
            return this;
        }

        public Builder type(SolutionOperationType type) {
            this.type = type;
            this.changedFields = this.changedFields.add("Type");
            return this;
        }

        public Builder status(SolutionOperationStatus status) {
            this.status = status;
            this.changedFields = this.changedFields.add("Status");
            return this;
        }

        public Builder warningMessages(List<String> warningMessages) {
            this.warningMessages = warningMessages;
            this.changedFields = this.changedFields.add("WarningMessages");
            return this;
        }

        public Builder warningMessages(String ... warningMessages) {
            return this.warningMessages(Arrays.asList(warningMessages));
        }

        public Builder warningMessagesNextLink(String warningMessagesNextLink) {
            this.warningMessagesNextLink = warningMessagesNextLink;
            this.changedFields = this.changedFields.add("WarningMessages");
            return this;
        }

        public Builder errorMessages(List<String> errorMessages) {
            this.errorMessages = errorMessages;
            this.changedFields = this.changedFields.add("ErrorMessages");
            return this;
        }

        public Builder errorMessages(String ... errorMessages) {
            return this.errorMessages(Arrays.asList(errorMessages));
        }

        public Builder errorMessagesNextLink(String errorMessagesNextLink) {
            this.errorMessagesNextLink = errorMessagesNextLink;
            this.changedFields = this.changedFields.add("ErrorMessages");
            return this;
        }

        public SolutionOperationResult build() {
            SolutionOperationResult _x = new SolutionOperationResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.SolutionOperationResult";
            _x.formattedResults = this.formattedResults;
            _x.type = this.type;
            _x.status = this.status;
            _x.warningMessages = this.warningMessages;
            _x.warningMessagesNextLink = this.warningMessagesNextLink;
            _x.errorMessages = this.errorMessages;
            _x.errorMessagesNextLink = this.errorMessagesNextLink;
            return _x;
        }
    }
}

