package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum StringFormat implements Enum {

    @JsonProperty("Email")
    EMAIL("Email", "0"),

    @JsonProperty("Text")
    TEXT("Text", "1"),

    @JsonProperty("TextArea")
    TEXT_AREA("TextArea", "2"),

    @JsonProperty("Url")
    URL("Url", "3"),

    @JsonProperty("TickerSymbol")
    TICKER_SYMBOL("TickerSymbol", "4"),

    @JsonProperty("PhoneticGuide")
    PHONETIC_GUIDE("PhoneticGuide", "5"),

    @JsonProperty("VersionNumber")
    VERSION_NUMBER("VersionNumber", "6"),

    @JsonProperty("Phone")
    PHONE("Phone", "7");

    private final String name;
    private final String value;

    private StringFormat(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
