package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AttributeTypeCode implements Enum {

    @JsonProperty("Boolean")
    BOOLEAN("Boolean", "0"),

    @JsonProperty("Customer")
    CUSTOMER("Customer", "1"),

    @JsonProperty("DateTime")
    DATE_TIME("DateTime", "2"),

    @JsonProperty("Decimal")
    DECIMAL("Decimal", "3"),

    @JsonProperty("Double")
    DOUBLE("Double", "4"),

    @JsonProperty("Integer")
    INTEGER("Integer", "5"),

    @JsonProperty("Lookup")
    LOOKUP("Lookup", "6"),

    @JsonProperty("Memo")
    MEMO("Memo", "7"),

    @JsonProperty("Money")
    MONEY("Money", "8"),

    @JsonProperty("Owner")
    OWNER("Owner", "9"),

    @JsonProperty("PartyList")
    PARTY_LIST("PartyList", "10"),

    @JsonProperty("Picklist")
    PICKLIST("Picklist", "11"),

    @JsonProperty("State")
    STATE("State", "12"),

    @JsonProperty("Status")
    STATUS("Status", "13"),

    @JsonProperty("String")
    STRING("String", "14"),

    @JsonProperty("Uniqueidentifier")
    UNIQUEIDENTIFIER("Uniqueidentifier", "15"),

    @JsonProperty("CalendarRules")
    CALENDAR_RULES("CalendarRules", "16"),

    @JsonProperty("Virtual")
    VIRTUAL("Virtual", "17"),

    @JsonProperty("BigInt")
    BIG_INT("BigInt", "18"),

    @JsonProperty("ManagedProperty")
    MANAGED_PROPERTY("ManagedProperty", "19"),

    @JsonProperty("EntityName")
    ENTITY_NAME("EntityName", "20");

    private final String name;
    private final String value;

    private AttributeTypeCode(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
