package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Transformationparametermapping;
import microsoft.dynamics.crm.entity.collection.request.LookupmappingCollectionRequest;

@JsonIgnoreType
public class TransformationparametermappingRequest extends EntityRequest<Transformationparametermapping> {

    public TransformationparametermappingRequest(ContextPath contextPath, Optional<Object> value) {
        super(Transformationparametermapping.class, contextPath, value, false);
    }

    public TransformationmappingRequest transformationmappingid() {
        return new TransformationmappingRequest(contextPath.addSegment("transformationmappingid"), Optional.empty());
    }

    public LookupmappingRequest lookUpMapping_TransformationParameterMapping(String lookupmappingid) {
        return new LookupmappingRequest(contextPath.addSegment("LookUpMapping_TransformationParameterMapping").addKeys(new NameValue(lookupmappingid.toString())), Optional.empty());
    }

    public LookupmappingCollectionRequest lookUpMapping_TransformationParameterMapping() {
        return new LookupmappingCollectionRequest(
                        contextPath.addSegment("LookUpMapping_TransformationParameterMapping"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

}
