package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Tracelog;
import microsoft.dynamics.crm.entity.collection.request.TracelogCollectionRequest;

@JsonIgnoreType
public class TracelogRequest extends EntityRequest<Tracelog> {

    public TracelogRequest(ContextPath contextPath, Optional<Object> value) {
        super(Tracelog.class, contextPath, value, false);
    }

    public MailboxRequest regardingobjectid_mailbox() {
        return new MailboxRequest(contextPath.addSegment("regardingobjectid_mailbox"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public TracelogRequest parenttracelogid() {
        return new TracelogRequest(contextPath.addSegment("parenttracelogid"), Optional.empty());
    }

    public TracelogRequest tracelog_parent_tracelog(String tracelogid) {
        return new TracelogRequest(contextPath.addSegment("tracelog_parent_tracelog").addKeys(new NameValue(tracelogid.toString())), Optional.empty());
    }

    public TracelogCollectionRequest tracelog_parent_tracelog() {
        return new TracelogCollectionRequest(
                        contextPath.addSegment("tracelog_parent_tracelog"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public EmailserverprofileRequest regardingobjectid_emailserverprofile() {
        return new EmailserverprofileRequest(contextPath.addSegment("regardingobjectid_emailserverprofile"), Optional.empty());
    }

}
