package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Template;
import microsoft.dynamics.crm.entity.collection.request.ActivitymimeattachmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EmailCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.OrganizationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class TemplateRequest extends EntityRequest<Template> {

    public TemplateRequest(ContextPath contextPath, Optional<Object> value) {
        super(Template.class, contextPath, value, false);
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public AsyncoperationRequest template_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Template_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest template_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("Template_AsyncOperations"), Optional.empty());
    }

    public BulkdeletefailureRequest template_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("Template_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest template_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("Template_BulkDeleteFailures"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public TeamRequest owningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), Optional.empty());
    }

    public ActivitymimeattachmentRequest template_activity_mime_attachments(String activitymimeattachmentid) {
        return new ActivitymimeattachmentRequest(contextPath.addSegment("template_activity_mime_attachments").addKeys(new NameValue(activitymimeattachmentid.toString())), Optional.empty());
    }

    public ActivitymimeattachmentCollectionRequest template_activity_mime_attachments() {
        return new ActivitymimeattachmentCollectionRequest(
                        contextPath.addSegment("template_activity_mime_attachments"), Optional.empty());
    }

    public ProcesssessionRequest template_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("Template_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest template_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("Template_ProcessSessions"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public SyncerrorRequest template_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Template_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest template_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Template_SyncErrors"), Optional.empty());
    }

    public SystemuserRequest owninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), Optional.empty());
    }

    public OrganizationRequest template_Organization(String organizationid) {
        return new OrganizationRequest(contextPath.addSegment("Template_Organization").addKeys(new NameValue(organizationid.toString())), Optional.empty());
    }

    public OrganizationCollectionRequest template_Organization() {
        return new OrganizationCollectionRequest(
                        contextPath.addSegment("Template_Organization"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public EmailRequest email_EmailTemplate(String activityid) {
        return new EmailRequest(contextPath.addSegment("Email_EmailTemplate").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public EmailCollectionRequest email_EmailTemplate() {
        return new EmailCollectionRequest(
                        contextPath.addSegment("Email_EmailTemplate"), Optional.empty());
    }

}
