package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Stagesolutionupload;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FileattachmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class StagesolutionuploadRequest extends EntityRequest<Stagesolutionupload> {

    public StagesolutionuploadRequest(ContextPath contextPath, Optional<Object> value) {
        super(Stagesolutionupload.class, contextPath, value, false);
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest owninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), Optional.empty());
    }

    public TeamRequest owningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public SyncerrorRequest stagesolutionupload_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("stagesolutionupload_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest stagesolutionupload_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("stagesolutionupload_SyncErrors"), Optional.empty());
    }

    public DuplicaterecordRequest stagesolutionupload_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("stagesolutionupload_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest stagesolutionupload_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("stagesolutionupload_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest stagesolutionupload_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("stagesolutionupload_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest stagesolutionupload_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("stagesolutionupload_DuplicateBaseRecord"), Optional.empty());
    }

    public AsyncoperationRequest stagesolutionupload_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("stagesolutionupload_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest stagesolutionupload_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("stagesolutionupload_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest stagesolutionupload_MailboxTrackingFolders(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("stagesolutionupload_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest stagesolutionupload_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("stagesolutionupload_MailboxTrackingFolders"), Optional.empty());
    }

    public ProcesssessionRequest stagesolutionupload_ProcessSession(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("stagesolutionupload_ProcessSession").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest stagesolutionupload_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("stagesolutionupload_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest stagesolutionupload_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("stagesolutionupload_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest stagesolutionupload_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("stagesolutionupload_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest stagesolutionupload_PrincipalObjectAttributeAccesses(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("stagesolutionupload_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest stagesolutionupload_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("stagesolutionupload_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public FileattachmentRequest stagesolutionupload_FileAttachments(String fileattachmentid) {
        return new FileattachmentRequest(contextPath.addSegment("stagesolutionupload_FileAttachments").addKeys(new NameValue(fileattachmentid.toString())), Optional.empty());
    }

    public FileattachmentCollectionRequest stagesolutionupload_FileAttachments() {
        return new FileattachmentCollectionRequest(
                        contextPath.addSegment("stagesolutionupload_FileAttachments"), Optional.empty());
    }

}
