package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Recurrencerule;
import microsoft.dynamics.crm.entity.collection.request.RecurringappointmentmasterCollectionRequest;

@JsonIgnoreType
public class RecurrenceruleRequest extends EntityRequest<Recurrencerule> {

    public RecurrenceruleRequest(ContextPath contextPath, Optional<Object> value) {
        super(Recurrencerule.class, contextPath, value, false);
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public RecurringappointmentmasterRequest recurrencerule_recurringappointmentmaster(String activityid) {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("recurrencerule_recurringappointmentmaster").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public RecurringappointmentmasterCollectionRequest recurrencerule_recurringappointmentmaster() {
        return new RecurringappointmentmasterCollectionRequest(
                        contextPath.addSegment("recurrencerule_recurringappointmentmaster"), Optional.empty());
    }

    public ActivitypointerRequest objectid() {
        return new ActivitypointerRequest(contextPath.addSegment("objectid"), Optional.empty());
    }

}
